import re

from yandex_checkout.domain.common.payment_method_type import PaymentMethodType
from yandex_checkout.domain.models.payment_data.payment_data import ResponsePaymentData


class PaymentDataSberbank(ResponsePaymentData):
    __phone = None

    def __init__(self, *args, **kwargs):
        super(PaymentDataSberbank, self).__init__(*args, **kwargs)
        if self.type is None or self.type is not PaymentMethodType.SBERBANK:
            self.type = PaymentMethodType.SBERBANK

    @property
    def phone(self):
        return self.__phone

    @phone.setter
    def phone(self, value):
        cast_value = str(value)
        if re.match('^[0-9]{4,15}$', cast_value):
            self.__phone = cast_value
        else:
            raise ValueError('Invalid phone value type')
