"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .meetinglistresponse import MeetingListResponse, MeetingListResponseTypedDict
from enum import Enum
from fathom_python.types import BaseModel
from fathom_python.utils import FieldMetadata, QueryParamMetadata
import pydantic
from typing import Callable, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListMeetingsCalendarInviteesDomainsType(str, Enum):
    r"""Filter by whether calendar invitee list includes external email domains."""

    ALL = "all"
    ONLY_INTERNAL = "only_internal"
    ONE_OR_MORE_EXTERNAL = "one_or_more_external"


class MeetingType(str, Enum):
    r"""Filter by meeting type."""

    ALL = "all"
    INTERNAL = "internal"
    EXTERNAL = "external"


class ListMeetingsRequestTypedDict(TypedDict):
    calendar_invitees: NotRequired[List[str]]
    r"""Email address of calendar_invitees to filter by.

    Pass the parameter once per value, e.g.
    `calendar_invitees[]=cfo@acme.com&calendar_invitees[]=legal@acme.com`.

    Returns meetings where any of the given email addresses appear
    in the calendar_invitees list.

    """
    calendar_invitees_domains: NotRequired[List[str]]
    r"""Domains of the companies to filter by. Exact match.

    Pass the parameter once per value, e.g.
    `calendar_invitees_domains[]=acme.com&calendar_invitees_domains[]=client.com`.

    Returns meetings where any of the given company domains appear in the meeting.

    """
    calendar_invitees_domains_type: NotRequired[ListMeetingsCalendarInviteesDomainsType]
    r"""Filter by whether calendar invitee list includes external email domains."""
    created_after: NotRequired[str]
    r"""Filter to meetings with created_at after this timestamp, e.g. `created_after=2025-01-01T00:00:00Z`."""
    created_before: NotRequired[str]
    r"""Filter to meetings with created_at before this timestamp, e.g. `created_before=2025-01-01T00:00:00Z`."""
    cursor: NotRequired[str]
    r"""Cursor for pagination."""
    include_action_items: NotRequired[bool]
    r"""Include the action items for each meeting."""
    include_crm_matches: NotRequired[bool]
    r"""Include CRM matches for each meeting. Only returns data from your or your team's linked CRM."""
    include_summary: NotRequired[bool]
    r"""Include the summary for each meeting. Unavailable for OAuth connected apps (use /recordings instead)."""
    include_transcript: NotRequired[bool]
    r"""Include the transcript for each meeting. Unavailable for OAuth connected apps (use /recordings instead)."""
    meeting_type: NotRequired[MeetingType]
    r"""Filter by meeting type."""
    recorded_by: NotRequired[List[str]]
    r"""Email addresses of users who recorded meetings.

    Pass the parameter once per value, e.g.
    `recorded_by[]=ceo@acme.com&recorded_by[]=pm@acme.com`.

    Returns meetings recorded by any of the specified users.

    """
    teams: NotRequired[List[str]]
    r"""Team names to filter by.

    Pass the parameter once per value, e.g.
    `teams[]=Sales&teams[]=Engineering`.

    Returns meetings that belong to any of the specified teams.

    """


class ListMeetingsRequest(BaseModel):
    calendar_invitees: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="calendar_invitees[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Email address of calendar_invitees to filter by.

    Pass the parameter once per value, e.g.
    `calendar_invitees[]=cfo@acme.com&calendar_invitees[]=legal@acme.com`.

    Returns meetings where any of the given email addresses appear
    in the calendar_invitees list.

    """

    calendar_invitees_domains: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="calendar_invitees_domains[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Domains of the companies to filter by. Exact match.

    Pass the parameter once per value, e.g.
    `calendar_invitees_domains[]=acme.com&calendar_invitees_domains[]=client.com`.

    Returns meetings where any of the given company domains appear in the meeting.

    """

    calendar_invitees_domains_type: Annotated[
        Optional[ListMeetingsCalendarInviteesDomainsType],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = ListMeetingsCalendarInviteesDomainsType.ALL
    r"""Filter by whether calendar invitee list includes external email domains."""

    created_after: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter to meetings with created_at after this timestamp, e.g. `created_after=2025-01-01T00:00:00Z`."""

    created_before: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter to meetings with created_at before this timestamp, e.g. `created_before=2025-01-01T00:00:00Z`."""

    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Cursor for pagination."""

    include_action_items: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Include the action items for each meeting."""

    include_crm_matches: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Include CRM matches for each meeting. Only returns data from your or your team's linked CRM."""

    include_summary: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Include the summary for each meeting. Unavailable for OAuth connected apps (use /recordings instead)."""

    include_transcript: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Include the transcript for each meeting. Unavailable for OAuth connected apps (use /recordings instead)."""

    meeting_type: Annotated[
        Optional[MeetingType],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter by meeting type."""

    recorded_by: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="recorded_by[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Email addresses of users who recorded meetings.

    Pass the parameter once per value, e.g.
    `recorded_by[]=ceo@acme.com&recorded_by[]=pm@acme.com`.

    Returns meetings recorded by any of the specified users.

    """

    teams: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="teams[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Team names to filter by.

    Pass the parameter once per value, e.g.
    `teams[]=Sales&teams[]=Engineering`.

    Returns meetings that belong to any of the specified teams.

    """


class ListMeetingsResponseTypedDict(TypedDict):
    result: MeetingListResponseTypedDict


class ListMeetingsResponse(BaseModel):
    next: Callable[[], Optional[ListMeetingsResponse]]

    result: MeetingListResponse
