# -*- coding: utf-8 -*-

"""
    cyn_sms_python_package

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from cyn_sms_python_package.api_helper import APIHelper
from cyn_sms_python_package.configuration import Configuration
from cyn_sms_python_package.controllers.base_controller import BaseController

class APIController(BaseController):

    """A Controller to access Endpoints in the cyn_sms_python_package API."""


    def create_send_sms(self,
                        api_key,
                        to,
                        sms,
                        mfrom):
        """Does a POST request to /api?action=send-sms.

        TODO: type endpoint description here.

        Args:
            api_key (string): set your API_KEY from
                http://sms.cynojine.com/sms-api/info (user panel)
            to (string): the number we are sending to - Any phone number
            sms (string): SMS Body
            mfrom (string): Change the from number below. It can be a valid
                phone number or a String

        Returns:
            string: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api?action=send-sms'
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_parameters = {
            'api key': api_key,
            'to': to,
            'sms': sms,
            'from': mfrom
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.http_client.post(_query_url)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return _context.response.raw_body

    def get_balance_check(self,
                          options=dict(),
                          _optional_query_parameters=None):
        """Does a GET request to /api?action=check-balance.

        Checking SMS Balance

        Args:
            options (dict, optional): Key-value pairs for any of the
                parameters to this API Endpoint. All parameters to the
                endpoint are supplied through the dictionary with their names
                being the key and their desired values being the value. A list
                of parameters that can be used are::

                    api_key -- string -- Get your account balance
                    response -- string -- Json Responce

        Returns:
            void: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api?action=check-balance'
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_parameters = {
            'api_key': options.get('api_key', None),
            'response': options.get('response', None)
        }
        if _query_parameters != None and _optional_query_parameters != None:
            _query_parameters.update(_optional_query_parameters)
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.http_client.get(_query_url)
        _context = self.execute_request(_request)
        self.validate_response(_context)
