# **XIFA**: Accelerated Item Factor Analysis
`xifa` is a python package for conducting *item factor analysis* (IFA), a representative multivariate techniques in psychometrics.

`xifa` is build on [`jax`](https://github.com/google/jax), a package for Autograd and XLA. Hence, `xifa` can run IFA on GPUs and TPUs to speed up the training process. That is why we call it *Accelerated IFA*.

`xifa` implements a vectorized Metropolis-Hastings Robbins-Monro (MH-RM) algorithm to calculate a marginal maximum likelihood (MML) estimate. MH-RM is one of the states-of-art algorithms for high dimensional IFA ([Cai, 2010](https://doi.org/10.1007/s11336-009-9136-x.)). The vectorized version is designed for parallel computing with GPUs of TPUs. The vectorized MH-RM includes two stages. The first stage updates the parameter estimate by a stochastic expectation-maximization (StEM) algorithm. The second stage conducts stochastic approximation (SA) to refine the estimate.

In the current version (0.1.1), `xifa` supports ordinal data IFA with graded response model (GRM; [Semejima, 1969](https://link.springer.com/article/10.1007%2FBF03372160)) and generalized partial credit model (GPCM; [Muraki, 1992](https://doi.org/10.1177/014662169201600206)). The analysis can be either exploratory or confirmatory. 

For a tutorial, please see [IPIP 50 Items Example](http://colab.research.google.com/github/psyphh/xifa/blob/master/examples/ipip50.ipynb).


