#imports
import pandas as pd
import numpy as np
from sklearn.base import BaseEstimator, TransformerMixin
from sklearn.pipeline import Pipeline

from OtterFeatureSelector import OtterFeatureSelector
from OtterComMedTransformer import OtterComMedTransformer
from OtterCareGapOnlyTransformer import OtterCareGapOnlyTransformer
from OtterCareGapMedMedAdherenceTransformer import OtterCareGapMedMedAdherenceTransformer
from OtterCareGapMedMedAdherencePipeline import OtterCareGapMedMedAdherencePipeline

class OtterCareGapMedMedAdherenceAggregatePipeline:
    """Aggregate medicare med adherence care gaps

    Parameters:
    :param modelParamsDict: dictionary for the care gap model parameters
    :type modelParamsDict: dictionary

    Returns:
    :returns: data frame new care gap column for each line of business specified with = int: 0 if ineligible, 1 if closed and eligible, 2 if closed and eligble
    :rtype: pd.DataFrame
    """

    def __init__(self, modelParamsDict):
        """constructor method
        """
        self.modelParamsDict = modelParamsDict

    
    # Apply aggregate function
    def addPipe(self,X):
        
        #iterate through keys ( keys hold the med adherence gap names)
        for key in self.modelParamsDict.keys():
            #print('Start coding {}'.format(key))
            
            #create med adherent gaps 
            X = pd.concat([X, OtterCareGapMedMedAdherencePipeline(careGapNameValue=key,
                                                                    comMedCol='insure_med',
                                                                    drugCol=self.modelParamsDict[key][0],
                                                                    drugPDCCol=self.modelParamsDict[key][1],
                                                                    comMedOutcomeValue='med').addPipe().transform(X)], axis = 1)

        #return
        return X 
