/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight;

import eu.quanticol.moonlight.MoonLightScript;
import eu.quanticol.moonlight.TemporalMonitorDefinition;
import eu.quanticol.moonlight.TemporalScriptComponent;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class MoonLightTemporalScript
implements MoonLightScript {
    private final Map<String, TemporalMonitorDefinition> monitors;
    private final String defaultMonitor;
    private SignalDomain<?> domain;

    public MoonLightTemporalScript(String defaultMonitor, SignalDomain<?> domain, TemporalMonitorDefinition[] monitors) {
        if (monitors.length == 0) {
            throw new IllegalArgumentException("At least a monitor should be provided!");
        }
        if (defaultMonitor == null) {
            throw new IllegalArgumentException("Default monitor should be a non null value!");
        }
        this.monitors = new TreeMap<String, TemporalMonitorDefinition>();
        Arrays.stream(monitors).forEach(d -> this.monitors.put(d.getName(), (TemporalMonitorDefinition)d));
        if (!this.monitors.containsKey(defaultMonitor)) {
            throw new IllegalArgumentException("No definition for the given default monitor is provided!");
        }
        this.defaultMonitor = defaultMonitor;
        this.domain = domain;
    }

    public TemporalScriptComponent<?> selectTemporalComponent(String name) {
        if (this.monitors.containsKey(name)) {
            return new TemporalScriptComponent(this.monitors.get(name), this.domain);
        }
        throw new IllegalArgumentException(String.format("Monitor %s is unknown.", name));
    }

    public TemporalScriptComponent<?> selectDefaultTemporalComponent() {
        return new TemporalScriptComponent(this.monitors.get(this.defaultMonitor), this.getMonitoringDomain());
    }

    @Override
    public void setMonitoringDomain(SignalDomain<?> domain) {
        this.domain = domain;
    }

    @Override
    public SignalDomain<?> getMonitoringDomain() {
        return this.domain;
    }

    @Override
    public String[] getMonitors() {
        return this.monitors.keySet().toArray(new String[0]);
    }

    @Override
    public String getInfoDefaultMonitor() {
        TemporalScriptComponent<?> c = this.selectDefaultTemporalComponent();
        if (c != null) {
            return c.getInfo();
        }
        return "There it not any default temporal monitor!";
    }

    @Override
    public String getInfoMonitor(String name) {
        TemporalScriptComponent<?> c = this.selectTemporalComponent(name);
        if (c != null) {
            return c.getInfo();
        }
        return "Temporal monitor " + name + " is unknown!";
    }

    public static MoonLightTemporalScript forName(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?> scriptClass = MoonLightTemporalScript.class.getClassLoader().loadClass(className);
        return (MoonLightTemporalScript)scriptClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @Override
    public boolean isTemporal() {
        return true;
    }

    @Override
    public boolean isSpatialTemporal() {
        return false;
    }

    @Override
    public MoonLightTemporalScript temporal() {
        return this;
    }
}

