/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight;

import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.core.io.SerializableData;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitor;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

@FunctionalInterface
public interface SpatialTemporalMonitorProducer {
    public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> var1, MoonLightRecord var2);

    public static SpatialTemporalMonitorProducer produceImplication(final SpatialTemporalMonitorProducer left, final SpatialTemporalMonitorProducer right) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.impliesMonitor(left.apply(domain, args), domain, right.apply(domain, args));
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceAtomic(final BiFunction<MoonLightRecord, MoonLightRecord, Double> atomic) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.atomicMonitor(s -> domain.valueOf((Double)atomic.apply(args, s)));
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceAtomic(final BiFunction<MoonLightRecord, MoonLightRecord, Double> left, final String op, final BiFunction<MoonLightRecord, MoonLightRecord, Double> right) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.atomicMonitor(s -> SerializableData.getOperator(domain, op).apply((Double)left.apply(args, s), (Double)right.apply(args, s)));
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceAnd(final SpatialTemporalMonitorProducer left, final SpatialTemporalMonitorProducer right) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.andMonitor(left.apply(domain, args), domain, right.apply(domain, args));
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceOr(final SpatialTemporalMonitorProducer left, final SpatialTemporalMonitorProducer right) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.orMonitor(left.apply(domain, args), domain, right.apply(domain, args));
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceNegation(final SpatialTemporalMonitorProducer arg) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.notMonitor(arg.apply(domain, args), domain);
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceFalse() {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.atomicMonitor(v -> domain.min());
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceTrue() {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.atomicMonitor(v -> domain.max());
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceOnce(final SpatialTemporalMonitorProducer arg) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.onceMonitor(arg.apply(domain, args), domain);
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceHistorically(final SpatialTemporalMonitorProducer arg) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.historicallyMonitor(arg.apply(domain, args), domain);
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceEventually(final SpatialTemporalMonitorProducer arg) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.eventuallyMonitor(arg.apply(domain, args), domain);
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceGlobally(final SpatialTemporalMonitorProducer arg) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.globallyMonitor(arg.apply(domain, args), domain);
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceOnce(final SpatialTemporalMonitorProducer arg, final Function<MoonLightRecord, Interval> interval) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.onceMonitor(arg.apply(domain, args), domain, (Interval)interval.apply(args));
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceHistorically(final SpatialTemporalMonitorProducer arg, final Function<MoonLightRecord, Interval> interval) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.historicallyMonitor(arg.apply(domain, args), domain, (Interval)interval.apply(args));
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceEventually(final SpatialTemporalMonitorProducer arg, final Function<MoonLightRecord, Interval> interval) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.eventuallyMonitor(arg.apply(domain, args), domain, (Interval)interval.apply(args));
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceGlobally(final SpatialTemporalMonitorProducer arg, final Function<MoonLightRecord, Interval> interval) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.globallyMonitor(arg.apply(domain, args), domain, (Interval)interval.apply(args));
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceUntil(final SpatialTemporalMonitorProducer left, final SpatialTemporalMonitorProducer right) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.untilMonitor(left.apply(domain, args), right.apply(domain, args), domain);
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceUntil(final SpatialTemporalMonitorProducer left, final Function<MoonLightRecord, Interval> interval, final SpatialTemporalMonitorProducer right) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.untilMonitor(left.apply(domain, args), (Interval)interval.apply(args), right.apply(domain, args), domain);
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceSince(final SpatialTemporalMonitorProducer left, final SpatialTemporalMonitorProducer right) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.sinceMonitor(left.apply(domain, args), right.apply(domain, args), domain);
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceSince(final SpatialTemporalMonitorProducer left, final Function<MoonLightRecord, Interval> interval, final SpatialTemporalMonitorProducer right) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.sinceMonitor(left.apply(domain, args), (Interval)interval.apply(args), right.apply(domain, args), domain);
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceReach(final SpatialTemporalMonitorProducer left, final Function<MoonLightRecord, Function<SpatialModel<MoonLightRecord>, DistanceStructure<MoonLightRecord, ?>>> distance, final SpatialTemporalMonitorProducer right) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.reachMonitor(left.apply(domain, args), (Function)distance.apply(args), right.apply(domain, args), domain);
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceEscape(final SpatialTemporalMonitorProducer arg, final Function<MoonLightRecord, Function<SpatialModel<MoonLightRecord>, DistanceStructure<MoonLightRecord, ?>>> distance) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.escapeMonitor(arg.apply(domain, args), (Function)distance.apply(args), domain);
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceSomewhere(final SpatialTemporalMonitorProducer arg, final Function<MoonLightRecord, Function<SpatialModel<MoonLightRecord>, DistanceStructure<MoonLightRecord, ?>>> distance) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.somewhereMonitor(arg.apply(domain, args), (Function)distance.apply(args), domain);
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceEverywhere(final SpatialTemporalMonitorProducer arg, final Function<MoonLightRecord, Function<SpatialModel<MoonLightRecord>, DistanceStructure<MoonLightRecord, ?>>> distance) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return SpatialTemporalMonitor.everywhereMonitor(arg.apply(domain, args), (Function)distance.apply(args), domain);
            }
        };
    }

    public static SpatialTemporalMonitorProducer produceCall(final SpatialTemporalMonitorProducer spatialTemporalMonitorProducer, final RecordHandler callee, final List<Function<MoonLightRecord, Double>> functionArgument) {
        return new SpatialTemporalMonitorProducer(){

            @Override
            public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> apply(SignalDomain<S> domain, MoonLightRecord args) {
                return spatialTemporalMonitorProducer.apply(domain, callee.fromDoubleArray(functionArgument.stream().mapToDouble(f -> (Double)f.apply(args)).toArray()));
            }
        };
    }
}

