/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.core.algorithms;

import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.base.Triple;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.space.DistanceDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.SpatialModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;

public class ReachAlgorithm<E, M, R> {
    private final SpatialModel<E> model;
    private final SignalDomain<R> signalDomain;
    private final IntFunction<R> leftSpatialSignal;
    private final IntFunction<R> rightSpatialSignal;
    private final DistanceStructure<E, M> distStr;
    private final DistanceDomain<M> distanceDomain;
    private final List<Triple<Integer, M, R>> reachabilityQueue;
    private final List<Map<M, R>> reachabilityFunction;

    public ReachAlgorithm(DistanceStructure<E, M> distStr, SignalDomain<R> signalDomain, IntFunction<R> leftSpatialSignal, IntFunction<R> rightSpatialSignal) {
        this.leftSpatialSignal = leftSpatialSignal;
        this.rightSpatialSignal = rightSpatialSignal;
        this.distStr = distStr;
        this.model = distStr.getModel();
        this.distanceDomain = distStr.getDistanceDomain();
        this.signalDomain = signalDomain;
        this.reachabilityFunction = new ArrayList<Map<M, R>>();
        this.reachabilityQueue = new LinkedList<Triple<Integer, M, R>>();
    }

    public IntFunction<R> compute() {
        this.initReachableValues();
        this.reachCore();
        return i -> this.selectMaxReachabilityValues().get(i);
    }

    private void initReachableValues() {
        for (int loc = 0; loc < this.model.size(); ++loc) {
            Map<M, R> reachableValues = this.fetchInitialReachableValues(loc);
            this.reachabilityFunction.add(reachableValues);
        }
    }

    private Map<M, R> fetchInitialReachableValues(int location) {
        HashMap reachableValues = new HashMap();
        R rightValue = this.rightSpatialSignal.apply(location);
        this.updateReachableValue(location, this.distanceDomain.zero(), rightValue, reachableValues);
        return reachableValues;
    }

    private void reachCore() {
        while (!this.reachabilityQueue.isEmpty()) {
            Triple<Integer, M, R> t1 = this.reachabilityQueue.remove(0);
            int l1 = t1.getFirst();
            M d1 = t1.getSecond();
            R v1 = t1.getThird();
            this.updateReachability(l1, d1, v1);
        }
    }

    private void updateReachability(int l1, M d1, R v1) {
        for (Pair<Integer, E> neighbour : this.model.previous(l1)) {
            int l2 = neighbour.getFirst();
            M d2 = this.newDistance(d1, neighbour.getSecond());
            if (!this.distStr.isWithinBounds(d2)) continue;
            R value = this.signalDomain.conjunction(v1, this.leftSpatialSignal.apply(l2));
            this.evaluateReachabilityUpdate(l2, d2, value);
        }
    }

    private M newDistance(M d1, E weight) {
        return this.distanceDomain.sum(this.distStr.getDistanceFunction().apply(weight), d1);
    }

    private void evaluateReachabilityUpdate(int location, M distance, R value) {
        Map<M, R> reachableValues = this.reachabilityFunction.get(location);
        if (reachableValues.containsKey(distance)) {
            R oldValue = reachableValues.get(distance);
            if (!this.signalDomain.equalTo(oldValue, value = this.signalDomain.disjunction(value, oldValue))) {
                this.updateReachableValue(location, distance, value, reachableValues);
            }
        } else {
            this.updateReachableValue(location, distance, value, reachableValues);
        }
    }

    private void updateReachableValue(int location, M distance, R newValue, Map<M, R> values) {
        values.put(distance, newValue);
        this.reachabilityQueue.add(new Triple<Integer, M, R>(location, distance, newValue));
    }

    private List<R> selectMaxReachabilityValues() {
        return this.reachabilityFunction.stream().map(this::maximizeLocationValue).collect(Collectors.toCollection(ArrayList::new));
    }

    private R maximizeLocationValue(Map<M, R> reachabilityMap) {
        return (R)reachabilityMap.entrySet().stream().filter(e -> this.distStr.isWithinBounds(e.getKey())).map(Map.Entry::getValue).reduce(this.signalDomain.min(), this.signalDomain::disjunction);
    }
}

