/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.core.base;

import eu.quanticol.moonlight.core.base.Tuple;
import eu.quanticol.moonlight.core.base.TupleType;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class TupleImpl
implements Tuple {
    private final TupleType type;
    private final Comparable<?>[] values;

    TupleImpl(TupleType type, Comparable<?>[] values) {
        this.type = type;
        if (values == null || values.length == 0) {
            this.values = new Comparable[0];
        } else {
            this.values = new Comparable[values.length];
            System.arraycopy(values, 0, this.values, 0, values.length);
        }
    }

    @Override
    public TupleType getType() {
        return this.type;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public <T> T getIthValue(int i) {
        return (T)this.values[i];
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof Tuple)) {
            return false;
        }
        Tuple other = (Tuple)object;
        if (other.size() != this.size()) {
            return false;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object thisIthValue = this.getIthValue(i);
            Object otherIthValue = other.getIthValue(i);
            if ((thisIthValue != null || otherIthValue == null) && (thisIthValue == null || thisIthValue.equals(otherIthValue))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(@NotNull Tuple o) {
        int bigger = 0;
        int smaller = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].compareTo(o.getIthValue(i)) > 0) {
                ++bigger;
                continue;
            }
            if (this.values[i].compareTo(o.getIthValue(i)) >= 0) continue;
            ++smaller;
        }
        if (bigger == this.values.length) {
            return 1;
        }
        if (smaller == this.values.length) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int hash = 17;
        for (Comparable<?> value : this.values) {
            if (value == null) continue;
            hash = hash * 37 + value.hashCode();
        }
        return hash;
    }

    public String toString() {
        return Arrays.toString(this.values);
    }
}

