/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.core.base;

import eu.quanticol.moonlight.core.base.Tuple;
import eu.quanticol.moonlight.core.base.TupleImpl;
import eu.quanticol.moonlight.core.base.TupleType;
import java.io.Serializable;

class TupleTypeImpl
implements TupleType {
    final Class<?>[] types;

    TupleTypeImpl(Class<? extends Comparable<?>>[] types) {
        this.types = types != null ? types : new Class[]{};
    }

    @Override
    public int size() {
        return this.types.length;
    }

    @Override
    public Class<?> getIthType(int i) {
        return this.types[i];
    }

    @Override
    public Tuple createTuple(Comparable<?> ... values) {
        if (values == null && this.types.length == 0 || values != null && values.length != this.types.length) {
            throw new IllegalArgumentException("Expected " + this.types.length + " values, not " + (Serializable)(values == null ? "(null)" : Integer.valueOf(values.length)) + " values");
        }
        if (values != null) {
            for (int i = 0; i < this.types.length; ++i) {
                Class<?> ithType = this.types[i];
                Comparable<?> ithValue = values[i];
                if (ithValue == null || ithType.isAssignableFrom(ithValue.getClass())) continue;
                throw new IllegalArgumentException("Expected value #" + i + " ('" + ithValue + "') of new Tuple to be " + ithType + ", not " + ithValue.getClass());
            }
        }
        return new TupleImpl(this, values);
    }
}

