/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.core.formula;

import eu.quanticol.moonlight.core.base.Box;
import org.jetbrains.annotations.NotNull;

public class Interval
extends Box<Double> {
    public Interval() {
        super(0.0, 0.0, true, true);
    }

    public Interval(Number value) {
        super(value.doubleValue(), value.doubleValue(), false, false);
    }

    public Interval(Number start, Number end) {
        super(start.doubleValue(), end.doubleValue(), false, false);
    }

    public Interval(Number start, Number end, boolean openOnRight) {
        super(start.doubleValue(), end.doubleValue(), false, openOnRight);
    }

    public Interval(Number start, Number end, boolean openOnLeft, boolean openOnRight) {
        super(start.doubleValue(), end.doubleValue(), openOnLeft, openOnRight);
    }

    public Interval translate(Double offset) {
        return new Interval((Double)this.getStart() + offset, (Double)this.getEnd() + offset, this.isOpenOnLeft(), this.isOpenOnRight());
    }

    public static Interval combine(@NotNull Interval i1, @NotNull Interval i2) {
        if (i1.isEmpty()) {
            return i2;
        }
        if (i2.isEmpty()) {
            return i1;
        }
        return new Interval((Double)i1.getStart() + (Double)i2.getStart(), (Double)i1.getEnd() + (Double)i2.getEnd());
    }

    public static Interval any() {
        return new Interval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }
}

