/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.core.signal;

import eu.quanticol.moonlight.core.signal.Sample;
import eu.quanticol.moonlight.online.signal.ChainIterator;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.Update;

public interface TimeSignal<T extends Comparable<T>, V> {
    public boolean refine(Update<T, V> var1) throws UnsupportedOperationException;

    public boolean refine(TimeChain<T, V> var1) throws UnsupportedOperationException;

    public TimeChain<T, V> getSegments() throws UnsupportedOperationException;

    default public V getValueAt(T time) {
        ChainIterator<Sample<T, V>> itr = this.getSegments().chainIterator();
        Sample<T, V> current = null;
        while (itr.hasNext()) {
            current = itr.next();
            if (current.getStart().compareTo(time) <= 0) continue;
            itr.previous();
            return itr.previous().getValue();
        }
        if (current != null) {
            return current.getValue();
        }
        throw new UnsupportedOperationException("Empty signal provided");
    }

    public TimeChain<T, V> select(T var1, T var2);
}

