/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.domain;

import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.base.Semiring;
import eu.quanticol.moonlight.core.io.DataHandler;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.domain.BoxDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ListDomain<T extends Comparable<T>>
implements SignalDomain<List<Box<T>>> {
    private final List<SignalDomain<Box<T>>> domains = new ArrayList<SignalDomain<Box<T>>>();

    public ListDomain(List<SignalDomain<T>> domains) {
        for (SignalDomain<T> d : domains) {
            this.domains.add(new BoxDomain<T>(d));
        }
    }

    public ListDomain(int size, SignalDomain<T> domain) {
        for (int i = 0; i < size; ++i) {
            this.domains.add(new BoxDomain<T>(domain));
        }
    }

    @Override
    public List<Box<T>> negation(List<Box<T>> x) {
        return IntStream.range(0, this.domains.size()).mapToObj(i -> this.domains.get(i).negation((Box)x.get(i))).collect(Collectors.toList());
    }

    @Override
    public List<Box<T>> conjunction(List<Box<T>> x, List<Box<T>> y) {
        return IntStream.range(0, this.domains.size()).mapToObj(i -> this.domains.get(i).conjunction((Box)x.get(i), (Box)y.get(i))).collect(Collectors.toList());
    }

    @Override
    public List<Box<T>> disjunction(List<Box<T>> x, List<Box<T>> y) {
        return IntStream.range(0, this.domains.size()).mapToObj(i -> this.domains.get(i).disjunction((Box)x.get(i), (Box)y.get(i))).collect(Collectors.toList());
    }

    @Override
    public List<Box<T>> min() {
        return this.domains.stream().map(Semiring::min).collect(Collectors.toList());
    }

    @Override
    public List<Box<T>> max() {
        return this.domains.stream().map(Semiring::max).collect(Collectors.toList());
    }

    @Override
    public List<Box<T>> any() {
        return this.domains.stream().map(SignalDomain::any).collect(Collectors.toList());
    }

    @Override
    public DataHandler<List<Box<T>>> getDataHandler() {
        return null;
    }

    @Override
    public boolean equalTo(List<Box<T>> x, List<Box<T>> y) {
        return false;
    }

    @Override
    public List<Box<T>> valueOf(boolean b) {
        return null;
    }

    @Override
    public List<Box<T>> valueOf(double v) {
        return null;
    }

    @Override
    public List<Box<T>> computeLessThan(double v1, double v2) {
        return null;
    }

    @Override
    public List<Box<T>> computeLessOrEqualThan(double v1, double v2) {
        return null;
    }

    @Override
    public List<Box<T>> computeEqualTo(double v1, double v2) {
        return null;
    }

    @Override
    public List<Box<T>> computeGreaterThan(double v1, double v2) {
        return null;
    }

    @Override
    public List<Box<T>> computeGreaterOrEqualThan(double v1, double v2) {
        return null;
    }
}

