/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.domain;

import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.base.Semiring;

public class PairSemiring<T, R>
implements Semiring<Pair<T, R>> {
    private final Semiring<T> firstSemiring;
    private final Semiring<R> secondSemiring;
    private final Pair<T, R> min;
    private final Pair<T, R> max;

    public PairSemiring(Semiring<T> firstSemiring, Semiring<R> secondSemiring) {
        this.firstSemiring = firstSemiring;
        this.secondSemiring = secondSemiring;
        this.min = new Pair<T, R>(firstSemiring.min(), secondSemiring.min());
        this.max = new Pair<T, R>(firstSemiring.max(), secondSemiring.max());
    }

    @Override
    public Pair<T, R> conjunction(Pair<T, R> x, Pair<T, R> y) {
        return new Pair<T, R>(this.firstSemiring.conjunction(x.getFirst(), y.getFirst()), this.secondSemiring.conjunction(x.getSecond(), y.getSecond()));
    }

    @Override
    public Pair<T, R> disjunction(Pair<T, R> x, Pair<T, R> y) {
        return new Pair<T, R>(this.firstSemiring.disjunction(x.getFirst(), y.getFirst()), this.secondSemiring.disjunction(x.getSecond(), y.getSecond()));
    }

    @Override
    public Pair<T, R> min() {
        return this.min;
    }

    @Override
    public Pair<T, R> max() {
        return this.max;
    }
}

