/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.io;

import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.io.AbstractFileByRowReader;
import eu.quanticol.moonlight.io.IllegalFileFormatException;
import eu.quanticol.moonlight.io.LocationServiceReader;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.space.GraphModel;
import eu.quanticol.moonlight.space.LocationServiceList;
import eu.quanticol.moonlight.space.StaticLocationService;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;

public class CsvLocationServiceReader
extends AbstractFileByRowReader
implements LocationServiceReader {
    @Override
    public LocationService<Double, MoonLightRecord> read(RecordHandler handler, File input) throws IOException, IllegalFileFormatException {
        return this.load(handler, this.getRows(input));
    }

    @Override
    public LocationService<Double, MoonLightRecord> read(RecordHandler handler, String input) throws IllegalFileFormatException {
        return this.load(handler, this.getRows(input));
    }

    private LocationService<Double, MoonLightRecord> load(RecordHandler handler, List<AbstractFileByRowReader.Row> rows) throws IllegalFileFormatException {
        int size = this.getModelSize(rows);
        boolean isStatic = this.checkStatic(rows);
        boolean isDirected = this.checkDirected(rows);
        if (isStatic) {
            return this.loadStaticLocationService(handler, size, isDirected, rows);
        }
        return this.loadDynamicLocationService(handler, size, isDirected, rows);
    }

    private LocationService<Double, MoonLightRecord> loadDynamicLocationService(RecordHandler handler, int size, boolean isDirected, List<AbstractFileByRowReader.Row> rows) throws IllegalFileFormatException {
        Iterator<AbstractFileByRowReader.Row> rowIterator = rows.iterator();
        AbstractFileByRowReader.Row current = this.shiftToFirstTimeDeclaration(rowIterator);
        LocationServiceList<MoonLightRecord> locationService = new LocationServiceList<MoonLightRecord>();
        while (current != null) {
            double time = this.extractTimeFromRow(current);
            GraphModel<MoonLightRecord> model = new GraphModel<MoonLightRecord>(size);
            AbstractFileByRowReader.Row row = current = rowIterator.hasNext() ? rowIterator.next() : null;
            while (current != null && !current.getRow().startsWith("TIME")) {
                this.addEdgeToModel(handler, model, size, isDirected, current);
                current = rowIterator.hasNext() ? rowIterator.next() : null;
            }
            locationService.add(time, model);
        }
        return locationService;
    }

    private double extractTimeFromRow(AbstractFileByRowReader.Row row) throws IllegalFileFormatException {
        row.split(" ");
        if (!row.isDouble(1)) {
            throw new IllegalFileFormatException(row.getLine(), "TIME <double> is expected!");
        }
        return Double.parseDouble(row.get(1));
    }

    private AbstractFileByRowReader.Row shiftToFirstTimeDeclaration(Iterator<AbstractFileByRowReader.Row> rowIterator) throws IllegalFileFormatException {
        try {
            do {
                AbstractFileByRowReader.Row current;
                if (!(current = rowIterator.next()).getRow().startsWith("TIME")) continue;
                return current;
            } while (rowIterator.hasNext());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        throw new IllegalFileFormatException(1, "Time declaration is missing!");
    }

    private boolean checkStatic(List<AbstractFileByRowReader.Row> rows) {
        return rows.stream().anyMatch(r -> r.getRow().startsWith("STATIC"));
    }

    private boolean checkDirected(List<AbstractFileByRowReader.Row> rows) {
        return rows.stream().anyMatch(r -> r.getRow().startsWith("DIRECTED"));
    }

    private LocationService<Double, MoonLightRecord> loadStaticLocationService(RecordHandler handler, int size, boolean isDirected, List<AbstractFileByRowReader.Row> rows) throws IllegalFileFormatException {
        GraphModel<MoonLightRecord> model = new GraphModel<MoonLightRecord>(size);
        Iterator<AbstractFileByRowReader.Row> rowIterator = rows.iterator();
        this.shiftToStatic(rowIterator);
        while (rowIterator.hasNext()) {
            this.addEdgeToModel(handler, model, size, isDirected, rowIterator.next());
        }
        return new StaticLocationService<MoonLightRecord>(model);
    }

    private void addEdgeToModel(RecordHandler handler, GraphModel<MoonLightRecord> model, int size, boolean isDirected, AbstractFileByRowReader.Row row) throws IllegalFileFormatException {
        row.split(";");
        int src = this.getSource(row, size);
        int trg = this.getTarget(row, size);
        MoonLightRecord record = this.getRecord(handler, row);
        model.add(src, record, trg);
        if (!isDirected) {
            model.add(trg, record, src);
        }
    }

    private MoonLightRecord getRecord(RecordHandler handler, AbstractFileByRowReader.Row row) throws IllegalFileFormatException {
        if (row.elements.length != handler.size() + 2) {
            throw new IllegalFileFormatException(row.getLine(), "Wrong number of data!");
        }
        try {
            return handler.fromStringArray(row.elements, 2, row.elements.length);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalFileFormatException(row.getLine(), e.getMessage());
        }
    }

    private int getSource(AbstractFileByRowReader.Row row, int size) throws IllegalFileFormatException {
        if (!row.isInteger(0)) {
            throw new IllegalFileFormatException(row.getLine(), "An integer is expected for the source location!");
        }
        int src = Integer.parseInt(row.get(0));
        if (src < 0 || src >= size) {
            throw new IllegalFileFormatException(row.getLine(), "An integer between 0 and " + size + " is expected for the source location!");
        }
        return src;
    }

    private int getTarget(AbstractFileByRowReader.Row row, int size) throws IllegalFileFormatException {
        if (!row.isInteger(1)) {
            throw new IllegalFileFormatException(row.getLine(), "An integer is expected for the target location!");
        }
        int trg = Integer.parseInt(row.get(1));
        if (trg < 0 || trg >= size) {
            throw new IllegalFileFormatException(row.getLine(), "An integer between 0 and " + size + " is expected for the target location!");
        }
        return trg;
    }

    private void shiftToStatic(Iterator<AbstractFileByRowReader.Row> rowIterator) {
        while (rowIterator.hasNext()) {
            AbstractFileByRowReader.Row row = rowIterator.next();
            if (!row.getRow().startsWith("STATIC")) continue;
            return;
        }
    }

    private int getModelSize(List<AbstractFileByRowReader.Row> rows) throws IllegalFileFormatException {
        Optional<AbstractFileByRowReader.Row> locationsSizeDeclarationRow = rows.stream().filter(r -> r.getRow().startsWith("LOCATIONS")).findFirst();
        if (locationsSizeDeclarationRow.isPresent()) {
            AbstractFileByRowReader.Row row = locationsSizeDeclarationRow.get();
            row.split(" ");
            if (!row.isInteger(1)) {
                throw new IllegalFileFormatException(row.getLine(), "Malformed location size declaration!");
            }
            return Integer.parseInt(row.get(1));
        }
        throw new IllegalFileFormatException(1, "Declaration of number of locations in the model is missing!");
    }
}

