/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.io;

import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.io.AbstractFileByRowReader;
import eu.quanticol.moonlight.io.IllegalFileFormatException;
import eu.quanticol.moonlight.io.TemporalSignalReader;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.offline.signal.Signal;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.Stream;

public class CsvTemporalSignalReader
extends AbstractFileByRowReader
implements TemporalSignalReader {
    @Override
    public Signal<MoonLightRecord> load(RecordHandler handler, File input) throws IOException, IllegalFileFormatException {
        return this.load(handler, this.collectDataRows(Files.lines(input.toPath())));
    }

    private Signal<MoonLightRecord> load(RecordHandler handler, List<AbstractFileByRowReader.Row> data) throws IllegalFileFormatException {
        this.checkData(handler, data);
        Signal<MoonLightRecord> s = new Signal<MoonLightRecord>();
        for (AbstractFileByRowReader.Row row : data) {
            row.addValueToSignal(handler, s);
        }
        s.getEnd();
        return s;
    }

    private void checkData(RecordHandler handler, List<AbstractFileByRowReader.Row> data) throws IllegalFileFormatException {
        for (AbstractFileByRowReader.Row row : data) {
            row.split(";");
            if (row.isEmpty()) continue;
            if (!row.isDouble(0)) {
                throw new IllegalFileFormatException(row.index, "First element of each row must be a double!");
            }
            if (row.checkRecord(handler)) continue;
            throw new IllegalFileFormatException(row.index, "Input data error!");
        }
    }

    @Override
    public Signal<MoonLightRecord> load(RecordHandler handler, String input) throws IllegalFileFormatException {
        return this.load(handler, this.collectDataRows(Stream.of(input.split("\n"))));
    }
}

