/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.io;

import eu.quanticol.moonlight.io.parsing.FileType;
import eu.quanticol.moonlight.io.parsing.PrintingStrategy;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class DataWriter<T> {
    private final FileType type;
    private final String path;
    private final PrintingStrategy<T> strategy;

    public DataWriter(String path, FileType type, PrintingStrategy<T> strategy) {
        this.path = path;
        this.type = type;
        this.strategy = strategy;
    }

    public void write(T data) {
        try (BufferedWriter outWriter = new BufferedWriter(new FileWriter(this.path));){
            this.writeHeader(outWriter, data);
            this.writeLines(outWriter, data);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read at:" + this.path, e);
        }
    }

    private void writeHeader(BufferedWriter outWriter, T header) throws IOException {
        outWriter.write(this.strategy.initialize(header, this.getWordBreak()) + "\n");
    }

    private void writeLines(BufferedWriter outWriter, T data) throws IOException {
        String output = this.strategy.print(data, this.getWordBreak());
        while (null != output) {
            outWriter.write(output + "\n");
            output = this.strategy.print(data, this.getWordBreak());
        }
    }

    private String getWordBreak() {
        return FileType.CSV == this.type ? "," : " ";
    }
}

