/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.io.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.io.json.IllegalFileFormat;
import eu.quanticol.moonlight.offline.monitoring.SpatialTemporalMonitoringInput;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.offline.signal.Signal;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import eu.quanticol.moonlight.space.GraphModel;
import eu.quanticol.moonlight.space.LocationServiceList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;

public class JSonSpatioTemporalSignalDeserializer {
    private final RecordHandler signalRecordHandler;
    private final RecordHandler edgeRecordHandler;

    public JSonSpatioTemporalSignalDeserializer(RecordHandler signalRecordHandler, RecordHandler edgeRecordHandler) {
        this.signalRecordHandler = signalRecordHandler;
        this.edgeRecordHandler = edgeRecordHandler;
    }

    public SpatialTemporalMonitoringInput<MoonLightRecord, MoonLightRecord> load(String str) throws IllegalFileFormat {
        JsonParser parser = new JsonParser();
        JsonObject root = this.getRoot(parser.parse(str));
        this.checkTypes(root);
        Map<String, Integer> locationIndex = this.getLocationIndex(root);
        SpatialTemporalSignal<MoonLightRecord> signal = this.loadSignal(locationIndex, root);
        LocationService<Double, MoonLightRecord> locationService = this.loadLocationService(locationIndex, root);
        return new SpatialTemporalMonitoringInput<MoonLightRecord, MoonLightRecord>(signal, locationService, null);
    }

    private Map<String, Integer> getLocationIndex(JsonObject root) throws IllegalFileFormat {
        if (!root.has("nodes")) {
            throw new IllegalFileFormat("Tag nodes is missing!");
        }
        if (!root.get("nodes").isJsonArray()) {
            throw new IllegalFileFormat("Tag nodes should be an array!");
        }
        JsonArray nodes = root.get("nodes").getAsJsonArray();
        HashMap<String, Integer> toReturn = new HashMap<String, Integer>();
        IntStream.range(0, nodes.size()).sequential().forEach(i -> toReturn.put(nodes.get(i).getAsString(), i));
        return toReturn;
    }

    private JsonObject getRoot(JsonElement tree) throws IllegalFileFormat {
        if (!tree.isJsonObject()) {
            throw new IllegalFileFormat("A JSON object is expected!");
        }
        JsonObject root = tree.getAsJsonObject();
        if (!root.has("trace_type")) {
            throw new IllegalFileFormat("Tag trace_type is missing!");
        }
        String trace_type = root.get("trace_type").getAsString();
        if (!"spatialtemporal".equals(trace_type)) {
            throw new IllegalFileFormat("Wrong value for tag trace_type: expected spatialtemporal is " + trace_type);
        }
        return root;
    }

    private void checkTypes(JsonObject root) throws IllegalFileFormat {
        Map<String, String> declaredSignalVariables = this.getMapOf(root, "signal_type");
        this.checkType(declaredSignalVariables, this.signalRecordHandler, "signal");
        Map<String, String> declaredEdgeVariables = this.getMapOf(root, "edge_type");
        this.checkType(declaredEdgeVariables, this.signalRecordHandler, "edge");
    }

    private void checkType(Map<String, String> vMap, RecordHandler handler, String context) throws IllegalFileFormat {
        for (Map.Entry<String, String> e : vMap.entrySet()) {
            if (handler.getVariableIndex(e.getKey()) < 0) {
                throw new IllegalFileFormat("Unknown " + context + " variable " + e.getKey() + "!");
            }
            if (handler.checkVariableType(e.getKey(), e.getValue())) continue;
            throw new IllegalFileFormat("Wrong type for " + context + " variable " + e.getKey() + "! Expected " + handler.getTypeCode(e.getKey()) + " is " + e.getValue() + "!");
        }
    }

    private Map<String, String> getMapOf(JsonObject root, String tagName) throws IllegalFileFormat {
        if (!root.has(tagName)) {
            throw new IllegalFileFormat("Tag " + tagName + " is missing!");
        }
        if (!root.get(tagName).isJsonObject()) {
            throw new IllegalFileFormat("Tag " + tagName + " should be a JSON Object!");
        }
        JsonObject o = root.get(tagName).getAsJsonObject();
        HashMap<String, String> toReturn = new HashMap<String, String>();
        o.entrySet().forEach(e -> toReturn.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString()));
        return toReturn;
    }

    private LocationService<Double, MoonLightRecord> loadLocationService(Map<String, Integer> locationIndex, JsonObject root) throws IllegalFileFormat {
        if (!root.has("space")) {
            throw new IllegalFileFormat("Tag space is missing!");
        }
        if (!root.get("space").isJsonArray()) {
            throw new IllegalFileFormat("Tag space should be an array!");
        }
        JsonArray spatialModels = root.get("space").getAsJsonArray();
        LocationServiceList<MoonLightRecord> toReturn = new LocationServiceList<MoonLightRecord>();
        for (int i = 0; i < spatialModels.size(); ++i) {
            if (!spatialModels.get(i).isJsonObject()) {
                throw new IllegalFileFormat("An object is expected as element " + i + " of tagspace!");
            }
            JsonObject timeModel = spatialModels.get(i).getAsJsonObject();
            if (!timeModel.has("t")) {
                throw new IllegalFileFormat("Tag t at element " + i + " of array space!");
            }
            toReturn.add(timeModel.get("t").getAsDouble(), this.getModel(locationIndex, timeModel.get("edges").getAsJsonArray()));
        }
        return toReturn;
    }

    private SpatialModel<MoonLightRecord> getModel(Map<String, Integer> locationIndex, JsonArray edges) throws IllegalFileFormat {
        GraphModel<MoonLightRecord> model = new GraphModel<MoonLightRecord>(locationIndex.size());
        for (int i = 0; i < edges.size(); ++i) {
            JsonObject edge = edges.get(i).getAsJsonObject();
            if (!(edge.has("src") && edge.has("trg") && edge.has("values"))) {
                throw new IllegalFileFormat("Missing mandatory tag  t at element " + i + " of array space!");
            }
            Integer src = locationIndex.get(edge.get("src").getAsString());
            Integer trg = locationIndex.get(edge.get("trg").getAsString());
            model.add(src, this.getEdgeValues(edge.get("values")), trg);
        }
        return model;
    }

    private MoonLightRecord getEdgeValues(JsonElement jsonElement) throws IllegalFileFormat {
        if (!jsonElement.isJsonObject()) {
            throw new IllegalFileFormat("Tag values in edge definitions should be an object!");
        }
        JsonObject edgeValues = jsonElement.getAsJsonObject();
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        for (String v : this.edgeRecordHandler.getVariables()) {
            if (!edgeValues.has(v)) {
                throw new IllegalFileFormat("Definition of variable " + v + " is missing in edge definition!");
            }
            String value = edgeValues.get(v).getAsString();
            if (this.edgeRecordHandler.checkValueFromString(v, value)) {
                throw new IllegalFileFormat("Wrong value " + value + "for " + v + "!");
            }
            valuesMap.put(v, value);
        }
        return this.edgeRecordHandler.fromStringArray(valuesMap);
    }

    private SpatialTemporalSignal<MoonLightRecord> loadSignal(Map<String, Integer> locationIndex, JsonObject root) throws IllegalFileFormat {
        if (!root.has("signals")) {
            throw new IllegalFileFormat("Tag signals is missing!");
        }
        if (!root.get("signals").isJsonObject()) {
            throw new IllegalFileFormat("Tag signals is not an object!");
        }
        JsonObject signals = root.get("signals").getAsJsonObject();
        double[] time = this.getTime(signals);
        JsonObject data = this.getSignalData(locationIndex, signals);
        String[] locations = new String[locationIndex.size()];
        locationIndex.forEach((v, i) -> {
            locations[i.intValue()] = v;
        });
        return new SpatialTemporalSignal<MoonLightRecord>(locations.length, i -> this.getSignal(time, locations[i], data.get(locations[i]).getAsJsonObject()));
    }

    private Signal<MoonLightRecord> getSignal(double[] time, String string, JsonObject locationData) {
        Signal<MoonLightRecord> record = new Signal<MoonLightRecord>();
        IntStream.range(0, time.length).sequential().forEach(i -> record.add(time[i], this.signalRecordHandler.fromStringArray(this.getRecordStringMap(i, locationData, this.signalRecordHandler))));
        return record;
    }

    private Map<String, String> getRecordStringMap(int i, JsonObject data, RecordHandler handler) {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        for (String v : handler.getVariables()) {
            JsonElement e = data.get(v);
            if (e.isJsonArray()) {
                toReturn.put(v, e.getAsJsonArray().get(i).getAsString());
                continue;
            }
            toReturn.put(v, e.getAsString());
        }
        return toReturn;
    }

    private JsonObject getSignalData(Map<String, Integer> locationIndex, JsonObject signals) throws IllegalFileFormat {
        if (!signals.has("values")) {
            throw new IllegalFileFormat("Tag values is missing!");
        }
        if (!signals.get("values").isJsonObject()) {
            throw new IllegalFileFormat("Tag values should be an object!");
        }
        JsonObject data = signals.get("values").getAsJsonObject();
        for (String location : locationIndex.keySet()) {
            if (!data.has(location)) {
                throw new IllegalFileFormat("No signal data for location " + location + "!");
            }
            if (!data.get(location).isJsonObject()) {
                throw new IllegalFileFormat("Wrong format for signal data of location " + location + "!");
            }
            JsonObject locationSignal = data.get(location).getAsJsonObject();
            for (String v : this.signalRecordHandler.getVariables()) {
                JsonArray dataArray;
                if (!locationSignal.has(v)) {
                    throw new IllegalFileFormat("Missing data for variable " + v + " of location " + location + "!");
                }
                if (!(locationSignal.get(v).isJsonArray() ? !IntStream.range(0, (dataArray = locationSignal.get(v).getAsJsonArray()).size()).allMatch(i -> this.signalRecordHandler.checkValueFromString(v, dataArray.get(i).getAsString())) : !this.signalRecordHandler.checkValueFromString(v, locationSignal.get(v).getAsString()))) continue;
                throw new IllegalFileFormat("Wrong value for variable " + v + " of location " + location + "!");
            }
        }
        return data;
    }

    private double[] getTime(JsonObject signals) throws IllegalFileFormat {
        if (!signals.has("t")) {
            throw new IllegalFileFormat("Tag t is missing!");
        }
        if (!signals.get("t").isJsonArray()) {
            throw new IllegalFileFormat("Tag t should be an array!");
        }
        JsonArray timeArray = signals.get("t").getAsJsonArray();
        int size = timeArray.size();
        try {
            return IntStream.range(0, size).mapToDouble(i -> timeArray.get(i).getAsDouble()).toArray();
        }
        catch (Exception e) {
            throw new IllegalFileFormat("Tag t should be an array of doubles!");
        }
    }
}

