/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.io.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.io.json.IllegalFileFormat;
import eu.quanticol.moonlight.io.json.JSONUtils;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.offline.signal.Signal;
import java.util.stream.IntStream;

public class JSonTemporalSignalDeserializer {
    private final RecordHandler recordHandler;

    public JSonTemporalSignalDeserializer(RecordHandler recordHandler) {
        this.recordHandler = recordHandler;
    }

    public Signal<MoonLightRecord> load(String str) throws IllegalFileFormat {
        JsonParser parser = new JsonParser();
        JsonElement tree = parser.parse(str);
        return this.fromJSon(tree);
    }

    private Signal<MoonLightRecord> fromJSon(JsonElement tree) throws IllegalFileFormat {
        if (!tree.isJsonObject()) {
            throw new IllegalFileFormat("A JSON object is expected!");
        }
        JsonObject root = tree.getAsJsonObject();
        this.checkTraceType(root);
        double[] times = this.getTime(root);
        this.checkVariables(root);
        return this.createSignal(times, root.get("signals").getAsJsonArray());
    }

    private Signal<MoonLightRecord> createSignal(double[] times, JsonArray signals) {
        String[] variables = this.recordHandler.getVariables();
        Signal<MoonLightRecord> toReturn = new Signal<MoonLightRecord>();
        for (int i = 0; i < times.length; ++i) {
            toReturn.add(times[i], this.recordHandler.fromStringArray(JSONUtils.getAssignmentMap(variables, i, signals)));
        }
        return toReturn;
    }

    private double[] getTime(JsonObject root) throws IllegalFileFormat {
        if (!root.has("t")) {
            throw new IllegalFileFormat("Tag t is missing!");
        }
        if (!root.get("t").isJsonArray()) {
            throw new IllegalFileFormat("Tag t should be an array!");
        }
        JsonArray timeArray = root.get("t").getAsJsonArray();
        int size = timeArray.size();
        try {
            return IntStream.range(0, size).mapToDouble(i -> timeArray.get(i).getAsDouble()).toArray();
        }
        catch (Exception e) {
            throw new IllegalFileFormat("Tag t should be an array of doubles!");
        }
    }

    private void checkVariables(JsonObject root) throws IllegalFileFormat {
        if (!root.has("signals")) {
            throw new IllegalFileFormat("Tag signals is missing!");
        }
        if (!root.get("signals").isJsonArray()) {
            throw new IllegalFileFormat("Tag signals is not array!");
        }
        JsonArray signal = root.get("signals").getAsJsonArray();
        if (signal.size() != this.recordHandler.size()) {
            throw new IllegalFileFormat("Wrong number of variables in tag signals!");
        }
        for (int i = 0; i < signal.size(); ++i) {
            JsonElement e = signal.get(i);
            if (!e.isJsonObject()) {
                throw new IllegalFileFormat("Tag signals should be an array of objects!");
            }
            JsonObject eo = e.getAsJsonObject();
            if (!eo.has("name")) {
                throw new IllegalFileFormat("Tag name is missing!");
            }
            if (!eo.has("type")) {
                throw new IllegalFileFormat("Tag type is missing!");
            }
            String name = eo.get("name").getAsString();
            String type = eo.get("type").getAsString();
            if (this.recordHandler.getVariableIndex(name) < 0) {
                throw new IllegalFileFormat("Unknown variable " + name + "!");
            }
            if (this.recordHandler.checkVariableType(name, type)) continue;
            throw new IllegalFileFormat("Wrong type for variable " + name + "! Expected " + this.recordHandler.getTypeCode(name) + " is " + type + "!");
        }
    }

    private void checkTraceType(JsonObject root) throws IllegalFileFormat {
        if (!root.has("trace_type")) {
            throw new IllegalFileFormat("Tag trace_type is missing!");
        }
        String trace_type = root.get("trace_type").getAsString();
        if (!"temporal".equals(trace_type)) {
            throw new IllegalFileFormat("Wrong value for tag trace_type: expected temporal is " + trace_type);
        }
    }
}

