/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.io.parsing;

import eu.quanticol.moonlight.io.parsing.ParsingStrategy;
import eu.quanticol.moonlight.io.parsing.PrintingStrategy;

public class RawTrajectoryExtractor
implements ParsingStrategy<double[][]>,
PrintingStrategy<double[][]> {
    private final int spaceNodes;
    private int timePoints;
    private int spaceLocations;
    private double[][] signal;
    private int spaceIterator;

    public RawTrajectoryExtractor(int spaceSize) {
        this.spaceNodes = spaceSize;
    }

    @Override
    public void initialize(String[] header) {
        this.timePoints = header.length;
        this.spaceIterator = 0;
        this.signal = new double[this.spaceNodes][this.timePoints];
    }

    @Override
    public void process(String[] data) {
        if (this.spaceIterator >= this.spaceNodes) {
            throw new UnsupportedOperationException("Trajectory bigger than spatial dimension. Are you importing multiple trajectories?");
        }
        for (int i = 0; i < data.length; ++i) {
            this.signal[this.spaceIterator][i] = Double.parseDouble(data[i]);
        }
        ++this.spaceIterator;
    }

    @Override
    public String initialize(double[][] header, String wordBreak) {
        this.spaceIterator = 0;
        this.spaceLocations = header.length;
        StringBuilder head = new StringBuilder("\"Space\"" + wordBreak);
        head.append("\"T").append(0).append("\"");
        for (int i = 1; i < header[0].length; ++i) {
            head.append(wordBreak).append("\"T").append(i).append("\"");
        }
        return head.toString();
    }

    @Override
    public String print(double[][] data, String wordBreak) {
        StringBuilder line = new StringBuilder("\"S" + this.spaceIterator + "\"" + wordBreak);
        if (this.spaceIterator == this.spaceLocations) {
            return null;
        }
        line.append(data[this.spaceIterator][0]);
        for (int i = 1; i < data[this.spaceIterator].length; ++i) {
            line.append(wordBreak).append(data[this.spaceIterator][i]);
        }
        ++this.spaceIterator;
        return line.toString();
    }

    @Override
    public boolean isComplete() {
        return this.spaceIterator == this.spaceLocations;
    }

    @Override
    public double[][] result() {
        return this.signal;
    }

    public int getTimePoints() {
        return this.timePoints;
    }
}

