/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.algorithms;

import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpaceIterator;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.offline.signal.ParallelSignalCursor;
import eu.quanticol.moonlight.offline.signal.SignalCursor;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;

public class SpatialOp<S, R> {
    private final SpaceIterator<Double, S> spaceItr;
    private final BiFunction<IntFunction<R>, DistanceStructure<S, ?>, IntFunction<R>> op;
    ParallelSignalCursor<R> cursor;
    private SpatialTemporalSignal<R> result;

    public SpatialOp(LocationService<Double, S> l, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance, BiFunction<IntFunction<R>, DistanceStructure<S, ?>, IntFunction<R>> operator) {
        this.op = operator;
        this.spaceItr = new SpaceIterator<Double, S>(l, distance);
    }

    public SpatialTemporalSignal<R> computeUnary(SpatialTemporalSignal<R> s) {
        this.outputInit(s.getNumberOfLocations());
        if (!this.spaceItr.isLocationServiceEmpty()) {
            this.doCompute(s);
        }
        return this.result;
    }

    private void outputInit(int locations) {
        this.result = new SpatialTemporalSignal(locations);
    }

    private void doCompute(SpatialTemporalSignal<R> s) {
        this.cursor = s.getSignalCursor(true);
        double t = (Double)this.cursor.getCurrentTime();
        this.spaceItr.init(t);
        while (!Double.isNaN(t) && SignalCursor.isNotCompleted(this.cursor)) {
            DistanceStructure<S, ?> ds = this.spaceItr.generateDistanceStructure();
            Object spatialSignal = this.cursor.getCurrentValue();
            double tNext = this.cursor.forwardTime();
            this.addResult(t, tNext, this.op.apply((IntFunction<R>)spatialSignal, ds));
            this.spaceItr.forEach(tNext, (arg_0, arg_1) -> this.lambda$doCompute$0(tNext, (IntFunction)spatialSignal, arg_0, arg_1));
            t = this.moveSpatialModel(tNext);
        }
    }

    private Double moveSpatialModel(@NotNull Double t) {
        if (this.spaceItr.isNextSpaceModelAtSameTime(t)) {
            this.spaceItr.shiftSpatialModel();
        }
        return t;
    }

    protected void addResult(Double start, Double end, IntFunction<R> value) {
        this.result.add((double)start, value);
    }

    private /* synthetic */ void lambda$doCompute$0(double tNext, IntFunction spatialSignal, Double itT, DistanceStructure itDs) {
        this.addResult(itT, tNext, this.op.apply(spatialSignal, itDs));
    }
}

