/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.monitoring.mfr;

import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.offline.algorithms.TemporalOp;
import eu.quanticol.moonlight.offline.monitoring.mfr.MfrMonitor;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import eu.quanticol.moonlight.offline.signal.mfr.MfrSignal;
import java.util.function.IntFunction;

public class MfrMonitorSince<S, T, R>
implements MfrMonitor<S, T, R> {
    private final MfrMonitor<S, T, R> m1;
    private final MfrMonitor<S, T, R> m2;
    private final Interval interval;
    private final SignalDomain<R> domain;

    public MfrMonitorSince(MfrMonitor<S, T, R> m1, Interval interval, MfrMonitor<S, T, R> m2, SignalDomain<R> domain) {
        this.m1 = m1;
        this.m2 = m2;
        this.interval = interval;
        this.domain = domain;
    }

    @Override
    public IntFunction<MfrSignal<R>> monitor(SpatialTemporalSignal<T> signal, IntFunction<int[]> locations) {
        return null;
    }

    @Override
    public SpatialTemporalSignal<R> monitor(SpatialTemporalSignal<T> signal) {
        SpatialTemporalSignal left = this.m1.monitor(signal);
        SpatialTemporalSignal<R> right = this.m2.monitor(signal);
        return left.applyToSignal(right, (s1, s2) -> TemporalOp.computeSince(this.domain, s1, this.interval, s2));
    }
}

