/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.monitoring.spatialtemporal;

import eu.quanticol.moonlight.core.algorithms.SpatialAlgorithms;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpaceIterator;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.offline.signal.ParallelSignalCursor;
import eu.quanticol.moonlight.offline.signal.ParallelSignalCursor1;
import eu.quanticol.moonlight.offline.signal.SignalCursor;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import java.util.function.Function;
import java.util.function.IntFunction;

public class SpatialBinaryOp<S, R> {
    private final SpaceIterator<Double, S> spaceItr;
    private final SignalDomain<R> domain;
    private SpatialTemporalSignal<R> result;

    public SpatialBinaryOp(LocationService<Double, S> l, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance, SignalDomain<R> domain) {
        this.domain = domain;
        this.spaceItr = new SpaceIterator<Double, S>(l, distance);
    }

    public SpatialTemporalSignal<R> computeReach(SpatialTemporalSignal<R> s1, SpatialTemporalSignal<R> s2) {
        this.outputInit(s1.getNumberOfLocations());
        if (!this.spaceItr.isLocationServiceEmpty()) {
            this.doCompute(s1, s2);
        }
        return this.result;
    }

    private void outputInit(int locations) {
        this.result = new SpatialTemporalSignal(locations);
    }

    public SpatialTemporalSignal<R> doCompute(SpatialTemporalSignal<R> s1, SpatialTemporalSignal<R> s2) {
        this.outputInit(s1.getNumberOfLocations());
        if (!this.spaceItr.isLocationServiceEmpty()) {
            ParallelSignalCursor1 c1 = s1.getSignalCursor(true);
            ParallelSignalCursor1 c2 = s2.getSignalCursor(true);
            double t = Math.max(s1.start(), s2.start());
            this.spaceItr.init(t);
            c1.move(t);
            c2.move(t);
            while (!Double.isNaN(t) && SignalCursor.isNotCompleted(new SignalCursor[]{c1, c2})) {
                DistanceStructure<S, ?> ds = this.spaceItr.generateDistanceStructure();
                Object spatialSignal1 = ((ParallelSignalCursor)c1).getCurrentValue();
                Object spatialSignal2 = ((ParallelSignalCursor)c2).getCurrentValue();
                this.result.add(t, SpatialAlgorithms.reach(this.domain, spatialSignal1, spatialSignal2, ds));
                t = this.getTNext(this.domain, (ParallelSignalCursor<R>)c1, (ParallelSignalCursor<R>)c2, (IntFunction<R>)spatialSignal1, (IntFunction<R>)spatialSignal2);
                if (!this.spaceItr.isNextSpaceModelMeaningful()) continue;
                this.spaceItr.shiftSpatialModel();
            }
        }
        return this.result;
    }

    private double getTNext(SignalDomain<R> domain, ParallelSignalCursor<R> c1, ParallelSignalCursor<R> c2, IntFunction<R> spatialSignal1, IntFunction<R> spatialSignal2) {
        double tNext = Math.min((Double)c1.nextTime(), (Double)c2.nextTime());
        c1.move(tNext);
        c2.move(tNext);
        this.spaceItr.forEach(tNext, (itT, itDs) -> {
            IntFunction output = SpatialAlgorithms.reach(domain, spatialSignal1, spatialSignal2, itDs);
            this.result.add((double)itT, output);
        });
        return tNext;
    }
}

