/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.monitoring.temporal;

import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.offline.monitoring.temporal.TemporalMonitorAtomic;
import eu.quanticol.moonlight.offline.monitoring.temporal.TemporalMonitorBinaryOperator;
import eu.quanticol.moonlight.offline.monitoring.temporal.TemporalMonitorFutureOperator;
import eu.quanticol.moonlight.offline.monitoring.temporal.TemporalMonitorPastOperator;
import eu.quanticol.moonlight.offline.monitoring.temporal.TemporalMonitorSince;
import eu.quanticol.moonlight.offline.monitoring.temporal.TemporalMonitorUnaryOperator;
import eu.quanticol.moonlight.offline.monitoring.temporal.TemporalMonitorUntil;
import eu.quanticol.moonlight.offline.signal.Signal;
import java.util.function.Function;

public interface TemporalMonitor<T, R> {
    public Signal<R> monitor(Signal<T> var1);

    public static <T, R> TemporalMonitor<T, R> atomicMonitor(Function<T, R> atomic) {
        return new TemporalMonitorAtomic<T, R>(atomic);
    }

    public static <T, R> TemporalMonitor<T, R> andMonitor(TemporalMonitor<T, R> m1, SignalDomain<R> domain, TemporalMonitor<T, R> m2) {
        return new TemporalMonitorBinaryOperator<T, R>(m1, domain::conjunction, m2);
    }

    public static <T, R> TemporalMonitor<T, R> orMonitor(TemporalMonitor<T, R> m1, SignalDomain<R> domain, TemporalMonitor<T, R> m2) {
        return new TemporalMonitorBinaryOperator<T, R>(m1, domain::disjunction, m2);
    }

    public static <T, R> TemporalMonitor<T, R> impliesMonitor(TemporalMonitor<T, R> m1, SignalDomain<R> domain, TemporalMonitor<T, R> m2) {
        return new TemporalMonitorBinaryOperator<T, R>(m1, domain::implies, m2);
    }

    public static <T, R> TemporalMonitor<T, R> notMonitor(TemporalMonitor<T, R> m, SignalDomain<R> domain) {
        return new TemporalMonitorUnaryOperator<T, R>(m, domain::negation);
    }

    public static <T, R> TemporalMonitor<T, R> eventuallyMonitor(TemporalMonitor<T, R> m, SignalDomain<R> domain) {
        return new TemporalMonitorFutureOperator<T, R>(m, domain::disjunction, domain.min());
    }

    public static <T, R> TemporalMonitor<T, R> eventuallyMonitor(TemporalMonitor<T, R> m, SignalDomain<R> domain, Interval interval) {
        return new TemporalMonitorFutureOperator<T, R>(m, domain::disjunction, domain.min(), interval);
    }

    public static <T, R> TemporalMonitor<T, R> globallyMonitor(TemporalMonitor<T, R> m, SignalDomain<R> domain) {
        return new TemporalMonitorFutureOperator<T, R>(m, domain::conjunction, domain.max());
    }

    public static <T, R> TemporalMonitor<T, R> globallyMonitor(TemporalMonitor<T, R> m, SignalDomain<R> domain, Interval interval) {
        return new TemporalMonitorFutureOperator<T, R>(m, domain::conjunction, domain.max(), interval);
    }

    public static <T, R> TemporalMonitor<T, R> untilMonitor(TemporalMonitor<T, R> m1, TemporalMonitor<T, R> m2, SignalDomain<R> domain) {
        return new TemporalMonitorUntil<T, R>(m1, m2, domain);
    }

    public static <T, R> TemporalMonitor<T, R> untilMonitor(TemporalMonitor<T, R> m1, Interval interval, TemporalMonitor<T, R> m2, SignalDomain<R> domain) {
        return new TemporalMonitorUntil<T, R>(m1, interval, m2, domain);
    }

    public static <T, R> TemporalMonitor<T, R> historicallyMonitor(TemporalMonitor<T, R> m, SignalDomain<R> domain) {
        return new TemporalMonitorPastOperator<T, R>(m, domain::conjunction, domain.max());
    }

    public static <T, R> TemporalMonitor<T, R> historicallyMonitor(TemporalMonitor<T, R> m, SignalDomain<R> domain, Interval interval) {
        return new TemporalMonitorPastOperator<T, R>(m, domain::conjunction, domain.max(), interval);
    }

    public static <T, R> TemporalMonitor<T, R> onceMonitor(TemporalMonitor<T, R> m, SignalDomain<R> domain) {
        return new TemporalMonitorPastOperator<T, R>(m, domain::disjunction, domain.min());
    }

    public static <T, R> TemporalMonitor<T, R> onceMonitor(TemporalMonitor<T, R> m, SignalDomain<R> domain, Interval interval) {
        return new TemporalMonitorPastOperator<T, R>(m, domain::disjunction, domain.min(), interval);
    }

    public static <T, R> TemporalMonitor<T, R> sinceMonitor(TemporalMonitor<T, R> m1, TemporalMonitor<T, R> m2, SignalDomain<R> domain) {
        return new TemporalMonitorSince<T, R>(m1, m2, domain);
    }

    public static <T, R> TemporalMonitor<T, R> sinceMonitor(TemporalMonitor<T, R> m1, Interval interval, TemporalMonitor<T, R> m2, SignalDomain<R> domain) {
        return new TemporalMonitorSince<T, R>(m1, interval, m2, domain);
    }
}

