/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.signal;

import eu.quanticol.moonlight.offline.signal.SignalCursor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.IntStream;

public abstract class ParallelSignalCursor1<V> {
    protected final List<SignalCursor<Double, V>> cursors;

    protected ParallelSignalCursor1(int size, IntFunction<SignalCursor<Double, V>> f) {
        this.cursors = new ArrayList<SignalCursor<Double, V>>(size);
        int[] locations = IntStream.range(0, size).toArray();
        this.initCursors(locations, f);
    }

    protected abstract void initCursors(int[] var1, IntFunction<SignalCursor<Double, V>> var2);

    protected ParallelSignalCursor1(int[] locations, IntFunction<SignalCursor<Double, V>> f) {
        this.cursors = new ArrayList<SignalCursor<Double, V>>(locations.length);
        this.initCursors(locations, f);
    }

    public boolean areSynchronized() {
        return !Double.isNaN(this.getCurrentTime());
    }

    public Double getCurrentTime() {
        double time = this.cursors.get(0).getCurrentTime();
        for (SignalCursor<Double, V> c : this.cursors) {
            if (c.getCurrentTime() == time) continue;
            return Double.NaN;
        }
        return time;
    }

    public double syncCursors() {
        double time = this.cursors.get(0).getCurrentTime();
        boolean flag = false;
        for (SignalCursor<Double, V> c : this.cursors) {
            if (time != c.getCurrentTime()) {
                flag = true;
            }
            time = Math.max(time, c.getCurrentTime());
        }
        if (flag) {
            this.move(time);
        }
        return time;
    }

    public void move(Double time) {
        for (SignalCursor<Double, V> c : this.cursors) {
            c.move(time);
        }
    }

    public void forward() {
        this.forwardTime();
    }

    public double forwardTime() {
        double time = this.nextTime();
        if (!Double.isNaN(time)) {
            this.move(time);
        }
        return time;
    }

    public Double nextTime() {
        double time = Double.POSITIVE_INFINITY;
        return this.subsequentTime(time, true);
    }

    private double subsequentTime(double time, boolean forward) {
        for (SignalCursor<Double, V> c : this.cursors) {
            double cursorTime = c.nextTime();
            if (Double.isNaN(cursorTime)) {
                return Double.NaN;
            }
            if (!this.isFirstAfterSecond(time, cursorTime, forward)) continue;
            time = cursorTime;
        }
        return time;
    }

    private boolean isFirstAfterSecond(double first, double second, boolean forward) {
        return forward ? first > second : first < second;
    }

    public void backward() {
        double time = this.previousTime();
        if (!Double.isNaN(time)) {
            this.move(time);
        }
    }

    public Double previousTime() {
        double time = Double.NEGATIVE_INFINITY;
        return this.subsequentTime(time, false);
    }

    public void revert() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public boolean hasNext() {
        for (SignalCursor<Double, V> c : this.cursors) {
            if (c.hasNext()) continue;
            return false;
        }
        return true;
    }

    public boolean hasPrevious() {
        for (SignalCursor<Double, V> c : this.cursors) {
            if (c.hasPrevious()) continue;
            return false;
        }
        return true;
    }

    public IntFunction<V> getCurrentValue() {
        return l -> this.getCursorAtLocation(l).getCurrentValue();
    }

    protected SignalCursor<Double, V> getCursorAtLocation(int location) {
        return this.cursors.get(location);
    }

    public List<SignalCursor<Double, V>> getCursors() {
        return this.cursors;
    }

    public boolean isCompleted() {
        for (SignalCursor<Double, V> signalCursor : this.cursors) {
            if (!signalCursor.isCompleted()) continue;
            return true;
        }
        return false;
    }
}

