/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.signal;

import eu.quanticol.moonlight.offline.signal.ParallelSignalCursor1;
import eu.quanticol.moonlight.offline.signal.Signal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;

public abstract class STSignal<T> {
    private final List<Signal<T>> signals;

    protected STSignal(int size, IntFunction<Signal<T>> f) {
        this.signals = new ArrayList<Signal<T>>(size);
        for (int i = 0; i < size; ++i) {
            this.getSignals().add(i, f.apply(i));
        }
    }

    public List<Signal<T>> getSignals() {
        return this.signals;
    }

    protected void checkSize(int inputSize) {
        if (inputSize != this.getNumberOfLocations()) {
            String error = "Input mismatch with signal size.";
            throw new IllegalArgumentException(error);
        }
    }

    public int getNumberOfLocations() {
        return this.signals.size();
    }

    public abstract ParallelSignalCursor1<T> getSignalCursor(boolean var1);

    public abstract Signal<T> getSignalAtLocation(int var1);

    public abstract <R> STSignal<R> apply(Function<T, R> var1);

    public String toString() {
        Optional<String> output = IntStream.range(0, this.getNumberOfLocations()).mapToObj(loc -> "loc=" + loc + ", signals=" + this.signals.get(loc).toString() + "; ").reduce(String::concat);
        return "[" + output.orElse("<Empty Signal>") + "]";
    }
}

