/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.signal;

import eu.quanticol.moonlight.core.signal.Sample;

public class Segment<T>
implements Sample<Double, T> {
    private double time;
    private T value;
    private Segment<T> next;
    private Segment<T> previous;
    private double end = Double.NaN;

    public Segment(double time, T value) {
        this.time = time;
        this.value = value;
        this.previous = null;
    }

    private Segment(Segment<T> previous, double time, T value) {
        this.previous = previous;
        this.time = time;
        this.value = value;
        this.end = time;
    }

    @Override
    public Double getStart() {
        return this.time;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public Segment<T> getNext() {
        return this.next;
    }

    public Segment<T> getPrevious() {
        return this.previous;
    }

    public void setNext(Segment<T> next) {
        this.next = next;
    }

    public T getValueAt(double t) {
        Segment<T> selected = this.jump(t);
        return selected == null ? null : (T)selected.value;
    }

    public Segment<T> jump(double t) {
        if (t < this.time) {
            return Segment.backwardTo(this, t);
        }
        return Segment.forwardTo(this, t);
    }

    public static <T> Segment<T> forwardTo(Segment<T> segment, double t) {
        Segment<T> cursor = segment;
        while (cursor != null) {
            if (cursor.contains(t)) {
                return cursor;
            }
            cursor = cursor.next;
        }
        return null;
    }

    public static <T> Segment<T> backwardTo(Segment<T> segment, double t) {
        Segment<T> cursor = segment;
        while (cursor != null) {
            if (cursor.contains(t)) {
                return cursor;
            }
            cursor = cursor.previous;
        }
        return null;
    }

    public boolean contains(double t) {
        return this.time == t || this.time <= t && (Double.isFinite(this.end) && t <= this.end || this.next != null && t < this.next.time);
    }

    public static <T> double getTime(Segment<T> s) {
        return s == null ? Double.NaN : s.getStart();
    }

    public Segment<T> addAfter(double time, T value) {
        if (this.time > time) {
            throw new IllegalArgumentException("Trying to add time: " + time + ". Expected > " + this.time);
        }
        if (this.time == time) {
            this.value = value;
            return this;
        }
        if (!this.value.equals(value)) {
            this.next = new Segment<T>(this, time, value);
            this.end = Double.NaN;
            return this.next;
        }
        this.end = time;
        this.next = null;
        return this;
    }

    public Segment<T> addBefore(double time, T value) {
        if (this.time <= time) {
            throw new IllegalArgumentException();
        }
        if (!this.value.equals(value)) {
            this.previous = new Segment<T>(this, time, value);
            this.previous.next = this;
            return this.previous;
        }
        if (this.isAPoint()) {
            this.end = this.time;
        }
        this.time = time;
        return this;
    }

    public Double getEnd() {
        return this.getSegmentEnd();
    }

    public double getSegmentEnd() {
        if (this.next == null) {
            if (Double.isNaN(this.end)) {
                return this.time;
            }
            return this.end;
        }
        return this.next.getStart();
    }

    public double getPreviousTime() {
        if (this.previous == null) {
            return Double.NaN;
        }
        return this.previous.getStart();
    }

    public String toString() {
        return (this.previous != null ? "<" : "[") + this.time + ":" + this.value + (this.next != null ? ">" : "]");
    }

    public void endAt(double end) {
        if (end < this.time) {
            throw new IllegalArgumentException();
        }
        this.end = end;
    }

    public Segment<T> splitAt(double time) {
        if (this.time >= time) {
            throw new IllegalArgumentException();
        }
        this.time = time;
        return this;
    }

    public boolean isTheEnd(double time) {
        return this.end == time;
    }

    public boolean doEndAt(double t) {
        return this.end == t;
    }

    public boolean isRightClosed() {
        return !Double.isNaN(this.end);
    }

    public double nextTimeAfter(double time) {
        if (this.next != null) {
            return this.next.getStart();
        }
        if (time < this.end) {
            return this.end;
        }
        return Double.NaN;
    }

    public void setFirst() {
        this.previous = null;
    }

    public boolean isAPoint() {
        return this.next == null && (Double.isNaN(this.end) || this.time == this.end);
    }
}

