/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.signal;

import java.util.Iterator;
import java.util.LinkedList;

public class TimeSequence {
    protected final LinkedList<Double> steps;

    public TimeSequence() {
        this(new LinkedList<Double>());
    }

    private TimeSequence(LinkedList<Double> steps) {
        this.steps = steps;
    }

    public void add(double t) {
        if (!this.steps.isEmpty() && this.steps.peekLast() >= t) {
            throw new IllegalArgumentException("A value greater than " + this.steps.peekLast() + " is expected! While " + t + " is used.");
        }
        this.steps.add(t);
    }

    public void addBefore(double t) {
        if (!this.steps.isEmpty() && this.steps.peekFirst() <= t) {
            throw new IllegalArgumentException("A value less than " + this.steps.peekLast() + " is expected! While " + t + " is used.");
        }
        this.steps.add(t);
    }

    public static TimeSequence merge(TimeSequence steps1, TimeSequence steps2) {
        return new TimeSequenceMerger(steps1, steps2).merge();
    }

    public boolean isEmpty() {
        return this.steps.isEmpty();
    }

    private static class TimeSequenceMerger {
        private final Iterator<Double> iterator1;
        private final Iterator<Double> iterator2;
        private final TimeSequence result;
        private double time1 = Double.NaN;
        private double time2 = Double.NaN;

        public TimeSequenceMerger(TimeSequence sequence1, TimeSequence sequence2) {
            this.iterator1 = sequence1.steps.iterator();
            this.iterator2 = sequence2.steps.iterator();
            this.result = new TimeSequence();
            this.stepIterator1();
            this.stepIterator2();
        }

        private void stepIterator1() {
            this.time1 = this.iterator1.hasNext() ? this.iterator1.next() : Double.NaN;
        }

        private void stepIterator2() {
            this.time2 = this.iterator2.hasNext() ? this.iterator2.next() : Double.NaN;
        }

        public TimeSequence merge() {
            while (!Double.isNaN(this.time1) && !Double.isNaN(this.time2)) {
                int code = this.mergeStep();
                if (code == 0 || code == 1) {
                    this.stepIterator1();
                }
                if (code != 0 && code != 2) continue;
                this.stepIterator2();
            }
            if (!Double.isNaN(this.time1)) {
                this.addAll(this.time1, this.iterator1);
            }
            if (!Double.isNaN(this.time2)) {
                this.addAll(this.time2, this.iterator2);
            }
            return this.result;
        }

        private void addAll(double time, Iterator<Double> iterator) {
            this.result.add(time);
            while (iterator.hasNext()) {
                this.result.add(iterator.next());
            }
        }

        private int mergeStep() {
            if (this.time1 == this.time2) {
                this.result.add(this.time1);
                return 0;
            }
            if (this.time1 < this.time2) {
                this.result.add(this.time1);
                return 1;
            }
            this.result.add(this.time2);
            return 2;
        }
    }
}

