/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.signal.mfr;

import eu.quanticol.moonlight.offline.algorithms.BooleanOp;
import eu.quanticol.moonlight.offline.signal.ParallelSignalCursor1;
import eu.quanticol.moonlight.offline.signal.STSignal;
import eu.quanticol.moonlight.offline.signal.Signal;
import eu.quanticol.moonlight.offline.signal.mfr.MfrCursor;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public class MfrSignal<T>
extends STSignal<T> {
    private final int[] locations;

    public MfrSignal(int size, IntFunction<Signal<T>> generator) {
        super(size, generator);
        this.locations = IntStream.range(1, size).toArray();
    }

    public MfrSignal(int size, IntFunction<Signal<T>> generator, int[] locations) {
        super(size, generator);
        this.locations = locations;
    }

    private static boolean contains(int target, int[] elements) {
        for (int element : elements) {
            if (element != target) continue;
            return true;
        }
        return false;
    }

    public T getValueAt(int location, double time) {
        return this.getSignalAtLocation(location).getValueAt(time);
    }

    @Override
    public Signal<T> getSignalAtLocation(int location) {
        int position = this.hasLocation(location);
        if (position >= 0) {
            return this.getSignals().get(position);
        }
        String error = "The signal is not defined at the given location";
        throw new IllegalArgumentException(error);
    }

    private int hasLocation(int location) {
        return Arrays.binarySearch(this.locations, location);
    }

    public int[] getLocationsSet() {
        return this.locations;
    }

    @Override
    public <R> MfrSignal<R> apply(Function<T, R> f) {
        return new MfrSignal<T>(this.getNumberOfLocations(), i -> this.partialFunction(i, j -> this.mappedSignal(j, f)), this.locations);
    }

    private <A> A partialFunction(int location, IntFunction<A> partialValue) {
        if (this.hasLocation(location) >= 0) {
            return partialValue.apply(location);
        }
        String error = "Signal undefined at location " + location + "!";
        return null;
    }

    private <R> Signal<R> mappedSignal(int l, Function<T, R> f) {
        BooleanOp<T, R> booleanOp = new BooleanOp<T, R>();
        return booleanOp.applyUnary(this.getSignalAtLocation(l), f);
    }

    public MfrSignal<T> filter(Predicate<T> p) {
        return new MfrSignal<T>(this.getNumberOfLocations(), i -> this.partialFunction(i, j -> this.filteredSignal(i, p)), this.locations);
    }

    private Signal<T> filteredSignal(int l, Predicate<T> p) {
        BooleanOp booleanOp = new BooleanOp();
        return booleanOp.filterUnary(this.getSignalAtLocation(l), p);
    }

    @Override
    public ParallelSignalCursor1<T> getSignalCursor(boolean forward) {
        IntFunction cursor = l -> this.getSignalAtLocation(l).getIterator(forward);
        return new MfrCursor(this.locations, cursor);
    }

    public MfrSignal<T> combine(BinaryOperator<T> f, STSignal<T> s, int[] locations) {
        this.checkSize(s.getNumberOfLocations());
        return new MfrSignal<T>(this.getNumberOfLocations(), i -> MfrSignal.binaryOpSignal(i, f, this, s), locations);
    }

    private static <T, R> Signal<R> binaryOpSignal(int i, BiFunction<T, T, R> f, STSignal<T> s1, STSignal<T> s2) {
        BooleanOp<T, R> booleanOp = new BooleanOp<T, R>();
        return booleanOp.applyBinary(s1.getSignalAtLocation(i), f, s2.getSignalAtLocation(i));
    }
}

