/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.algorithms;

import eu.quanticol.moonlight.core.signal.Sample;
import eu.quanticol.moonlight.online.signal.ChainIterator;
import eu.quanticol.moonlight.online.signal.ChainsCombinator;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.TimeSegment;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class BooleanOp {
    private BooleanOp() {
    }

    public static <T extends Comparable<T>, V, R> Update<T, R> atom(Update<T, V> u, Function<V, R> op) {
        return new Update<T, R>(u.getStart(), u.getEnd(), op.apply(u.getValue()));
    }

    public static <T extends Comparable<T>, V, R> TimeChain<T, R> atomSequence(TimeChain<T, V> us, Function<V, R> op) {
        List ls = us.stream().map(s -> new TimeSegment(s.getStart(), op.apply(s.getValue()))).collect(Collectors.toList());
        return new TimeChain(ls, us.getEnd());
    }

    public static <T extends Comparable<T>, V, R> TimeChain<T, R> atomSequence(Update<T, V> u, Function<V, R> op) {
        ArrayList ups = new ArrayList();
        ups.add(BooleanOp.atom(u, op));
        return Update.asTimeChain(ups);
    }

    public static <T extends Comparable<T>, R> List<Update<T, R>> unary(Update<T, R> u, UnaryOperator<R> op) {
        Update result = new Update(u.getStart(), u.getEnd(), op.apply(u.getValue()));
        ArrayList<Update<T, R>> results = new ArrayList<Update<T, R>>();
        results.add(result);
        return results;
    }

    public static <T extends Comparable<T>, R> TimeChain<T, R> unarySequence(TimeChain<T, R> us, UnaryOperator<R> op) {
        List ls = us.stream().map(s -> new TimeSegment(s.getStart(), op.apply(s.getValue()))).collect(Collectors.toList());
        return new TimeChain(ls, us.getEnd());
    }

    public static <T extends Comparable<T>, R> TimeChain<T, R> binarySequence(TimeChain<T, R> c1, TimeChain<T, R> us, BinaryOperator<R> op) {
        ArrayList updates = new ArrayList(us.size());
        ChainsCombinator itr = new ChainsCombinator(c1, us);
        itr.forEach((segment, update) -> BooleanOp.binaryOp(segment, update, updates, op));
        return new TimeChain(updates, us.getEnd());
    }

    public static <T extends Comparable<T>, R> List<Update<T, R>> binary(TimeChain<T, R> c1, Update<T, R> u, BinaryOperator<R> op) {
        List<Update<T, R>> updates = BooleanOp.rightApply(c1, op, u);
        return updates;
    }

    private static <T extends Comparable<T>, R> List<Update<T, R>> rightApply(TimeChain<T, R> s, BinaryOperator<R> op, Update<T, R> u) {
        ArrayList<Update<T, R>> updates = new ArrayList<Update<T, R>>();
        ChainIterator itr = s.chainIterator();
        while (itr.hasNext()) {
            Sample<T, R> curr = itr.next();
            T nextTime = BooleanOp.tryPeekNextStart(itr, s.getEnd());
            BooleanOp.exec(curr, u, nextTime, op, updates);
        }
        return updates;
    }

    private static <T extends Comparable<T>, R> void exec(Sample<T, R> curr, Update<T, R> u, T nextTime, BinaryOperator<R> op, List<Update<T, R>> updates) {
        if (curr.getStart().compareTo(u.getEnd()) < 0 && nextTime.compareTo(u.getStart()) >= 0) {
            T end = BooleanOp.min(nextTime, u.getEnd());
            T start = BooleanOp.max(curr.getStart(), u.getStart());
            if (!start.equals(end)) {
                Update r = new Update(start, end, op.apply(u.getValue(), curr.getValue()));
                updates.add(r);
            }
        }
    }

    private static <T extends Comparable<T>, R> void binaryOp(Sample<T, R> left, Sample<T, R> right, List<Sample<T, R>> output, BinaryOperator<R> op) {
        T start = BooleanOp.max(left, right).getStart();
        Object value = op.apply(right.getValue(), left.getValue());
        TimeSegment r = new TimeSegment(start, value);
        int last = output.size() - 1;
        if (output.isEmpty() || !output.get(last).getValue().equals(value)) {
            output.add(r);
        }
    }

    private static <R extends Comparable<R>> R max(R a, R b) {
        return a.compareTo(b) >= 0 ? a : b;
    }

    private static <R extends Comparable<R>> R min(R a, R b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    static <T extends Comparable<T>, V> T tryPeekNextStart(ChainIterator<Sample<T, V>> itr, T defaultValue) {
        if (itr.hasNext()) {
            return itr.peekNext().getStart();
        }
        return defaultValue;
    }
}

