/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.algorithms;

import eu.quanticol.moonlight.core.signal.Sample;
import eu.quanticol.moonlight.online.signal.ChainIterator;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.TimeSegment;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.function.BiPredicate;

public class Signals {
    private Signals() {
    }

    public static <V> boolean refineChain(TimeChain<Double, V> s, TimeChain<Double, V> updates, BiPredicate<V, V> refinable) {
        ChainIterator<Sample<Double, V>> utr = updates.chainIterator();
        ChainIterator<Sample<Double, V>> itr = s.chainIterator();
        Sample<Double, V> current = itr.next();
        V prevV = current.getValue();
        if (utr.hasNext()) {
            Update<Double, V> u = Signals.nextUpdate(utr, updates.getEnd());
            while (true) {
                if (Signals.stillRefining(itr, current, u, refinable, prevV, s.getEnd())) {
                    prevV = current.getValue();
                    current = itr.next();
                    continue;
                }
                if (!utr.hasNext()) break;
                u = Signals.nextUpdate(utr, updates.getEnd());
                current = itr.previous();
                if (itr.hasPrevious()) {
                    current = itr.previous();
                }
                prevV = itr.tryPeekPrevious(current).getValue();
            }
        }
        return itr.noEffects();
    }

    public static <V> boolean refine(TimeChain<Double, V> s, Update<Double, V> u, BiPredicate<V, V> refinable) {
        ChainIterator<Sample<Double, V>> itr = s.chainIterator();
        Sample<Double, V> current = itr.next();
        V prevV = current.getValue();
        while (Signals.stillRefining(itr, current, u, refinable, prevV, s.getEnd())) {
            prevV = current.getValue();
            current = itr.next();
        }
        return itr.noEffects();
    }

    private static <V> Update<Double, V> nextUpdate(ChainIterator<Sample<Double, V>> itr, double end) {
        Sample<Double, V> fst = itr.next();
        Double sEnd = itr.hasNext() ? itr.peekNext().getStart() : end;
        return new Update<Double, V>(fst.getStart(), sEnd, fst.getValue());
    }

    private static <V> boolean stillRefining(ChainIterator<Sample<Double, V>> itr, Sample<Double, V> curr, Update<Double, V> u, BiPredicate<V, V> refinable, V prevV, double lastT) {
        double t = curr.getStart();
        V v = curr.getValue();
        double tNext = itr.hasNext() ? itr.peekNext().getStart() : lastT;
        double from = u.getStart();
        double to = u.getEnd();
        V vNew = u.getValue();
        return !Signals.doRefine(itr, from, to, vNew, t, tNext, v, prevV, refinable);
    }

    public static <V> boolean doRefine(ChainIterator<Sample<Double, V>> itr, double from, double to, V vNew, double t, double tNext, V v, V prevV, BiPredicate<V, V> refinable) {
        Signals.processUpdate(itr, from, to, vNew, t, tNext, v, prevV, refinable);
        if (to < tNext && t != to) {
            Signals.add(itr, to, v);
            return true;
        }
        if (t == from && itr.hasNext() && itr.peekNext().getValue().equals(vNew)) {
            itr.next();
            Signals.remove(itr);
            itr.previous();
        }
        return t >= to;
    }

    private static <V> void processUpdate(ChainIterator<Sample<Double, V>> itr, double from, double to, V vNew, double t, double tNext, V v, V prevV, BiPredicate<V, V> refinable) {
        if (t < from && tNext > from && refinable.test(v, vNew)) {
            Signals.add(itr, from, vNew);
        }
        if (t == from && !v.equals(vNew)) {
            Signals.update(itr, t, v, vNew, refinable, prevV);
        }
        if (t > from && t < to && refinable.test(v, vNew) && !v.equals(vNew)) {
            Signals.remove(itr);
        }
    }

    private static <V> void update(ChainIterator<Sample<Double, V>> itr, double t, V v, V vNew, BiPredicate<V, V> refinable, V prevV) {
        boolean isRefinable = refinable.test(v, vNew);
        if (isRefinable && prevV.equals(vNew)) {
            Signals.remove(itr);
        } else if (isRefinable) {
            TimeSegment<Double, V> s = new TimeSegment<Double, V>(t, vNew);
            itr.set(s);
        } else {
            throw new UnsupportedOperationException("Refining interval: " + vNew + " is wider than the original:" + v);
        }
    }

    private static <V> void remove(ChainIterator<Sample<Double, V>> itr) {
        itr.previous();
        itr.remove();
    }

    private static <V> void add(ChainIterator<Sample<Double, V>> itr, Double start, V vNew) {
        if (itr.hasPrevious() && !itr.peekPrevious().getValue().equals(vNew)) {
            itr.add(new TimeSegment<Double, V>(start, vNew));
        }
        if (itr.hasNext() && itr.peekNext().getValue().equals(vNew)) {
            itr.next();
            Signals.remove(itr);
            if (itr.hasPrevious()) {
                itr.previous();
            }
        }
    }

    public static <T extends Comparable<T>, V> TimeChain<T, V> select(TimeChain<T, V> segments, T from, T to) {
        if (from.compareTo(to) > 0) {
            throw new UnsupportedOperationException("Illegal selection span");
        }
        int start = 0;
        int end = 1;
        ChainIterator<Sample<T, V>> itr = segments.chainIterator();
        do {
            Sample<T, V> current;
            if ((current = itr.next()).getStart().compareTo(to) > 0) {
                end = itr.previousIndex();
                break;
            }
            if (current.getStart().compareTo(from) <= 0) {
                start = itr.previousIndex();
            }
            if (!itr.tryPeekNext(current).equals(current)) continue;
            end = itr.previousIndex() + 1;
        } while (itr.hasNext());
        return segments.subChain(start, end, to);
    }
}

