/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.monitoring;

import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.formula.Formula;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.signal.TimeSignal;
import eu.quanticol.moonlight.formula.AtomicFormula;
import eu.quanticol.moonlight.formula.classic.AndFormula;
import eu.quanticol.moonlight.formula.classic.NegationFormula;
import eu.quanticol.moonlight.formula.classic.OrFormula;
import eu.quanticol.moonlight.formula.temporal.EventuallyFormula;
import eu.quanticol.moonlight.formula.temporal.GloballyFormula;
import eu.quanticol.moonlight.online.monitoring.OnlineMonitor;
import eu.quanticol.moonlight.online.monitoring.temporal.AtomicMonitor;
import eu.quanticol.moonlight.online.monitoring.temporal.BinaryMonitor;
import eu.quanticol.moonlight.online.monitoring.temporal.TemporalOpMonitor;
import eu.quanticol.moonlight.online.monitoring.temporal.UnaryMonitor;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.Update;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class OnlineTimeMonitor<V, R extends Comparable<R>> {
    private final Formula formula;
    private final SignalDomain<R> interpretation;
    private final Map<String, OnlineMonitor<Double, V, Box<R>>> monitors;
    private final Map<String, Function<V, Box<R>>> atoms;

    public OnlineTimeMonitor(Formula formula, SignalDomain<R> interpretation, Map<String, Function<V, Box<R>>> atomicPropositions) {
        this.atoms = atomicPropositions;
        this.formula = formula;
        this.interpretation = interpretation;
        this.monitors = new HashMap<String, OnlineMonitor<Double, V, Box<R>>>();
    }

    private OnlineMonitor<Double, V, Box<R>> monitor(Formula f) {
        Formula formula = f;
        Objects.requireNonNull(formula);
        Formula formula2 = formula;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AtomicFormula.class, NegationFormula.class, AndFormula.class, OrFormula.class, EventuallyFormula.class, GloballyFormula.class}, (Object)formula2, n)) {
            case 0 -> {
                AtomicFormula atomic = (AtomicFormula)formula2;
                yield this.generateAtomicMonitor(atomic);
            }
            case 1 -> {
                NegationFormula negation = (NegationFormula)formula2;
                yield this.generateNegationMonitor(negation);
            }
            case 2 -> {
                AndFormula and = (AndFormula)formula2;
                yield this.generateAndMonitor(and);
            }
            case 3 -> {
                OrFormula or = (OrFormula)formula2;
                yield this.generateOrMonitor(or);
            }
            case 4 -> {
                EventuallyFormula ev = (EventuallyFormula)formula2;
                yield this.generateEventuallyMonitor(ev);
            }
            case 5 -> {
                GloballyFormula globally = (GloballyFormula)formula2;
                yield this.generateGloballyMonitor(globally);
            }
            default -> this.illegalFormula(f);
        };
    }

    private OnlineMonitor<Double, V, Box<R>> illegalFormula(Formula f) {
        throw new IllegalArgumentException("Unsupported formula: " + f);
    }

    public TimeSignal<Double, Box<R>> monitor(@NotNull Update<Double, V> update) {
        OnlineMonitor<Double, V, Box<R>> m = this.monitor(this.formula);
        m.monitor(update);
        return m.getResult();
    }

    public TimeSignal<Double, Box<R>> monitor(@NotNull TimeChain<Double, V> updates) {
        OnlineMonitor<Double, V, Box<R>> m = this.monitor(this.formula);
        m.monitor(updates);
        return m.getResult();
    }

    private OnlineMonitor<Double, V, Box<R>> generateAtomicMonitor(AtomicFormula f) {
        Function<V, Box<R>> func = this.fetchAtom(f);
        return this.monitors.computeIfAbsent(f.toString(), x -> new AtomicMonitor(func, this.interpretation));
    }

    private OnlineMonitor<Double, V, Box<R>> generateNegationMonitor(NegationFormula formula) {
        OnlineMonitor<Double, V, Box<R>> argumentMonitor = this.monitor(formula.getArgument());
        return this.monitors.computeIfAbsent(formula.toString(), x -> new UnaryMonitor(argumentMonitor, v -> this.negation((Box<R>)v, this.interpretation), this.interpretation));
    }

    private OnlineMonitor<Double, V, Box<R>> generateAndMonitor(AndFormula formula) {
        OnlineMonitor<Double, V, Box<R>> firstArgMonitor = this.monitor(formula.getFirstArgument());
        OnlineMonitor<Double, V, Box<R>> secondArgMonitor = this.monitor(formula.getSecondArgument());
        return this.monitors.computeIfAbsent(formula.toString(), x -> new BinaryMonitor(firstArgMonitor, secondArgMonitor, (v1, v2) -> this.conjunction((Box<R>)v1, (Box<R>)v2, this.interpretation), this.interpretation));
    }

    private OnlineMonitor<Double, V, Box<R>> generateOrMonitor(OrFormula formula) {
        OnlineMonitor<Double, V, Box<R>> firstArgMonitor = this.monitor(formula.getFirstArgument());
        OnlineMonitor<Double, V, Box<R>> secondArgMonitor = this.monitor(formula.getSecondArgument());
        return this.monitors.computeIfAbsent(formula.toString(), x -> new BinaryMonitor(firstArgMonitor, secondArgMonitor, (v1, v2) -> this.disjunction((Box<R>)v1, (Box<R>)v2, this.interpretation), this.interpretation));
    }

    private OnlineMonitor<Double, V, Box<R>> generateEventuallyMonitor(EventuallyFormula formula) {
        OnlineMonitor<Double, V, Box<R>> argumentMonitor = this.monitor(formula.getArgument());
        return this.monitors.computeIfAbsent(formula.toString(), x -> new TemporalOpMonitor(argumentMonitor, (v1, v2) -> this.disjunction((Box<R>)v1, (Box<R>)v2, this.interpretation), formula.getInterval(), this.interpretation));
    }

    private OnlineMonitor<Double, V, Box<R>> generateGloballyMonitor(GloballyFormula formula) {
        OnlineMonitor<Double, V, Box<R>> argumentMonitor = this.monitor(formula.getArgument());
        return this.monitors.computeIfAbsent(formula.toString(), x -> new TemporalOpMonitor(argumentMonitor, (v1, v2) -> this.conjunction((Box<R>)v1, (Box<R>)v2, this.interpretation), formula.getInterval(), this.interpretation));
    }

    private Box<R> negation(Box<R> value, SignalDomain<R> domain) {
        return new Box<Comparable>((Comparable)domain.negation(value.getEnd()), (Comparable)domain.negation(value.getStart()));
    }

    private Box<R> conjunction(Box<R> fstVal, Box<R> sndVal, SignalDomain<R> domain) {
        return new Box<Comparable>((Comparable)domain.conjunction(fstVal.getStart(), sndVal.getStart()), (Comparable)domain.conjunction(fstVal.getEnd(), sndVal.getEnd()));
    }

    private Box<R> disjunction(Box<R> fstVal, Box<R> sndVal, SignalDomain<R> domain) {
        return new Box<Comparable>((Comparable)domain.disjunction(fstVal.getStart(), sndVal.getStart()), (Comparable)domain.disjunction(fstVal.getEnd(), sndVal.getEnd()));
    }

    private Function<V, Box<R>> fetchAtom(AtomicFormula f) {
        Function<V, Box<R>> atom = this.atoms.get(f.getAtomicId());
        if (atom == null) {
            throw new IllegalArgumentException("Unknown atomic ID " + f.getAtomicId());
        }
        return atom;
    }
}

