/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.signal;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ChainIterator<E>
implements ListIterator<E> {
    private final ListIterator<E> itr;
    private boolean changed;
    private static final String NO_NEXT = "There is no next element!";
    private static final String NO_PREV = "There is no previous element!";

    public ChainIterator(List<E> list, int index) {
        this.itr = list.listIterator(index);
        this.changed = false;
    }

    public ChainIterator(List<E> list) {
        this(list, 0);
    }

    public boolean noEffects() {
        return !this.changed;
    }

    public E peekNext() {
        if (this.hasNext()) {
            E e = this.next();
            this.previous();
            if (this.hasPrevious()) {
                this.previous();
                this.next();
            }
            return e;
        }
        throw new NoSuchElementException(NO_NEXT);
    }

    public E peekPrevious() {
        if (this.hasPrevious()) {
            E e = this.previous();
            this.next();
            return e;
        }
        throw new NoSuchElementException(NO_PREV);
    }

    public E tryPeekNext(E other) {
        if (this.hasNext()) {
            return this.peekNext();
        }
        return other;
    }

    public E tryPeekPrevious(E other) {
        if (this.hasPrevious()) {
            return this.peekPrevious();
        }
        return other;
    }

    @Override
    public boolean hasNext() {
        return this.itr.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.itr.hasPrevious();
    }

    @Override
    public int nextIndex() {
        return this.itr.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.itr.previousIndex();
    }

    @Override
    public E next() {
        return this.itr.next();
    }

    @Override
    public E previous() {
        return this.itr.previous();
    }

    @Override
    public void remove() {
        this.itr.remove();
        this.changed = true;
    }

    @Override
    public void set(E e) {
        this.itr.set(e);
        this.changed = true;
    }

    @Override
    public void add(E e) {
        this.itr.add(e);
        this.changed = true;
    }
}

