/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.signal;

import eu.quanticol.moonlight.core.signal.Sample;
import eu.quanticol.moonlight.online.signal.ChainIterator;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.TimeSegment;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public class ChainsCombinator<T extends Comparable<T>, V> {
    private final ChainIterator<Sample<T, V>> primary;
    private final ChainIterator<Sample<T, V>> secondary;
    private final Sample<T, V> primaryEnd;
    private final Sample<T, V> secondaryEnd;
    Sample<T, V> primaryCurr;
    Sample<T, V> primaryNext;
    Sample<T, V> secondaryCurr;
    Sample<T, V> secondaryNext;

    public ChainsCombinator(@NotNull TimeChain<T, V> primaryChain, @NotNull TimeChain<T, V> secondaryChain) {
        if (primaryChain.isEmpty() || secondaryChain.isEmpty()) {
            throw new IllegalArgumentException("Both chains must not be empty");
        }
        this.primary = primaryChain.chainIterator();
        this.secondary = secondaryChain.chainIterator();
        this.primaryEnd = this.endingSegment(primaryChain);
        this.secondaryEnd = this.endingSegment(secondaryChain);
    }

    public void forEach(BiConsumer<Sample<T, V>, Sample<T, V>> operation) {
        this.movePrimary();
        this.moveSecondary();
        do {
            if (this.notYetRelevant()) {
                this.movePrimary();
                continue;
            }
            if (this.notAnymoreRelevant()) {
                this.moveSecondary();
                continue;
            }
            this.process(operation);
        } while (this.stillToProcess());
    }

    private void movePrimary() {
        this.primaryCurr = this.primary.hasNext() ? this.primary.next() : this.primaryEnd;
        this.primaryNext = this.primary.tryPeekNext(this.primaryEnd);
    }

    private void moveSecondary() {
        this.secondaryCurr = this.secondary.hasNext() ? this.secondary.next() : this.secondaryEnd;
        this.secondaryNext = this.secondary.tryPeekNext(this.secondaryEnd);
    }

    private boolean notAnymoreRelevant() {
        return this.primaryCurr.compareTo(this.secondaryNext) > 0;
    }

    private boolean notYetRelevant() {
        return this.primaryNext.compareTo(this.secondaryCurr) <= 0;
    }

    private void process(BiConsumer<Sample<T, V>, Sample<T, V>> op) {
        op.accept(this.primaryCurr, this.secondaryCurr);
        if (this.secondaryProcessingNotComplete()) {
            this.movePrimary();
        } else {
            this.moveSecondary();
        }
    }

    private boolean secondaryProcessingNotComplete() {
        return this.primaryNext.compareTo(this.secondaryNext) < 0;
    }

    private boolean stillToProcess() {
        return !this.secondaryEnd.equals(this.secondaryCurr);
    }

    private Sample<T, V> endingSegment(TimeChain<T, V> chain) {
        return new TimeSegment<T, V>(chain.getEnd(), chain.getLast().getValue());
    }
}

