/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.signal;

import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.signal.Sample;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.signal.TimeSignal;
import eu.quanticol.moonlight.online.algorithms.Signals;
import eu.quanticol.moonlight.online.signal.ChainIterator;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.TimeSegment;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.List;
import java.util.stream.IntStream;

public class MultiOnlineSignal
implements TimeSignal<Double, List<Box<?>>> {
    private final TimeChain<Double, List<Box<?>>> segments;

    public MultiOnlineSignal(SignalDomain<List<Box<?>>> domain) {
        this.segments = new TimeChain(new TimeSegment(0.0, domain.any()), Double.valueOf(Double.POSITIVE_INFINITY));
    }

    @Override
    public TimeChain<Double, List<Box<?>>> getSegments() {
        return this.segments;
    }

    public double getStart() {
        assert (this.segments.getFirst() != null);
        return this.segments.getFirst().getStart();
    }

    @Override
    public boolean refine(Update<Double, List<Box<?>>> u) {
        return Signals.refine(this.segments, u, (v, vNew) -> IntStream.range(0, v.size()).filter(i -> !((Box)v.get(i)).contains((Box)vNew.get(i))).boxed().count() != 0L);
    }

    @Override
    public boolean refine(TimeChain<Double, List<Box<?>>> updates) {
        return Signals.refineChain(this.segments, updates, (v, vNew) -> IntStream.range(0, v.size()).filter(i -> !((Box)v.get(i)).contains((Box)vNew.get(i))).boxed().count() != 0L);
    }

    @Override
    public TimeChain<Double, List<Box<?>>> select(Double from, Double to) {
        int start = 0;
        int end = 1;
        ChainIterator<Sample<Double, List<Box<?>>>> itr = this.segments.chainIterator();
        while (itr.hasNext()) {
            Sample<Double, List<Box<?>>> current = itr.next();
            if (current.getStart() > from && start == 0) {
                start = itr.previousIndex();
            }
            if (!(current.getStart() > to)) continue;
            end = itr.previousIndex();
            break;
        }
        return this.segments.subChain(start, end, to);
    }

    public String toString() {
        return "OnlineSignal{segments=" + this.segments + "}";
    }
}

