/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.signal;

import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.signal.TimeSignal;
import eu.quanticol.moonlight.online.algorithms.Signals;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.TimeSegment;
import eu.quanticol.moonlight.online.signal.Update;

public class OnlineSignal<D extends Comparable<D>>
implements TimeSignal<Double, Box<D>> {
    private final TimeChain<Double, Box<D>> segments;

    public OnlineSignal(SignalDomain<D> domain) {
        Box<Comparable> i = new Box<Comparable>((Comparable)domain.min(), (Comparable)domain.max());
        this.segments = new TimeChain<Double, Box<Comparable>>(new TimeSegment<Double, Box<Comparable>>(0.0, i), Double.valueOf(Double.POSITIVE_INFINITY));
    }

    public OnlineSignal(Box<D> defaultValue) {
        this.segments = new TimeChain<Double, Box<D>>(new TimeSegment<Double, Box<D>>(0.0, defaultValue), Double.valueOf(Double.POSITIVE_INFINITY));
    }

    @Override
    public TimeChain<Double, Box<D>> getSegments() {
        return this.segments;
    }

    public double getStart() {
        assert (this.segments.getFirst() != null);
        return this.segments.getFirst().getStart();
    }

    @Override
    public boolean refine(Update<Double, Box<D>> u) {
        return Signals.refine(this.segments, u, Box::contains);
    }

    @Override
    public boolean refine(TimeChain<Double, Box<D>> updates) {
        return Signals.refineChain(this.segments, updates, Box::contains);
    }

    @Override
    public TimeChain<Double, Box<D>> select(Double from, Double to) {
        return Signals.select(this.segments, from, to);
    }

    public String toString() {
        return "OnlineSignal{segments=" + this.segments + "}";
    }
}

