/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.signal;

import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.TimeSegment;
import java.util.List;

public record Update<T extends Comparable<T>, V>(T start, T end, V value) {
    public Update {
        if (start.compareTo(end) > 0 || start.equals(end)) {
            throw new IllegalArgumentException("Invalid update time span: [" + start + ", " + end + ")");
        }
    }

    public T getStart() {
        return this.start;
    }

    public T getEnd() {
        return this.end;
    }

    public V getValue() {
        return this.value;
    }

    public static <T extends Comparable<T>, V> TimeChain<T, V> asTimeChain(List<Update<T, V>> ups) {
        T end = ups.get(ups.size() - 1).end();
        TimeChain<T, V> chain = new TimeChain<T, V>(end);
        for (int i = 0; i < ups.size(); ++i) {
            if (i != ups.size() - 1) {
                if (ups.get(i).getEnd().equals(ups.get(i + 1).getStart())) {
                    chain.add(new TimeSegment<T, V>(ups.get(i).getStart(), ups.get(i).getValue()));
                    continue;
                }
                throw new UnsupportedOperationException("Updates " + i + " and " + (i + 1) + " are not sequential");
            }
            chain.add(new TimeSegment<T, V>(ups.get(i).getStart(), ups.get(i).getValue()));
        }
        return chain;
    }
}

