/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.space;

import eu.quanticol.moonlight.core.space.DistanceDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.domain.IntegerDomain;
import eu.quanticol.moonlight.space.RegularGridModel;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class IntManhattanDistanceStructure
implements DistanceStructure<Integer, Integer> {
    private final int lowerBound;
    private final boolean parallel;
    private final int upperBound;
    private final RegularGridModel<Integer> model;
    private final int cappedUpperBound;
    private int[][] distanceMatrix;
    private int[][] oneStepDistanceMatrix;

    public IntManhattanDistanceStructure(int lowerBound, int upperBound, @NotNull RegularGridModel<Integer> model) {
        this(false, lowerBound, upperBound, model);
    }

    public IntManhattanDistanceStructure(boolean parallel, int lowerBound, int upperBound, @NotNull RegularGridModel<Integer> model) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.model = model;
        this.parallel = parallel;
        this.cappedUpperBound = Math.min(model.size(), upperBound + 1);
        this.computeDistanceMatrix();
    }

    private void computeDistanceMatrix() {
        this.distanceMatrix = new int[this.model.size()][0];
        this.prepareOneStepDistanceMatrix();
        this.computeReachableSets();
    }

    private void prepareOneStepDistanceMatrix() {
        this.oneStepDistanceMatrix = new int[this.model.size()][4];
        IntStream.range(0, this.model.size()).forEach(i -> {
            this.oneStepDistanceMatrix[i] = this.model.getNeighboursArray(i);
        });
    }

    private void computeReachableSets() {
        if (this.parallel) {
            IntStream.range(0, this.model.size()).parallel().forEach(this::computeLocationReachableSet);
        } else {
            IntStream.range(0, this.model.size()).forEach(this::computeLocationReachableSet);
        }
    }

    private void computeLocationReachableSet(int location) {
        IntStream.range(this.lowerBound, this.cappedUpperBound).forEach(distance -> this.addAll(location, distance));
    }

    private void addAll(int location, int distance) {
        switch (distance) {
            case 0: {
                this.addDistanceSet(new int[]{location}, location);
                break;
            }
            case 1: {
                this.addDistanceSet(this.oneStepDistanceMatrix[location], location);
                break;
            }
            default: {
                this.addDistanceSet(this.computeDistanceSet(location), location);
            }
        }
    }

    private int[] computeDistanceSet(int location) {
        int[] previous = this.distanceMatrix[location];
        IntFunction<IntStream> next = i -> Arrays.stream(this.oneStepDistanceMatrix[i]);
        return Arrays.stream(previous).flatMap(next).toArray();
    }

    private void addDistanceSet(int[] set, int target) {
        int[] oldNeighbours = this.distanceMatrix[target];
        int[] result = Arrays.copyOf(oldNeighbours, oldNeighbours.length + set.length);
        System.arraycopy(set, 0, result, oldNeighbours.length, set.length);
        result = Arrays.stream(result).distinct().toArray();
        this.distanceMatrix[target] = result;
    }

    @Override
    public int[] getNeighbourhood(int location) {
        return this.distanceMatrix[location];
    }

    @Override
    public boolean areWithinBounds(int from, int to) {
        return Arrays.stream(this.distanceMatrix[from]).anyMatch(x -> x == to);
    }

    @Override
    public Integer getDistance(int from, int to) {
        return this.getIntDistance(from, to);
    }

    public int getIntDistance(int from, int to) {
        int[] fPair = this.model.unsafeToCoordinates(from);
        int[] tPair = this.model.unsafeToCoordinates(to);
        return this.computeManhattanDistance(fPair, tPair);
    }

    private int computeManhattanDistance(int[] from, int[] to) {
        int distX = Math.abs(from[0] - to[0]);
        int distY = Math.abs(from[1] - to[1]);
        return distX + distY;
    }

    @Override
    public boolean isWithinBounds(Integer d) {
        return this.isWithinBounds((int)d);
    }

    @Override
    public boolean isWithinBounds(int d) {
        return this.lowerBound <= d && d <= this.upperBound;
    }

    @Override
    public SpatialModel<Integer> getModel() {
        return this.model;
    }

    @Override
    public Function<Integer, Integer> getDistanceFunction() {
        return x -> x;
    }

    @Override
    public DistanceDomain<Integer> getDistanceDomain() {
        return new IntegerDomain();
    }
}

