/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.space;

import eu.quanticol.moonlight.core.space.DistanceDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.domain.IntegerDomain;
import eu.quanticol.moonlight.space.RegularGridModel;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class IntManhattanDistanceStructureLazy
implements DistanceStructure<Integer, Integer> {
    private final int lowerBound;
    private final int upperBound;
    private final RegularGridModel<Integer> model;

    public IntManhattanDistanceStructureLazy(int lowerBound, int upperBound, @NotNull RegularGridModel<Integer> model) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.model = model;
    }

    @Override
    public boolean areWithinBounds(int from, int to) {
        return this.isWithinBounds(this.getIntDistance(from, to));
    }

    public int getIntDistance(int from, int to) {
        int[] fPair = this.model.unsafeToCoordinates(from);
        int[] tPair = this.model.unsafeToCoordinates(to);
        return this.computeManhattanDistance(fPair, tPair);
    }

    private int computeManhattanDistance(int[] from, int[] to) {
        int distX = Math.abs(from[0] - to[0]);
        int distY = Math.abs(from[1] - to[1]);
        return distX + distY;
    }

    @Override
    public boolean isWithinBounds(int d) {
        return this.lowerBound <= d && d <= this.upperBound;
    }

    @Override
    public Integer getDistance(int from, int to) {
        return this.getIntDistance(from, to);
    }

    @Override
    public boolean isWithinBounds(Integer d) {
        return this.isWithinBounds((int)d);
    }

    @Override
    public SpatialModel<Integer> getModel() {
        return this.model;
    }

    @Override
    public Function<Integer, Integer> getDistanceFunction() {
        return x -> x;
    }

    @Override
    public DistanceDomain<Integer> getDistanceDomain() {
        return new IntegerDomain();
    }
}

