/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.space;

import eu.quanticol.moonlight.core.space.DistanceDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.domain.IntegerDomain;
import eu.quanticol.moonlight.space.RegularGridModel;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class IntManhattanDistanceStructureLegacy
implements DistanceStructure<Integer, Integer> {
    private final int lowerBound;
    private final int upperBound;
    private final RegularGridModel<Integer> model;
    private boolean[][] distanceMatrix;

    public IntManhattanDistanceStructureLegacy(int lowerBound, int upperBound, @NotNull RegularGridModel<Integer> model) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.model = model;
        this.computeDistanceMatrix();
    }

    private void computeDistanceMatrix() {
        this.distanceMatrix = new boolean[this.model.size()][this.model.size()];
        for (int i = 0; i < this.model.size(); ++i) {
            for (int j = 0; j < this.model.size(); ++j) {
                this.distanceMatrix[i][j] = this.isWithinBounds(this.getIntDistance(i, j));
            }
        }
    }

    public int getIntDistance(int from, int to) {
        int[] fPair = this.model.unsafeToCoordinates(from);
        int[] tPair = this.model.unsafeToCoordinates(to);
        return this.computeManhattanDistance(fPair, tPair);
    }

    private int computeManhattanDistance(int[] from, int[] to) {
        int distX = Math.abs(from[0] - to[0]);
        int distY = Math.abs(from[1] - to[1]);
        return distX + distY;
    }

    @Override
    public boolean isWithinBounds(int d) {
        return this.lowerBound <= d && d <= this.upperBound;
    }

    @Override
    public boolean areWithinBounds(int from, int to) {
        return this.distanceMatrix[from][to];
    }

    @Override
    public Integer getDistance(int from, int to) {
        return this.getIntDistance(from, to);
    }

    @Override
    public boolean isWithinBounds(Integer d) {
        return this.isWithinBounds((int)d);
    }

    @Override
    public SpatialModel<Integer> getModel() {
        return this.model;
    }

    @Override
    public Function<Integer, Integer> getDistanceFunction() {
        return x -> x;
    }

    @Override
    public DistanceDomain<Integer> getDistanceDomain() {
        return new IntegerDomain();
    }
}

