/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.space;

import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.space.SpatialModel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RegularGridModel<E>
implements SpatialModel<E> {
    private final int columns;
    private final int rows;
    private final int size;
    private final E weight;

    public RegularGridModel(int rows, int columns, E weight) {
        this.rows = rows;
        this.columns = columns;
        this.size = rows * columns;
        this.weight = weight;
    }

    public E getWeight() {
        return this.weight;
    }

    public int[] toCoordinates(int location) {
        if (location >= 0 && location <= this.size) {
            int column = location % this.columns;
            int row = location / this.columns;
            return new int[]{column, row};
        }
        throw new IllegalArgumentException("invalid location passed");
    }

    public int[] unsafeToCoordinates(int location) {
        int column = location % this.columns;
        int row = location / this.columns;
        return new int[]{column, row};
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E get(int source, int target) {
        this.checkLocationIsLegal(source);
        this.checkLocationIsLegal(target);
        return !this.getNeighbours(source).contains(target) ? null : (E)this.weight;
    }

    private void checkLocationIsLegal(int location) {
        if (location > this.size || location < 0) {
            throw new IllegalArgumentException("invalid location passed");
        }
    }

    @NotNull
    private List<Integer> getNeighbours(int node) {
        ArrayList<Integer> neighbours = new ArrayList<Integer>(4);
        if (node + this.columns < this.size) {
            neighbours.add(node + this.columns);
        }
        if (node - this.columns >= 0) {
            neighbours.add(node - this.columns);
        }
        if (node % this.columns == 0) {
            neighbours.add(node + 1);
        } else if (node % this.columns == this.columns - 1) {
            neighbours.add(node - 1);
        } else {
            neighbours.add(node - 1);
            neighbours.add(node + 1);
        }
        return neighbours;
    }

    public int[] getNeighboursArray(int node) {
        return this.getNeighbours(node).stream().mapToInt(i -> i).toArray();
    }

    @Override
    public List<Pair<Integer, E>> previous(int location) {
        return this.next(location);
    }

    @Override
    public List<Pair<Integer, E>> next(int location) {
        this.checkLocationIsLegal(location);
        return this.listToWeighted(this.getNeighbours(location));
    }

    private List<Pair<Integer, E>> listToWeighted(List<Integer> list) {
        return list.stream().map(x -> new Pair<Integer, E>((Integer)x, this.weight)).toList();
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int fromCoordinates(int x, int y) {
        return y * this.columns + x;
    }
}

