/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.statistics;

import eu.quanticol.moonlight.core.signal.TimeSignal;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;

public class SignalStatistics<T extends SpatialTemporalSignal<?>> {
    private final Collection<T> results = Collections.synchronizedCollection(new ArrayList());
    private final Collection<Float> durations = Collections.synchronizedCollection(new ArrayList());
    private final long startingTime = System.currentTimeMillis();
    private final int locations;
    private int timePoints;

    public SignalStatistics(int locations, int timePoints) {
        this.locations = locations;
        this.timePoints = timePoints;
    }

    public T track(Supplier<T> f) {
        try {
            long start = System.currentTimeMillis();
            SpatialTemporalSignal result = (SpatialTemporalSignal)f.get();
            long end = System.currentTimeMillis();
            float duration = (float)((double)(end - start) / 1000.0);
            int tps = (int)result.getSignals().get(0).getEnd();
            this.timePoints = Math.min(tps, this.timePoints);
            this.durations.add(Float.valueOf(duration));
            this.results.add(result);
            return (T)result;
        }
        catch (Exception e) {
            System.out.println("ERROR: Statistics computation failed");
            e.printStackTrace();
            return null;
        }
    }

    public Statistics[][] analyze() {
        Statistics[][] stats = new Statistics[this.locations][this.timePoints];
        for (int t = 0; t < this.timePoints; ++t) {
            float[] average = this.generateAverages(t);
            float[] variance = this.generateVariances(average, t);
            float execTime = this.computeAvgExecTime();
            int cnt = this.results.size();
            long endingTime = System.currentTimeMillis();
            float totalTime = (float)((double)(endingTime - this.startingTime) / 1000.0);
            for (int l = 0; l < this.locations; ++l) {
                float stdDev = (float)Math.sqrt(variance[l]);
                stats[l][t] = new Statistics(average[l], execTime, stdDev, variance[l], cnt, totalTime);
            }
        }
        return stats;
    }

    private float[] generateAverages(double t) {
        float[] outputs = new float[this.locations];
        for (int l = 0; l < this.locations; ++l) {
            float value = 0.0f;
            for (SpatialTemporalSignal r : this.results) {
                TimeSignal s = r.getSignals().get(l);
                value = this.computeAverage(s, value, t);
            }
            outputs[l] = value / (float)this.results.size();
        }
        return outputs;
    }

    private float computeAverage(TimeSignal<Double, ?> s, float value, double t) {
        if (s.getValueAt(t) instanceof Double) {
            value += ((Double)s.getValueAt(t)).floatValue();
        } else if (s.getValueAt(t) instanceof Boolean) {
            value += Boolean.TRUE.equals(s.getValueAt(t)) ? 1.0f : 0.0f;
        } else {
            throw new InvalidParameterException("Unknown Signal Domain");
        }
        return value;
    }

    private float computeAvgExecTime() {
        float t = 0.0f;
        for (Float duration : this.durations) {
            t += duration.floatValue();
        }
        return t / (float)this.durations.size();
    }

    private float[] generateVariances(float[] avg, double t) {
        float[] outputs = new float[this.locations];
        for (int l = 0; l < this.locations; ++l) {
            float value = 0.0f;
            for (SpatialTemporalSignal r : this.results) {
                TimeSignal s = r.getSignals().get(l);
                value = this.computeVariance(s, avg[l], value, t);
            }
            outputs[l] = value / (float)this.results.size();
        }
        return outputs;
    }

    private float computeVariance(TimeSignal<Double, ?> s, float avg, float value, double t) {
        if (s.getValueAt(t) instanceof Double) {
            float v = ((Double)s.getValueAt(t)).floatValue();
            value = (float)((double)value + Math.pow(v - avg, 2.0));
        } else if (s.getValueAt(t) instanceof Boolean) {
            float v = Boolean.TRUE.equals(s.getValueAt(t)) ? 1.0f : 0.0f;
            value = (float)((double)value + Math.pow(v - avg, 2.0));
        } else {
            throw new InvalidParameterException("Unknown Signal Domain");
        }
        return value;
    }

    public Collection<T> getResults() {
        return this.results;
    }

    public static class Statistics
    implements Serializable {
        public final float average;
        public final float stdDeviation;
        public final float variance;
        public final float executionTime;
        public final int count;
        public final float totalExecutionTime;

        public Statistics(float avg, float exec, float std, float variance, int cnt, float tot) {
            this.average = avg;
            this.executionTime = exec;
            this.stdDeviation = std;
            this.variance = variance;
            this.count = cnt;
            this.totalExecutionTime = tot;
        }

        public String toString() {
            return "AVG:" + this.average + " | STD:" + this.stdDeviation + " | VAR:" + this.variance + " | CNT:" + this.count + " | AVG_EXEC_TIME:" + this.executionTime + "ms | TOT_EXEC_TIME:" + this.totalExecutionTime + "ms";
        }
    }
}

