/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.statistics;

import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitor;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import eu.quanticol.moonlight.statistics.SignalStatistics;
import eu.quanticol.moonlight.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StatisticalModelChecker<S, T, R> {
    private static final Logger LOG = Logger.getLogger();
    private final SpatialTemporalMonitor<S, T, R> monitor;
    private final Collection<? extends SpatialTemporalSignal<T>> samples;
    private final LocationService<Double, S> locService;
    private final List<SpatialTemporalSignal<R>> results;
    private final SignalStatistics<SpatialTemporalSignal<R>> stats;
    private final Collection<Thread> threads = new ArrayList<Thread>();

    public StatisticalModelChecker(SpatialTemporalMonitor<S, T, R> propertyMonitor, Collection<? extends SpatialTemporalSignal<T>> trajectorySamples, LocationService<Double, S> locationService) {
        this.monitor = propertyMonitor;
        this.samples = trajectorySamples;
        this.locService = locationService;
        SpatialTemporalSignal<T> s = trajectorySamples.iterator().next();
        int locations = s.getNumberOfLocations();
        int timePoints = s.getSignals().get(0).getTimeSet().size();
        this.stats = new SignalStatistics(locations, timePoints);
        this.results = new ArrayList<SpatialTemporalSignal<R>>();
    }

    public void compute() {
        int i = 0;
        for (SpatialTemporalSignal<T> s : this.samples) {
            int n = i++;
            Thread t = new Thread(() -> this.stats.track(() -> {
                SpatialTemporalSignal<R> r = this.monitor.monitor(this.locService, s);
                LOG.info("Monitoring " + n + " finished!");
                return r;
            }));
            this.threads.add(t);
            LOG.info("Thread starting.");
            t.start();
        }
        try {
            for (Thread thread : this.threads) {
                thread.join();
            }
            this.results.addAll(this.stats.getResults());
        }
        catch (InterruptedException e) {
            LOG.fatal("Thread crashed! " + e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    public SignalStatistics.Statistics[][] getStats() {
        return this.stats.analyze();
    }

    public List<SpatialTemporalSignal<R>> getResults() {
        return this.results;
    }
}

