/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.util;

import eu.quanticol.moonlight.offline.signal.Signal;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import java.util.ArrayList;
import java.util.List;

public class MultiValuedTrace
extends SpatialTemporalSignal<List<Comparable<?>>> {
    private final int length;
    private final List<Comparable<?>[][]> data;
    private int dimensions = 0;

    public MultiValuedTrace(int size, int length) {
        super(size);
        this.length = length;
        this.data = new ArrayList<Comparable<?>[][]>();
    }

    public void initialize() {
        this.dimensions = this.data.size();
        if (this.data.isEmpty()) {
            throw new IllegalArgumentException("Empty signal passed");
        }
        for (int t = 0; t < this.length; ++t) {
            int time = t;
            this.add((double)t, (int i) -> this.setSignal(i, time));
        }
        this.endAt(this.length);
        this.data.clear();
    }

    private void endAt(double end) {
        for (Signal signal : this.getSignals()) {
            signal.endAt(end);
        }
    }

    private List<Comparable<?>> setSignal(int l, int t) {
        ArrayList signal = new ArrayList();
        for (Comparable<?>[][] datum : this.data) {
            signal.add(datum[l][t]);
        }
        return signal;
    }

    public MultiValuedTrace setDimension(Comparable<?>[][] dimData, int index) {
        if (!this.data.isEmpty() && dimData.length != this.getNumberOfLocations()) {
            throw new IllegalArgumentException("Mismatching space size ");
        }
        if (!this.data.isEmpty() && dimData[0].length != this.length) {
            throw new IllegalArgumentException("Mismatching time length");
        }
        this.data.add(dimData);
        return this;
    }

    public int dimensions() {
        return this.dimensions;
    }
}

