/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.util;

import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.offline.signal.Signal;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import eu.quanticol.moonlight.space.GraphModel;
import eu.quanticol.moonlight.space.LocationServiceList;
import eu.quanticol.moonlight.space.RegularGridModel;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Utils {
    private Utils() {
    }

    public static <T> Signal<T> createSignal(double start, double end, double dt, Function<Double, T> f) {
        Signal<T> signal = new Signal<T>();
        for (double time = start; time <= end; time += dt) {
            signal.add(time, f.apply(time));
        }
        signal.endAt(end);
        return signal;
    }

    public static <T> SpatialTemporalSignal<T> createSpatioTemporalSignal(int size, double start, double dt, double end, BiFunction<Double, Integer, T> f) {
        SpatialTemporalSignal<Object> s = new SpatialTemporalSignal<Object>(size);
        for (double time = start; time < end; time += dt) {
            double current = time;
            s.add(time, i -> f.apply(current, i));
        }
        s.add(end, i -> f.apply(end, i));
        return s;
    }

    public static <T> SpatialTemporalSignal<T> createSpatioTemporalSignalFromGrid(int rowLength, int columnLength, double start, double dt, double end, BiFunction<Double, Pair<Integer, Integer>, T> f) {
        SpatialTemporalSignal<Object> s = new SpatialTemporalSignal<Object>(rowLength * columnLength);
        for (double time = start; time < end; time += dt) {
            double current = time;
            s.add(time, i -> f.apply(current, Utils.gridLocationOf(i, rowLength, columnLength)));
        }
        s.add(end, i -> f.apply(end, Utils.gridLocationOf(i, rowLength, columnLength)));
        return s;
    }

    public static Pair<Integer, Integer> gridLocationOf(int i, int rows, int columns) {
        int r = i / columns;
        int c = i % columns;
        if (r >= rows || c >= columns) {
            throw new IllegalArgumentException();
        }
        return new Pair<Integer, Integer>(r, c);
    }

    public static <T> SpatialModel<T> createSpatialModel(int size, Map<Pair<Integer, Integer>, T> edges) {
        return Utils.createSpatialModel(size, (Integer i, Integer j) -> edges.get(new Pair<Integer, Integer>((Integer)i, (Integer)j)));
    }

    public static <T> SpatialModel<T> createSpatialModel(int size, BiFunction<Integer, Integer, T> edges) {
        GraphModel<T> model = new GraphModel<T>(size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                T value = edges.apply(i, j);
                if (value == null) continue;
                model.add(i, value, j);
            }
        }
        return model;
    }

    public static <T> SpatialModel<T> createGridModelAsGraph(int rows, int columns, boolean directed, T w) {
        int size = rows * columns;
        GraphModel<T> model = new GraphModel<T>(size);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (i + 1 < rows) {
                    model.add(Utils.gridIndexOf(i, j, columns), w, Utils.gridIndexOf(i + 1, j, columns));
                    if (!directed) {
                        model.add(Utils.gridIndexOf(i + 1, j, columns), w, Utils.gridIndexOf(i, j, columns));
                    }
                }
                if (j + 1 >= columns) continue;
                model.add(Utils.gridIndexOf(i, j, columns), w, Utils.gridIndexOf(i, j + 1, columns));
                if (directed) continue;
                model.add(Utils.gridIndexOf(i, j + 1, columns), w, Utils.gridIndexOf(i, j, columns));
            }
        }
        return model;
    }

    public static int gridIndexOf(int r, int c, int columns) {
        return r * columns + c;
    }

    public static <T> RegularGridModel<T> createGridModel(int rows, int cols, T w) {
        return new RegularGridModel<T>(rows, cols, w);
    }

    public static <T> GraphModel<T> createGraphFromMatlabData(int nodes, int[][] edges, T[] weights) {
        boolean SOURCE = false;
        boolean DESTINATION = true;
        GraphModel<T> space = new GraphModel<T>(nodes);
        if (edges.length != weights.length) {
            throw new IllegalArgumentException("Mismatching edges provided");
        }
        for (int i = 0; i < edges.length; ++i) {
            space.add(edges[i][0] - 1, weights[i], edges[i][1] - 1);
        }
        return space;
    }

    public static <T> LocationService<Double, T> createLocationServiceFromTimesAndModels(double[] times, SpatialModel<T>[] models) {
        LocationServiceList<T> locSvc = new LocationServiceList<T>();
        if (times.length != models.length) {
            throw new IllegalArgumentException("Mismatched arguments provided");
        }
        for (int i = 0; i < times.length; ++i) {
            locSvc.add(times[i], models[i]);
        }
        return locSvc;
    }

    public static LocationService<Double, Double> createLocServiceFromSetMatrix(Object[] cgraph1) {
        LocationServiceList<Double> locService = new LocationServiceList<Double>();
        for (int k = 0; k < cgraph1.length; ++k) {
            double t = k;
            double[][] matrix = (double[][])cgraph1[(int)Math.floor(t)];
            int size = matrix.length;
            GraphModel<Double> graphModel = new GraphModel<Double>(size);
            for (int i = 0; i < matrix.length; ++i) {
                for (int j = i + 1; j < matrix[i].length; ++j) {
                    graphModel.add(i, matrix[i][j], j);
                    graphModel.add(j, matrix[j][i], i);
                }
            }
            locService.add(t, graphModel);
        }
        return locService;
    }

    public static LocationService<Double, Double> createLocServiceStatic(double start, double dt, double end, SpatialModel<Double> graph) {
        LocationServiceList<Double> locService = new LocationServiceList<Double>();
        for (double time = start; time < end; time += dt) {
            double current = time;
            locService.add(time, graph);
        }
        locService.add(end, graph);
        return locService;
    }

    public static LocationService<Double, Double> createLocServiceStaticFromTimeTraj(double[] time, SpatialModel<Double> graph) {
        LocationServiceList<Double> locService = new LocationServiceList<Double>();
        for (double v : time) {
            locService.add(v, graph);
        }
        return locService;
    }
}

