"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageInstallation = void 0;
const child_process_1 = require("child_process");
const util_1 = require("./util");
/**
 * Package installation
 */
class PackageInstallation {
    static detect(module) {
        try {
            // Check local version first
            const version = util_1.tryGetModuleVersion(module);
            if (version) {
                return {
                    isLocal: true,
                    version,
                };
            }
            // Fallback to a global version
            const proc = child_process_1.spawnSync(module, ['--version']);
            if (proc.status === 0 && !proc.error) {
                return {
                    isLocal: false,
                    version: proc.stdout.toString().trim(),
                };
            }
            return undefined;
        }
        catch (err) {
            return undefined;
        }
    }
}
exports.PackageInstallation = PackageInstallation;
//# sourceMappingURL=data:application/json;base64,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