# This file is part of the Gudhi Library - https://gudhi.inria.fr/ - which is released under MIT.
#  See file LICENSE or go to https://gudhi.inria.fr/licensing/ for full license details.
#  Author(s):       Vincent Rouvreau
#
# Copyright (C) 2016  Inria
#
# Modification(s):
#   - YYYY/MM Author: Description of the modification

from importlib import import_module

__author__ = "GUDHI Editorial Board"
__copyright__ = "Copyright (C) 2016 Inria"
__license__ = "https://gudhi.inria.fr/licensing/"
__version__ = "3.10.0rc2"
# This variable is used by doctest to find files
__root_source_dir__ = "D:/a/gudhi-devel/gudhi-devel"
__debug_info__ =     "Pybind11 version 2.13.0 \n" \
    "Python version 3.10.11\n" \
    "Cython version 3.0.10 \n" \
    "Numpy version 2.0.0 \n" \
    "Eigen3 version 3.4.0\n" \
    "Boost version 1.85.0\n" \
    "CGAL header only version 5.6.1\n" \
    "GMP_LIBRARIES = C:/vcpkg/installed/x64-windows/lib/gmp.lib\n" \
    "GMPXX_LIBRARIES = C:/vcpkg/installed/x64-windows/lib/gmpxx.lib\n" \
    "MPFR_LIBRARIES = C:/vcpkg/installed/x64-windows/lib/mpfr.lib\n" \


__all__ = ['bottleneck', 'off_utils', 'simplex_tree', 'rips_complex', 'cubical_complex', 'periodic_cubical_complex', 'persistence_graphical_tools', 'reader_utils', 'witness_complex', 'strong_witness_complex', 'nerve_gic', 'subsampling', 'tangential_complex', 'alpha_complex', 'euclidean_witness_complex', 'euclidean_strong_witness_complex',  'hera', 'clustering', 'datasets', 'representations', 'sklearn', 'tensorflow', 'wasserstein', 'point_cloud', 'weighted_rips_complex', 'dtm_rips_complex', 'cover_complex', 'flag_filtration', ]

__available_modules = ''
__missing_modules = ''

# Try to import * from gudhi.__module_name for default modules.
# Extra modules require an explicit import by the user (mostly because of
# unusual dependencies, but also to avoid cluttering namespace gudhi and
# speed up the basic import)
for __module_name in ['bottleneck', 'off_utils', 'simplex_tree', 'rips_complex', 'cubical_complex', 'periodic_cubical_complex', 'persistence_graphical_tools', 'reader_utils', 'witness_complex', 'strong_witness_complex', 'nerve_gic', 'subsampling', 'tangential_complex', 'alpha_complex', 'euclidean_witness_complex', 'euclidean_strong_witness_complex', ]:
    try:
        __module = import_module('gudhi.' + __module_name)
        try:
            __to_import = __module.__all__
        except AttributeError:
            __to_import = [name for name in __module.__dict__ if not name.startswith('_')]
        globals().update({name: __module.__dict__[name] for name in __to_import})
        __available_modules += __module_name + ";"
    except:
        __missing_modules += __module_name + ";"
