# coding: utf-8

"""
  Copyright 2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six


class DealDetails(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_type': 'str',
        'badge': 'str',
        'early_access_duration_in_milliseconds': 'int',
        'end_time': 'str',
        'percent_claimed': 'int',
        'start_time': 'str'
    }

    attribute_map = {
        'access_type': 'AccessType',
        'badge': 'Badge',
        'early_access_duration_in_milliseconds': 'EarlyAccessDurationInMilliseconds',
        'end_time': 'EndTime',
        'percent_claimed': 'PercentClaimed',
        'start_time': 'StartTime'
    }

    def __init__(self, access_type=None, badge=None, early_access_duration_in_milliseconds=None, end_time=None, percent_claimed=None, start_time=None):  # noqa: E501
        """DealDetails - a model defined in Swagger"""  # noqa: E501

        self._access_type = None
        self._badge = None
        self._early_access_duration_in_milliseconds = None
        self._end_time = None
        self._percent_claimed = None
        self._start_time = None
        self.discriminator = None

        if access_type is not None:
            self.access_type = access_type
        if badge is not None:
            self.badge = badge
        if early_access_duration_in_milliseconds is not None:
            self.early_access_duration_in_milliseconds = early_access_duration_in_milliseconds
        if end_time is not None:
            self.end_time = end_time
        if percent_claimed is not None:
            self.percent_claimed = percent_claimed
        if start_time is not None:
            self.start_time = start_time

    @property
    def access_type(self):
        """Gets the access_type of this DealDetails.  # noqa: E501


        :return: The access_type of this DealDetails.  # noqa: E501
        :rtype: str
        """
        return self._access_type

    @access_type.setter
    def access_type(self, access_type):
        """Sets the access_type of this DealDetails.


        :param access_type: The access_type of this DealDetails.  # noqa: E501
        :type: str
        """

        self._access_type = access_type

    @property
    def badge(self):
        """Gets the badge of this DealDetails.  # noqa: E501


        :return: The badge of this DealDetails.  # noqa: E501
        :rtype: str
        """
        return self._badge

    @badge.setter
    def badge(self, badge):
        """Sets the badge of this DealDetails.


        :param badge: The badge of this DealDetails.  # noqa: E501
        :type: str
        """

        self._badge = badge

    @property
    def early_access_duration_in_milliseconds(self):
        """Gets the early_access_duration_in_milliseconds of this DealDetails.  # noqa: E501


        :return: The early_access_duration_in_milliseconds of this DealDetails.  # noqa: E501
        :rtype: int
        """
        return self._early_access_duration_in_milliseconds

    @early_access_duration_in_milliseconds.setter
    def early_access_duration_in_milliseconds(self, early_access_duration_in_milliseconds):
        """Sets the early_access_duration_in_milliseconds of this DealDetails.


        :param early_access_duration_in_milliseconds: The early_access_duration_in_milliseconds of this DealDetails.  # noqa: E501
        :type: int
        """

        self._early_access_duration_in_milliseconds = early_access_duration_in_milliseconds

    @property
    def end_time(self):
        """Gets the end_time of this DealDetails.  # noqa: E501


        :return: The end_time of this DealDetails.  # noqa: E501
        :rtype: str
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this DealDetails.


        :param end_time: The end_time of this DealDetails.  # noqa: E501
        :type: str
        """

        self._end_time = end_time

    @property
    def percent_claimed(self):
        """Gets the percent_claimed of this DealDetails.  # noqa: E501


        :return: The percent_claimed of this DealDetails.  # noqa: E501
        :rtype: int
        """
        return self._percent_claimed

    @percent_claimed.setter
    def percent_claimed(self, percent_claimed):
        """Sets the percent_claimed of this DealDetails.


        :param percent_claimed: The percent_claimed of this DealDetails.  # noqa: E501
        :type: int
        """

        self._percent_claimed = percent_claimed

    @property
    def start_time(self):
        """Gets the start_time of this DealDetails.  # noqa: E501


        :return: The start_time of this DealDetails.  # noqa: E501
        :rtype: str
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this DealDetails.


        :param start_time: The start_time of this DealDetails.  # noqa: E501
        :type: str
        """

        self._start_time = start_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DealDetails, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DealDetails):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
