# Specification definition prompt

Specifications in this project are managed systematically to ensure clarity, completeness, and traceability. Each specification is saved in the `.project/specs` directory, and an index of all specifications is maintained in `.project/SPECS.md` for a quick overview of project requirements.

## Specification Format

Each specification should follow the format below:

- **Unique Specification ID:** SPEC-NN-descriptive-name (where NN is a sequential number)
- **Title:** A clear and concise title for the specification.
- **Description:** A detailed description of the feature, component, or requirement being specified.
- **Requirements:** Numbered and atomic requirements listed as checkable items with priority levels:
  ```
  - [ ] Requirement 1.1 [HIGH]: Clear, specific, testable requirement with high priority
  - [ ] Requirement 1.2 [MEDIUM]: Another clear requirement with medium priority
  - [ ] Requirement 1.3 [LOW]: A lower priority requirement
  ```
- **Testing Criteria:** Details on how the implementation will be tested:
  - Unit Testing: Component-level tests
  - Integration Testing: Tests for component interaction
  - Other specific testing types relevant to the specification
- **Acceptance Criteria:** Clear criteria that must be met for the specification to be considered implemented.
- **Metadata:**
    - **ID:** Unique identifier for the specification.
    - **Creation Date:** The date when the specification was created.
    - **Last Updated:** The date when the specification was last modified.
    - **Status:** Current status (e.g., draft, approved, implemented, deprecated).
    - **Completion Percentage:** Percentage of requirements completed.
- **Domain/Component:** The domain or component this specification belongs to.
- **Related Specifications:** Links to related specifications, if applicable.
- **Notes:** Additional context, constraints, or considerations.

## Technical Details

For specifications that require technical implementation details:
- Include technology stack and dependencies
- Document architectural patterns and approaches
- Outline performance considerations
- Specify security requirements
- Include diagrams where appropriate

## Priority Levels

Each requirement must include a priority level:
- **[HIGH]**: Critical for core functionality, must be implemented first
- **[MEDIUM]**: Important but can be implemented after high-priority items
- **[LOW]**: Nice-to-have features that can be deferred if necessary

## Specification Quality Guidelines

To ensure high-quality specifications:

1. **Avoid vague terms:** Replace words like "should," "would," "could," etc., with specific, testable language.
2. **Use atomic requirements:** Each requirement should describe exactly one thing.
3. **Include all required sections:** All specifications must have a description, requirements, testing criteria, and acceptance criteria.
4. **Ensure testability:** Requirements should be written so that their implementation can be verified.
5. **Organize by domain:** Specifications should be organized by domain or component.
6. **Assign appropriate priorities:** Ensure priority levels accurately reflect implementation importance.

## Progress Tracking

The SPECS.md file will include visual progress tracking with:
- Progress bars for high, medium, and low priority requirements
- A summary table showing completion status by specification
- Overall project completion statistics

## Specification Validation

Specifications will be regularly validated for:
- Quality issues (vague terms, non-atomic requirements)
- Implementation status (whether requirements have been implemented in code)
- Test coverage (whether requirements have corresponding tests)
- Priority alignment (whether priorities are assigned appropriately)

By adhering to this format and these guidelines, we ensure that all specifications are well-documented, traceable, and drive high-quality implementation throughout the project lifecycle.