#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Jan 30 15:00:16 2025 by generateDS.py version 2.43.3.
# Python 3.12.6 (tags/v3.12.6:a4a2d2b, Sep  6 2024, 20:11:23) [MSC v.1940 64 bit (AMD64)]
#
# Command line options:
#   ('-o', 'at_ext.py')
#   ('--no-questions', '')
#   ('-f', '')
#
# Command line arguments:
#   ../cda-schema/CDA_extELGA.xsd
#
# Command line:
#   generateDS.py -o "at_ext.py" --no-questions -f ../cda-schema/CDA_extELGA.xsd
#
# Current working directory (os.getcwd()):
#   generateds
#

import sys
try:
    ModulenotfoundExp_ = ModuleNotFoundError
except NameError:
    ModulenotfoundExp_ = ImportError
from six.moves import zip_longest
import os
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
from lxml import etree as etree_
from typing import List as List_


Validate_simpletypes_ = True
SaveElementTreeNode = True
SaveNodeDict = True
TagNamePrefix = ""
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str
node_dict = {}


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the _exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ModulenotfoundExp_ :
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ModulenotfoundExp_ :
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ModulenotfoundExp_ :

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ModulenotfoundExp_ :
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ModulenotfoundExp_ as exp:
    try:
        from generatedssupersuper import GeneratedsSuperSuper
    except ModulenotfoundExp_ as exp:
        class GeneratedsSuperSuper(object):
            pass
    
    class GeneratedsSuper(GeneratedsSuperSuper):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def __str__(self):
            settings = {
                'str_pretty_print': True,
                'str_indent_level': 0,
                'str_namespaceprefix': '',
                'str_name': self.__class__.__name__,
                'str_namespacedefs': '',
            }
            for n in settings:
                if hasattr(self, n):
                    settings[n] = getattr(self, n)
            if sys.version_info.major == 2:
                from StringIO import StringIO
            else:
                from io import StringIO
            output = StringIO()
            self.export(
                output,
                settings['str_indent_level'],
                pretty_print=settings['str_pretty_print'],
                namespaceprefix_=settings['str_namespaceprefix'],
                name_=settings['str_name'],
                namespacedef_=settings['str_namespacedefs']
            )
            strval = output.getvalue()
            output.close()
            return strval
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data).decode('ascii')
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % int(input_data)
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer values')
            return values
        def gds_format_float(self, input_data, input_name=''):
            value = ('%.15f' % float(input_data)).rstrip('0')
            if value.endswith('.'):
                value += '0'
            return value
    
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return ' '.join([self.gds_format_decimal(item) for item in input_data])
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            input_data = input_data.strip()
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                value = self.gds_parse_boolean(value, node, input_name)
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            target = str(target)
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if instring is None:
                result = ""
            elif isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    s1 = s1.replace('\n', '&#10;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if prefix == 'xml':
            namespace = 'http://www.w3.org/XML/1998/namespace'
        else:
            namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)


#
# Start enum classes
#
class ActClassComposition(str, Enum):
    """ActClassComposition -- specDomain: V19442
    (C-0-D11527-V13856-V19445-V19442-cpt)
    
    """
    COMPOSITION='COMPOSITION'


class ActClassCondition(str, Enum):
    """ActClassCondition -- specDomain: V19580
    (C-0-D11527-V13856-V11529-V19580-cpt)
    
    """
    COND='COND'


class ActClassContract(str, Enum):
    """ActClassContract -- specDomain: V14002 (C-0-D11527-V13856-V14002-cpt)
    
    """
    CNTRCT='CNTRCT'


class ActClassControlAct(str, Enum):
    """ActClassControlAct -- specDomain: V11534 (C-0-D11527-V13856-V11534-cpt)
    
    """
    CACT='CACT'
    ACTN='ACTN'
    INFO='INFO'
    STC='STC'


class ActClassDocument(str, Enum):
    """ActClassDocument -- specDomain: V18938
    (C-0-D11527-V13856-V19445-V19442-V18938-cpt)
    
    """
    DOC='DOC'


class ActClassEntry(str, Enum):
    """ActClassEntry -- specDomain: V19444
    (C-0-D11527-V13856-V19445-V19444-cpt)
    
    """
    ENTRY='ENTRY'
    BATTERY='BATTERY'
    CLUSTER='CLUSTER'


class ActClassExtract(str, Enum):
    """ActClassExtract -- specDomain: V19441
    (C-0-D11527-V13856-V19445-V19441-cpt)
    
    """
    EXTRACT='EXTRACT'
    EHR='EHR'


class ActClassFinancialContract(str, Enum):
    """ActClassFinancialContract -- specDomain: V14003
    (C-0-D11527-V13856-V14002-V14003-cpt)
    
    """
    FCNTRCT='FCNTRCT'
    COV='COV'


class ActClassInvoiceElement(str, Enum):
    INVE='INVE'


class ActClassObservation(str, Enum):
    """ActClassObservation -- specDomain: V11529 (C-0-D11527-V13856-V11529-cpt)
    
    """
    OBS='OBS'
    ALRT='ALRT'
    CLNTRL='CLNTRL'
    CNOD='CNOD'
    DGIMG='DGIMG'
    INVSTG='INVSTG'
    SPCOBS='SPCOBS'


class ActClassObservationSeries(str, Enum):
    """ActClassObservationSeries -- specDomain: V18875
    (C-0-D11527-V13856-V11529-V18875-cpt)
    
    """
    OBSSER='OBSSER'
    OBSCOR='OBSCOR'


class ActClassOrganizer(str, Enum):
    """ActClassOrganizer -- specDomain: V19443
    (C-0-D11527-V13856-V19445-V19443-cpt)
    
    """
    ORGANIZER='ORGANIZER'
    CATEGORY='CATEGORY'
    DOCBODY='DOCBODY'
    DOCSECT='DOCSECT'
    TOPIC='TOPIC'


class ActClassPublicHealthCase(str, Enum):
    """ActClassPublicHealthCase -- specDomain: V11530
    (C-0-D11527-V13856-V11529-V19580-V11530-cpt)
    
    """
    CASE='CASE'
    OUTB='OUTB'


class ActClassROI(str, Enum):
    """ActClassROI -- abstDomain: V17893
    (C-0-D11527-V13856-V11529-V17893-cpt)
    
    """
    ROIBND='ROIBND'
    ROIOVL='ROIOVL'


class ActClassRoot(str, Enum):
    """ActClassRoot -- specDomain: V13856 (C-0-D11527-V13856-cpt)
    
    """
    ACT='ACT'
    ACCM='ACCM'
    ACCT='ACCT'
    ACSN='ACSN'
    ADJUD='ADJUD'
    CONS='CONS'
    CONTREG='CONTREG'
    CTTEVENT='CTTEVENT'
    DISPACT='DISPACT'
    ENC='ENC'
    INC='INC'
    INFRM='INFRM'
    INVE='INVE'
    LIST='LIST'
    MPROT='MPROT'
    PCPR='PCPR'
    PROC='PROC'
    REG='REG'
    REV='REV'
    SBADM='SBADM'
    SPCTRT='SPCTRT'
    SUBST='SUBST'
    TRNS='TRNS'
    VERIF='VERIF'
    XACT='XACT'


class ActClassSupply(str, Enum):
    """ActClassSupply -- specDomain: V11535 (C-0-D11527-V13856-V11535-cpt)
    
    """
    SPLY='SPLY'
    DIET='DIET'


class ActClinicalDocument(str, Enum):
    """ActClinicalDocument -- specDomain: V13948
    (C-0-D11527-V13856-V19445-V19442-V18938-V13948-cpt)
    
    """
    DOCCLIN='DOCCLIN'
    CDALVLONE='CDALVLONE'


class ActContainer(str, Enum):
    """ActContainer -- abstDomain: V19445 (C-0-D11527-V13856-V19445-cpt)
    
    """
    FOLDER='FOLDER'


class ActMoodCompletionTrack(str, Enum):
    """ActMoodCompletionTrack -- abstDomain: V10197 (C-0-D10196-V10197-cpt)
    
    """
    DEF='DEF'
    EVN='EVN'


class ActMoodDefinition(str, Enum):
    DEF='DEF'


class ActMoodEventOccurrence(str, Enum):
    EVN='EVN'


class ActMoodGoal(str, Enum):
    GOL='GOL'


class ActMoodIntent(str, Enum):
    """ActMoodIntent -- specDomain: V10199 (C-0-D10196-V16742-V10199-cpt)
    
    """
    INT='INT'
    APT='APT'
    ARQ='ARQ'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'
    SLOT='SLOT'


class ActMoodPredicate(str, Enum):
    """ActMoodPredicate -- abstDomain: V10202 (C-0-D10196-V10202-cpt)
    
    """
    EVNCRT='EVN.CRT'
    GOL='GOL'
    OPT='OPT'
    PERM='PERM'
    PERMRQ='PERMRQ'


class ActRelationshipConditional(str, Enum):
    """ActRelationshipConditional -- abstDomain: V18977 (C-0-D10317-V18977-cpt)
    
    """
    CIND='CIND'
    PRCN='PRCN'
    TRIG='TRIG'


class ActRelationshipCostTracking(str, Enum):
    """ActRelationshipCostTracking -- abstDomain: V19618
    (C-0-D10317-V10329-V14900-V19618-cpt)
    
    """
    CHRG='CHRG'
    COST='COST'


class ActRelationshipExcerpt(str, Enum):
    """ActRelationshipExcerpt -- specDomain: V18660 (C-0-D10317-V10337-V18660-cpt)
    
    """
    XCRPT='XCRPT'
    VRXCRPT='VRXCRPT'


class ActRelationshipFulfills(str, Enum):
    """ActRelationshipFulfills -- specDomain: V10342 (C-0-D10317-V10337-V10342-cpt)
    
    """
    FLFS='FLFS'
    OCCR='OCCR'
    OREF='OREF'
    SCH='SCH'


class ActRelationshipHasComponent(str, Enum):
    """ActRelationshipHasComponent -- specDomain: V10318 (C-0-D10317-V10318-cpt)
    
    """
    COMP='COMP'
    ARR='ARR'
    CTRLV='CTRLV'
    DEP='DEP'


class ActRelationshipObjective(str, Enum):
    """ActRelationshipObjective -- abstDomain: V19625 (C-0-D10317-V10324-V19625-cpt)
    
    """
    OBJC='OBJC'
    OBJF='OBJF'


class ActRelationshipOutcome(str, Enum):
    """ActRelationshipOutcome -- specDomain: V10324 (C-0-D10317-V10324-cpt)
    
    """
    OUTC='OUTC'
    GOAL='GOAL'
    RISK='RISK'


class ActRelationshipPertains(str, Enum):
    """ActRelationshipPertains -- specDomain: V10329 (C-0-D10317-V10329-cpt)
    
    """
    PERT='PERT'
    AUTH='AUTH'
    CAUS='CAUS'
    COVBY='COVBY'
    DRIV='DRIV'
    EXPL='EXPL'
    ITEMSLOC='ITEMSLOC'
    LIMIT='LIMIT'
    MFST='MFST'
    NAME='NAME'
    PREV='PREV'
    REFR='REFR'
    REFV='REFV'
    SUBJ='SUBJ'
    SUMM='SUMM'


class ActRelationshipPosting(str, Enum):
    """ActRelationshipPosting -- abstDomain: V19617
    (C-0-D10317-V10329-V14900-V19617-cpt)
    
    """
    CREDIT='CREDIT'
    DEBIT='DEBIT'


class ActRelationshipReason(str, Enum):
    """ActRelationshipReason -- specDomain: V19376 (C-0-D10317-V18977-V19376-cpt)
    
    """
    RSON='RSON'
    MITGT='MITGT'


class ActRelationshipReplacement(str, Enum):
    """ActRelationshipReplacement -- specDomain: V10338 (C-0-D10317-V10337-V10338-cpt)
    
    """
    RPLC='RPLC'
    SUCC='SUCC'


class ActRelationshipSequel(str, Enum):
    """ActRelationshipSequel -- specDomain: V10337 (C-0-D10317-V10337-cpt)
    
    """
    SEQL='SEQL'
    APND='APND'
    DOC='DOC'
    ELNK='ELNK'
    GEN='GEN'
    GEVL='GEVL'
    INST='INST'
    MTCH='MTCH'
    OPTN='OPTN'
    REV='REV'
    UPDT='UPDT'
    XFRM='XFRM'


class AdditionalLocator(str, Enum):
    """AdditionalLocator -- specDomain: V10651 (C-0-D10642-V10651-cpt)
    
    """
    ADL='ADL'
    UNID='UNID'
    UNIT='UNIT'


class AddressPartType(str, Enum):
    """AddressPartType -- vocSet: D10642 (C-0-D10642-cpt)
    
    """
    CAR='CAR'
    CEN='CEN'
    CNT='CNT'
    CPA='CPA'
    CTY='CTY'
    DEL='DEL'
    POB='POB'
    PRE='PRE'
    STA='STA'
    ZIP='ZIP'


class AddressUse(str, Enum):
    """AddressUse -- abstDomain: V190 (C-0-D201-V190-cpt)
    
    """
    BAD='BAD'
    TMP='TMP'


class ApplicationMediaType(str, Enum):
    """ApplicationMediaType -- abstDomain: V14832 (C-0-D14824-V14832-cpt)
    
    """
    APPLICATIONDICOM='application/dicom'
    APPLICATIONMSWORD='application/msword'
    APPLICATIONPDF='application/pdf'


class AskedButUnknown(str, Enum):
    """AskedButUnknown -- specDomain: V10614
    (C-0-D10609-V10610-V10612-V10614-cpt)
    
    """
    ASKU='ASKU'
    NAV='NAV'


class AudioMediaType(str, Enum):
    """AudioMediaType -- abstDomain: V14835 (C-0-D14824-V14835-cpt)
    
    """
    AUDIOBASIC='audio/basic'
    AUDIOK_32_ADPCM='audio/k32adpcm'
    AUDIOMPEG='audio/mpeg'


class BinaryDataEncoding(str, Enum):
    B_64='B64'
    TXT='TXT'


class BuildingNumber(str, Enum):
    """BuildingNumber -- specDomain: V10649 (C-0-D10642-V14822-V10649-cpt)
    
    """
    BNR='BNR'
    BNN='BNN'
    BNS='BNS'


class CalendarCycleOneLetter(str, Enum):
    """CalendarCycleOneLetter -- abstDomain: V10701 (C-0-D10684-V10701-cpt)
    
    """
    D='D'
    H='H'
    J='J'
    M='M'
    N='N'
    S='S'
    W='W'
    Y='Y'


class CalendarCycleTwoLetter(str, Enum):
    """CalendarCycleTwoLetter -- abstDomain: V10685 (C-0-D10684-V10685-cpt)
    
    """
    CD='CD'
    CH='CH'
    CM='CM'
    CN='CN'
    CS='CS'
    CW='CW'
    CY='CY'
    DM='DM'
    DW='DW'
    DY='DY'
    HD='HD'
    MY='MY'
    NH='NH'
    SN='SN'
    WY='WY'


class CommunicationFunctionType(str, Enum):
    """CommunicationFunctionType -- vocSet: D16031 (C-0-D16031-cpt)
    
    """
    RCV='RCV'
    RSP='RSP'
    SND='SND'


class CompressionAlgorithm(str, Enum):
    """CompressionAlgorithm -- vocSet: D10620 (C-0-D10620-cpt)
    
    """
    DF='DF'
    GZ='GZ'
    Z='Z'
    ZL='ZL'


class ContextControlAdditive(str, Enum):
    """ContextControlAdditive -- abstDomain: V18934 (C-0-D16478-V18934-cpt)
    
    """
    AN='AN'
    AP='AP'


class ContextControlNonPropagating(str, Enum):
    """ContextControlNonPropagating -- abstDomain: V18937 (C-0-D16478-V18937-cpt)
    
    """
    AN='AN'
    ON='ON'


class ContextControlOverriding(str, Enum):
    """ContextControlOverriding -- abstDomain: V18935 (C-0-D16478-V18935-cpt)
    
    """
    ON='ON'
    OP='OP'


class ContextControlPropagating(str, Enum):
    """ContextControlPropagating -- abstDomain: V18936 (C-0-D16478-V18936-cpt)
    
    """
    AP='AP'
    OP='OP'


class Currency(str, Enum):
    """Currency -- vocSet: D17388 (C-0-D17388-cpt)
    
    """
    ARS='ARS'
    AUD='AUD'
    BRL='BRL'
    CAD='CAD'
    CHF='CHF'
    CLF='CLF'
    CNY='CNY'
    DEM='DEM'
    ESP='ESP'
    EUR='EUR'
    FIM='FIM'
    FRF='FRF'
    GBP='GBP'
    ILS='ILS'
    INR='INR'
    JPY='JPY'
    KRW='KRW'
    MXN='MXN'
    NLG='NLG'
    NZD='NZD'
    PHP='PHP'
    RUR='RUR'
    THB='THB'
    TRL='TRL'
    TWD='TWD'
    USD='USD'
    ZAR='ZAR'


class DeliveryAddressLine(str, Enum):
    """DeliveryAddressLine -- specDomain: V17887 (C-0-D10642-V17887-cpt)
    
    """
    DAL='DAL'
    DINST='DINST'
    DINSTA='DINSTA'
    DINSTQ='DINSTQ'
    DMOD='DMOD'
    DMODID='DMODID'


class EntityClassContainer(str, Enum):
    """EntityClassContainer -- specDomain: V11622
    (C-0-D10882-V13922-V10883-V13934-V11622-cpt)
    
    """
    CONT='CONT'
    HOLD='HOLD'


class EntityClassDevice(str, Enum):
    """EntityClassDevice -- specDomain: V11623
    (C-0-D10882-V13922-V10883-V13934-V11623-cpt)
    
    """
    DEV='DEV'
    CER='CER'
    MODDV='MODDV'


class EntityClassLivingSubject(str, Enum):
    """EntityClassLivingSubject -- specDomain: V10884 (C-0-D10882-V13922-V10884-cpt)
    
    """
    LIV='LIV'
    PSN='PSN'


class EntityClassManufacturedMaterial(str, Enum):
    """EntityClassManufacturedMaterial -- specDomain: V13934
    (C-0-D10882-V13922-V10883-V13934-cpt)
    
    """
    MMAT='MMAT'


class EntityClassMaterial(str, Enum):
    """EntityClassMaterial -- specDomain: V10883 (C-0-D10882-V13922-V10883-cpt)
    
    """
    MAT='MAT'
    CHEM='CHEM'
    FOOD='FOOD'


class EntityClassNonPersonLivingSubject(str, Enum):
    """EntityClassNonPersonLivingSubject -- specDomain: V11621
    (C-0-D10882-V13922-V10884-V11621-cpt)
    
    """
    NLIV='NLIV'
    ANM='ANM'
    MIC='MIC'
    PLNT='PLNT'


class EntityClassOrganization(str, Enum):
    """EntityClassOrganization -- specDomain: V10889 (C-0-D10882-V19463-V10889-cpt)
    
    """
    ORG='ORG'
    PUB='PUB'


class EntityClassPlace(str, Enum):
    """EntityClassPlace -- specDomain: V10892 (C-0-D10882-V13922-V10892-cpt)
    
    """
    PLC='PLC'
    CITY='CITY'
    COUNTRY='COUNTRY'
    COUNTY='COUNTY'
    PROVINCE='PROVINCE'


class EntityClassPublicInstitution(str, Enum):
    PUB='PUB'


class EntityClassRoot(str, Enum):
    """EntityClassRoot -- specDomain: V13922 (C-0-D10882-V13922-cpt)
    
    """
    ENT='ENT'
    HCE='HCE'
    RGRP='RGRP'


class EntityClassState(str, Enum):
    STATE='STATE'
    NAT='NAT'


class EntityDeterminer(str, Enum):
    """EntityDeterminer -- vocSet: D10878 (C-0-D10878-cpt)
    
    """
    INSTANCE='INSTANCE'


class EntityDeterminerDetermined(str, Enum):
    """EntityDeterminerDetermined -- specDomain: V10879 (C-0-D10878-V10879-cpt)
    
    """
    KIND='KIND'
    QUANTIFIED_KIND='QUANTIFIED_KIND'


class EntityDeterminerSpecific(str, Enum):
    INSTANCE='INSTANCE'


class EntityNamePartType(str, Enum):
    """EntityNamePartType -- vocSet: D15880 (C-0-D15880-cpt)
    
    """
    DEL='DEL'
    FAM='FAM'
    GIV='GIV'
    PFX='PFX'
    SFX='SFX'


class EntityNameSearchUse(str, Enum):
    """EntityNameSearchUse -- specDomain: V19619 (C-0-D15913-V200-V19619-cpt)
    
    """
    SRCH='SRCH'
    PHON='PHON'
    SNDX='SNDX'


class EntityNameUse(str, Enum):
    """EntityNameUse -- vocSet: D15913 (C-0-D15913-cpt)
    
    """
    C='C'


class HomeAddressUse(str, Enum):
    """HomeAddressUse -- specDomain: V10628 (C-0-D201-V190-V10628-cpt)
    
    """
    H='H'
    HP='HP'
    HV='HV'


class ImageMediaType(str, Enum):
    """ImageMediaType -- abstDomain: V14839 (C-0-D14824-V14839-cpt)
    
    """
    IMAGEG_3_FAX='image/g3fax'
    IMAGEGIF='image/gif'
    IMAGEJPEG='image/jpeg'
    IMAGEPNG='image/png'
    IMAGETIFF='image/tiff'


class IntegrityCheckAlgorithm(str, Enum):
    """IntegrityCheckAlgorithm -- vocSet: D17385 (C-0-D17385-cpt)
    
    """
    SHA_1='SHA-1'
    SHA_256='SHA-256'


class LicensedEntityRole(str, Enum):
    """LicensedEntityRole -- specDomain: V16773
    (C-0-D11555-V13940-V16930-V16773-cpt)
    
    """
    LIC='LIC'
    NOT='NOT'
    PROV='PROV'


class ModelMediaType(str, Enum):
    """ModelMediaType -- abstDomain: V14848 (C-0-D14824-V14848-cpt)
    
    """
    MODELVRML='model/vrml'


class MultipartMediaType(str, Enum):
    """MultipartMediaType -- abstDomain: V14850 (C-0-D14824-V14850-cpt)
    
    """
    MULTIPARTXHL_7CDALEVEL_1='multipart/x-hl7-cda-level1'


class NamePseudonymUse(str, Enum):
    """NamePseudonymUse -- specDomain: V19591 (C-0-D15913-V200-V19591-cpt)
    
    """
    P='P'
    A='A'


class NameRepresentationUse(str, Enum):
    """NameRepresentationUse -- abstDomain: V17860 (C-0-D10637-V17860-cpt)
    
    """
    ABC='ABC'
    IDE='IDE'
    SYL='SYL'


class NoInformation(str, Enum):
    """NoInformation -- specDomain: V10610 (C-0-D10609-V10610-cpt)
    
    """
    NI='NI'
    MSK='MSK'
    NA='NA'


class NullFlavor(str, Enum):
    """NullFlavor -- vocSet: D10609 (C-0-D10609-cpt)
    
    """
    NP='NP'


class OrganizationNamePartQualifier(str, Enum):
    """OrganizationNamePartQualifier -- abstDomain: V15889 (C-0-D15888-V15889-cpt)
    
    """
    LS='LS'


class OrganizationNameUse(str, Enum):
    """OrganizationNameUse -- abstDomain: V15914 (C-0-D15913-V15914-cpt)
    
    """
    C='C'
    L='L'


class Other(str, Enum):
    """Other -- specDomain: V10616 (C-0-D10609-V10610-V10616-cpt)
    
    """
    OTH='OTH'
    NINF='NINF'
    PINF='PINF'


class ParticipationAncillary(str, Enum):
    """ParticipationAncillary -- abstDomain: V10247 (C-0-D10901-V10247-cpt)
    
    """
    ADM='ADM'
    ATND='ATND'
    CALLBCK='CALLBCK'
    CON='CON'
    DIS='DIS'
    ESC='ESC'
    REF='REF'


class ParticipationAuthorOriginator(str, Enum):
    AUT='AUT'


class ParticipationHolder(str, Enum):
    HLD='HLD'


class ParticipationIndirectTarget(str, Enum):
    """ParticipationIndirectTarget -- specDomain: V19032 (C-0-D10901-V19032-cpt)
    
    """
    IND='IND'
    BEN='BEN'
    COV='COV'
    HLD='HLD'
    RCT='RCT'
    RCV='RCV'


class ParticipationInformationGenerator(str, Enum):
    """ParticipationInformationGenerator -- abstDomain: V10251 (C-0-D10901-V10251-cpt)
    
    """
    AUT='AUT'
    ENT='ENT'
    INF='INF'
    WIT='WIT'


class ParticipationInformationRecipient(str, Enum):
    """ParticipationInformationRecipient -- specDomain: V10263 (C-0-D10901-V10263-cpt)
    
    """
    IRCP='IRCP'
    NOT='NOT'
    PRCP='PRCP'
    REFB='REFB'
    REFT='REFT'
    TRC='TRC'


class ParticipationPhysicalPerformer(str, Enum):
    """ParticipationPhysicalPerformer -- specDomain: V10248 (C-0-D10901-V10248-cpt)
    
    """
    PRF='PRF'
    DIST='DIST'
    PPRF='PPRF'
    SPRF='SPRF'


class ParticipationTargetDevice(str, Enum):
    """ParticipationTargetDevice -- specDomain: V10298 (C-0-D10901-V10286-V10298-cpt)
    
    """
    DEV='DEV'
    NRD='NRD'
    RDV='RDV'


class ParticipationTargetDirect(str, Enum):
    """ParticipationTargetDirect -- specDomain: V10286 (C-0-D10901-V10286-cpt)
    
    """
    DIR='DIR'
    BBY='BBY'
    CSM='CSM'
    DON='DON'
    PRD='PRD'


class ParticipationTargetLocation(str, Enum):
    """ParticipationTargetLocation -- specDomain: V10302 (C-0-D10901-V10302-cpt)
    
    """
    LOC='LOC'
    DST='DST'
    ELOC='ELOC'
    ORG='ORG'
    RML='RML'
    VIA='VIA'


class ParticipationTargetSubject(str, Enum):
    """ParticipationTargetSubject -- specDomain: V19584 (C-0-D10901-V10286-V19584-cpt)
    
    """
    SBJ='SBJ'
    SPC='SPC'


class ParticipationType(str, Enum):
    """ParticipationType -- vocSet: D10901 (C-0-D10901-cpt)
    
    """
    CST='CST'
    RESP='RESP'


class ParticipationVerifier(str, Enum):
    """ParticipationVerifier -- specDomain: V10259 (C-0-D10901-V10259-cpt)
    
    """
    VRF='VRF'
    AUTHEN='AUTHEN'
    LA='LA'


class PersonNamePartAffixTypes(str, Enum):
    """PersonNamePartAffixTypes -- abstDomain: V10666 (C-0-D15888-V10659-V10666-cpt)
    
    """
    AC='AC'
    NB='NB'
    PR='PR'
    VV='VV'


class PersonNamePartChangeQualifier(str, Enum):
    """PersonNamePartChangeQualifier -- abstDomain: V10660 (C-0-D15888-V10659-V10660-cpt)
    
    """
    AD='AD'
    BR='BR'
    SP='SP'


class PersonNamePartMiscQualifier(str, Enum):
    """PersonNamePartMiscQualifier -- abstDomain: V10671 (C-0-D15888-V10659-V10671-cpt)
    
    """
    CL='CL'


class PersonNamePartQualifier(str, Enum):
    """PersonNamePartQualifier -- abstDomain: V10659 (C-0-D15888-V10659-cpt)
    
    """
    IN='IN'
    TITLE='TITLE'


class PersonNameUse(str, Enum):
    """PersonNameUse -- abstDomain: V200 (C-0-D15913-V200-cpt)
    
    """
    A='A'
    ASGN='ASGN'
    C='C'
    I='I'
    L='L'
    R='R'


class PostalAddressUse(str, Enum):
    """PostalAddressUse -- vocSet: D10637 (C-0-D10637-cpt)
    
    """
    PHYS='PHYS'
    PST='PST'


class ProbabilityDistributionType(str, Enum):
    """ProbabilityDistributionType -- vocSet: D10747 (C-0-D10747-cpt)
    
    """
    B='B'
    E='E'
    F='F'
    G='G'
    LN='LN'
    N='N'
    T='T'
    U='U'
    X_2='X2'


class RelatedLinkType(str, Enum):
    """RelatedLinkType -- specDomain: V19615 (C-0-D11603-V19615-cpt)
    
    """
    REL='REL'
    BACKUP='BACKUP'
    DIRAUTH='DIRAUTH'
    INDAUTH='INDAUTH'
    PART='PART'
    REPL='REPL'


class RoleClassAdministerableMaterial(str, Enum):
    ADMM='ADMM'


class RoleClassAgent(str, Enum):
    """RoleClassAgent -- specDomain: V14006
    (C-0-D11555-V13940-V19313-V19316-V10416-V14006-cpt)
    
    """
    AGNT='AGNT'
    GUARD='GUARD'


class RoleClassAssignedEntity(str, Enum):
    """RoleClassAssignedEntity -- specDomain: V11595
    (C-0-D11555-V13940-V19313-V19316-V10416-V14006-V11595-cpt)
    
    """
    ASSIGNED='ASSIGNED'
    COMPAR='COMPAR'
    SGNOFF='SGNOFF'


class RoleClassContact(str, Enum):
    """RoleClassContact -- specDomain: V12205
    (C-0-D11555-V13940-V19313-V19316-V10416-V14006-V11595-V12205-cpt)
    
    """
    CON='CON'
    ECON='ECON'
    NOK='NOK'


class RoleClassContent(str, Enum):
    CONT='CONT'


class RoleClassDistributedMaterial(str, Enum):
    """RoleClassDistributedMaterial -- specDomain: V10418
    (C-0-D11555-V13940-V19313-V19105-V10418-cpt)
    
    """
    DST='DST'
    RET='RET'


class RoleClassEmployee(str, Enum):
    """RoleClassEmployee -- specDomain: V11569
    (C-0-D11555-V13940-V19313-V19316-V10416-V11569-cpt)
    
    """
    EMP='EMP'
    MIL='MIL'


class RoleClassInactiveIngredient(str, Enum):
    """RoleClassInactiveIngredient -- specDomain: V19089
    (C-0-D11555-V13940-V10429-V10430-V19089-cpt)
    
    """
    IACT='IACT'
    COLR='COLR'
    FLVR='FLVR'
    PRSV='PRSV'
    STBL='STBL'


class RoleClassIngredientEntity(str, Enum):
    """RoleClassIngredientEntity -- specDomain: V10430
    (C-0-D11555-V13940-V10429-V10430-cpt)
    
    """
    INGR='INGR'
    ACTI='ACTI'
    ACTM='ACTM'
    ADTV='ADTV'
    BASE='BASE'


class RoleClassInvestigationSubject(str, Enum):
    """RoleClassInvestigationSubject -- specDomain: V19587
    (C-0-D11555-V13940-V19313-V19316-V10416-V19587-cpt)
    
    """
    INVSBJ='INVSBJ'
    CASESBJ='CASESBJ'
    RESBJ='RESBJ'


class RoleClassIsSpeciesEntity(str, Enum):
    """RoleClassIsSpeciesEntity -- specDomain: V10441
    (C-0-D11555-V13940-V10428-V10441-cpt)
    
    """
    GEN='GEN'
    GRIC='GRIC'


class RoleClassLocatedEntity(str, Enum):
    """RoleClassLocatedEntity -- specDomain: V16815
    (C-0-D11555-V13940-V10429-V16815-cpt)
    
    """
    LOCE='LOCE'
    STOR='STOR'


class RoleClassManufacturedProduct(str, Enum):
    """RoleClassManufacturedProduct -- specDomain: V11580
    (C-0-D11555-V13940-V19313-V19105-V11580-cpt)
    
    """
    MANU='MANU'
    THER='THER'


class RoleClassMutualRelationship(str, Enum):
    """RoleClassMutualRelationship -- abstDomain: V19316
    (C-0-D11555-V13940-V19313-V19316-cpt)
    
    """
    CAREGIVER='CAREGIVER'
    PRS='PRS'


class RoleClassOntological(str, Enum):
    """RoleClassOntological -- abstDomain: V10428 (C-0-D11555-V13940-V10428-cpt)
    
    """
    INST='INST'
    SUBS='SUBS'
    SUBY='SUBY'


class RoleClassPart(str, Enum):
    PART='PART'
    ACTM='ACTM'


class RoleClassPartitive(str, Enum):
    """RoleClassPartitive -- abstDomain: V10429 (C-0-D11555-V13940-V10429-cpt)
    
    """
    CONT='CONT'
    MBR='MBR'
    PART='PART'


class RoleClassPassive(str, Enum):
    """RoleClassPassive -- abstDomain: V19105
    (C-0-D11555-V13940-V19313-V19105-cpt)
    
    """
    ACCESS='ACCESS'
    BIRTHPL='BIRTHPL'
    EXPR='EXPR'
    HLD='HLD'
    HLTHCHRT='HLTHCHRT'
    IDENT='IDENT'
    MNT='MNT'
    OWN='OWN'
    RGPR='RGPR'
    TERR='TERR'
    WRTE='WRTE'


class RoleClassRelationshipFormal(str, Enum):
    """RoleClassRelationshipFormal -- abstDomain: V10416
    (C-0-D11555-V13940-V19313-V19316-V10416-cpt)
    
    """
    CIT='CIT'
    COVPTY='COVPTY'
    CRINV='CRINV'
    CRSPNSR='CRSPNSR'
    GUAR='GUAR'
    PAT='PAT'
    PAYEE='PAYEE'
    PAYOR='PAYOR'
    POLHOLD='POLHOLD'
    QUAL='QUAL'
    SPNSR='SPNSR'
    STD='STD'
    UNDWRT='UNDWRT'


class RoleClassRoot(str, Enum):
    """RoleClassRoot -- specDomain: V13940 (C-0-D11555-V13940-cpt)
    
    """
    ROL='ROL'


class RoleClassServiceDeliveryLocation(str, Enum):
    """RoleClassServiceDeliveryLocation -- specDomain: V16927
    (C-0-D11555-V13940-V19313-V19105-V16927-cpt)
    
    """
    SDLOC='SDLOC'
    DSDLOC='DSDLOC'
    ISDLOC='ISDLOC'


class RoleClassSpecimen(str, Enum):
    """RoleClassSpecimen -- specDomain: V11591
    (C-0-D11555-V13940-V10429-V11591-cpt)
    
    """
    SPEC='SPEC'
    ALQT='ALQT'
    ISLT='ISLT'


class RoleClassTerritoryOfAuthority(str, Enum):
    TERR='TERR'


class SetOperator(str, Enum):
    """SetOperator -- vocSet: D17416 (C-0-D17416-cpt)
    
    """
    A='A'
    E='E'
    H='H'
    I='I'
    P='P'


class State(str, Enum):
    """State -- specDomain: V19455
    (C-0-D10882-V19463-V10889-V19455-cpt)
    
    """
    STATE='STATE'
    NAT='NAT'


class StreetAddressLine(str, Enum):
    """StreetAddressLine -- specDomain: V14822 (C-0-D10642-V14822-cpt)
    
    """
    SAL='SAL'
    DIR='DIR'


class StreetName(str, Enum):
    """StreetName -- specDomain: V10648 (C-0-D10642-V14822-V10648-cpt)
    
    """
    STR='STR'
    STB='STB'
    STTYP='STTYP'


class TelecommunicationAddressUse(str, Enum):
    """TelecommunicationAddressUse -- vocSet: D201 (C-0-D201-cpt)
    
    """
    AS='AS'
    EC='EC'
    MC='MC'
    PG='PG'


class TemporallyPertains(str, Enum):
    """TemporallyPertains -- abstDomain: V19590 (C-0-D10317-V10329-V19590-cpt)
    
    """
    SAS='SAS'


class TextMediaType(str, Enum):
    """TextMediaType -- abstDomain: V14825 (C-0-D14824-V14825-cpt)
    
    """
    TEXTHTML='text/html'
    TEXTPLAIN='text/plain'
    TEXTRTF='text/rtf'
    TEXTSGML='text/sgml'
    TEXTXHL_7FT='text/x-hl7-ft'
    TEXTXML='text/xml'


class TimingEvent(str, Enum):
    """TimingEvent -- vocSet: D10706 (C-0-D10706-cpt)
    
    """
    AC='AC'
    ACD='ACD'
    ACM='ACM'
    ACV='ACV'
    HS='HS'
    IC='IC'
    ICD='ICD'
    ICM='ICM'
    ICV='ICV'
    PC='PC'
    PCD='PCD'
    PCM='PCM'
    PCV='PCV'
    CM='CM'
    CD='CD'
    CV='CV'


class URLScheme(str, Enum):
    """URLScheme -- vocSet: D14866 (C-0-D14866-cpt)
    
    """
    FAX='fax'
    FILE='file'
    FTP='ftp'
    HTTP='http'
    MAILTO='mailto'
    MLLP='mllp'
    MODEM='modem'
    NFS='nfs'
    TEL='tel'
    TELNET='telnet'
    ME='me'
    HTTPS='https'


class Unknown(str, Enum):
    """Unknown -- specDomain: V10612 (C-0-D10609-V10610-V10612-cpt)
    
    """
    UNK='UNK'
    NASK='NASK'
    TRC='TRC'


class VideoMediaType(str, Enum):
    """VideoMediaType -- abstDomain: V14845 (C-0-D14824-V14845-cpt)
    
    """
    VIDEOMPEG='video/mpeg'
    VIDEOXAVI='video/x-avi'


class WorkPlaceAddressUse(str, Enum):
    """WorkPlaceAddressUse -- specDomain: V19613 (C-0-D201-V190-V19613-cpt)
    
    """
    WP='WP'
    DIR='DIR'
    PUB='PUB'


class alignType(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class alignType1(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class alignType10(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class alignType12(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class alignType14(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class alignType3(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class alignType5(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class alignType7(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class frameType(str, Enum):
    VOID='void'
    ABOVE='above'
    BELOW='below'
    HSIDES='hsides'
    LHS='lhs'
    RHS='rhs'
    VSIDES='vsides'
    BOX='box'
    BORDER='border'


class hasSupport(str, Enum):
    """hasSupport -- specDomain: V10330 (C-0-D10317-V10329-V10330-cpt)
    
    """
    SPRT='SPRT'
    SPRTBND='SPRTBND'


class listTypeType(str, Enum):
    ORDERED='ordered'
    UNORDERED='unordered'


class revisedType(str, Enum):
    INSERT='insert'
    DELETE='delete'


class rulesType(str, Enum):
    NONE='none'
    GROUPS='groups'
    ROWS='rows'
    COLS='cols'
    ALL='all'


class scopeType(str, Enum):
    ROW='row'
    COL='col'
    ROWGROUP='rowgroup'
    COLGROUP='colgroup'


class scopeType9(str, Enum):
    ROW='row'
    COL='col'
    ROWGROUP='rowgroup'
    COLGROUP='colgroup'


class valignType(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class valignType11(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class valignType13(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class valignType15(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class valignType2(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class valignType4(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class valignType6(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class valignType8(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


class xELGA_TimingEvent(str, Enum):
    """xELGA_TimingEvent -- vocSet: D10706 (C-0-D10706-cpt)
    
    """
    AC='AC'
    ACD='ACD'
    ACM='ACM'
    ACV='ACV'
    HS='HS'
    IC='IC'
    ICD='ICD'
    ICM='ICM'
    ICV='ICV'
    PC='PC'
    PCD='PCD'
    PCM='PCM'
    PCV='PCV'
    CM='CM'
    CD='CD'
    CV='CV'


class xELGA_URLScheme(str, Enum):
    """xELGA_URLScheme -- vocSet: D14866 (C-0-D14866-cpt)
    
    """
    FAX='fax'
    FILE='file'
    FTP='ftp'
    HTTP='http'
    HTTPS='https'
    MAILTO='mailto'
    MLLP='mllp'
    MODEM='modem'
    NFS='nfs'
    TEL='tel'
    TELNET='telnet'
    ME='me'


class x_ActClassDocumentEntryAct(str, Enum):
    """x_ActClassDocumentEntryAct -- abstDomain: V19604 (C-0-D11527-V13856-V19604-cpt)
    
    """
    ACT='ACT'
    ACCM='ACCM'
    CONS='CONS'
    CTTEVENT='CTTEVENT'
    INC='INC'
    INFRM='INFRM'
    PCPR='PCPR'
    REG='REG'
    SPCTRT='SPCTRT'


class x_ActClassDocumentEntryOrganizer(str, Enum):
    """x_ActClassDocumentEntryOrganizer -- abstDomain: V19603 (C-0-D11527-V13856-V19603-cpt)
    
    """
    BATTERY='BATTERY'
    CLUSTER='CLUSTER'


class x_ActMoodDefEvn(str, Enum):
    """x_ActMoodDefEvn -- abstDomain: V19375 (C-0-D10196-V19375-cpt)
    
    """
    DEF='DEF'
    EVN='EVN'


class x_ActMoodDefEvnRqoPrmsPrp(str, Enum):
    """x_ActMoodDefEvnRqoPrmsPrp -- abstDomain: V19371 (C-0-D10196-V19371-cpt)
    
    """
    DEF='DEF'
    EVN='EVN'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_ActMoodDocumentObservation(str, Enum):
    """x_ActMoodDocumentObservation -- abstDomain: V18943 (C-0-D10196-V18943-cpt)
    
    """
    INT='INT'
    DEF='DEF'
    EVN='EVN'
    GOL='GOL'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_ActMoodEvnOrdPrmsPrp(str, Enum):
    """x_ActMoodEvnOrdPrmsPrp -- abstDomain: V18965 (C-0-D10196-V18965-cpt)
    
    """
    EVN='EVN'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_ActMoodIntentEvent(str, Enum):
    """x_ActMoodIntentEvent -- abstDomain: V16742 (C-0-D10196-V16742-cpt)
    
    """
    EVN='EVN'


class x_ActMoodOrdPrms(str, Enum):
    """x_ActMoodOrdPrms -- abstDomain: V16735 (C-0-D10196-V16735-cpt)
    
    """
    PRMS='PRMS'
    RQO='RQO'


class x_ActMoodOrdPrmsEvn(str, Enum):
    """x_ActMoodOrdPrmsEvn -- abstDomain: V16730 (C-0-D10196-V16730-cpt)
    
    """
    EVN='EVN'
    PRMS='PRMS'
    RQO='RQO'


class x_ActMoodRqoPrpAptArq(str, Enum):
    """x_ActMoodRqoPrpAptArq -- abstDomain: V19372 (C-0-D10196-V19372-cpt)
    
    """
    APT='APT'
    ARQ='ARQ'
    PRP='PRP'
    RQO='RQO'


class x_ActRelationshipDocument(str, Enum):
    """x_ActRelationshipDocument -- abstDomain: V11610 (C-0-D10317-V11610-cpt)
    
    """
    RPLC='RPLC'
    APND='APND'
    XFRM='XFRM'


class x_ActRelationshipEntry(str, Enum):
    """x_ActRelationshipEntry -- abstDomain: V19446 (C-0-D10317-V19446-cpt)
    
    """
    COMP='COMP'
    DRIV='DRIV'


class x_ActRelationshipEntryRelationship(str, Enum):
    """x_ActRelationshipEntryRelationship -- abstDomain: V19447 (C-0-D10317-V19447-cpt)
    
    """
    XCRPT='XCRPT'
    COMP='COMP'
    RSON='RSON'
    SPRT='SPRT'
    CAUS='CAUS'
    GEVL='GEVL'
    MFST='MFST'
    REFR='REFR'
    SAS='SAS'
    SUBJ='SUBJ'


class x_ActRelationshipExternalReference(str, Enum):
    """x_ActRelationshipExternalReference -- abstDomain: V19000 (C-0-D10317-V19000-cpt)
    
    """
    XCRPT='XCRPT'
    RPLC='RPLC'
    SPRT='SPRT'
    ELNK='ELNK'
    REFR='REFR'
    SUBJ='SUBJ'


class x_ActRelationshipPatientTransport(str, Enum):
    """x_ActRelationshipPatientTransport -- abstDomain: V19005 (C-0-D10317-V19005-cpt)
    
    """
    ARR='ARR'
    DEP='DEP'


class x_ActRelationshipPertinentInfo(str, Enum):
    """x_ActRelationshipPertinentInfo -- abstDomain: V19562 (C-0-D10317-V19562-cpt)
    
    """
    SPRT='SPRT'
    CAUS='CAUS'
    MFST='MFST'
    REFR='REFR'
    SUBJ='SUBJ'


class x_DeterminerInstanceKind(str, Enum):
    """x_DeterminerInstanceKind -- abstDomain: V19647 (C-0-D10878-V19647-cpt)
    
    """
    KIND='KIND'
    INSTANCE='INSTANCE'


class x_DocumentActMood(str, Enum):
    """x_DocumentActMood -- abstDomain: V19458 (C-0-D10196-V19458-cpt)
    
    """
    INT='INT'
    APT='APT'
    ARQ='ARQ'
    DEF='DEF'
    EVN='EVN'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_DocumentEncounterMood(str, Enum):
    """x_DocumentEncounterMood -- abstDomain: V19459 (C-0-D10196-V19459-cpt)
    
    """
    INT='INT'
    APT='APT'
    ARQ='ARQ'
    EVN='EVN'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_DocumentEntrySubject(str, Enum):
    """x_DocumentEntrySubject -- abstDomain: V19367 (C-0-D11555-V13940-V19367-cpt)
    
    """
    SPEC='SPEC'
    PAT='PAT'
    PRS='PRS'


class x_DocumentProcedureMood(str, Enum):
    """x_DocumentProcedureMood -- abstDomain: V19460 (C-0-D10196-V19460-cpt)
    
    """
    INT='INT'
    APT='APT'
    ARQ='ARQ'
    DEF='DEF'
    EVN='EVN'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_DocumentSubject(str, Enum):
    """x_DocumentSubject -- abstDomain: V19368 (C-0-D11555-V13940-V19368-cpt)
    
    """
    PAT='PAT'
    PRS='PRS'


class x_DocumentSubstanceMood(str, Enum):
    """x_DocumentSubstanceMood -- abstDomain: V19461 (C-0-D10196-V19461-cpt)
    
    """
    INT='INT'
    EVN='EVN'
    PRMS='PRMS'
    PRP='PRP'
    RQO='RQO'


class x_EncounterParticipant(str, Enum):
    """x_EncounterParticipant -- abstDomain: V19605 (C-0-D10901-V19605-cpt)
    
    """
    ADM='ADM'
    ATND='ATND'
    CON='CON'
    DIS='DIS'
    REF='REF'


class x_EncounterPerformerParticipation(str, Enum):
    """x_EncounterPerformerParticipation -- abstDomain: V16764 (C-0-D10901-V16764-cpt)
    
    """
    PRF='PRF'
    CON='CON'
    SPRF='SPRF'


class x_EntityClassDocumentReceiving(str, Enum):
    """x_EntityClassDocumentReceiving -- abstDomain: V19462 (C-0-D10882-V19462-cpt)
    
    """
    HCE='HCE'
    PSN='PSN'


class x_EntityClassPersonOrOrgReceiving(str, Enum):
    """x_EntityClassPersonOrOrgReceiving -- abstDomain: V19463 (C-0-D10882-V19463-cpt)
    
    """
    PSN='PSN'


class x_InformationRecipient(str, Enum):
    """x_InformationRecipient -- abstDomain: V19366 (C-0-D10901-V19366-cpt)
    
    """
    PRCP='PRCP'
    TRC='TRC'


class x_InformationRecipientRole(str, Enum):
    """x_InformationRecipientRole -- abstDomain: V16772 (C-0-D11555-V13940-V16772-cpt)
    
    """
    ASSIGNED='ASSIGNED'
    HLTHCHRT='HLTHCHRT'


class x_OrganizationNamePartType(str, Enum):
    """x_OrganizationNamePartType -- abstDomain: V15881 (C-0-D15880-V15881-cpt)
    
    """
    DEL='DEL'
    PFX='PFX'
    SFX='SFX'


class x_ParticipationAuthorPerformer(str, Enum):
    """x_ParticipationAuthorPerformer -- abstDomain: V19080 (C-0-D10901-V19080-cpt)
    
    """
    PRF='PRF'
    AUT='AUT'


class x_ParticipationEntVrf(str, Enum):
    """x_ParticipationEntVrf -- abstDomain: V19600 (C-0-D10901-V19600-cpt)
    
    """
    VRF='VRF'
    ENT='ENT'


class x_ParticipationPrfEntVrf(str, Enum):
    """x_ParticipationPrfEntVrf -- abstDomain: V19601 (C-0-D10901-V19601-cpt)
    
    """
    PRF='PRF'
    VRF='VRF'
    ENT='ENT'


class x_ParticipationVrfRespSprfWit(str, Enum):
    """x_ParticipationVrfRespSprfWit -- abstDomain: V19083 (C-0-D10901-V19083-cpt)
    
    """
    VRF='VRF'
    RESP='RESP'
    SPRF='SPRF'
    WIT='WIT'


class x_PersonNamePartType(str, Enum):
    """x_PersonNamePartType -- abstDomain: V10653 (C-0-D15880-V10653-cpt)
    
    """
    DEL='DEL'
    FAM='FAM'
    GIV='GIV'
    PFX='PFX'
    SFX='SFX'


class x_RoleClassAccommodationRequestor(str, Enum):
    """x_RoleClassAccommodationRequestor -- abstDomain: V19382 (C-0-D11555-V13940-V19382-cpt)
    
    """
    AGNT='AGNT'
    PAT='PAT'
    PROV='PROV'
    PRS='PRS'


class x_RoleClassCoverage(str, Enum):
    """x_RoleClassCoverage -- abstDomain: V14008 (C-0-D11555-V13940-V14008-cpt)
    
    """
    COVPTY='COVPTY'
    POLHOLD='POLHOLD'
    SPNSR='SPNSR'
    UNDWRT='UNDWRT'


class x_RoleClassCoverageInvoice(str, Enum):
    """x_RoleClassCoverageInvoice -- abstDomain: V14013 (C-0-D11555-V13940-V14013-cpt)
    
    """
    PAYEE='PAYEE'
    PAYOR='PAYOR'


class x_RoleClassCredentialedEntity(str, Enum):
    """x_RoleClassCredentialedEntity -- abstDomain: V16930 (C-0-D11555-V13940-V16930-cpt)
    
    """
    ASSIGNED='ASSIGNED'
    QUAL='QUAL'


class x_RoleClassPayeePolicyRelationship(str, Enum):
    """x_RoleClassPayeePolicyRelationship -- abstDomain: V19395 (C-0-D11555-V13940-V19395-cpt)
    
    """
    COVPTY='COVPTY'
    GUAR='GUAR'
    POLHOLD='POLHOLD'
    PROV='PROV'
    PRS='PRS'


class x_ServiceEventPerformer(str, Enum):
    """x_ServiceEventPerformer -- abstDomain: V19606 (C-0-D10901-V19606-cpt)
    
    """
    PRF='PRF'
    PPRF='PPRF'
    SPRF='SPRF'


#
# Start data representation classes
#
class POCD_MT000040_Act(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'x_ActClassDocumentEntryAct' = None, moodCode: 'x_DocumentActMood' = None, negationInd: 'bl' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, statusCode: 'CS' = None, effectiveTime: 'IVL_TS' = None, priorityCode: 'CE' = None, languageCode: 'CS' = None, subject: 'POCD_MT000040.Subject' = None, specimen: List_['POCD_MT000040.Specimen'] = None, performer: List_['POCD_MT000040.Performer2'] = None, author: List_['POCD_MT000040.Author'] = None, informant: List_['POCD_MT000040.Informant12'] = None, participant: List_['POCD_MT000040.Participant2'] = None, entryRelationship: List_['POCD_MT000040.EntryRelationship'] = None, reference: List_['POCD_MT000040.Reference'] = None, precondition: List_['POCD_MT000040.Precondition'] = None, inFulfillmentOf1: List_['InFulfillmentOf1'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        self.negationInd = _cast(bool, negationInd)
        self.negationInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.statusCode = statusCode
        self.statusCode_nsprefix_ = None
        self.effectiveTime = effectiveTime
        self.effectiveTime_nsprefix_ = None
        self.priorityCode = priorityCode
        self.priorityCode_nsprefix_ = None
        self.languageCode = languageCode
        self.languageCode_nsprefix_ = None
        self.subject = subject
        self.subject_nsprefix_ = None
        if specimen is None:
            self.specimen = []
        else:
            self.specimen = specimen
        self.specimen_nsprefix_ = None
        if performer is None:
            self.performer = []
        else:
            self.performer = performer
        self.performer_nsprefix_ = None
        if author is None:
            self.author = []
        else:
            self.author = author
        self.author_nsprefix_ = None
        if informant is None:
            self.informant = []
        else:
            self.informant = informant
        self.informant_nsprefix_ = None
        if participant is None:
            self.participant = []
        else:
            self.participant = participant
        self.participant_nsprefix_ = None
        if entryRelationship is None:
            self.entryRelationship = []
        else:
            self.entryRelationship = entryRelationship
        self.entryRelationship_nsprefix_ = None
        if reference is None:
            self.reference = []
        else:
            self.reference = reference
        self.reference_nsprefix_ = None
        if precondition is None:
            self.precondition = []
        else:
            self.precondition = precondition
        self.precondition_nsprefix_ = None
        if inFulfillmentOf1 is None:
            self.inFulfillmentOf1 = []
        else:
            self.inFulfillmentOf1 = inFulfillmentOf1
        self.inFulfillmentOf1_nsprefix_ = "sdtc"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Act)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Act.subclass:
            return POCD_MT000040_Act.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Act(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_statusCode(self):
        return self.statusCode
    def set_statusCode(self, statusCode):
        self.statusCode = statusCode
    def get_effectiveTime(self):
        return self.effectiveTime
    def set_effectiveTime(self, effectiveTime):
        self.effectiveTime = effectiveTime
    def get_priorityCode(self):
        return self.priorityCode
    def set_priorityCode(self, priorityCode):
        self.priorityCode = priorityCode
    def get_languageCode(self):
        return self.languageCode
    def set_languageCode(self, languageCode):
        self.languageCode = languageCode
    def get_subject(self):
        return self.subject
    def set_subject(self, subject):
        self.subject = subject
    def get_specimen(self):
        return self.specimen
    def set_specimen(self, specimen):
        self.specimen = specimen
    def add_specimen(self, value):
        self.specimen.append(value)
    def insert_specimen_at(self, index, value):
        self.specimen.insert(index, value)
    def replace_specimen_at(self, index, value):
        self.specimen[index] = value
    def get_performer(self):
        return self.performer
    def set_performer(self, performer):
        self.performer = performer
    def add_performer(self, value):
        self.performer.append(value)
    def insert_performer_at(self, index, value):
        self.performer.insert(index, value)
    def replace_performer_at(self, index, value):
        self.performer[index] = value
    def get_author(self):
        return self.author
    def set_author(self, author):
        self.author = author
    def add_author(self, value):
        self.author.append(value)
    def insert_author_at(self, index, value):
        self.author.insert(index, value)
    def replace_author_at(self, index, value):
        self.author[index] = value
    def get_informant(self):
        return self.informant
    def set_informant(self, informant):
        self.informant = informant
    def add_informant(self, value):
        self.informant.append(value)
    def insert_informant_at(self, index, value):
        self.informant.insert(index, value)
    def replace_informant_at(self, index, value):
        self.informant[index] = value
    def get_participant(self):
        return self.participant
    def set_participant(self, participant):
        self.participant = participant
    def add_participant(self, value):
        self.participant.append(value)
    def insert_participant_at(self, index, value):
        self.participant.insert(index, value)
    def replace_participant_at(self, index, value):
        self.participant[index] = value
    def get_entryRelationship(self):
        return self.entryRelationship
    def set_entryRelationship(self, entryRelationship):
        self.entryRelationship = entryRelationship
    def add_entryRelationship(self, value):
        self.entryRelationship.append(value)
    def insert_entryRelationship_at(self, index, value):
        self.entryRelationship.insert(index, value)
    def replace_entryRelationship_at(self, index, value):
        self.entryRelationship[index] = value
    def get_reference(self):
        return self.reference
    def set_reference(self, reference):
        self.reference = reference
    def add_reference(self, value):
        self.reference.append(value)
    def insert_reference_at(self, index, value):
        self.reference.insert(index, value)
    def replace_reference_at(self, index, value):
        self.reference[index] = value
    def get_precondition(self):
        return self.precondition
    def set_precondition(self, precondition):
        self.precondition = precondition
    def add_precondition(self, value):
        self.precondition.append(value)
    def insert_precondition_at(self, index, value):
        self.precondition.insert(index, value)
    def replace_precondition_at(self, index, value):
        self.precondition[index] = value
    def get_inFulfillmentOf1(self):
        return self.inFulfillmentOf1
    def set_inFulfillmentOf1(self, inFulfillmentOf1):
        self.inFulfillmentOf1 = inFulfillmentOf1
    def add_inFulfillmentOf1(self, value):
        self.inFulfillmentOf1.append(value)
    def insert_inFulfillmentOf1_at(self, index, value):
        self.inFulfillmentOf1.insert(index, value)
    def replace_inFulfillmentOf1_at(self, index, value):
        self.inFulfillmentOf1[index] = value
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def get_negationInd(self):
        return self.negationInd
    def set_negationInd(self, negationInd):
        self.negationInd = negationInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_x_ActClassDocumentEntryAct(self, value):
        # Validate type x_ActClassDocumentEntryAct, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ACT', 'ACCM', 'CONS', 'CTTEVENT', 'INC', 'INFRM', 'PCPR', 'REG', 'SPCTRT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_ActClassDocumentEntryAct' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_ActClassDocumentEntryAct_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_ActClassDocumentEntryAct_patterns_, ))
    validate_x_ActClassDocumentEntryAct_patterns_ = [['^([^\\s]+)$']]
    def validate_x_DocumentActMood(self, value):
        # Validate type x_DocumentActMood, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['INT', 'APT', 'ARQ', 'DEF', 'EVN', 'PRMS', 'PRP', 'RQO']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_DocumentActMood' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_DocumentActMood_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_DocumentActMood_patterns_, ))
    validate_x_DocumentActMood_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.text is not None or
            self.statusCode is not None or
            self.effectiveTime is not None or
            self.priorityCode is not None or
            self.languageCode is not None or
            self.subject is not None or
            self.specimen or
            self.performer or
            self.author or
            self.informant or
            self.participant or
            self.entryRelationship or
            self.reference or
            self.precondition or
            self.inFulfillmentOf1
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.Act', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Act')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Act':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Act')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Act', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Act'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
        if self.negationInd is not None and 'negationInd' not in already_processed:
            already_processed.add('negationInd')
            outfile.write(' negationInd="%s"' % self.gds_format_boolean(self.negationInd, input_name='negationInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.Act', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.statusCode is not None:
            namespaceprefix_ = self.statusCode_nsprefix_ + ':' if (UseCapturedNS_ and self.statusCode_nsprefix_) else ''
            self.statusCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='statusCode', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            namespaceprefix_ = self.effectiveTime_nsprefix_ + ':' if (UseCapturedNS_ and self.effectiveTime_nsprefix_) else ''
            self.effectiveTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='effectiveTime', pretty_print=pretty_print)
        if self.priorityCode is not None:
            namespaceprefix_ = self.priorityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.priorityCode_nsprefix_) else ''
            self.priorityCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='priorityCode', pretty_print=pretty_print)
        if self.languageCode is not None:
            namespaceprefix_ = self.languageCode_nsprefix_ + ':' if (UseCapturedNS_ and self.languageCode_nsprefix_) else ''
            self.languageCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='languageCode', pretty_print=pretty_print)
        if self.subject is not None:
            namespaceprefix_ = self.subject_nsprefix_ + ':' if (UseCapturedNS_ and self.subject_nsprefix_) else ''
            self.subject.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subject', pretty_print=pretty_print)
        for specimen_ in self.specimen:
            namespaceprefix_ = self.specimen_nsprefix_ + ':' if (UseCapturedNS_ and self.specimen_nsprefix_) else ''
            specimen_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specimen', pretty_print=pretty_print)
        for performer_ in self.performer:
            namespaceprefix_ = self.performer_nsprefix_ + ':' if (UseCapturedNS_ and self.performer_nsprefix_) else ''
            performer_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='performer', pretty_print=pretty_print)
        for author_ in self.author:
            namespaceprefix_ = self.author_nsprefix_ + ':' if (UseCapturedNS_ and self.author_nsprefix_) else ''
            author_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='author', pretty_print=pretty_print)
        for informant_ in self.informant:
            namespaceprefix_ = self.informant_nsprefix_ + ':' if (UseCapturedNS_ and self.informant_nsprefix_) else ''
            informant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='informant', pretty_print=pretty_print)
        for participant_ in self.participant:
            namespaceprefix_ = self.participant_nsprefix_ + ':' if (UseCapturedNS_ and self.participant_nsprefix_) else ''
            participant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='participant', pretty_print=pretty_print)
        for entryRelationship_ in self.entryRelationship:
            namespaceprefix_ = self.entryRelationship_nsprefix_ + ':' if (UseCapturedNS_ and self.entryRelationship_nsprefix_) else ''
            entryRelationship_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='entryRelationship', pretty_print=pretty_print)
        for reference_ in self.reference:
            namespaceprefix_ = self.reference_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_nsprefix_) else ''
            reference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reference', pretty_print=pretty_print)
        for precondition_ in self.precondition:
            namespaceprefix_ = self.precondition_nsprefix_ + ':' if (UseCapturedNS_ and self.precondition_nsprefix_) else ''
            precondition_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='precondition', pretty_print=pretty_print)
        for inFulfillmentOf1_ in self.inFulfillmentOf1:
            namespaceprefix_ = self.inFulfillmentOf1_nsprefix_ + ':' if (UseCapturedNS_ and self.inFulfillmentOf1_nsprefix_) else ''
            inFulfillmentOf1_.export(outfile, level, namespaceprefix_='sdtc:', namespacedef_='', name_='inFulfillmentOf1', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_x_ActClassDocumentEntryAct(self.classCode)    # validate type x_ActClassDocumentEntryAct
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_x_DocumentActMood(self.moodCode)    # validate type x_DocumentActMood
        value = find_attr_value_('negationInd', node)
        if value is not None and 'negationInd' not in already_processed:
            already_processed.add('negationInd')
            if value in ('true', '1'):
                self.negationInd = True
            elif value in ('false', '0'):
                self.negationInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.negationInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'statusCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.statusCode = obj_
            obj_.original_tagname_ = 'statusCode'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'priorityCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.priorityCode = obj_
            obj_.original_tagname_ = 'priorityCode'
        elif nodeName_ == 'languageCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.languageCode = obj_
            obj_.original_tagname_ = 'languageCode'
        elif nodeName_ == 'subject':
            obj_ = POCD_MT000040_Subject.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subject = obj_
            obj_.original_tagname_ = 'subject'
        elif nodeName_ == 'specimen':
            obj_ = POCD_MT000040_Specimen.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specimen.append(obj_)
            obj_.original_tagname_ = 'specimen'
        elif nodeName_ == 'performer':
            obj_ = POCD_MT000040_Performer2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.performer.append(obj_)
            obj_.original_tagname_ = 'performer'
        elif nodeName_ == 'author':
            obj_ = POCD_MT000040_Author.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'informant':
            obj_ = POCD_MT000040_Informant12.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.informant.append(obj_)
            obj_.original_tagname_ = 'informant'
        elif nodeName_ == 'participant':
            obj_ = POCD_MT000040_Participant2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.participant.append(obj_)
            obj_.original_tagname_ = 'participant'
        elif nodeName_ == 'entryRelationship':
            obj_ = POCD_MT000040_EntryRelationship.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.entryRelationship.append(obj_)
            obj_.original_tagname_ = 'entryRelationship'
        elif nodeName_ == 'reference':
            obj_ = POCD_MT000040_Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reference.append(obj_)
            obj_.original_tagname_ = 'reference'
        elif nodeName_ == 'precondition':
            obj_ = POCD_MT000040_Precondition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.precondition.append(obj_)
            obj_.original_tagname_ = 'precondition'
        elif nodeName_ == 'inFulfillmentOf1':
            obj_ = InFulfillmentOf1.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.inFulfillmentOf1.append(obj_)
            obj_.original_tagname_ = 'inFulfillmentOf1'
# end class POCD_MT000040_Act


class POCD_MT000040_AssignedAuthor(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClassAssignedEntity' = 'ASSIGNED', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, addr: List_['AD'] = None, telecom: List_['TEL'] = None, assignedPerson: 'POCD_MT000040.Person' = None, assignedAuthoringDevice: 'POCD_MT000040.AuthoringDevice' = None, representedOrganization: 'POCD_MT000040.Organization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        if addr is None:
            self.addr = []
        else:
            self.addr = addr
        self.addr_nsprefix_ = None
        if telecom is None:
            self.telecom = []
        else:
            self.telecom = telecom
        self.telecom_nsprefix_ = None
        self.assignedPerson = assignedPerson
        self.assignedPerson_nsprefix_ = None
        self.assignedAuthoringDevice = assignedAuthoringDevice
        self.assignedAuthoringDevice_nsprefix_ = None
        self.representedOrganization = representedOrganization
        self.representedOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_AssignedAuthor)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_AssignedAuthor.subclass:
            return POCD_MT000040_AssignedAuthor.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_AssignedAuthor(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_addr(self):
        return self.addr
    def set_addr(self, addr):
        self.addr = addr
    def add_addr(self, value):
        self.addr.append(value)
    def insert_addr_at(self, index, value):
        self.addr.insert(index, value)
    def replace_addr_at(self, index, value):
        self.addr[index] = value
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def add_telecom(self, value):
        self.telecom.append(value)
    def insert_telecom_at(self, index, value):
        self.telecom.insert(index, value)
    def replace_telecom_at(self, index, value):
        self.telecom[index] = value
    def get_assignedPerson(self):
        return self.assignedPerson
    def set_assignedPerson(self, assignedPerson):
        self.assignedPerson = assignedPerson
    def get_assignedAuthoringDevice(self):
        return self.assignedAuthoringDevice
    def set_assignedAuthoringDevice(self, assignedAuthoringDevice):
        self.assignedAuthoringDevice = assignedAuthoringDevice
    def get_representedOrganization(self):
        return self.representedOrganization
    def set_representedOrganization(self, representedOrganization):
        self.representedOrganization = representedOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_RoleClassAssignedEntity(self, value):
        # Validate type RoleClassAssignedEntity, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.addr or
            self.telecom or
            self.assignedPerson is not None or
            self.assignedAuthoringDevice is not None or
            self.representedOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.AssignedAuthor', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.AssignedAuthor')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.AssignedAuthor':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.AssignedAuthor')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.AssignedAuthor', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.AssignedAuthor'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.AssignedAuthor', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        for addr_ in self.addr:
            namespaceprefix_ = self.addr_nsprefix_ + ':' if (UseCapturedNS_ and self.addr_nsprefix_) else ''
            addr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addr', pretty_print=pretty_print)
        for telecom_ in self.telecom:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            telecom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
        if self.assignedPerson is not None:
            namespaceprefix_ = self.assignedPerson_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedPerson_nsprefix_) else ''
            self.assignedPerson.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedPerson', pretty_print=pretty_print)
        if self.assignedAuthoringDevice is not None:
            namespaceprefix_ = self.assignedAuthoringDevice_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedAuthoringDevice_nsprefix_) else ''
            self.assignedAuthoringDevice.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedAuthoringDevice', pretty_print=pretty_print)
        if self.representedOrganization is not None:
            namespaceprefix_ = self.representedOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.representedOrganization_nsprefix_) else ''
            self.representedOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='representedOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClassAssignedEntity(self.classCode)    # validate type RoleClassAssignedEntity
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'addr':
            obj_ = AD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addr.append(obj_)
            obj_.original_tagname_ = 'addr'
        elif nodeName_ == 'telecom':
            obj_ = TEL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom.append(obj_)
            obj_.original_tagname_ = 'telecom'
        elif nodeName_ == 'assignedPerson':
            obj_ = POCD_MT000040_Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedPerson = obj_
            obj_.original_tagname_ = 'assignedPerson'
        elif nodeName_ == 'assignedAuthoringDevice':
            obj_ = POCD_MT000040_AuthoringDevice.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedAuthoringDevice = obj_
            obj_.original_tagname_ = 'assignedAuthoringDevice'
        elif nodeName_ == 'representedOrganization':
            obj_ = POCD_MT000040_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.representedOrganization = obj_
            obj_.original_tagname_ = 'representedOrganization'
# end class POCD_MT000040_AssignedAuthor


class POCD_MT000040_AssignedCustodian(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClassAssignedEntity' = 'ASSIGNED', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, representedCustodianOrganization: 'POCD_MT000040.CustodianOrganization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.representedCustodianOrganization = representedCustodianOrganization
        self.representedCustodianOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_AssignedCustodian)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_AssignedCustodian.subclass:
            return POCD_MT000040_AssignedCustodian.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_AssignedCustodian(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_representedCustodianOrganization(self):
        return self.representedCustodianOrganization
    def set_representedCustodianOrganization(self, representedCustodianOrganization):
        self.representedCustodianOrganization = representedCustodianOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_RoleClassAssignedEntity(self, value):
        # Validate type RoleClassAssignedEntity, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.representedCustodianOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.AssignedCustodian', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.AssignedCustodian')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.AssignedCustodian':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.AssignedCustodian')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.AssignedCustodian', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.AssignedCustodian'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.AssignedCustodian', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.representedCustodianOrganization is not None:
            namespaceprefix_ = self.representedCustodianOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.representedCustodianOrganization_nsprefix_) else ''
            self.representedCustodianOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='representedCustodianOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClassAssignedEntity(self.classCode)    # validate type RoleClassAssignedEntity
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'representedCustodianOrganization':
            obj_ = POCD_MT000040_CustodianOrganization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.representedCustodianOrganization = obj_
            obj_.original_tagname_ = 'representedCustodianOrganization'
# end class POCD_MT000040_AssignedCustodian


class POCD_MT000040_AssignedEntity(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClassAssignedEntity' = 'ASSIGNED', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, addr: List_['AD'] = None, telecom: List_['TEL'] = None, assignedPerson: 'POCD_MT000040.Person' = None, representedOrganization: 'POCD_MT000040.Organization' = None, patient: 'SdtcPatient' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        if addr is None:
            self.addr = []
        else:
            self.addr = addr
        self.addr_nsprefix_ = None
        if telecom is None:
            self.telecom = []
        else:
            self.telecom = telecom
        self.telecom_nsprefix_ = None
        self.assignedPerson = assignedPerson
        self.assignedPerson_nsprefix_ = None
        self.representedOrganization = representedOrganization
        self.representedOrganization_nsprefix_ = None
        self.patient = patient
        self.patient_nsprefix_ = "sdtc"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_AssignedEntity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_AssignedEntity.subclass:
            return POCD_MT000040_AssignedEntity.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_AssignedEntity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_addr(self):
        return self.addr
    def set_addr(self, addr):
        self.addr = addr
    def add_addr(self, value):
        self.addr.append(value)
    def insert_addr_at(self, index, value):
        self.addr.insert(index, value)
    def replace_addr_at(self, index, value):
        self.addr[index] = value
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def add_telecom(self, value):
        self.telecom.append(value)
    def insert_telecom_at(self, index, value):
        self.telecom.insert(index, value)
    def replace_telecom_at(self, index, value):
        self.telecom[index] = value
    def get_assignedPerson(self):
        return self.assignedPerson
    def set_assignedPerson(self, assignedPerson):
        self.assignedPerson = assignedPerson
    def get_representedOrganization(self):
        return self.representedOrganization
    def set_representedOrganization(self, representedOrganization):
        self.representedOrganization = representedOrganization
    def get_patient(self):
        return self.patient
    def set_patient(self, patient):
        self.patient = patient
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_RoleClassAssignedEntity(self, value):
        # Validate type RoleClassAssignedEntity, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.addr or
            self.telecom or
            self.assignedPerson is not None or
            self.representedOrganization is not None or
            self.patient is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.AssignedEntity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.AssignedEntity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.AssignedEntity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.AssignedEntity')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.AssignedEntity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.AssignedEntity'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.AssignedEntity', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        for addr_ in self.addr:
            namespaceprefix_ = self.addr_nsprefix_ + ':' if (UseCapturedNS_ and self.addr_nsprefix_) else ''
            addr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addr', pretty_print=pretty_print)
        for telecom_ in self.telecom:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            telecom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
        if self.assignedPerson is not None:
            namespaceprefix_ = self.assignedPerson_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedPerson_nsprefix_) else ''
            self.assignedPerson.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedPerson', pretty_print=pretty_print)
        if self.representedOrganization is not None:
            namespaceprefix_ = self.representedOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.representedOrganization_nsprefix_) else ''
            self.representedOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='representedOrganization', pretty_print=pretty_print)
        if self.patient is not None:
            namespaceprefix_ = self.patient_nsprefix_ + ':' if (UseCapturedNS_ and self.patient_nsprefix_) else ''
            self.patient.export(outfile, level, namespaceprefix_='sdtc:', namespacedef_='', name_='patient', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClassAssignedEntity(self.classCode)    # validate type RoleClassAssignedEntity
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'addr':
            obj_ = AD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addr.append(obj_)
            obj_.original_tagname_ = 'addr'
        elif nodeName_ == 'telecom':
            obj_ = TEL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom.append(obj_)
            obj_.original_tagname_ = 'telecom'
        elif nodeName_ == 'assignedPerson':
            obj_ = POCD_MT000040_Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedPerson = obj_
            obj_.original_tagname_ = 'assignedPerson'
        elif nodeName_ == 'representedOrganization':
            obj_ = POCD_MT000040_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.representedOrganization = obj_
            obj_.original_tagname_ = 'representedOrganization'
        elif nodeName_ == 'patient':
            obj_ = SdtcPatient.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.patient = obj_
            obj_.original_tagname_ = 'patient'
# end class POCD_MT000040_AssignedEntity


class POCD_MT000040_AssociatedEntity(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClassAssociative' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, addr: List_['AD'] = None, telecom: List_['TEL'] = None, associatedPerson: 'POCD_MT000040.Person' = None, scopingOrganization: 'POCD_MT000040.Organization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        if addr is None:
            self.addr = []
        else:
            self.addr = addr
        self.addr_nsprefix_ = None
        if telecom is None:
            self.telecom = []
        else:
            self.telecom = telecom
        self.telecom_nsprefix_ = None
        self.associatedPerson = associatedPerson
        self.associatedPerson_nsprefix_ = None
        self.scopingOrganization = scopingOrganization
        self.scopingOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_AssociatedEntity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_AssociatedEntity.subclass:
            return POCD_MT000040_AssociatedEntity.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_AssociatedEntity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_addr(self):
        return self.addr
    def set_addr(self, addr):
        self.addr = addr
    def add_addr(self, value):
        self.addr.append(value)
    def insert_addr_at(self, index, value):
        self.addr.insert(index, value)
    def replace_addr_at(self, index, value):
        self.addr[index] = value
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def add_telecom(self, value):
        self.telecom.append(value)
    def insert_telecom_at(self, index, value):
        self.telecom.insert(index, value)
    def replace_telecom_at(self, index, value):
        self.telecom[index] = value
    def get_associatedPerson(self):
        return self.associatedPerson
    def set_associatedPerson(self, associatedPerson):
        self.associatedPerson = associatedPerson
    def get_scopingOrganization(self):
        return self.scopingOrganization
    def set_scopingOrganization(self, scopingOrganization):
        self.scopingOrganization = scopingOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_RoleClassAssociative(self, value):
        # Validate type RoleClassAssociative, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.addr or
            self.telecom or
            self.associatedPerson is not None or
            self.scopingOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.AssociatedEntity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.AssociatedEntity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.AssociatedEntity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.AssociatedEntity')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.AssociatedEntity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.AssociatedEntity'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.AssociatedEntity', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        for addr_ in self.addr:
            namespaceprefix_ = self.addr_nsprefix_ + ':' if (UseCapturedNS_ and self.addr_nsprefix_) else ''
            addr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addr', pretty_print=pretty_print)
        for telecom_ in self.telecom:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            telecom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
        if self.associatedPerson is not None:
            namespaceprefix_ = self.associatedPerson_nsprefix_ + ':' if (UseCapturedNS_ and self.associatedPerson_nsprefix_) else ''
            self.associatedPerson.export(outfile, level, namespaceprefix_, namespacedef_='', name_='associatedPerson', pretty_print=pretty_print)
        if self.scopingOrganization is not None:
            namespaceprefix_ = self.scopingOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.scopingOrganization_nsprefix_) else ''
            self.scopingOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='scopingOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClassAssociative(self.classCode)    # validate type RoleClassAssociative
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'addr':
            obj_ = AD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addr.append(obj_)
            obj_.original_tagname_ = 'addr'
        elif nodeName_ == 'telecom':
            obj_ = TEL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom.append(obj_)
            obj_.original_tagname_ = 'telecom'
        elif nodeName_ == 'associatedPerson':
            obj_ = POCD_MT000040_Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.associatedPerson = obj_
            obj_.original_tagname_ = 'associatedPerson'
        elif nodeName_ == 'scopingOrganization':
            obj_ = POCD_MT000040_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.scopingOrganization = obj_
            obj_.original_tagname_ = 'scopingOrganization'
# end class POCD_MT000040_AssociatedEntity


class POCD_MT000040_Authenticator(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'AUTHEN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, time: 'TS' = None, signatureCode: 'CS' = None, signatureText: 'ED' = None, assignedEntity: 'POCD_MT000040.AssignedEntity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.time = time
        self.time_nsprefix_ = None
        self.signatureCode = signatureCode
        self.signatureCode_nsprefix_ = None
        self.signatureText = signatureText
        self.signatureText_nsprefix_ = "sdtc"
        self.assignedEntity = assignedEntity
        self.assignedEntity_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Authenticator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Authenticator.subclass:
            return POCD_MT000040_Authenticator.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Authenticator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_signatureCode(self):
        return self.signatureCode
    def set_signatureCode(self, signatureCode):
        self.signatureCode = signatureCode
    def get_signatureText(self):
        return self.signatureText
    def set_signatureText(self, signatureText):
        self.signatureText = signatureText
    def get_assignedEntity(self):
        return self.assignedEntity
    def set_assignedEntity(self, assignedEntity):
        self.assignedEntity = assignedEntity
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.time is not None or
            self.signatureCode is not None or
            self.signatureText is not None or
            self.assignedEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.Authenticator', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Authenticator')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Authenticator':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Authenticator')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Authenticator', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Authenticator'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.Authenticator', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            self.time.export(outfile, level, namespaceprefix_, namespacedef_='', name_='time', pretty_print=pretty_print)
        if self.signatureCode is not None:
            namespaceprefix_ = self.signatureCode_nsprefix_ + ':' if (UseCapturedNS_ and self.signatureCode_nsprefix_) else ''
            self.signatureCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='signatureCode', pretty_print=pretty_print)
        if self.signatureText is not None:
            namespaceprefix_ = self.signatureText_nsprefix_ + ':' if (UseCapturedNS_ and self.signatureText_nsprefix_) else ''
            self.signatureText.export(outfile, level, namespaceprefix_='sdtc:', namespacedef_='', name_='signatureText', pretty_print=pretty_print)
        if self.assignedEntity is not None:
            namespaceprefix_ = self.assignedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedEntity_nsprefix_) else ''
            self.assignedEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedEntity', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'time':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'signatureCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.signatureCode = obj_
            obj_.original_tagname_ = 'signatureCode'
        elif nodeName_ == 'signatureText':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.signatureText = obj_
            obj_.original_tagname_ = 'signatureText'
        elif nodeName_ == 'assignedEntity':
            obj_ = POCD_MT000040_AssignedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedEntity = obj_
            obj_.original_tagname_ = 'assignedEntity'
# end class POCD_MT000040_Authenticator


class POCD_MT000040_Author(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'AUT', contextControlCode: 'ContextControl' = 'OP', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, functionCode: 'CE' = None, time: 'TS' = None, assignedAuthor: 'POCD_MT000040.AssignedAuthor' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextControlCode = _cast(None, contextControlCode)
        self.contextControlCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.functionCode = functionCode
        self.functionCode_nsprefix_ = None
        self.time = time
        self.time_nsprefix_ = None
        self.assignedAuthor = assignedAuthor
        self.assignedAuthor_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Author)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Author.subclass:
            return POCD_MT000040_Author.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Author(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_functionCode(self):
        return self.functionCode
    def set_functionCode(self, functionCode):
        self.functionCode = functionCode
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_assignedAuthor(self):
        return self.assignedAuthor
    def set_assignedAuthor(self, assignedAuthor):
        self.assignedAuthor = assignedAuthor
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def get_contextControlCode(self):
        return self.contextControlCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        pass
    def validate_ContextControl(self, value):
        # Validate type ContextControl, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.functionCode is not None or
            self.time is not None or
            self.assignedAuthor is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Author', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Author')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Author':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Author')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Author', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Author'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextControlCode is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            outfile.write(' contextControlCode=%s' % (quote_attrib(self.contextControlCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Author', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.functionCode is not None:
            namespaceprefix_ = self.functionCode_nsprefix_ + ':' if (UseCapturedNS_ and self.functionCode_nsprefix_) else ''
            self.functionCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='functionCode', pretty_print=pretty_print)
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            self.time.export(outfile, level, namespaceprefix_, namespacedef_='', name_='time', pretty_print=pretty_print)
        if self.assignedAuthor is not None:
            namespaceprefix_ = self.assignedAuthor_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedAuthor_nsprefix_) else ''
            self.assignedAuthor.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedAuthor', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
        value = find_attr_value_('contextControlCode', node)
        if value is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            self.contextControlCode = value
            self.validate_ContextControl(self.contextControlCode)    # validate type ContextControl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'functionCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.functionCode = obj_
            obj_.original_tagname_ = 'functionCode'
        elif nodeName_ == 'time':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'assignedAuthor':
            obj_ = POCD_MT000040_AssignedAuthor.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedAuthor = obj_
            obj_.original_tagname_ = 'assignedAuthor'
# end class POCD_MT000040_Author


class POCD_MT000040_AuthoringDevice(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'EntityClassDevice' = 'DEV', determinerCode: 'EntityDeterminer' = 'INSTANCE', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, code: 'CE' = None, manufacturerModelName: 'SC' = None, softwareName: 'SC' = None, asMaintainedEntity: List_['POCD_MT000040.MaintainedEntity'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.determinerCode = _cast(None, determinerCode)
        self.determinerCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.manufacturerModelName = manufacturerModelName
        self.manufacturerModelName_nsprefix_ = None
        self.softwareName = softwareName
        self.softwareName_nsprefix_ = None
        if asMaintainedEntity is None:
            self.asMaintainedEntity = []
        else:
            self.asMaintainedEntity = asMaintainedEntity
        self.asMaintainedEntity_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_AuthoringDevice)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_AuthoringDevice.subclass:
            return POCD_MT000040_AuthoringDevice.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_AuthoringDevice(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_manufacturerModelName(self):
        return self.manufacturerModelName
    def set_manufacturerModelName(self, manufacturerModelName):
        self.manufacturerModelName = manufacturerModelName
    def get_softwareName(self):
        return self.softwareName
    def set_softwareName(self, softwareName):
        self.softwareName = softwareName
    def get_asMaintainedEntity(self):
        return self.asMaintainedEntity
    def set_asMaintainedEntity(self, asMaintainedEntity):
        self.asMaintainedEntity = asMaintainedEntity
    def add_asMaintainedEntity(self, value):
        self.asMaintainedEntity.append(value)
    def insert_asMaintainedEntity_at(self, index, value):
        self.asMaintainedEntity.insert(index, value)
    def replace_asMaintainedEntity_at(self, index, value):
        self.asMaintainedEntity[index] = value
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def get_determinerCode(self):
        return self.determinerCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_EntityClassDevice(self, value):
        # Validate type EntityClassDevice, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['DEV', 'CER', 'MODDV']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityClassDevice' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityClassDevice_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityClassDevice_patterns_, ))
    validate_EntityClassDevice_patterns_ = [['^([^\\s]+)$']]
    def validate_EntityDeterminer(self, value):
        # Validate type EntityDeterminer, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.code is not None or
            self.manufacturerModelName is not None or
            self.softwareName is not None or
            self.asMaintainedEntity
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.AuthoringDevice', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.AuthoringDevice')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.AuthoringDevice':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.AuthoringDevice')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.AuthoringDevice', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.AuthoringDevice'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.determinerCode is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            outfile.write(' determinerCode=%s' % (quote_attrib(self.determinerCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.AuthoringDevice', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.manufacturerModelName is not None:
            namespaceprefix_ = self.manufacturerModelName_nsprefix_ + ':' if (UseCapturedNS_ and self.manufacturerModelName_nsprefix_) else ''
            self.manufacturerModelName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='manufacturerModelName', pretty_print=pretty_print)
        if self.softwareName is not None:
            namespaceprefix_ = self.softwareName_nsprefix_ + ':' if (UseCapturedNS_ and self.softwareName_nsprefix_) else ''
            self.softwareName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='softwareName', pretty_print=pretty_print)
        for asMaintainedEntity_ in self.asMaintainedEntity:
            namespaceprefix_ = self.asMaintainedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.asMaintainedEntity_nsprefix_) else ''
            asMaintainedEntity_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='asMaintainedEntity', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_EntityClassDevice(self.classCode)    # validate type EntityClassDevice
        value = find_attr_value_('determinerCode', node)
        if value is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            self.determinerCode = value
            self.determinerCode = ' '.join(self.determinerCode.split())
            self.validate_EntityDeterminer(self.determinerCode)    # validate type EntityDeterminer
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'manufacturerModelName':
            obj_ = SC.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.manufacturerModelName = obj_
            obj_.original_tagname_ = 'manufacturerModelName'
        elif nodeName_ == 'softwareName':
            obj_ = SC.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.softwareName = obj_
            obj_.original_tagname_ = 'softwareName'
        elif nodeName_ == 'asMaintainedEntity':
            obj_ = POCD_MT000040_MaintainedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.asMaintainedEntity.append(obj_)
            obj_.original_tagname_ = 'asMaintainedEntity'
# end class POCD_MT000040_AuthoringDevice


class POCD_MT000040_Authorization(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipType' = 'AUTH', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, consent: 'POCD_MT000040.Consent' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.consent = consent
        self.consent_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Authorization)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Authorization.subclass:
            return POCD_MT000040_Authorization.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Authorization(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_consent(self):
        return self.consent
    def set_consent(self, consent):
        self.consent = consent
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActRelationshipType(self, value):
        # Validate type ActRelationshipType, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.consent is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Authorization', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Authorization')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Authorization':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Authorization')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Authorization', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Authorization'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Authorization', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.consent is not None:
            namespaceprefix_ = self.consent_nsprefix_ + ':' if (UseCapturedNS_ and self.consent_nsprefix_) else ''
            self.consent.export(outfile, level, namespaceprefix_, namespacedef_='', name_='consent', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ActRelationshipType(self.typeCode)    # validate type ActRelationshipType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'consent':
            obj_ = POCD_MT000040_Consent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.consent = obj_
            obj_.original_tagname_ = 'consent'
# end class POCD_MT000040_Authorization


class POCD_MT000040_Birthplace(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClass' = 'BIRTHPL', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, place: 'POCD_MT000040.Place' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.place = place
        self.place_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Birthplace)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Birthplace.subclass:
            return POCD_MT000040_Birthplace.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Birthplace(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_place(self):
        return self.place
    def set_place(self, place):
        self.place = place
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_RoleClass(self, value):
        # Validate type RoleClass, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.place is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Birthplace', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Birthplace')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Birthplace':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Birthplace')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Birthplace', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Birthplace'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Birthplace', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.place is not None:
            namespaceprefix_ = self.place_nsprefix_ + ':' if (UseCapturedNS_ and self.place_nsprefix_) else ''
            self.place.export(outfile, level, namespaceprefix_, namespacedef_='', name_='place', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_RoleClass(self.classCode)    # validate type RoleClass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'place':
            obj_ = POCD_MT000040_Place.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.place = obj_
            obj_.original_tagname_ = 'place'
# end class POCD_MT000040_Birthplace


class POCD_MT000040_ClinicalDocument(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ID: 'xs_string' = None, nullFlavor: 'NullFlavor' = None, classCode: 'ActClinicalDocument' = 'DOCCLIN', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: 'II' = None, code: 'CE' = None, title: 'ST' = None, statusCode: 'CS' = None, terminologyDate: 'TS' = None, formatCode: 'CD' = None, practiceSettingCode: 'CD' = None, effectiveTime: 'TS' = None, confidentialityCode: 'CE' = None, languageCode: 'CS' = None, setId: 'II' = None, versionNumber: 'INT' = None, copyTime: 'TS' = None, recordTarget: List_['POCD_MT000040.RecordTarget'] = None, author: List_['POCD_MT000040.Author'] = None, dataEnterer: 'POCD_MT000040.DataEnterer' = None, informant: List_['POCD_MT000040.Informant12'] = None, custodian: 'POCD_MT000040.Custodian' = None, informationRecipient: List_['POCD_MT000040.InformationRecipient'] = None, legalAuthenticator: List_['POCD_MT000040.LegalAuthenticator'] = None, authenticator: List_['POCD_MT000040.Authenticator'] = None, participant: List_['POCD_MT000040.Participant1'] = None, inFulfillmentOf: List_['POCD_MT000040.InFulfillmentOf'] = None, documentationOf: List_['POCD_MT000040.DocumentationOf'] = None, relatedDocument: List_['POCD_MT000040.RelatedDocument'] = None, authorization: List_['POCD_MT000040.Authorization'] = None, componentOf: 'POCD_MT000040.Component1' = None, component: 'POCD_MT000040.Component2' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ID = _cast(None, ID)
        self.ID_nsprefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        self.statusCode = statusCode
        self.statusCode_nsprefix_ = "sdtc"
        self.terminologyDate = terminologyDate
        self.terminologyDate_nsprefix_ = "hl7at"
        self.formatCode = formatCode
        self.formatCode_nsprefix_ = "hl7at"
        self.practiceSettingCode = practiceSettingCode
        self.practiceSettingCode_nsprefix_ = "hl7at"
        self.effectiveTime = effectiveTime
        self.effectiveTime_nsprefix_ = None
        self.confidentialityCode = confidentialityCode
        self.confidentialityCode_nsprefix_ = None
        self.languageCode = languageCode
        self.languageCode_nsprefix_ = None
        self.setId = setId
        self.setId_nsprefix_ = None
        self.versionNumber = versionNumber
        self.versionNumber_nsprefix_ = None
        self.copyTime = copyTime
        self.copyTime_nsprefix_ = None
        if recordTarget is None:
            self.recordTarget = []
        else:
            self.recordTarget = recordTarget
        self.recordTarget_nsprefix_ = None
        if author is None:
            self.author = []
        else:
            self.author = author
        self.author_nsprefix_ = None
        self.dataEnterer = dataEnterer
        self.dataEnterer_nsprefix_ = None
        if informant is None:
            self.informant = []
        else:
            self.informant = informant
        self.informant_nsprefix_ = None
        self.custodian = custodian
        self.custodian_nsprefix_ = None
        if informationRecipient is None:
            self.informationRecipient = []
        else:
            self.informationRecipient = informationRecipient
        self.informationRecipient_nsprefix_ = None
        if legalAuthenticator is None:
            self.legalAuthenticator = []
        else:
            self.legalAuthenticator = legalAuthenticator
        self.legalAuthenticator_nsprefix_ = None
        if authenticator is None:
            self.authenticator = []
        else:
            self.authenticator = authenticator
        self.authenticator_nsprefix_ = None
        if participant is None:
            self.participant = []
        else:
            self.participant = participant
        self.participant_nsprefix_ = None
        if inFulfillmentOf is None:
            self.inFulfillmentOf = []
        else:
            self.inFulfillmentOf = inFulfillmentOf
        self.inFulfillmentOf_nsprefix_ = None
        if documentationOf is None:
            self.documentationOf = []
        else:
            self.documentationOf = documentationOf
        self.documentationOf_nsprefix_ = None
        if relatedDocument is None:
            self.relatedDocument = []
        else:
            self.relatedDocument = relatedDocument
        self.relatedDocument_nsprefix_ = None
        if authorization is None:
            self.authorization = []
        else:
            self.authorization = authorization
        self.authorization_nsprefix_ = None
        self.componentOf = componentOf
        self.componentOf_nsprefix_ = None
        self.component = component
        self.component_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_ClinicalDocument)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_ClinicalDocument.subclass:
            return POCD_MT000040_ClinicalDocument.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_ClinicalDocument(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_statusCode(self):
        return self.statusCode
    def set_statusCode(self, statusCode):
        self.statusCode = statusCode
    def get_terminologyDate(self):
        return self.terminologyDate
    def set_terminologyDate(self, terminologyDate):
        self.terminologyDate = terminologyDate
    def get_formatCode(self):
        return self.formatCode
    def set_formatCode(self, formatCode):
        self.formatCode = formatCode
    def get_practiceSettingCode(self):
        return self.practiceSettingCode
    def set_practiceSettingCode(self, practiceSettingCode):
        self.practiceSettingCode = practiceSettingCode
    def get_effectiveTime(self):
        return self.effectiveTime
    def set_effectiveTime(self, effectiveTime):
        self.effectiveTime = effectiveTime
    def get_confidentialityCode(self):
        return self.confidentialityCode
    def set_confidentialityCode(self, confidentialityCode):
        self.confidentialityCode = confidentialityCode
    def get_languageCode(self):
        return self.languageCode
    def set_languageCode(self, languageCode):
        self.languageCode = languageCode
    def get_setId(self):
        return self.setId
    def set_setId(self, setId):
        self.setId = setId
    def get_versionNumber(self):
        return self.versionNumber
    def set_versionNumber(self, versionNumber):
        self.versionNumber = versionNumber
    def get_copyTime(self):
        return self.copyTime
    def set_copyTime(self, copyTime):
        self.copyTime = copyTime
    def get_recordTarget(self):
        return self.recordTarget
    def set_recordTarget(self, recordTarget):
        self.recordTarget = recordTarget
    def add_recordTarget(self, value):
        self.recordTarget.append(value)
    def insert_recordTarget_at(self, index, value):
        self.recordTarget.insert(index, value)
    def replace_recordTarget_at(self, index, value):
        self.recordTarget[index] = value
    def get_author(self):
        return self.author
    def set_author(self, author):
        self.author = author
    def add_author(self, value):
        self.author.append(value)
    def insert_author_at(self, index, value):
        self.author.insert(index, value)
    def replace_author_at(self, index, value):
        self.author[index] = value
    def get_dataEnterer(self):
        return self.dataEnterer
    def set_dataEnterer(self, dataEnterer):
        self.dataEnterer = dataEnterer
    def get_informant(self):
        return self.informant
    def set_informant(self, informant):
        self.informant = informant
    def add_informant(self, value):
        self.informant.append(value)
    def insert_informant_at(self, index, value):
        self.informant.insert(index, value)
    def replace_informant_at(self, index, value):
        self.informant[index] = value
    def get_custodian(self):
        return self.custodian
    def set_custodian(self, custodian):
        self.custodian = custodian
    def get_informationRecipient(self):
        return self.informationRecipient
    def set_informationRecipient(self, informationRecipient):
        self.informationRecipient = informationRecipient
    def add_informationRecipient(self, value):
        self.informationRecipient.append(value)
    def insert_informationRecipient_at(self, index, value):
        self.informationRecipient.insert(index, value)
    def replace_informationRecipient_at(self, index, value):
        self.informationRecipient[index] = value
    def get_legalAuthenticator(self):
        return self.legalAuthenticator
    def set_legalAuthenticator(self, legalAuthenticator):
        self.legalAuthenticator = legalAuthenticator
    def add_legalAuthenticator(self, value):
        self.legalAuthenticator.append(value)
    def insert_legalAuthenticator_at(self, index, value):
        self.legalAuthenticator.insert(index, value)
    def replace_legalAuthenticator_at(self, index, value):
        self.legalAuthenticator[index] = value
    def get_authenticator(self):
        return self.authenticator
    def set_authenticator(self, authenticator):
        self.authenticator = authenticator
    def add_authenticator(self, value):
        self.authenticator.append(value)
    def insert_authenticator_at(self, index, value):
        self.authenticator.insert(index, value)
    def replace_authenticator_at(self, index, value):
        self.authenticator[index] = value
    def get_participant(self):
        return self.participant
    def set_participant(self, participant):
        self.participant = participant
    def add_participant(self, value):
        self.participant.append(value)
    def insert_participant_at(self, index, value):
        self.participant.insert(index, value)
    def replace_participant_at(self, index, value):
        self.participant[index] = value
    def get_inFulfillmentOf(self):
        return self.inFulfillmentOf
    def set_inFulfillmentOf(self, inFulfillmentOf):
        self.inFulfillmentOf = inFulfillmentOf
    def add_inFulfillmentOf(self, value):
        self.inFulfillmentOf.append(value)
    def insert_inFulfillmentOf_at(self, index, value):
        self.inFulfillmentOf.insert(index, value)
    def replace_inFulfillmentOf_at(self, index, value):
        self.inFulfillmentOf[index] = value
    def get_documentationOf(self):
        return self.documentationOf
    def set_documentationOf(self, documentationOf):
        self.documentationOf = documentationOf
    def add_documentationOf(self, value):
        self.documentationOf.append(value)
    def insert_documentationOf_at(self, index, value):
        self.documentationOf.insert(index, value)
    def replace_documentationOf_at(self, index, value):
        self.documentationOf[index] = value
    def get_relatedDocument(self):
        return self.relatedDocument
    def set_relatedDocument(self, relatedDocument):
        self.relatedDocument = relatedDocument
    def add_relatedDocument(self, value):
        self.relatedDocument.append(value)
    def insert_relatedDocument_at(self, index, value):
        self.relatedDocument.insert(index, value)
    def replace_relatedDocument_at(self, index, value):
        self.relatedDocument[index] = value
    def get_authorization(self):
        return self.authorization
    def set_authorization(self, authorization):
        self.authorization = authorization
    def add_authorization(self, value):
        self.authorization.append(value)
    def insert_authorization_at(self, index, value):
        self.authorization.insert(index, value)
    def replace_authorization_at(self, index, value):
        self.authorization[index] = value
    def get_componentOf(self):
        return self.componentOf
    def set_componentOf(self, componentOf):
        self.componentOf = componentOf
    def get_component(self):
        return self.component
    def set_component(self, component):
        self.component = component
    def get_ID(self):
        return self.ID
    def set_ID(self, ID):
        self.ID = ID
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def get_moodCode(self):
        return self.moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClinicalDocument(self, value):
        # Validate type ActClinicalDocument, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['DOCCLIN', 'CDALVLONE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActClinicalDocument' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClinicalDocument_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActClinicalDocument_patterns_, ))
    validate_ActClinicalDocument_patterns_ = [['^([^\\s]+)$']]
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id is not None or
            self.code is not None or
            self.title is not None or
            self.statusCode is not None or
            self.terminologyDate is not None or
            self.formatCode is not None or
            self.practiceSettingCode is not None or
            self.effectiveTime is not None or
            self.confidentialityCode is not None or
            self.languageCode is not None or
            self.setId is not None or
            self.versionNumber is not None or
            self.copyTime is not None or
            self.recordTarget or
            self.author or
            self.dataEnterer is not None or
            self.informant or
            self.custodian is not None or
            self.informationRecipient or
            self.legalAuthenticator or
            self.authenticator or
            self.participant or
            self.inFulfillmentOf or
            self.documentationOf or
            self.relatedDocument or
            self.authorization or
            self.componentOf is not None or
            self.component is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc"  xmlns:hl7at="urn:hl7-at:v3" ', name_='POCD_MT000040.ClinicalDocument', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.ClinicalDocument')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.ClinicalDocument':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.ClinicalDocument')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.ClinicalDocument', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.ClinicalDocument'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc"  xmlns:hl7at="urn:hl7-at:v3" ', name_='POCD_MT000040.ClinicalDocument', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            self.id.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            self.title.export(outfile, level, namespaceprefix_, namespacedef_='', name_='title', pretty_print=pretty_print)
        if self.statusCode is not None:
            namespaceprefix_ = self.statusCode_nsprefix_ + ':' if (UseCapturedNS_ and self.statusCode_nsprefix_) else ''
            self.statusCode.export(outfile, level, namespaceprefix_='sdtc:', namespacedef_='', name_='statusCode', pretty_print=pretty_print)
        if self.terminologyDate is not None:
            namespaceprefix_ = self.terminologyDate_nsprefix_ + ':' if (UseCapturedNS_ and self.terminologyDate_nsprefix_) else ''
            self.terminologyDate.export(outfile, level, namespaceprefix_='hl7at:', namespacedef_='', name_='terminologyDate', pretty_print=pretty_print)
        if self.formatCode is not None:
            namespaceprefix_ = self.formatCode_nsprefix_ + ':' if (UseCapturedNS_ and self.formatCode_nsprefix_) else ''
            self.formatCode.export(outfile, level, namespaceprefix_='hl7at:', namespacedef_='', name_='formatCode', pretty_print=pretty_print)
        if self.practiceSettingCode is not None:
            namespaceprefix_ = self.practiceSettingCode_nsprefix_ + ':' if (UseCapturedNS_ and self.practiceSettingCode_nsprefix_) else ''
            self.practiceSettingCode.export(outfile, level, namespaceprefix_='hl7at:', namespacedef_='', name_='practiceSettingCode', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            namespaceprefix_ = self.effectiveTime_nsprefix_ + ':' if (UseCapturedNS_ and self.effectiveTime_nsprefix_) else ''
            self.effectiveTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='effectiveTime', pretty_print=pretty_print)
        if self.confidentialityCode is not None:
            namespaceprefix_ = self.confidentialityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.confidentialityCode_nsprefix_) else ''
            self.confidentialityCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='confidentialityCode', pretty_print=pretty_print)
        if self.languageCode is not None:
            namespaceprefix_ = self.languageCode_nsprefix_ + ':' if (UseCapturedNS_ and self.languageCode_nsprefix_) else ''
            self.languageCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='languageCode', pretty_print=pretty_print)
        if self.setId is not None:
            namespaceprefix_ = self.setId_nsprefix_ + ':' if (UseCapturedNS_ and self.setId_nsprefix_) else ''
            self.setId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='setId', pretty_print=pretty_print)
        if self.versionNumber is not None:
            namespaceprefix_ = self.versionNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.versionNumber_nsprefix_) else ''
            self.versionNumber.export(outfile, level, namespaceprefix_, namespacedef_='', name_='versionNumber', pretty_print=pretty_print)
        if self.copyTime is not None:
            namespaceprefix_ = self.copyTime_nsprefix_ + ':' if (UseCapturedNS_ and self.copyTime_nsprefix_) else ''
            self.copyTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='copyTime', pretty_print=pretty_print)
        for recordTarget_ in self.recordTarget:
            namespaceprefix_ = self.recordTarget_nsprefix_ + ':' if (UseCapturedNS_ and self.recordTarget_nsprefix_) else ''
            recordTarget_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='recordTarget', pretty_print=pretty_print)
        for author_ in self.author:
            namespaceprefix_ = self.author_nsprefix_ + ':' if (UseCapturedNS_ and self.author_nsprefix_) else ''
            author_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='author', pretty_print=pretty_print)
        if self.dataEnterer is not None:
            namespaceprefix_ = self.dataEnterer_nsprefix_ + ':' if (UseCapturedNS_ and self.dataEnterer_nsprefix_) else ''
            self.dataEnterer.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dataEnterer', pretty_print=pretty_print)
        for informant_ in self.informant:
            namespaceprefix_ = self.informant_nsprefix_ + ':' if (UseCapturedNS_ and self.informant_nsprefix_) else ''
            informant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='informant', pretty_print=pretty_print)
        if self.custodian is not None:
            namespaceprefix_ = self.custodian_nsprefix_ + ':' if (UseCapturedNS_ and self.custodian_nsprefix_) else ''
            self.custodian.export(outfile, level, namespaceprefix_, namespacedef_='', name_='custodian', pretty_print=pretty_print)
        for informationRecipient_ in self.informationRecipient:
            namespaceprefix_ = self.informationRecipient_nsprefix_ + ':' if (UseCapturedNS_ and self.informationRecipient_nsprefix_) else ''
            informationRecipient_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='informationRecipient', pretty_print=pretty_print)
        for legalAuthenticator_ in self.legalAuthenticator:
            namespaceprefix_ = self.legalAuthenticator_nsprefix_ + ':' if (UseCapturedNS_ and self.legalAuthenticator_nsprefix_) else ''
            legalAuthenticator_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='legalAuthenticator', pretty_print=pretty_print)
        for authenticator_ in self.authenticator:
            namespaceprefix_ = self.authenticator_nsprefix_ + ':' if (UseCapturedNS_ and self.authenticator_nsprefix_) else ''
            authenticator_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='authenticator', pretty_print=pretty_print)
        for participant_ in self.participant:
            namespaceprefix_ = self.participant_nsprefix_ + ':' if (UseCapturedNS_ and self.participant_nsprefix_) else ''
            participant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='participant', pretty_print=pretty_print)
        for inFulfillmentOf_ in self.inFulfillmentOf:
            namespaceprefix_ = self.inFulfillmentOf_nsprefix_ + ':' if (UseCapturedNS_ and self.inFulfillmentOf_nsprefix_) else ''
            inFulfillmentOf_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='inFulfillmentOf', pretty_print=pretty_print)
        for documentationOf_ in self.documentationOf:
            namespaceprefix_ = self.documentationOf_nsprefix_ + ':' if (UseCapturedNS_ and self.documentationOf_nsprefix_) else ''
            documentationOf_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='documentationOf', pretty_print=pretty_print)
        for relatedDocument_ in self.relatedDocument:
            namespaceprefix_ = self.relatedDocument_nsprefix_ + ':' if (UseCapturedNS_ and self.relatedDocument_nsprefix_) else ''
            relatedDocument_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='relatedDocument', pretty_print=pretty_print)
        for authorization_ in self.authorization:
            namespaceprefix_ = self.authorization_nsprefix_ + ':' if (UseCapturedNS_ and self.authorization_nsprefix_) else ''
            authorization_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='authorization', pretty_print=pretty_print)
        if self.componentOf is not None:
            namespaceprefix_ = self.componentOf_nsprefix_ + ':' if (UseCapturedNS_ and self.componentOf_nsprefix_) else ''
            self.componentOf.export(outfile, level, namespaceprefix_, namespacedef_='', name_='componentOf', pretty_print=pretty_print)
        if self.component is not None:
            namespaceprefix_ = self.component_nsprefix_ + ':' if (UseCapturedNS_ and self.component_nsprefix_) else ''
            self.component.export(outfile, level, namespaceprefix_, namespacedef_='', name_='component', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClinicalDocument(self.classCode)    # validate type ActClinicalDocument
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id = obj_
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'title':
            class_obj_ = self.get_class_obj_(child_, ST)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.title = obj_
            obj_.original_tagname_ = 'title'
        elif nodeName_ == 'statusCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.statusCode = obj_
            obj_.original_tagname_ = 'statusCode'
        elif nodeName_ == 'terminologyDate':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.terminologyDate = obj_
            obj_.original_tagname_ = 'terminologyDate'
        elif nodeName_ == 'formatCode':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.formatCode = obj_
            obj_.original_tagname_ = 'formatCode'
        elif nodeName_ == 'practiceSettingCode':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.practiceSettingCode = obj_
            obj_.original_tagname_ = 'practiceSettingCode'
        elif nodeName_ == 'effectiveTime':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'confidentialityCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.confidentialityCode = obj_
            obj_.original_tagname_ = 'confidentialityCode'
        elif nodeName_ == 'languageCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.languageCode = obj_
            obj_.original_tagname_ = 'languageCode'
        elif nodeName_ == 'setId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.setId = obj_
            obj_.original_tagname_ = 'setId'
        elif nodeName_ == 'versionNumber':
            class_obj_ = self.get_class_obj_(child_, INT)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.versionNumber = obj_
            obj_.original_tagname_ = 'versionNumber'
        elif nodeName_ == 'copyTime':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.copyTime = obj_
            obj_.original_tagname_ = 'copyTime'
        elif nodeName_ == 'recordTarget':
            obj_ = POCD_MT000040_RecordTarget.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.recordTarget.append(obj_)
            obj_.original_tagname_ = 'recordTarget'
        elif nodeName_ == 'author':
            obj_ = POCD_MT000040_Author.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'dataEnterer':
            obj_ = POCD_MT000040_DataEnterer.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dataEnterer = obj_
            obj_.original_tagname_ = 'dataEnterer'
        elif nodeName_ == 'informant':
            obj_ = POCD_MT000040_Informant12.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.informant.append(obj_)
            obj_.original_tagname_ = 'informant'
        elif nodeName_ == 'custodian':
            obj_ = POCD_MT000040_Custodian.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.custodian = obj_
            obj_.original_tagname_ = 'custodian'
        elif nodeName_ == 'informationRecipient':
            obj_ = POCD_MT000040_InformationRecipient.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.informationRecipient.append(obj_)
            obj_.original_tagname_ = 'informationRecipient'
        elif nodeName_ == 'legalAuthenticator':
            obj_ = POCD_MT000040_LegalAuthenticator.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.legalAuthenticator.append(obj_)
            obj_.original_tagname_ = 'legalAuthenticator'
        elif nodeName_ == 'authenticator':
            obj_ = POCD_MT000040_Authenticator.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authenticator.append(obj_)
            obj_.original_tagname_ = 'authenticator'
        elif nodeName_ == 'participant':
            obj_ = POCD_MT000040_Participant1.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.participant.append(obj_)
            obj_.original_tagname_ = 'participant'
        elif nodeName_ == 'inFulfillmentOf':
            obj_ = POCD_MT000040_InFulfillmentOf.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.inFulfillmentOf.append(obj_)
            obj_.original_tagname_ = 'inFulfillmentOf'
        elif nodeName_ == 'documentationOf':
            obj_ = POCD_MT000040_DocumentationOf.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.documentationOf.append(obj_)
            obj_.original_tagname_ = 'documentationOf'
        elif nodeName_ == 'relatedDocument':
            obj_ = POCD_MT000040_RelatedDocument.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.relatedDocument.append(obj_)
            obj_.original_tagname_ = 'relatedDocument'
        elif nodeName_ == 'authorization':
            obj_ = POCD_MT000040_Authorization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authorization.append(obj_)
            obj_.original_tagname_ = 'authorization'
        elif nodeName_ == 'componentOf':
            obj_ = POCD_MT000040_Component1.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.componentOf = obj_
            obj_.original_tagname_ = 'componentOf'
        elif nodeName_ == 'component':
            obj_ = POCD_MT000040_Component2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.component = obj_
            obj_.original_tagname_ = 'component'
# end class POCD_MT000040_ClinicalDocument


class POCD_MT000040_Component1(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipHasComponent' = 'COMP', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, encompassingEncounter: 'POCD_MT000040.EncompassingEncounter' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.encompassingEncounter = encompassingEncounter
        self.encompassingEncounter_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Component1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Component1.subclass:
            return POCD_MT000040_Component1.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Component1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_encompassingEncounter(self):
        return self.encompassingEncounter
    def set_encompassingEncounter(self, encompassingEncounter):
        self.encompassingEncounter = encompassingEncounter
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActRelationshipHasComponent(self, value):
        # Validate type ActRelationshipHasComponent, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['COMP', 'ARR', 'CTRLV', 'DEP']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipHasComponent' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipHasComponent_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipHasComponent_patterns_, ))
    validate_ActRelationshipHasComponent_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.encompassingEncounter is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Component1', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Component1')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Component1':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Component1')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Component1', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Component1'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Component1', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.encompassingEncounter is not None:
            namespaceprefix_ = self.encompassingEncounter_nsprefix_ + ':' if (UseCapturedNS_ and self.encompassingEncounter_nsprefix_) else ''
            self.encompassingEncounter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='encompassingEncounter', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipHasComponent(self.typeCode)    # validate type ActRelationshipHasComponent
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'encompassingEncounter':
            obj_ = POCD_MT000040_EncompassingEncounter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.encompassingEncounter = obj_
            obj_.original_tagname_ = 'encompassingEncounter'
# end class POCD_MT000040_Component1


class POCD_MT000040_Component2(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipHasComponent' = 'COMP', contextConductionInd: 'bl' = 'true', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, nonXMLBody: 'POCD_MT000040.NonXMLBody' = None, structuredBody: 'POCD_MT000040.StructuredBody' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextConductionInd = _cast(bool, contextConductionInd)
        self.contextConductionInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.nonXMLBody = nonXMLBody
        self.nonXMLBody_nsprefix_ = None
        self.structuredBody = structuredBody
        self.structuredBody_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Component2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Component2.subclass:
            return POCD_MT000040_Component2.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Component2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_nonXMLBody(self):
        return self.nonXMLBody
    def set_nonXMLBody(self, nonXMLBody):
        self.nonXMLBody = nonXMLBody
    def get_structuredBody(self):
        return self.structuredBody
    def set_structuredBody(self, structuredBody):
        self.structuredBody = structuredBody
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def get_contextConductionInd(self):
        return self.contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActRelationshipHasComponent(self, value):
        # Validate type ActRelationshipHasComponent, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['COMP', 'ARR', 'CTRLV', 'DEP']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipHasComponent' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipHasComponent_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipHasComponent_patterns_, ))
    validate_ActRelationshipHasComponent_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.nonXMLBody is not None or
            self.structuredBody is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Component2', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Component2')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Component2':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Component2')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Component2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Component2'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextConductionInd is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd="%s"' % self.gds_format_boolean(self.contextConductionInd, input_name='contextConductionInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Component2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.nonXMLBody is not None:
            namespaceprefix_ = self.nonXMLBody_nsprefix_ + ':' if (UseCapturedNS_ and self.nonXMLBody_nsprefix_) else ''
            self.nonXMLBody.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nonXMLBody', pretty_print=pretty_print)
        if self.structuredBody is not None:
            namespaceprefix_ = self.structuredBody_nsprefix_ + ':' if (UseCapturedNS_ and self.structuredBody_nsprefix_) else ''
            self.structuredBody.export(outfile, level, namespaceprefix_, namespacedef_='', name_='structuredBody', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipHasComponent(self.typeCode)    # validate type ActRelationshipHasComponent
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'nonXMLBody':
            obj_ = POCD_MT000040_NonXMLBody.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.nonXMLBody = obj_
            obj_.original_tagname_ = 'nonXMLBody'
        elif nodeName_ == 'structuredBody':
            obj_ = POCD_MT000040_StructuredBody.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.structuredBody = obj_
            obj_.original_tagname_ = 'structuredBody'
# end class POCD_MT000040_Component2


class POCD_MT000040_Component3(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipHasComponent' = 'COMP', contextConductionInd: 'bl' = 'true', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, section: 'POCD_MT000040.Section' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextConductionInd = _cast(bool, contextConductionInd)
        self.contextConductionInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.section = section
        self.section_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Component3)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Component3.subclass:
            return POCD_MT000040_Component3.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Component3(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_section(self):
        return self.section
    def set_section(self, section):
        self.section = section
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def get_contextConductionInd(self):
        return self.contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActRelationshipHasComponent(self, value):
        # Validate type ActRelationshipHasComponent, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['COMP', 'ARR', 'CTRLV', 'DEP']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipHasComponent' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipHasComponent_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipHasComponent_patterns_, ))
    validate_ActRelationshipHasComponent_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.section is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Component3', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Component3')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Component3':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Component3')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Component3', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Component3'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextConductionInd is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd="%s"' % self.gds_format_boolean(self.contextConductionInd, input_name='contextConductionInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Component3', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.section is not None:
            namespaceprefix_ = self.section_nsprefix_ + ':' if (UseCapturedNS_ and self.section_nsprefix_) else ''
            self.section.export(outfile, level, namespaceprefix_, namespacedef_='', name_='section', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipHasComponent(self.typeCode)    # validate type ActRelationshipHasComponent
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'section':
            obj_ = POCD_MT000040_Section.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.section = obj_
            obj_.original_tagname_ = 'section'
# end class POCD_MT000040_Component3


class POCD_MT000040_Component4(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipHasComponent' = 'COMP', contextConductionInd: 'bl' = 'true', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, sequenceNumber: 'INT' = None, priorityNumber: 'INT' = None, seperatableInd: 'BL' = None, act: 'POCD_MT000040.Act' = None, encounter: 'POCD_MT000040.Encounter' = None, observation: 'POCD_MT000040.Observation' = None, observationMedia: 'POCD_MT000040.ObservationMedia' = None, organizer: 'POCD_MT000040.Organizer' = None, procedure: 'POCD_MT000040.Procedure' = None, regionOfInterest: 'POCD_MT000040.RegionOfInterest' = None, substanceAdministration: 'POCD_MT000040.SubstanceAdministration' = None, supply: 'POCD_MT000040.Supply' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextConductionInd = _cast(bool, contextConductionInd)
        self.contextConductionInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.sequenceNumber = sequenceNumber
        self.sequenceNumber_nsprefix_ = None
        self.priorityNumber = priorityNumber
        self.priorityNumber_nsprefix_ = "sdtc"
        self.seperatableInd = seperatableInd
        self.seperatableInd_nsprefix_ = None
        self.act = act
        self.act_nsprefix_ = None
        self.encounter = encounter
        self.encounter_nsprefix_ = None
        self.observation = observation
        self.observation_nsprefix_ = None
        self.observationMedia = observationMedia
        self.observationMedia_nsprefix_ = None
        self.organizer = organizer
        self.organizer_nsprefix_ = None
        self.procedure = procedure
        self.procedure_nsprefix_ = None
        self.regionOfInterest = regionOfInterest
        self.regionOfInterest_nsprefix_ = None
        self.substanceAdministration = substanceAdministration
        self.substanceAdministration_nsprefix_ = None
        self.supply = supply
        self.supply_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Component4)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Component4.subclass:
            return POCD_MT000040_Component4.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Component4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_sequenceNumber(self):
        return self.sequenceNumber
    def set_sequenceNumber(self, sequenceNumber):
        self.sequenceNumber = sequenceNumber
    def get_priorityNumber(self):
        return self.priorityNumber
    def set_priorityNumber(self, priorityNumber):
        self.priorityNumber = priorityNumber
    def get_seperatableInd(self):
        return self.seperatableInd
    def set_seperatableInd(self, seperatableInd):
        self.seperatableInd = seperatableInd
    def get_act(self):
        return self.act
    def set_act(self, act):
        self.act = act
    def get_encounter(self):
        return self.encounter
    def set_encounter(self, encounter):
        self.encounter = encounter
    def get_observation(self):
        return self.observation
    def set_observation(self, observation):
        self.observation = observation
    def get_observationMedia(self):
        return self.observationMedia
    def set_observationMedia(self, observationMedia):
        self.observationMedia = observationMedia
    def get_organizer(self):
        return self.organizer
    def set_organizer(self, organizer):
        self.organizer = organizer
    def get_procedure(self):
        return self.procedure
    def set_procedure(self, procedure):
        self.procedure = procedure
    def get_regionOfInterest(self):
        return self.regionOfInterest
    def set_regionOfInterest(self, regionOfInterest):
        self.regionOfInterest = regionOfInterest
    def get_substanceAdministration(self):
        return self.substanceAdministration
    def set_substanceAdministration(self, substanceAdministration):
        self.substanceAdministration = substanceAdministration
    def get_supply(self):
        return self.supply
    def set_supply(self, supply):
        self.supply = supply
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def get_contextConductionInd(self):
        return self.contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActRelationshipHasComponent(self, value):
        # Validate type ActRelationshipHasComponent, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['COMP', 'ARR', 'CTRLV', 'DEP']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipHasComponent' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipHasComponent_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipHasComponent_patterns_, ))
    validate_ActRelationshipHasComponent_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.sequenceNumber is not None or
            self.priorityNumber is not None or
            self.seperatableInd is not None or
            self.act is not None or
            self.encounter is not None or
            self.observation is not None or
            self.observationMedia is not None or
            self.organizer is not None or
            self.procedure is not None or
            self.regionOfInterest is not None or
            self.substanceAdministration is not None or
            self.supply is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.Component4', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Component4')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Component4':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Component4')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Component4', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Component4'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextConductionInd is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd="%s"' % self.gds_format_boolean(self.contextConductionInd, input_name='contextConductionInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.Component4', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.sequenceNumber is not None:
            namespaceprefix_ = self.sequenceNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.sequenceNumber_nsprefix_) else ''
            self.sequenceNumber.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sequenceNumber', pretty_print=pretty_print)
        if self.priorityNumber is not None:
            namespaceprefix_ = self.priorityNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.priorityNumber_nsprefix_) else ''
            self.priorityNumber.export(outfile, level, namespaceprefix_='sdtc:', namespacedef_='', name_='priorityNumber', pretty_print=pretty_print)
        if self.seperatableInd is not None:
            namespaceprefix_ = self.seperatableInd_nsprefix_ + ':' if (UseCapturedNS_ and self.seperatableInd_nsprefix_) else ''
            self.seperatableInd.export(outfile, level, namespaceprefix_, namespacedef_='', name_='seperatableInd', pretty_print=pretty_print)
        if self.act is not None:
            namespaceprefix_ = self.act_nsprefix_ + ':' if (UseCapturedNS_ and self.act_nsprefix_) else ''
            self.act.export(outfile, level, namespaceprefix_, namespacedef_='', name_='act', pretty_print=pretty_print)
        if self.encounter is not None:
            namespaceprefix_ = self.encounter_nsprefix_ + ':' if (UseCapturedNS_ and self.encounter_nsprefix_) else ''
            self.encounter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='encounter', pretty_print=pretty_print)
        if self.observation is not None:
            namespaceprefix_ = self.observation_nsprefix_ + ':' if (UseCapturedNS_ and self.observation_nsprefix_) else ''
            self.observation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='observation', pretty_print=pretty_print)
        if self.observationMedia is not None:
            namespaceprefix_ = self.observationMedia_nsprefix_ + ':' if (UseCapturedNS_ and self.observationMedia_nsprefix_) else ''
            self.observationMedia.export(outfile, level, namespaceprefix_, namespacedef_='', name_='observationMedia', pretty_print=pretty_print)
        if self.organizer is not None:
            namespaceprefix_ = self.organizer_nsprefix_ + ':' if (UseCapturedNS_ and self.organizer_nsprefix_) else ''
            self.organizer.export(outfile, level, namespaceprefix_, namespacedef_='', name_='organizer', pretty_print=pretty_print)
        if self.procedure is not None:
            namespaceprefix_ = self.procedure_nsprefix_ + ':' if (UseCapturedNS_ and self.procedure_nsprefix_) else ''
            self.procedure.export(outfile, level, namespaceprefix_, namespacedef_='', name_='procedure', pretty_print=pretty_print)
        if self.regionOfInterest is not None:
            namespaceprefix_ = self.regionOfInterest_nsprefix_ + ':' if (UseCapturedNS_ and self.regionOfInterest_nsprefix_) else ''
            self.regionOfInterest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='regionOfInterest', pretty_print=pretty_print)
        if self.substanceAdministration is not None:
            namespaceprefix_ = self.substanceAdministration_nsprefix_ + ':' if (UseCapturedNS_ and self.substanceAdministration_nsprefix_) else ''
            self.substanceAdministration.export(outfile, level, namespaceprefix_, namespacedef_='', name_='substanceAdministration', pretty_print=pretty_print)
        if self.supply is not None:
            namespaceprefix_ = self.supply_nsprefix_ + ':' if (UseCapturedNS_ and self.supply_nsprefix_) else ''
            self.supply.export(outfile, level, namespaceprefix_, namespacedef_='', name_='supply', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipHasComponent(self.typeCode)    # validate type ActRelationshipHasComponent
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'sequenceNumber':
            class_obj_ = self.get_class_obj_(child_, INT)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sequenceNumber = obj_
            obj_.original_tagname_ = 'sequenceNumber'
        elif nodeName_ == 'priorityNumber':
            class_obj_ = self.get_class_obj_(child_, INT)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.priorityNumber = obj_
            obj_.original_tagname_ = 'priorityNumber'
        elif nodeName_ == 'seperatableInd':
            obj_ = BL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.seperatableInd = obj_
            obj_.original_tagname_ = 'seperatableInd'
        elif nodeName_ == 'act':
            obj_ = POCD_MT000040_Act.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.act = obj_
            obj_.original_tagname_ = 'act'
        elif nodeName_ == 'encounter':
            obj_ = POCD_MT000040_Encounter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.encounter = obj_
            obj_.original_tagname_ = 'encounter'
        elif nodeName_ == 'observation':
            obj_ = POCD_MT000040_Observation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.observation = obj_
            obj_.original_tagname_ = 'observation'
        elif nodeName_ == 'observationMedia':
            obj_ = POCD_MT000040_ObservationMedia.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.observationMedia = obj_
            obj_.original_tagname_ = 'observationMedia'
        elif nodeName_ == 'organizer':
            obj_ = POCD_MT000040_Organizer.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.organizer = obj_
            obj_.original_tagname_ = 'organizer'
        elif nodeName_ == 'procedure':
            obj_ = POCD_MT000040_Procedure.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.procedure = obj_
            obj_.original_tagname_ = 'procedure'
        elif nodeName_ == 'regionOfInterest':
            obj_ = POCD_MT000040_RegionOfInterest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.regionOfInterest = obj_
            obj_.original_tagname_ = 'regionOfInterest'
        elif nodeName_ == 'substanceAdministration':
            obj_ = POCD_MT000040_SubstanceAdministration.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.substanceAdministration = obj_
            obj_.original_tagname_ = 'substanceAdministration'
        elif nodeName_ == 'supply':
            obj_ = POCD_MT000040_Supply.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.supply = obj_
            obj_.original_tagname_ = 'supply'
# end class POCD_MT000040_Component4


class POCD_MT000040_Component5(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipHasComponent' = 'COMP', contextConductionInd: 'bl' = 'true', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, section: 'POCD_MT000040.Section' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextConductionInd = _cast(bool, contextConductionInd)
        self.contextConductionInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.section = section
        self.section_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Component5)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Component5.subclass:
            return POCD_MT000040_Component5.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Component5(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_section(self):
        return self.section
    def set_section(self, section):
        self.section = section
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def get_contextConductionInd(self):
        return self.contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActRelationshipHasComponent(self, value):
        # Validate type ActRelationshipHasComponent, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['COMP', 'ARR', 'CTRLV', 'DEP']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipHasComponent' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipHasComponent_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipHasComponent_patterns_, ))
    validate_ActRelationshipHasComponent_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.section is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Component5', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Component5')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Component5':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Component5')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Component5', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Component5'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextConductionInd is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd="%s"' % self.gds_format_boolean(self.contextConductionInd, input_name='contextConductionInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Component5', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.section is not None:
            namespaceprefix_ = self.section_nsprefix_ + ':' if (UseCapturedNS_ and self.section_nsprefix_) else ''
            self.section.export(outfile, level, namespaceprefix_, namespacedef_='', name_='section', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipHasComponent(self.typeCode)    # validate type ActRelationshipHasComponent
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'section':
            obj_ = POCD_MT000040_Section.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.section = obj_
            obj_.original_tagname_ = 'section'
# end class POCD_MT000040_Component5


class POCD_MT000040_Consent(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClass' = 'CONS', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, statusCode: 'CS' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.statusCode = statusCode
        self.statusCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Consent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Consent.subclass:
            return POCD_MT000040_Consent.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Consent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_statusCode(self):
        return self.statusCode
    def set_statusCode(self, statusCode):
        self.statusCode = statusCode
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def get_moodCode(self):
        return self.moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClass(self, value):
        # Validate type ActClass, a restriction on None.
        pass
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.statusCode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Consent', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Consent')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Consent':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Consent')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Consent', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Consent'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Consent', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.statusCode is not None:
            namespaceprefix_ = self.statusCode_nsprefix_ + ':' if (UseCapturedNS_ and self.statusCode_nsprefix_) else ''
            self.statusCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='statusCode', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClass(self.classCode)    # validate type ActClass
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'statusCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.statusCode = obj_
            obj_.original_tagname_ = 'statusCode'
# end class POCD_MT000040_Consent


class POCD_MT000040_Consumable(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'CSM', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, manufacturedProduct: 'POCD_MT000040.ManufacturedProduct' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.manufacturedProduct = manufacturedProduct
        self.manufacturedProduct_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Consumable)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Consumable.subclass:
            return POCD_MT000040_Consumable.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Consumable(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_manufacturedProduct(self):
        return self.manufacturedProduct
    def set_manufacturedProduct(self, manufacturedProduct):
        self.manufacturedProduct = manufacturedProduct
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.manufacturedProduct is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Consumable', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Consumable')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Consumable':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Consumable')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Consumable', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Consumable'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Consumable', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.manufacturedProduct is not None:
            namespaceprefix_ = self.manufacturedProduct_nsprefix_ + ':' if (UseCapturedNS_ and self.manufacturedProduct_nsprefix_) else ''
            self.manufacturedProduct.export(outfile, level, namespaceprefix_, namespacedef_='', name_='manufacturedProduct', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'manufacturedProduct':
            obj_ = POCD_MT000040_ManufacturedProduct.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.manufacturedProduct = obj_
            obj_.original_tagname_ = 'manufacturedProduct'
# end class POCD_MT000040_Consumable


class POCD_MT000040_Criterion(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClassObservation' = 'OBS', moodCode: 'ActMood' = 'EVN.CRT', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, value: 'ANY' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.value = value
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Criterion)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Criterion.subclass:
            return POCD_MT000040_Criterion.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Criterion(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def set_value_with_type(self, value):
        self.value = value
        value.original_tagname_ = 'value'
        value.extensiontype_ = value.__class__.__name__
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClassObservation(self, value):
        # Validate type ActClassObservation, a restriction on cs.
        pass
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.code is not None or
            self.text is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Criterion', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Criterion')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Criterion':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Criterion')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Criterion', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Criterion'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "OBS" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Criterion', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.value is not None:
            self.value.export(outfile, level, namespaceprefix_, name_='value', namespacedef_='', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClassObservation(self.classCode)    # validate type ActClassObservation
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'value':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()["" + type_name_]
                obj_ = class_.factory()
                obj_.build(child_, gds_collector_=gds_collector_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <value> element')
            self.value = obj_
            obj_.original_tagname_ = 'value'
# end class POCD_MT000040_Criterion


class POCD_MT000040_Custodian(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'CST', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, assignedCustodian: 'POCD_MT000040.AssignedCustodian' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.assignedCustodian = assignedCustodian
        self.assignedCustodian_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Custodian)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Custodian.subclass:
            return POCD_MT000040_Custodian.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Custodian(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_assignedCustodian(self):
        return self.assignedCustodian
    def set_assignedCustodian(self, assignedCustodian):
        self.assignedCustodian = assignedCustodian
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.assignedCustodian is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Custodian', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Custodian')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Custodian':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Custodian')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Custodian', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Custodian'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Custodian', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.assignedCustodian is not None:
            namespaceprefix_ = self.assignedCustodian_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedCustodian_nsprefix_) else ''
            self.assignedCustodian.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedCustodian', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'assignedCustodian':
            obj_ = POCD_MT000040_AssignedCustodian.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedCustodian = obj_
            obj_.original_tagname_ = 'assignedCustodian'
# end class POCD_MT000040_Custodian


class POCD_MT000040_CustodianOrganization(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'EntityClassOrganization' = 'ORG', determinerCode: 'EntityDeterminer' = 'INSTANCE', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, name: 'ON' = None, telecom: List_['TEL'] = None, addr: 'AD' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.determinerCode = _cast(None, determinerCode)
        self.determinerCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        if telecom is None:
            self.telecom = []
        else:
            self.telecom = telecom
        self.telecom_nsprefix_ = None
        self.addr = addr
        self.addr_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_CustodianOrganization)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_CustodianOrganization.subclass:
            return POCD_MT000040_CustodianOrganization.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_CustodianOrganization(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def add_telecom(self, value):
        self.telecom.append(value)
    def insert_telecom_at(self, index, value):
        self.telecom.insert(index, value)
    def replace_telecom_at(self, index, value):
        self.telecom[index] = value
    def get_addr(self):
        return self.addr
    def set_addr(self, addr):
        self.addr = addr
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def get_determinerCode(self):
        return self.determinerCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_EntityClassOrganization(self, value):
        # Validate type EntityClassOrganization, a restriction on cs.
        pass
    def validate_EntityDeterminer(self, value):
        # Validate type EntityDeterminer, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.name is not None or
            self.telecom or
            self.addr is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.CustodianOrganization', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.CustodianOrganization')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.CustodianOrganization':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.CustodianOrganization')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.CustodianOrganization', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.CustodianOrganization'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.determinerCode is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            outfile.write(' determinerCode=%s' % (quote_attrib(self.determinerCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.CustodianOrganization', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        for telecom_ in self.telecom:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            telecom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
        if self.addr is not None:
            namespaceprefix_ = self.addr_nsprefix_ + ':' if (UseCapturedNS_ and self.addr_nsprefix_) else ''
            self.addr.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addr', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_EntityClassOrganization(self.classCode)    # validate type EntityClassOrganization
        value = find_attr_value_('determinerCode', node)
        if value is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            self.determinerCode = value
            self.determinerCode = ' '.join(self.determinerCode.split())
            self.validate_EntityDeterminer(self.determinerCode)    # validate type EntityDeterminer
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'name':
            obj_ = ON.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'telecom':
            obj_ = TEL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom.append(obj_)
            obj_.original_tagname_ = 'telecom'
        elif nodeName_ == 'addr':
            obj_ = AD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addr = obj_
            obj_.original_tagname_ = 'addr'
# end class POCD_MT000040_CustodianOrganization


class POCD_MT000040_DataEnterer(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'ENT', contextControlCode: 'ContextControl' = 'OP', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, time: 'TS' = None, assignedEntity: 'POCD_MT000040.AssignedEntity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextControlCode = _cast(None, contextControlCode)
        self.contextControlCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.time = time
        self.time_nsprefix_ = None
        self.assignedEntity = assignedEntity
        self.assignedEntity_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_DataEnterer)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_DataEnterer.subclass:
            return POCD_MT000040_DataEnterer.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_DataEnterer(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_assignedEntity(self):
        return self.assignedEntity
    def set_assignedEntity(self, assignedEntity):
        self.assignedEntity = assignedEntity
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def get_contextControlCode(self):
        return self.contextControlCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        pass
    def validate_ContextControl(self, value):
        # Validate type ContextControl, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.time is not None or
            self.assignedEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.DataEnterer', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.DataEnterer')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.DataEnterer':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.DataEnterer')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.DataEnterer', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.DataEnterer'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextControlCode is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            outfile.write(' contextControlCode=%s' % (quote_attrib(self.contextControlCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.DataEnterer', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            self.time.export(outfile, level, namespaceprefix_, namespacedef_='', name_='time', pretty_print=pretty_print)
        if self.assignedEntity is not None:
            namespaceprefix_ = self.assignedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedEntity_nsprefix_) else ''
            self.assignedEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedEntity', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
        value = find_attr_value_('contextControlCode', node)
        if value is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            self.contextControlCode = value
            self.validate_ContextControl(self.contextControlCode)    # validate type ContextControl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'time':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'assignedEntity':
            obj_ = POCD_MT000040_AssignedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedEntity = obj_
            obj_.original_tagname_ = 'assignedEntity'
# end class POCD_MT000040_DataEnterer


class POCD_MT000040_Device(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'EntityClassDevice' = 'DEV', determinerCode: 'EntityDeterminer' = 'INSTANCE', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, code: 'CE' = None, manufacturerModelName: 'SC' = None, softwareName: 'SC' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.determinerCode = _cast(None, determinerCode)
        self.determinerCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.manufacturerModelName = manufacturerModelName
        self.manufacturerModelName_nsprefix_ = None
        self.softwareName = softwareName
        self.softwareName_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Device)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Device.subclass:
            return POCD_MT000040_Device.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Device(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_manufacturerModelName(self):
        return self.manufacturerModelName
    def set_manufacturerModelName(self, manufacturerModelName):
        self.manufacturerModelName = manufacturerModelName
    def get_softwareName(self):
        return self.softwareName
    def set_softwareName(self, softwareName):
        self.softwareName = softwareName
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_determinerCode(self):
        return self.determinerCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_EntityClassDevice(self, value):
        # Validate type EntityClassDevice, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['DEV', 'CER', 'MODDV']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityClassDevice' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityClassDevice_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityClassDevice_patterns_, ))
    validate_EntityClassDevice_patterns_ = [['^([^\\s]+)$']]
    def validate_EntityDeterminer(self, value):
        # Validate type EntityDeterminer, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.code is not None or
            self.manufacturerModelName is not None or
            self.softwareName is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Device', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Device')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Device':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Device')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Device', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Device'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "DEV" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.determinerCode is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            outfile.write(' determinerCode=%s' % (quote_attrib(self.determinerCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Device', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.manufacturerModelName is not None:
            namespaceprefix_ = self.manufacturerModelName_nsprefix_ + ':' if (UseCapturedNS_ and self.manufacturerModelName_nsprefix_) else ''
            self.manufacturerModelName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='manufacturerModelName', pretty_print=pretty_print)
        if self.softwareName is not None:
            namespaceprefix_ = self.softwareName_nsprefix_ + ':' if (UseCapturedNS_ and self.softwareName_nsprefix_) else ''
            self.softwareName.export(outfile, level, namespaceprefix_, namespacedef_='', name_='softwareName', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_EntityClassDevice(self.classCode)    # validate type EntityClassDevice
        value = find_attr_value_('determinerCode', node)
        if value is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            self.determinerCode = value
            self.determinerCode = ' '.join(self.determinerCode.split())
            self.validate_EntityDeterminer(self.determinerCode)    # validate type EntityDeterminer
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'manufacturerModelName':
            obj_ = SC.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.manufacturerModelName = obj_
            obj_.original_tagname_ = 'manufacturerModelName'
        elif nodeName_ == 'softwareName':
            obj_ = SC.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.softwareName = obj_
            obj_.original_tagname_ = 'softwareName'
# end class POCD_MT000040_Device


class POCD_MT000040_DocumentationOf(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipType' = 'DOC', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, serviceEvent: 'POCD_MT000040.ServiceEvent' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.serviceEvent = serviceEvent
        self.serviceEvent_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_DocumentationOf)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_DocumentationOf.subclass:
            return POCD_MT000040_DocumentationOf.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_DocumentationOf(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_serviceEvent(self):
        return self.serviceEvent
    def set_serviceEvent(self, serviceEvent):
        self.serviceEvent = serviceEvent
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActRelationshipType(self, value):
        # Validate type ActRelationshipType, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.serviceEvent is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.DocumentationOf', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.DocumentationOf')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.DocumentationOf':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.DocumentationOf')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.DocumentationOf', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.DocumentationOf'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.DocumentationOf', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.serviceEvent is not None:
            namespaceprefix_ = self.serviceEvent_nsprefix_ + ':' if (UseCapturedNS_ and self.serviceEvent_nsprefix_) else ''
            self.serviceEvent.export(outfile, level, namespaceprefix_, namespacedef_='', name_='serviceEvent', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.validate_ActRelationshipType(self.typeCode)    # validate type ActRelationshipType
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'serviceEvent':
            obj_ = POCD_MT000040_ServiceEvent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.serviceEvent = obj_
            obj_.original_tagname_ = 'serviceEvent'
# end class POCD_MT000040_DocumentationOf


class POCD_MT000040_EncompassingEncounter(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClass' = 'ENC', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, effectiveTime: 'IVL_TS' = None, dischargeDispositionCode: 'CE' = None, responsibleParty: 'POCD_MT000040.ResponsibleParty' = None, encounterParticipant: List_['POCD_MT000040.EncounterParticipant'] = None, location: 'POCD_MT000040.Location' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.effectiveTime = effectiveTime
        self.effectiveTime_nsprefix_ = None
        self.dischargeDispositionCode = dischargeDispositionCode
        self.dischargeDispositionCode_nsprefix_ = None
        self.responsibleParty = responsibleParty
        self.responsibleParty_nsprefix_ = None
        if encounterParticipant is None:
            self.encounterParticipant = []
        else:
            self.encounterParticipant = encounterParticipant
        self.encounterParticipant_nsprefix_ = None
        self.location = location
        self.location_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_EncompassingEncounter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_EncompassingEncounter.subclass:
            return POCD_MT000040_EncompassingEncounter.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_EncompassingEncounter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_effectiveTime(self):
        return self.effectiveTime
    def set_effectiveTime(self, effectiveTime):
        self.effectiveTime = effectiveTime
    def get_dischargeDispositionCode(self):
        return self.dischargeDispositionCode
    def set_dischargeDispositionCode(self, dischargeDispositionCode):
        self.dischargeDispositionCode = dischargeDispositionCode
    def get_responsibleParty(self):
        return self.responsibleParty
    def set_responsibleParty(self, responsibleParty):
        self.responsibleParty = responsibleParty
    def get_encounterParticipant(self):
        return self.encounterParticipant
    def set_encounterParticipant(self, encounterParticipant):
        self.encounterParticipant = encounterParticipant
    def add_encounterParticipant(self, value):
        self.encounterParticipant.append(value)
    def insert_encounterParticipant_at(self, index, value):
        self.encounterParticipant.insert(index, value)
    def replace_encounterParticipant_at(self, index, value):
        self.encounterParticipant[index] = value
    def get_location(self):
        return self.location
    def set_location(self, location):
        self.location = location
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def get_moodCode(self):
        return self.moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClass(self, value):
        # Validate type ActClass, a restriction on None.
        pass
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.effectiveTime is not None or
            self.dischargeDispositionCode is not None or
            self.responsibleParty is not None or
            self.encounterParticipant or
            self.location is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.EncompassingEncounter', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.EncompassingEncounter')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.EncompassingEncounter':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.EncompassingEncounter')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.EncompassingEncounter', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.EncompassingEncounter'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.EncompassingEncounter', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            namespaceprefix_ = self.effectiveTime_nsprefix_ + ':' if (UseCapturedNS_ and self.effectiveTime_nsprefix_) else ''
            self.effectiveTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='effectiveTime', pretty_print=pretty_print)
        if self.dischargeDispositionCode is not None:
            namespaceprefix_ = self.dischargeDispositionCode_nsprefix_ + ':' if (UseCapturedNS_ and self.dischargeDispositionCode_nsprefix_) else ''
            self.dischargeDispositionCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dischargeDispositionCode', pretty_print=pretty_print)
        if self.responsibleParty is not None:
            namespaceprefix_ = self.responsibleParty_nsprefix_ + ':' if (UseCapturedNS_ and self.responsibleParty_nsprefix_) else ''
            self.responsibleParty.export(outfile, level, namespaceprefix_, namespacedef_='', name_='responsibleParty', pretty_print=pretty_print)
        for encounterParticipant_ in self.encounterParticipant:
            namespaceprefix_ = self.encounterParticipant_nsprefix_ + ':' if (UseCapturedNS_ and self.encounterParticipant_nsprefix_) else ''
            encounterParticipant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='encounterParticipant', pretty_print=pretty_print)
        if self.location is not None:
            namespaceprefix_ = self.location_nsprefix_ + ':' if (UseCapturedNS_ and self.location_nsprefix_) else ''
            self.location.export(outfile, level, namespaceprefix_, namespacedef_='', name_='location', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClass(self.classCode)    # validate type ActClass
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'dischargeDispositionCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dischargeDispositionCode = obj_
            obj_.original_tagname_ = 'dischargeDispositionCode'
        elif nodeName_ == 'responsibleParty':
            obj_ = POCD_MT000040_ResponsibleParty.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.responsibleParty = obj_
            obj_.original_tagname_ = 'responsibleParty'
        elif nodeName_ == 'encounterParticipant':
            obj_ = POCD_MT000040_EncounterParticipant.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.encounterParticipant.append(obj_)
            obj_.original_tagname_ = 'encounterParticipant'
        elif nodeName_ == 'location':
            obj_ = POCD_MT000040_Location.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.location = obj_
            obj_.original_tagname_ = 'location'
# end class POCD_MT000040_EncompassingEncounter


class POCD_MT000040_Encounter(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClass' = None, moodCode: 'x_DocumentEncounterMood' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, statusCode: 'CS' = None, effectiveTime: 'IVL_TS' = None, dischargeDispositionCode: 'CE' = None, priorityCode: 'CE' = None, subject: 'POCD_MT000040.Subject' = None, specimen: List_['POCD_MT000040.Specimen'] = None, performer: List_['POCD_MT000040.Performer2'] = None, author: List_['POCD_MT000040.Author'] = None, informant: List_['POCD_MT000040.Informant12'] = None, participant: List_['POCD_MT000040.Participant2'] = None, entryRelationship: List_['POCD_MT000040.EntryRelationship'] = None, reference: List_['POCD_MT000040.Reference'] = None, precondition: List_['POCD_MT000040.Precondition'] = None, inFulfillmentOf1: List_['InFulfillmentOf1'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.statusCode = statusCode
        self.statusCode_nsprefix_ = None
        self.effectiveTime = effectiveTime
        self.effectiveTime_nsprefix_ = None
        self.dischargeDispositionCode = dischargeDispositionCode
        self.dischargeDispositionCode_nsprefix_ = "sdtc"
        self.priorityCode = priorityCode
        self.priorityCode_nsprefix_ = None
        self.subject = subject
        self.subject_nsprefix_ = None
        if specimen is None:
            self.specimen = []
        else:
            self.specimen = specimen
        self.specimen_nsprefix_ = None
        if performer is None:
            self.performer = []
        else:
            self.performer = performer
        self.performer_nsprefix_ = None
        if author is None:
            self.author = []
        else:
            self.author = author
        self.author_nsprefix_ = None
        if informant is None:
            self.informant = []
        else:
            self.informant = informant
        self.informant_nsprefix_ = None
        if participant is None:
            self.participant = []
        else:
            self.participant = participant
        self.participant_nsprefix_ = None
        if entryRelationship is None:
            self.entryRelationship = []
        else:
            self.entryRelationship = entryRelationship
        self.entryRelationship_nsprefix_ = None
        if reference is None:
            self.reference = []
        else:
            self.reference = reference
        self.reference_nsprefix_ = None
        if precondition is None:
            self.precondition = []
        else:
            self.precondition = precondition
        self.precondition_nsprefix_ = None
        if inFulfillmentOf1 is None:
            self.inFulfillmentOf1 = []
        else:
            self.inFulfillmentOf1 = inFulfillmentOf1
        self.inFulfillmentOf1_nsprefix_ = "sdtc"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Encounter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Encounter.subclass:
            return POCD_MT000040_Encounter.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Encounter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_statusCode(self):
        return self.statusCode
    def set_statusCode(self, statusCode):
        self.statusCode = statusCode
    def get_effectiveTime(self):
        return self.effectiveTime
    def set_effectiveTime(self, effectiveTime):
        self.effectiveTime = effectiveTime
    def get_dischargeDispositionCode(self):
        return self.dischargeDispositionCode
    def set_dischargeDispositionCode(self, dischargeDispositionCode):
        self.dischargeDispositionCode = dischargeDispositionCode
    def get_priorityCode(self):
        return self.priorityCode
    def set_priorityCode(self, priorityCode):
        self.priorityCode = priorityCode
    def get_subject(self):
        return self.subject
    def set_subject(self, subject):
        self.subject = subject
    def get_specimen(self):
        return self.specimen
    def set_specimen(self, specimen):
        self.specimen = specimen
    def add_specimen(self, value):
        self.specimen.append(value)
    def insert_specimen_at(self, index, value):
        self.specimen.insert(index, value)
    def replace_specimen_at(self, index, value):
        self.specimen[index] = value
    def get_performer(self):
        return self.performer
    def set_performer(self, performer):
        self.performer = performer
    def add_performer(self, value):
        self.performer.append(value)
    def insert_performer_at(self, index, value):
        self.performer.insert(index, value)
    def replace_performer_at(self, index, value):
        self.performer[index] = value
    def get_author(self):
        return self.author
    def set_author(self, author):
        self.author = author
    def add_author(self, value):
        self.author.append(value)
    def insert_author_at(self, index, value):
        self.author.insert(index, value)
    def replace_author_at(self, index, value):
        self.author[index] = value
    def get_informant(self):
        return self.informant
    def set_informant(self, informant):
        self.informant = informant
    def add_informant(self, value):
        self.informant.append(value)
    def insert_informant_at(self, index, value):
        self.informant.insert(index, value)
    def replace_informant_at(self, index, value):
        self.informant[index] = value
    def get_participant(self):
        return self.participant
    def set_participant(self, participant):
        self.participant = participant
    def add_participant(self, value):
        self.participant.append(value)
    def insert_participant_at(self, index, value):
        self.participant.insert(index, value)
    def replace_participant_at(self, index, value):
        self.participant[index] = value
    def get_entryRelationship(self):
        return self.entryRelationship
    def set_entryRelationship(self, entryRelationship):
        self.entryRelationship = entryRelationship
    def add_entryRelationship(self, value):
        self.entryRelationship.append(value)
    def insert_entryRelationship_at(self, index, value):
        self.entryRelationship.insert(index, value)
    def replace_entryRelationship_at(self, index, value):
        self.entryRelationship[index] = value
    def get_reference(self):
        return self.reference
    def set_reference(self, reference):
        self.reference = reference
    def add_reference(self, value):
        self.reference.append(value)
    def insert_reference_at(self, index, value):
        self.reference.insert(index, value)
    def replace_reference_at(self, index, value):
        self.reference[index] = value
    def get_precondition(self):
        return self.precondition
    def set_precondition(self, precondition):
        self.precondition = precondition
    def add_precondition(self, value):
        self.precondition.append(value)
    def insert_precondition_at(self, index, value):
        self.precondition.insert(index, value)
    def replace_precondition_at(self, index, value):
        self.precondition[index] = value
    def get_inFulfillmentOf1(self):
        return self.inFulfillmentOf1
    def set_inFulfillmentOf1(self, inFulfillmentOf1):
        self.inFulfillmentOf1 = inFulfillmentOf1
    def add_inFulfillmentOf1(self, value):
        self.inFulfillmentOf1.append(value)
    def insert_inFulfillmentOf1_at(self, index, value):
        self.inFulfillmentOf1.insert(index, value)
    def replace_inFulfillmentOf1_at(self, index, value):
        self.inFulfillmentOf1[index] = value
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClass(self, value):
        # Validate type ActClass, a restriction on None.
        pass
    def validate_x_DocumentEncounterMood(self, value):
        # Validate type x_DocumentEncounterMood, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['INT', 'APT', 'ARQ', 'EVN', 'PRMS', 'PRP', 'RQO']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_DocumentEncounterMood' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_DocumentEncounterMood_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_DocumentEncounterMood_patterns_, ))
    validate_x_DocumentEncounterMood_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.text is not None or
            self.statusCode is not None or
            self.effectiveTime is not None or
            self.dischargeDispositionCode is not None or
            self.priorityCode is not None or
            self.subject is not None or
            self.specimen or
            self.performer or
            self.author or
            self.informant or
            self.participant or
            self.entryRelationship or
            self.reference or
            self.precondition or
            self.inFulfillmentOf1
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.Encounter', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Encounter')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Encounter':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Encounter')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Encounter', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Encounter'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.Encounter', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.statusCode is not None:
            namespaceprefix_ = self.statusCode_nsprefix_ + ':' if (UseCapturedNS_ and self.statusCode_nsprefix_) else ''
            self.statusCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='statusCode', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            namespaceprefix_ = self.effectiveTime_nsprefix_ + ':' if (UseCapturedNS_ and self.effectiveTime_nsprefix_) else ''
            self.effectiveTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='effectiveTime', pretty_print=pretty_print)
        if self.dischargeDispositionCode is not None:
            namespaceprefix_ = self.dischargeDispositionCode_nsprefix_ + ':' if (UseCapturedNS_ and self.dischargeDispositionCode_nsprefix_) else ''
            self.dischargeDispositionCode.export(outfile, level, namespaceprefix_='sdtc:', namespacedef_='', name_='dischargeDispositionCode', pretty_print=pretty_print)
        if self.priorityCode is not None:
            namespaceprefix_ = self.priorityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.priorityCode_nsprefix_) else ''
            self.priorityCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='priorityCode', pretty_print=pretty_print)
        if self.subject is not None:
            namespaceprefix_ = self.subject_nsprefix_ + ':' if (UseCapturedNS_ and self.subject_nsprefix_) else ''
            self.subject.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subject', pretty_print=pretty_print)
        for specimen_ in self.specimen:
            namespaceprefix_ = self.specimen_nsprefix_ + ':' if (UseCapturedNS_ and self.specimen_nsprefix_) else ''
            specimen_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specimen', pretty_print=pretty_print)
        for performer_ in self.performer:
            namespaceprefix_ = self.performer_nsprefix_ + ':' if (UseCapturedNS_ and self.performer_nsprefix_) else ''
            performer_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='performer', pretty_print=pretty_print)
        for author_ in self.author:
            namespaceprefix_ = self.author_nsprefix_ + ':' if (UseCapturedNS_ and self.author_nsprefix_) else ''
            author_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='author', pretty_print=pretty_print)
        for informant_ in self.informant:
            namespaceprefix_ = self.informant_nsprefix_ + ':' if (UseCapturedNS_ and self.informant_nsprefix_) else ''
            informant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='informant', pretty_print=pretty_print)
        for participant_ in self.participant:
            namespaceprefix_ = self.participant_nsprefix_ + ':' if (UseCapturedNS_ and self.participant_nsprefix_) else ''
            participant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='participant', pretty_print=pretty_print)
        for entryRelationship_ in self.entryRelationship:
            namespaceprefix_ = self.entryRelationship_nsprefix_ + ':' if (UseCapturedNS_ and self.entryRelationship_nsprefix_) else ''
            entryRelationship_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='entryRelationship', pretty_print=pretty_print)
        for reference_ in self.reference:
            namespaceprefix_ = self.reference_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_nsprefix_) else ''
            reference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reference', pretty_print=pretty_print)
        for precondition_ in self.precondition:
            namespaceprefix_ = self.precondition_nsprefix_ + ':' if (UseCapturedNS_ and self.precondition_nsprefix_) else ''
            precondition_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='precondition', pretty_print=pretty_print)
        for inFulfillmentOf1_ in self.inFulfillmentOf1:
            namespaceprefix_ = self.inFulfillmentOf1_nsprefix_ + ':' if (UseCapturedNS_ and self.inFulfillmentOf1_nsprefix_) else ''
            inFulfillmentOf1_.export(outfile, level, namespaceprefix_='sdtc:', namespacedef_='', name_='inFulfillmentOf1', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClass(self.classCode)    # validate type ActClass
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_x_DocumentEncounterMood(self.moodCode)    # validate type x_DocumentEncounterMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'statusCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.statusCode = obj_
            obj_.original_tagname_ = 'statusCode'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'dischargeDispositionCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dischargeDispositionCode = obj_
            obj_.original_tagname_ = 'dischargeDispositionCode'
        elif nodeName_ == 'priorityCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.priorityCode = obj_
            obj_.original_tagname_ = 'priorityCode'
        elif nodeName_ == 'subject':
            obj_ = POCD_MT000040_Subject.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subject = obj_
            obj_.original_tagname_ = 'subject'
        elif nodeName_ == 'specimen':
            obj_ = POCD_MT000040_Specimen.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specimen.append(obj_)
            obj_.original_tagname_ = 'specimen'
        elif nodeName_ == 'performer':
            obj_ = POCD_MT000040_Performer2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.performer.append(obj_)
            obj_.original_tagname_ = 'performer'
        elif nodeName_ == 'author':
            obj_ = POCD_MT000040_Author.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'informant':
            obj_ = POCD_MT000040_Informant12.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.informant.append(obj_)
            obj_.original_tagname_ = 'informant'
        elif nodeName_ == 'participant':
            obj_ = POCD_MT000040_Participant2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.participant.append(obj_)
            obj_.original_tagname_ = 'participant'
        elif nodeName_ == 'entryRelationship':
            obj_ = POCD_MT000040_EntryRelationship.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.entryRelationship.append(obj_)
            obj_.original_tagname_ = 'entryRelationship'
        elif nodeName_ == 'reference':
            obj_ = POCD_MT000040_Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reference.append(obj_)
            obj_.original_tagname_ = 'reference'
        elif nodeName_ == 'precondition':
            obj_ = POCD_MT000040_Precondition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.precondition.append(obj_)
            obj_.original_tagname_ = 'precondition'
        elif nodeName_ == 'inFulfillmentOf1':
            obj_ = InFulfillmentOf1.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.inFulfillmentOf1.append(obj_)
            obj_.original_tagname_ = 'inFulfillmentOf1'
# end class POCD_MT000040_Encounter


class POCD_MT000040_EncounterParticipant(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'x_EncounterParticipant' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, time: 'IVL_TS' = None, assignedEntity: 'POCD_MT000040.AssignedEntity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.time = time
        self.time_nsprefix_ = None
        self.assignedEntity = assignedEntity
        self.assignedEntity_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_EncounterParticipant)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_EncounterParticipant.subclass:
            return POCD_MT000040_EncounterParticipant.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_EncounterParticipant(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_assignedEntity(self):
        return self.assignedEntity
    def set_assignedEntity(self, assignedEntity):
        self.assignedEntity = assignedEntity
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_x_EncounterParticipant(self, value):
        # Validate type x_EncounterParticipant, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ADM', 'ATND', 'CON', 'DIS', 'REF']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_EncounterParticipant' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_EncounterParticipant_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_EncounterParticipant_patterns_, ))
    validate_x_EncounterParticipant_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.time is not None or
            self.assignedEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.EncounterParticipant', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.EncounterParticipant')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.EncounterParticipant':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.EncounterParticipant')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.EncounterParticipant', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.EncounterParticipant'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.EncounterParticipant', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            self.time.export(outfile, level, namespaceprefix_, namespacedef_='', name_='time', pretty_print=pretty_print)
        if self.assignedEntity is not None:
            namespaceprefix_ = self.assignedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedEntity_nsprefix_) else ''
            self.assignedEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedEntity', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_x_EncounterParticipant(self.typeCode)    # validate type x_EncounterParticipant
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'time':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'assignedEntity':
            obj_ = POCD_MT000040_AssignedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedEntity = obj_
            obj_.original_tagname_ = 'assignedEntity'
# end class POCD_MT000040_EncounterParticipant


class POCD_MT000040_Entity(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'EntityClassRoot' = 'ENT', determinerCode: 'EntityDeterminer' = 'INSTANCE', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, desc: 'ED' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.determinerCode = _cast(None, determinerCode)
        self.determinerCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.desc = desc
        self.desc_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Entity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Entity.subclass:
            return POCD_MT000040_Entity.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Entity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_desc(self):
        return self.desc
    def set_desc(self, desc):
        self.desc = desc
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_determinerCode(self):
        return self.determinerCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_EntityClassRoot(self, value):
        # Validate type EntityClassRoot, a restriction on cs.
        pass
    def validate_EntityDeterminer(self, value):
        # Validate type EntityDeterminer, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.desc is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Entity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Entity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Entity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Entity')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Entity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Entity'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ENT" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.determinerCode is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            outfile.write(' determinerCode=%s' % (quote_attrib(self.determinerCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Entity', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.desc is not None:
            namespaceprefix_ = self.desc_nsprefix_ + ':' if (UseCapturedNS_ and self.desc_nsprefix_) else ''
            self.desc.export(outfile, level, namespaceprefix_, namespacedef_='', name_='desc', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_EntityClassRoot(self.classCode)    # validate type EntityClassRoot
        value = find_attr_value_('determinerCode', node)
        if value is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            self.determinerCode = value
            self.determinerCode = ' '.join(self.determinerCode.split())
            self.validate_EntityDeterminer(self.determinerCode)    # validate type EntityDeterminer
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'desc':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.desc = obj_
            obj_.original_tagname_ = 'desc'
# end class POCD_MT000040_Entity


class POCD_MT000040_Entry(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'x_ActRelationshipEntry' = 'COMP', contextConductionInd: 'bl' = 'true', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, act: 'POCD_MT000040.Act' = None, encounter: 'POCD_MT000040.Encounter' = None, observation: 'POCD_MT000040.Observation' = None, observationMedia: 'POCD_MT000040.ObservationMedia' = None, organizer: 'POCD_MT000040.Organizer' = None, procedure: 'POCD_MT000040.Procedure' = None, regionOfInterest: 'POCD_MT000040.RegionOfInterest' = None, substanceAdministration: 'POCD_MT000040.SubstanceAdministration' = None, supply: 'POCD_MT000040.Supply' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextConductionInd = _cast(bool, contextConductionInd)
        self.contextConductionInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.act = act
        self.act_nsprefix_ = None
        self.encounter = encounter
        self.encounter_nsprefix_ = None
        self.observation = observation
        self.observation_nsprefix_ = None
        self.observationMedia = observationMedia
        self.observationMedia_nsprefix_ = None
        self.organizer = organizer
        self.organizer_nsprefix_ = None
        self.procedure = procedure
        self.procedure_nsprefix_ = None
        self.regionOfInterest = regionOfInterest
        self.regionOfInterest_nsprefix_ = None
        self.substanceAdministration = substanceAdministration
        self.substanceAdministration_nsprefix_ = None
        self.supply = supply
        self.supply_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Entry)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Entry.subclass:
            return POCD_MT000040_Entry.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Entry(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_act(self):
        return self.act
    def set_act(self, act):
        self.act = act
    def get_encounter(self):
        return self.encounter
    def set_encounter(self, encounter):
        self.encounter = encounter
    def get_observation(self):
        return self.observation
    def set_observation(self, observation):
        self.observation = observation
    def get_observationMedia(self):
        return self.observationMedia
    def set_observationMedia(self, observationMedia):
        self.observationMedia = observationMedia
    def get_organizer(self):
        return self.organizer
    def set_organizer(self, organizer):
        self.organizer = organizer
    def get_procedure(self):
        return self.procedure
    def set_procedure(self, procedure):
        self.procedure = procedure
    def get_regionOfInterest(self):
        return self.regionOfInterest
    def set_regionOfInterest(self, regionOfInterest):
        self.regionOfInterest = regionOfInterest
    def get_substanceAdministration(self):
        return self.substanceAdministration
    def set_substanceAdministration(self, substanceAdministration):
        self.substanceAdministration = substanceAdministration
    def get_supply(self):
        return self.supply
    def set_supply(self, supply):
        self.supply = supply
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_contextConductionInd(self):
        return self.contextConductionInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_x_ActRelationshipEntry(self, value):
        # Validate type x_ActRelationshipEntry, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['COMP', 'DRIV']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_ActRelationshipEntry' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_ActRelationshipEntry_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_ActRelationshipEntry_patterns_, ))
    validate_x_ActRelationshipEntry_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.act is not None or
            self.encounter is not None or
            self.observation is not None or
            self.observationMedia is not None or
            self.organizer is not None or
            self.procedure is not None or
            self.regionOfInterest is not None or
            self.substanceAdministration is not None or
            self.supply is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Entry', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Entry')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Entry':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Entry')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Entry', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Entry'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "COMP" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextConductionInd is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd="%s"' % self.gds_format_boolean(self.contextConductionInd, input_name='contextConductionInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Entry', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.act is not None:
            namespaceprefix_ = self.act_nsprefix_ + ':' if (UseCapturedNS_ and self.act_nsprefix_) else ''
            self.act.export(outfile, level, namespaceprefix_, namespacedef_='', name_='act', pretty_print=pretty_print)
        if self.encounter is not None:
            namespaceprefix_ = self.encounter_nsprefix_ + ':' if (UseCapturedNS_ and self.encounter_nsprefix_) else ''
            self.encounter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='encounter', pretty_print=pretty_print)
        if self.observation is not None:
            namespaceprefix_ = self.observation_nsprefix_ + ':' if (UseCapturedNS_ and self.observation_nsprefix_) else ''
            self.observation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='observation', pretty_print=pretty_print)
        if self.observationMedia is not None:
            namespaceprefix_ = self.observationMedia_nsprefix_ + ':' if (UseCapturedNS_ and self.observationMedia_nsprefix_) else ''
            self.observationMedia.export(outfile, level, namespaceprefix_, namespacedef_='', name_='observationMedia', pretty_print=pretty_print)
        if self.organizer is not None:
            namespaceprefix_ = self.organizer_nsprefix_ + ':' if (UseCapturedNS_ and self.organizer_nsprefix_) else ''
            self.organizer.export(outfile, level, namespaceprefix_, namespacedef_='', name_='organizer', pretty_print=pretty_print)
        if self.procedure is not None:
            namespaceprefix_ = self.procedure_nsprefix_ + ':' if (UseCapturedNS_ and self.procedure_nsprefix_) else ''
            self.procedure.export(outfile, level, namespaceprefix_, namespacedef_='', name_='procedure', pretty_print=pretty_print)
        if self.regionOfInterest is not None:
            namespaceprefix_ = self.regionOfInterest_nsprefix_ + ':' if (UseCapturedNS_ and self.regionOfInterest_nsprefix_) else ''
            self.regionOfInterest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='regionOfInterest', pretty_print=pretty_print)
        if self.substanceAdministration is not None:
            namespaceprefix_ = self.substanceAdministration_nsprefix_ + ':' if (UseCapturedNS_ and self.substanceAdministration_nsprefix_) else ''
            self.substanceAdministration.export(outfile, level, namespaceprefix_, namespacedef_='', name_='substanceAdministration', pretty_print=pretty_print)
        if self.supply is not None:
            namespaceprefix_ = self.supply_nsprefix_ + ':' if (UseCapturedNS_ and self.supply_nsprefix_) else ''
            self.supply.export(outfile, level, namespaceprefix_, namespacedef_='', name_='supply', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_x_ActRelationshipEntry(self.typeCode)    # validate type x_ActRelationshipEntry
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'act':
            obj_ = POCD_MT000040_Act.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.act = obj_
            obj_.original_tagname_ = 'act'
        elif nodeName_ == 'encounter':
            obj_ = POCD_MT000040_Encounter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.encounter = obj_
            obj_.original_tagname_ = 'encounter'
        elif nodeName_ == 'observation':
            obj_ = POCD_MT000040_Observation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.observation = obj_
            obj_.original_tagname_ = 'observation'
        elif nodeName_ == 'observationMedia':
            obj_ = POCD_MT000040_ObservationMedia.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.observationMedia = obj_
            obj_.original_tagname_ = 'observationMedia'
        elif nodeName_ == 'organizer':
            obj_ = POCD_MT000040_Organizer.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.organizer = obj_
            obj_.original_tagname_ = 'organizer'
        elif nodeName_ == 'procedure':
            obj_ = POCD_MT000040_Procedure.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.procedure = obj_
            obj_.original_tagname_ = 'procedure'
        elif nodeName_ == 'regionOfInterest':
            obj_ = POCD_MT000040_RegionOfInterest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.regionOfInterest = obj_
            obj_.original_tagname_ = 'regionOfInterest'
        elif nodeName_ == 'substanceAdministration':
            obj_ = POCD_MT000040_SubstanceAdministration.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.substanceAdministration = obj_
            obj_.original_tagname_ = 'substanceAdministration'
        elif nodeName_ == 'supply':
            obj_ = POCD_MT000040_Supply.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.supply = obj_
            obj_.original_tagname_ = 'supply'
# end class POCD_MT000040_Entry


class POCD_MT000040_EntryRelationship(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'x_ActRelationshipEntryRelationship' = None, inversionInd: 'bl' = None, contextConductionInd: 'bl' = 'true', negationInd: 'bl' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, sequenceNumber: 'INT' = None, seperatableInd: 'BL' = None, act: 'POCD_MT000040.Act' = None, encounter: 'POCD_MT000040.Encounter' = None, observation: 'POCD_MT000040.Observation' = None, observationMedia: 'POCD_MT000040.ObservationMedia' = None, organizer: 'POCD_MT000040.Organizer' = None, procedure: 'POCD_MT000040.Procedure' = None, regionOfInterest: 'POCD_MT000040.RegionOfInterest' = None, substanceAdministration: 'POCD_MT000040.SubstanceAdministration' = None, supply: 'POCD_MT000040.Supply' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.inversionInd = _cast(bool, inversionInd)
        self.inversionInd_nsprefix_ = None
        self.contextConductionInd = _cast(bool, contextConductionInd)
        self.contextConductionInd_nsprefix_ = None
        self.negationInd = _cast(bool, negationInd)
        self.negationInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.sequenceNumber = sequenceNumber
        self.sequenceNumber_nsprefix_ = None
        self.seperatableInd = seperatableInd
        self.seperatableInd_nsprefix_ = None
        self.act = act
        self.act_nsprefix_ = None
        self.encounter = encounter
        self.encounter_nsprefix_ = None
        self.observation = observation
        self.observation_nsprefix_ = None
        self.observationMedia = observationMedia
        self.observationMedia_nsprefix_ = None
        self.organizer = organizer
        self.organizer_nsprefix_ = None
        self.procedure = procedure
        self.procedure_nsprefix_ = None
        self.regionOfInterest = regionOfInterest
        self.regionOfInterest_nsprefix_ = None
        self.substanceAdministration = substanceAdministration
        self.substanceAdministration_nsprefix_ = None
        self.supply = supply
        self.supply_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_EntryRelationship)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_EntryRelationship.subclass:
            return POCD_MT000040_EntryRelationship.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_EntryRelationship(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_sequenceNumber(self):
        return self.sequenceNumber
    def set_sequenceNumber(self, sequenceNumber):
        self.sequenceNumber = sequenceNumber
    def get_seperatableInd(self):
        return self.seperatableInd
    def set_seperatableInd(self, seperatableInd):
        self.seperatableInd = seperatableInd
    def get_act(self):
        return self.act
    def set_act(self, act):
        self.act = act
    def get_encounter(self):
        return self.encounter
    def set_encounter(self, encounter):
        self.encounter = encounter
    def get_observation(self):
        return self.observation
    def set_observation(self, observation):
        self.observation = observation
    def get_observationMedia(self):
        return self.observationMedia
    def set_observationMedia(self, observationMedia):
        self.observationMedia = observationMedia
    def get_organizer(self):
        return self.organizer
    def set_organizer(self, organizer):
        self.organizer = organizer
    def get_procedure(self):
        return self.procedure
    def set_procedure(self, procedure):
        self.procedure = procedure
    def get_regionOfInterest(self):
        return self.regionOfInterest
    def set_regionOfInterest(self, regionOfInterest):
        self.regionOfInterest = regionOfInterest
    def get_substanceAdministration(self):
        return self.substanceAdministration
    def set_substanceAdministration(self, substanceAdministration):
        self.substanceAdministration = substanceAdministration
    def get_supply(self):
        return self.supply
    def set_supply(self, supply):
        self.supply = supply
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_inversionInd(self):
        return self.inversionInd
    def set_inversionInd(self, inversionInd):
        self.inversionInd = inversionInd
    def get_contextConductionInd(self):
        return self.contextConductionInd
    def set_contextConductionInd(self, contextConductionInd):
        self.contextConductionInd = contextConductionInd
    def get_negationInd(self):
        return self.negationInd
    def set_negationInd(self, negationInd):
        self.negationInd = negationInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_x_ActRelationshipEntryRelationship(self, value):
        # Validate type x_ActRelationshipEntryRelationship, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['XCRPT', 'COMP', 'RSON', 'SPRT', 'CAUS', 'GEVL', 'MFST', 'REFR', 'SAS', 'SUBJ']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_ActRelationshipEntryRelationship' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_ActRelationshipEntryRelationship_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_ActRelationshipEntryRelationship_patterns_, ))
    validate_x_ActRelationshipEntryRelationship_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.sequenceNumber is not None or
            self.seperatableInd is not None or
            self.act is not None or
            self.encounter is not None or
            self.observation is not None or
            self.observationMedia is not None or
            self.organizer is not None or
            self.procedure is not None or
            self.regionOfInterest is not None or
            self.substanceAdministration is not None or
            self.supply is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.EntryRelationship', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.EntryRelationship')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.EntryRelationship':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.EntryRelationship')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.EntryRelationship', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.EntryRelationship'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.inversionInd is not None and 'inversionInd' not in already_processed:
            already_processed.add('inversionInd')
            outfile.write(' inversionInd="%s"' % self.gds_format_boolean(self.inversionInd, input_name='inversionInd'))
        if not self.contextConductionInd and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            outfile.write(' contextConductionInd="%s"' % self.gds_format_boolean(self.contextConductionInd, input_name='contextConductionInd'))
        if self.negationInd is not None and 'negationInd' not in already_processed:
            already_processed.add('negationInd')
            outfile.write(' negationInd="%s"' % self.gds_format_boolean(self.negationInd, input_name='negationInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.EntryRelationship', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.sequenceNumber is not None:
            namespaceprefix_ = self.sequenceNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.sequenceNumber_nsprefix_) else ''
            self.sequenceNumber.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sequenceNumber', pretty_print=pretty_print)
        if self.seperatableInd is not None:
            namespaceprefix_ = self.seperatableInd_nsprefix_ + ':' if (UseCapturedNS_ and self.seperatableInd_nsprefix_) else ''
            self.seperatableInd.export(outfile, level, namespaceprefix_, namespacedef_='', name_='seperatableInd', pretty_print=pretty_print)
        if self.act is not None:
            namespaceprefix_ = self.act_nsprefix_ + ':' if (UseCapturedNS_ and self.act_nsprefix_) else ''
            self.act.export(outfile, level, namespaceprefix_, namespacedef_='', name_='act', pretty_print=pretty_print)
        if self.encounter is not None:
            namespaceprefix_ = self.encounter_nsprefix_ + ':' if (UseCapturedNS_ and self.encounter_nsprefix_) else ''
            self.encounter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='encounter', pretty_print=pretty_print)
        if self.observation is not None:
            namespaceprefix_ = self.observation_nsprefix_ + ':' if (UseCapturedNS_ and self.observation_nsprefix_) else ''
            self.observation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='observation', pretty_print=pretty_print)
        if self.observationMedia is not None:
            namespaceprefix_ = self.observationMedia_nsprefix_ + ':' if (UseCapturedNS_ and self.observationMedia_nsprefix_) else ''
            self.observationMedia.export(outfile, level, namespaceprefix_, namespacedef_='', name_='observationMedia', pretty_print=pretty_print)
        if self.organizer is not None:
            namespaceprefix_ = self.organizer_nsprefix_ + ':' if (UseCapturedNS_ and self.organizer_nsprefix_) else ''
            self.organizer.export(outfile, level, namespaceprefix_, namespacedef_='', name_='organizer', pretty_print=pretty_print)
        if self.procedure is not None:
            namespaceprefix_ = self.procedure_nsprefix_ + ':' if (UseCapturedNS_ and self.procedure_nsprefix_) else ''
            self.procedure.export(outfile, level, namespaceprefix_, namespacedef_='', name_='procedure', pretty_print=pretty_print)
        if self.regionOfInterest is not None:
            namespaceprefix_ = self.regionOfInterest_nsprefix_ + ':' if (UseCapturedNS_ and self.regionOfInterest_nsprefix_) else ''
            self.regionOfInterest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='regionOfInterest', pretty_print=pretty_print)
        if self.substanceAdministration is not None:
            namespaceprefix_ = self.substanceAdministration_nsprefix_ + ':' if (UseCapturedNS_ and self.substanceAdministration_nsprefix_) else ''
            self.substanceAdministration.export(outfile, level, namespaceprefix_, namespacedef_='', name_='substanceAdministration', pretty_print=pretty_print)
        if self.supply is not None:
            namespaceprefix_ = self.supply_nsprefix_ + ':' if (UseCapturedNS_ and self.supply_nsprefix_) else ''
            self.supply.export(outfile, level, namespaceprefix_, namespacedef_='', name_='supply', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_x_ActRelationshipEntryRelationship(self.typeCode)    # validate type x_ActRelationshipEntryRelationship
        value = find_attr_value_('inversionInd', node)
        if value is not None and 'inversionInd' not in already_processed:
            already_processed.add('inversionInd')
            if value in ('true', '1'):
                self.inversionInd = True
            elif value in ('false', '0'):
                self.inversionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.inversionInd)    # validate type bl
        value = find_attr_value_('contextConductionInd', node)
        if value is not None and 'contextConductionInd' not in already_processed:
            already_processed.add('contextConductionInd')
            if value in ('true', '1'):
                self.contextConductionInd = True
            elif value in ('false', '0'):
                self.contextConductionInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.contextConductionInd)    # validate type bl
        value = find_attr_value_('negationInd', node)
        if value is not None and 'negationInd' not in already_processed:
            already_processed.add('negationInd')
            if value in ('true', '1'):
                self.negationInd = True
            elif value in ('false', '0'):
                self.negationInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.negationInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'sequenceNumber':
            class_obj_ = self.get_class_obj_(child_, INT)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sequenceNumber = obj_
            obj_.original_tagname_ = 'sequenceNumber'
        elif nodeName_ == 'seperatableInd':
            obj_ = BL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.seperatableInd = obj_
            obj_.original_tagname_ = 'seperatableInd'
        elif nodeName_ == 'act':
            obj_ = POCD_MT000040_Act.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.act = obj_
            obj_.original_tagname_ = 'act'
        elif nodeName_ == 'encounter':
            obj_ = POCD_MT000040_Encounter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.encounter = obj_
            obj_.original_tagname_ = 'encounter'
        elif nodeName_ == 'observation':
            obj_ = POCD_MT000040_Observation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.observation = obj_
            obj_.original_tagname_ = 'observation'
        elif nodeName_ == 'observationMedia':
            obj_ = POCD_MT000040_ObservationMedia.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.observationMedia = obj_
            obj_.original_tagname_ = 'observationMedia'
        elif nodeName_ == 'organizer':
            obj_ = POCD_MT000040_Organizer.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.organizer = obj_
            obj_.original_tagname_ = 'organizer'
        elif nodeName_ == 'procedure':
            obj_ = POCD_MT000040_Procedure.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.procedure = obj_
            obj_.original_tagname_ = 'procedure'
        elif nodeName_ == 'regionOfInterest':
            obj_ = POCD_MT000040_RegionOfInterest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.regionOfInterest = obj_
            obj_.original_tagname_ = 'regionOfInterest'
        elif nodeName_ == 'substanceAdministration':
            obj_ = POCD_MT000040_SubstanceAdministration.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.substanceAdministration = obj_
            obj_.original_tagname_ = 'substanceAdministration'
        elif nodeName_ == 'supply':
            obj_ = POCD_MT000040_Supply.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.supply = obj_
            obj_.original_tagname_ = 'supply'
# end class POCD_MT000040_EntryRelationship


class POCD_MT000040_ExternalAct(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClassRoot' = 'ACT', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_ExternalAct)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_ExternalAct.subclass:
            return POCD_MT000040_ExternalAct.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_ExternalAct(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClassRoot(self, value):
        # Validate type ActClassRoot, a restriction on cs.
        pass
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.text is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.ExternalAct', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.ExternalAct')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.ExternalAct':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.ExternalAct')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.ExternalAct', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.ExternalAct'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ACT" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.ExternalAct', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClassRoot(self.classCode)    # validate type ActClassRoot
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
# end class POCD_MT000040_ExternalAct


class POCD_MT000040_ExternalDocument(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClassDocument' = 'DOC', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, setId: 'II' = None, versionNumber: 'INT' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.setId = setId
        self.setId_nsprefix_ = None
        self.versionNumber = versionNumber
        self.versionNumber_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_ExternalDocument)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_ExternalDocument.subclass:
            return POCD_MT000040_ExternalDocument.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_ExternalDocument(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_setId(self):
        return self.setId
    def set_setId(self, setId):
        self.setId = setId
    def get_versionNumber(self):
        return self.versionNumber
    def set_versionNumber(self, versionNumber):
        self.versionNumber = versionNumber
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClassDocument(self, value):
        # Validate type ActClassDocument, a restriction on cs.
        pass
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.text is not None or
            self.setId is not None or
            self.versionNumber is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.ExternalDocument', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.ExternalDocument')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.ExternalDocument':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.ExternalDocument')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.ExternalDocument', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.ExternalDocument'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "DOC" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.ExternalDocument', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.setId is not None:
            namespaceprefix_ = self.setId_nsprefix_ + ':' if (UseCapturedNS_ and self.setId_nsprefix_) else ''
            self.setId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='setId', pretty_print=pretty_print)
        if self.versionNumber is not None:
            namespaceprefix_ = self.versionNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.versionNumber_nsprefix_) else ''
            self.versionNumber.export(outfile, level, namespaceprefix_, namespacedef_='', name_='versionNumber', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClassDocument(self.classCode)    # validate type ActClassDocument
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'setId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.setId = obj_
            obj_.original_tagname_ = 'setId'
        elif nodeName_ == 'versionNumber':
            class_obj_ = self.get_class_obj_(child_, INT)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.versionNumber = obj_
            obj_.original_tagname_ = 'versionNumber'
# end class POCD_MT000040_ExternalDocument


class POCD_MT000040_ExternalObservation(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClassObservation' = 'OBS', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_ExternalObservation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_ExternalObservation.subclass:
            return POCD_MT000040_ExternalObservation.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_ExternalObservation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClassObservation(self, value):
        # Validate type ActClassObservation, a restriction on cs.
        pass
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.text is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.ExternalObservation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.ExternalObservation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.ExternalObservation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.ExternalObservation')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.ExternalObservation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.ExternalObservation'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "OBS" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.ExternalObservation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClassObservation(self.classCode)    # validate type ActClassObservation
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
# end class POCD_MT000040_ExternalObservation


class POCD_MT000040_ExternalProcedure(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClass' = 'PROC', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_ExternalProcedure)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_ExternalProcedure.subclass:
            return POCD_MT000040_ExternalProcedure.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_ExternalProcedure(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def get_moodCode(self):
        return self.moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClass(self, value):
        # Validate type ActClass, a restriction on None.
        pass
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.text is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.ExternalProcedure', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.ExternalProcedure')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.ExternalProcedure':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.ExternalProcedure')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.ExternalProcedure', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.ExternalProcedure'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.ExternalProcedure', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClass(self.classCode)    # validate type ActClass
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
# end class POCD_MT000040_ExternalProcedure


class POCD_MT000040_Guardian(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClass' = 'GUARD', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, addr: List_['AD'] = None, telecom: List_['TEL'] = None, guardianPerson: 'POCD_MT000040.Person' = None, guardianOrganization: 'POCD_MT000040.Organization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        if addr is None:
            self.addr = []
        else:
            self.addr = addr
        self.addr_nsprefix_ = None
        if telecom is None:
            self.telecom = []
        else:
            self.telecom = telecom
        self.telecom_nsprefix_ = None
        self.guardianPerson = guardianPerson
        self.guardianPerson_nsprefix_ = None
        self.guardianOrganization = guardianOrganization
        self.guardianOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Guardian)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Guardian.subclass:
            return POCD_MT000040_Guardian.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Guardian(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_addr(self):
        return self.addr
    def set_addr(self, addr):
        self.addr = addr
    def add_addr(self, value):
        self.addr.append(value)
    def insert_addr_at(self, index, value):
        self.addr.insert(index, value)
    def replace_addr_at(self, index, value):
        self.addr[index] = value
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def add_telecom(self, value):
        self.telecom.append(value)
    def insert_telecom_at(self, index, value):
        self.telecom.insert(index, value)
    def replace_telecom_at(self, index, value):
        self.telecom[index] = value
    def get_guardianPerson(self):
        return self.guardianPerson
    def set_guardianPerson(self, guardianPerson):
        self.guardianPerson = guardianPerson
    def get_guardianOrganization(self):
        return self.guardianOrganization
    def set_guardianOrganization(self, guardianOrganization):
        self.guardianOrganization = guardianOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_RoleClass(self, value):
        # Validate type RoleClass, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.addr or
            self.telecom or
            self.guardianPerson is not None or
            self.guardianOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Guardian', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Guardian')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Guardian':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Guardian')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Guardian', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Guardian'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Guardian', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        for addr_ in self.addr:
            namespaceprefix_ = self.addr_nsprefix_ + ':' if (UseCapturedNS_ and self.addr_nsprefix_) else ''
            addr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addr', pretty_print=pretty_print)
        for telecom_ in self.telecom:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            telecom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
        if self.guardianPerson is not None:
            namespaceprefix_ = self.guardianPerson_nsprefix_ + ':' if (UseCapturedNS_ and self.guardianPerson_nsprefix_) else ''
            self.guardianPerson.export(outfile, level, namespaceprefix_, namespacedef_='', name_='guardianPerson', pretty_print=pretty_print)
        if self.guardianOrganization is not None:
            namespaceprefix_ = self.guardianOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.guardianOrganization_nsprefix_) else ''
            self.guardianOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='guardianOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_RoleClass(self.classCode)    # validate type RoleClass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'addr':
            obj_ = AD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addr.append(obj_)
            obj_.original_tagname_ = 'addr'
        elif nodeName_ == 'telecom':
            obj_ = TEL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom.append(obj_)
            obj_.original_tagname_ = 'telecom'
        elif nodeName_ == 'guardianPerson':
            obj_ = POCD_MT000040_Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.guardianPerson = obj_
            obj_.original_tagname_ = 'guardianPerson'
        elif nodeName_ == 'guardianOrganization':
            obj_ = POCD_MT000040_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.guardianOrganization = obj_
            obj_.original_tagname_ = 'guardianOrganization'
# end class POCD_MT000040_Guardian


class POCD_MT000040_HealthCareFacility(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClassServiceDeliveryLocation' = 'SDLOC', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, location: 'POCD_MT000040.Place' = None, serviceProviderOrganization: 'POCD_MT000040.Organization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.location = location
        self.location_nsprefix_ = None
        self.serviceProviderOrganization = serviceProviderOrganization
        self.serviceProviderOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_HealthCareFacility)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_HealthCareFacility.subclass:
            return POCD_MT000040_HealthCareFacility.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_HealthCareFacility(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_location(self):
        return self.location
    def set_location(self, location):
        self.location = location
    def get_serviceProviderOrganization(self):
        return self.serviceProviderOrganization
    def set_serviceProviderOrganization(self, serviceProviderOrganization):
        self.serviceProviderOrganization = serviceProviderOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_RoleClassServiceDeliveryLocation(self, value):
        # Validate type RoleClassServiceDeliveryLocation, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['SDLOC', 'DSDLOC', 'ISDLOC']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on RoleClassServiceDeliveryLocation' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RoleClassServiceDeliveryLocation_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RoleClassServiceDeliveryLocation_patterns_, ))
    validate_RoleClassServiceDeliveryLocation_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.location is not None or
            self.serviceProviderOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.HealthCareFacility', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.HealthCareFacility')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.HealthCareFacility':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.HealthCareFacility')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.HealthCareFacility', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.HealthCareFacility'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "SDLOC" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.HealthCareFacility', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.location is not None:
            namespaceprefix_ = self.location_nsprefix_ + ':' if (UseCapturedNS_ and self.location_nsprefix_) else ''
            self.location.export(outfile, level, namespaceprefix_, namespacedef_='', name_='location', pretty_print=pretty_print)
        if self.serviceProviderOrganization is not None:
            namespaceprefix_ = self.serviceProviderOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.serviceProviderOrganization_nsprefix_) else ''
            self.serviceProviderOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='serviceProviderOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClassServiceDeliveryLocation(self.classCode)    # validate type RoleClassServiceDeliveryLocation
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'location':
            obj_ = POCD_MT000040_Place.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.location = obj_
            obj_.original_tagname_ = 'location'
        elif nodeName_ == 'serviceProviderOrganization':
            obj_ = POCD_MT000040_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.serviceProviderOrganization = obj_
            obj_.original_tagname_ = 'serviceProviderOrganization'
# end class POCD_MT000040_HealthCareFacility


class POCD_MT000040_Informant12(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'INF', contextControlCode: 'ContextControl' = 'OP', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, assignedEntity: 'POCD_MT000040.AssignedEntity' = None, relatedEntity: 'POCD_MT000040.RelatedEntity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextControlCode = _cast(None, contextControlCode)
        self.contextControlCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.assignedEntity = assignedEntity
        self.assignedEntity_nsprefix_ = None
        self.relatedEntity = relatedEntity
        self.relatedEntity_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Informant12)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Informant12.subclass:
            return POCD_MT000040_Informant12.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Informant12(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_assignedEntity(self):
        return self.assignedEntity
    def set_assignedEntity(self, assignedEntity):
        self.assignedEntity = assignedEntity
    def get_relatedEntity(self):
        return self.relatedEntity
    def set_relatedEntity(self, relatedEntity):
        self.relatedEntity = relatedEntity
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def get_contextControlCode(self):
        return self.contextControlCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        pass
    def validate_ContextControl(self, value):
        # Validate type ContextControl, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.assignedEntity is not None or
            self.relatedEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Informant12', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Informant12')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Informant12':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Informant12')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Informant12', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Informant12'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextControlCode is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            outfile.write(' contextControlCode=%s' % (quote_attrib(self.contextControlCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Informant12', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.assignedEntity is not None:
            namespaceprefix_ = self.assignedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedEntity_nsprefix_) else ''
            self.assignedEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedEntity', pretty_print=pretty_print)
        if self.relatedEntity is not None:
            namespaceprefix_ = self.relatedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.relatedEntity_nsprefix_) else ''
            self.relatedEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='relatedEntity', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
        value = find_attr_value_('contextControlCode', node)
        if value is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            self.contextControlCode = value
            self.validate_ContextControl(self.contextControlCode)    # validate type ContextControl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'assignedEntity':
            obj_ = POCD_MT000040_AssignedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedEntity = obj_
            obj_.original_tagname_ = 'assignedEntity'
        elif nodeName_ == 'relatedEntity':
            obj_ = POCD_MT000040_RelatedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.relatedEntity = obj_
            obj_.original_tagname_ = 'relatedEntity'
# end class POCD_MT000040_Informant12


class POCD_MT000040_InformationRecipient(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'x_InformationRecipient' = 'PRCP', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, intendedRecipient: 'POCD_MT000040.IntendedRecipient' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.intendedRecipient = intendedRecipient
        self.intendedRecipient_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_InformationRecipient)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_InformationRecipient.subclass:
            return POCD_MT000040_InformationRecipient.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_InformationRecipient(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_intendedRecipient(self):
        return self.intendedRecipient
    def set_intendedRecipient(self, intendedRecipient):
        self.intendedRecipient = intendedRecipient
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_x_InformationRecipient(self, value):
        # Validate type x_InformationRecipient, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['PRCP', 'TRC']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_InformationRecipient' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_InformationRecipient_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_InformationRecipient_patterns_, ))
    validate_x_InformationRecipient_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.intendedRecipient is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.InformationRecipient', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.InformationRecipient')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.InformationRecipient':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.InformationRecipient')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.InformationRecipient', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.InformationRecipient'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode != "PRCP" and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.InformationRecipient', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.intendedRecipient is not None:
            namespaceprefix_ = self.intendedRecipient_nsprefix_ + ':' if (UseCapturedNS_ and self.intendedRecipient_nsprefix_) else ''
            self.intendedRecipient.export(outfile, level, namespaceprefix_, namespacedef_='', name_='intendedRecipient', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_x_InformationRecipient(self.typeCode)    # validate type x_InformationRecipient
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'intendedRecipient':
            obj_ = POCD_MT000040_IntendedRecipient.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.intendedRecipient = obj_
            obj_.original_tagname_ = 'intendedRecipient'
# end class POCD_MT000040_InformationRecipient


class POCD_MT000040_InFulfillmentOf(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ActRelationshipFulfills' = 'FLFS', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, order: 'POCD_MT000040.Order' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.order = order
        self.order_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_InFulfillmentOf)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_InFulfillmentOf.subclass:
            return POCD_MT000040_InFulfillmentOf.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_InFulfillmentOf(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_order(self):
        return self.order
    def set_order(self, order):
        self.order = order
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActRelationshipFulfills(self, value):
        # Validate type ActRelationshipFulfills, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['FLFS', 'OCCR', 'OREF', 'SCH']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActRelationshipFulfills' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActRelationshipFulfills_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActRelationshipFulfills_patterns_, ))
    validate_ActRelationshipFulfills_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.order is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.InFulfillmentOf', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.InFulfillmentOf')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.InFulfillmentOf':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.InFulfillmentOf')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.InFulfillmentOf', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.InFulfillmentOf'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.InFulfillmentOf', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.order is not None:
            namespaceprefix_ = self.order_nsprefix_ + ':' if (UseCapturedNS_ and self.order_nsprefix_) else ''
            self.order.export(outfile, level, namespaceprefix_, namespacedef_='', name_='order', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ActRelationshipFulfills(self.typeCode)    # validate type ActRelationshipFulfills
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'order':
            obj_ = POCD_MT000040_Order.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.order = obj_
            obj_.original_tagname_ = 'order'
# end class POCD_MT000040_InFulfillmentOf


class POCD_MT000040_IntendedRecipient(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'x_InformationRecipientRole' = 'ASSIGNED', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, addr: List_['AD'] = None, telecom: List_['TEL'] = None, informationRecipient: 'POCD_MT000040.Person' = None, receivedOrganization: 'POCD_MT000040.Organization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        if addr is None:
            self.addr = []
        else:
            self.addr = addr
        self.addr_nsprefix_ = None
        if telecom is None:
            self.telecom = []
        else:
            self.telecom = telecom
        self.telecom_nsprefix_ = None
        self.informationRecipient = informationRecipient
        self.informationRecipient_nsprefix_ = None
        self.receivedOrganization = receivedOrganization
        self.receivedOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_IntendedRecipient)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_IntendedRecipient.subclass:
            return POCD_MT000040_IntendedRecipient.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_IntendedRecipient(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_addr(self):
        return self.addr
    def set_addr(self, addr):
        self.addr = addr
    def add_addr(self, value):
        self.addr.append(value)
    def insert_addr_at(self, index, value):
        self.addr.insert(index, value)
    def replace_addr_at(self, index, value):
        self.addr[index] = value
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def add_telecom(self, value):
        self.telecom.append(value)
    def insert_telecom_at(self, index, value):
        self.telecom.insert(index, value)
    def replace_telecom_at(self, index, value):
        self.telecom[index] = value
    def get_informationRecipient(self):
        return self.informationRecipient
    def set_informationRecipient(self, informationRecipient):
        self.informationRecipient = informationRecipient
    def get_receivedOrganization(self):
        return self.receivedOrganization
    def set_receivedOrganization(self, receivedOrganization):
        self.receivedOrganization = receivedOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_x_InformationRecipientRole(self, value):
        # Validate type x_InformationRecipientRole, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ASSIGNED', 'HLTHCHRT']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_InformationRecipientRole' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_InformationRecipientRole_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_InformationRecipientRole_patterns_, ))
    validate_x_InformationRecipientRole_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.addr or
            self.telecom or
            self.informationRecipient is not None or
            self.receivedOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.IntendedRecipient', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.IntendedRecipient')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.IntendedRecipient':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.IntendedRecipient')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.IntendedRecipient', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.IntendedRecipient'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ASSIGNED" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.IntendedRecipient', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        for addr_ in self.addr:
            namespaceprefix_ = self.addr_nsprefix_ + ':' if (UseCapturedNS_ and self.addr_nsprefix_) else ''
            addr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addr', pretty_print=pretty_print)
        for telecom_ in self.telecom:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            telecom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
        if self.informationRecipient is not None:
            namespaceprefix_ = self.informationRecipient_nsprefix_ + ':' if (UseCapturedNS_ and self.informationRecipient_nsprefix_) else ''
            self.informationRecipient.export(outfile, level, namespaceprefix_, namespacedef_='', name_='informationRecipient', pretty_print=pretty_print)
        if self.receivedOrganization is not None:
            namespaceprefix_ = self.receivedOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.receivedOrganization_nsprefix_) else ''
            self.receivedOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='receivedOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_x_InformationRecipientRole(self.classCode)    # validate type x_InformationRecipientRole
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'addr':
            obj_ = AD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addr.append(obj_)
            obj_.original_tagname_ = 'addr'
        elif nodeName_ == 'telecom':
            obj_ = TEL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom.append(obj_)
            obj_.original_tagname_ = 'telecom'
        elif nodeName_ == 'informationRecipient':
            obj_ = POCD_MT000040_Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.informationRecipient = obj_
            obj_.original_tagname_ = 'informationRecipient'
        elif nodeName_ == 'receivedOrganization':
            obj_ = POCD_MT000040_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.receivedOrganization = obj_
            obj_.original_tagname_ = 'receivedOrganization'
# end class POCD_MT000040_IntendedRecipient


class POCD_MT000040_LabeledDrug(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'EntityClassManufacturedMaterial' = 'MMAT', determinerCode: 'EntityDeterminerDetermined' = 'KIND', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, code: 'CE' = None, name: 'EN' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.determinerCode = _cast(None, determinerCode)
        self.determinerCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_LabeledDrug)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_LabeledDrug.subclass:
            return POCD_MT000040_LabeledDrug.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_LabeledDrug(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def get_determinerCode(self):
        return self.determinerCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_EntityClassManufacturedMaterial(self, value):
        # Validate type EntityClassManufacturedMaterial, a restriction on cs.
        pass
    def validate_EntityDeterminerDetermined(self, value):
        # Validate type EntityDeterminerDetermined, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['KIND', 'QUANTIFIED_KIND']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityDeterminerDetermined' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityDeterminerDetermined_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityDeterminerDetermined_patterns_, ))
    validate_EntityDeterminerDetermined_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.code is not None or
            self.name is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.LabeledDrug', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.LabeledDrug')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.LabeledDrug':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.LabeledDrug')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.LabeledDrug', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.LabeledDrug'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.determinerCode is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            outfile.write(' determinerCode=%s' % (quote_attrib(self.determinerCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.LabeledDrug', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_EntityClassManufacturedMaterial(self.classCode)    # validate type EntityClassManufacturedMaterial
        value = find_attr_value_('determinerCode', node)
        if value is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            self.determinerCode = value
            self.determinerCode = ' '.join(self.determinerCode.split())
            self.validate_EntityDeterminerDetermined(self.determinerCode)    # validate type EntityDeterminerDetermined
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'name':
            class_obj_ = self.get_class_obj_(child_, EN)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
# end class POCD_MT000040_LabeledDrug


class POCD_MT000040_LanguageCommunication(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, languageCode: 'CS' = None, modeCode: 'CE' = None, proficiencyLevelCode: 'CE' = None, preferenceInd: 'BL' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.languageCode = languageCode
        self.languageCode_nsprefix_ = None
        self.modeCode = modeCode
        self.modeCode_nsprefix_ = None
        self.proficiencyLevelCode = proficiencyLevelCode
        self.proficiencyLevelCode_nsprefix_ = None
        self.preferenceInd = preferenceInd
        self.preferenceInd_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_LanguageCommunication)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_LanguageCommunication.subclass:
            return POCD_MT000040_LanguageCommunication.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_LanguageCommunication(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_languageCode(self):
        return self.languageCode
    def set_languageCode(self, languageCode):
        self.languageCode = languageCode
    def get_modeCode(self):
        return self.modeCode
    def set_modeCode(self, modeCode):
        self.modeCode = modeCode
    def get_proficiencyLevelCode(self):
        return self.proficiencyLevelCode
    def set_proficiencyLevelCode(self, proficiencyLevelCode):
        self.proficiencyLevelCode = proficiencyLevelCode
    def get_preferenceInd(self):
        return self.preferenceInd
    def set_preferenceInd(self, preferenceInd):
        self.preferenceInd = preferenceInd
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.languageCode is not None or
            self.modeCode is not None or
            self.proficiencyLevelCode is not None or
            self.preferenceInd is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.LanguageCommunication', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.LanguageCommunication')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.LanguageCommunication':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.LanguageCommunication')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.LanguageCommunication', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.LanguageCommunication'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.LanguageCommunication', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.languageCode is not None:
            namespaceprefix_ = self.languageCode_nsprefix_ + ':' if (UseCapturedNS_ and self.languageCode_nsprefix_) else ''
            self.languageCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='languageCode', pretty_print=pretty_print)
        if self.modeCode is not None:
            namespaceprefix_ = self.modeCode_nsprefix_ + ':' if (UseCapturedNS_ and self.modeCode_nsprefix_) else ''
            self.modeCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='modeCode', pretty_print=pretty_print)
        if self.proficiencyLevelCode is not None:
            namespaceprefix_ = self.proficiencyLevelCode_nsprefix_ + ':' if (UseCapturedNS_ and self.proficiencyLevelCode_nsprefix_) else ''
            self.proficiencyLevelCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='proficiencyLevelCode', pretty_print=pretty_print)
        if self.preferenceInd is not None:
            namespaceprefix_ = self.preferenceInd_nsprefix_ + ':' if (UseCapturedNS_ and self.preferenceInd_nsprefix_) else ''
            self.preferenceInd.export(outfile, level, namespaceprefix_, namespacedef_='', name_='preferenceInd', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'languageCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.languageCode = obj_
            obj_.original_tagname_ = 'languageCode'
        elif nodeName_ == 'modeCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.modeCode = obj_
            obj_.original_tagname_ = 'modeCode'
        elif nodeName_ == 'proficiencyLevelCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.proficiencyLevelCode = obj_
            obj_.original_tagname_ = 'proficiencyLevelCode'
        elif nodeName_ == 'preferenceInd':
            obj_ = BL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.preferenceInd = obj_
            obj_.original_tagname_ = 'preferenceInd'
# end class POCD_MT000040_LanguageCommunication


class POCD_MT000040_LegalAuthenticator(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ID: 'xs_string' = None, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = 'LA', contextControlCode: 'ContextControl' = 'OP', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, time: 'TS' = None, signatureCode: 'CS' = None, signatureText: 'ED' = None, assignedEntity: 'POCD_MT000040.AssignedEntity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ID = _cast(None, ID)
        self.ID_nsprefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextControlCode = _cast(None, contextControlCode)
        self.contextControlCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.time = time
        self.time_nsprefix_ = None
        self.signatureCode = signatureCode
        self.signatureCode_nsprefix_ = None
        self.signatureText = signatureText
        self.signatureText_nsprefix_ = "sdtc"
        self.assignedEntity = assignedEntity
        self.assignedEntity_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_LegalAuthenticator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_LegalAuthenticator.subclass:
            return POCD_MT000040_LegalAuthenticator.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_LegalAuthenticator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_signatureCode(self):
        return self.signatureCode
    def set_signatureCode(self, signatureCode):
        self.signatureCode = signatureCode
    def get_signatureText(self):
        return self.signatureText
    def set_signatureText(self, signatureText):
        self.signatureText = signatureText
    def get_assignedEntity(self):
        return self.assignedEntity
    def set_assignedEntity(self, assignedEntity):
        self.assignedEntity = assignedEntity
    def get_ID(self):
        return self.ID
    def set_ID(self, ID):
        self.ID = ID
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def get_contextControlCode(self):
        return self.contextControlCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        pass
    def validate_ContextControl(self, value):
        # Validate type ContextControl, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.time is not None or
            self.signatureCode is not None or
            self.signatureText is not None or
            self.assignedEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.LegalAuthenticator', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.LegalAuthenticator')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.LegalAuthenticator':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.LegalAuthenticator')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.LegalAuthenticator', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.LegalAuthenticator'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextControlCode is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            outfile.write(' contextControlCode=%s' % (quote_attrib(self.contextControlCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.LegalAuthenticator', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            self.time.export(outfile, level, namespaceprefix_, namespacedef_='', name_='time', pretty_print=pretty_print)
        if self.signatureCode is not None:
            namespaceprefix_ = self.signatureCode_nsprefix_ + ':' if (UseCapturedNS_ and self.signatureCode_nsprefix_) else ''
            self.signatureCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='signatureCode', pretty_print=pretty_print)
        if self.signatureText is not None:
            namespaceprefix_ = self.signatureText_nsprefix_ + ':' if (UseCapturedNS_ and self.signatureText_nsprefix_) else ''
            self.signatureText.export(outfile, level, namespaceprefix_='sdtc:', namespacedef_='', name_='signatureText', pretty_print=pretty_print)
        if self.assignedEntity is not None:
            namespaceprefix_ = self.assignedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.assignedEntity_nsprefix_) else ''
            self.assignedEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assignedEntity', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
        value = find_attr_value_('contextControlCode', node)
        if value is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            self.contextControlCode = value
            self.validate_ContextControl(self.contextControlCode)    # validate type ContextControl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'time':
            class_obj_ = self.get_class_obj_(child_, TS)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'signatureCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.signatureCode = obj_
            obj_.original_tagname_ = 'signatureCode'
        elif nodeName_ == 'signatureText':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.signatureText = obj_
            obj_.original_tagname_ = 'signatureText'
        elif nodeName_ == 'assignedEntity':
            obj_ = POCD_MT000040_AssignedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assignedEntity = obj_
            obj_.original_tagname_ = 'assignedEntity'
# end class POCD_MT000040_LegalAuthenticator


class POCD_MT000040_Location(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationTargetLocation' = 'LOC', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, healthCareFacility: 'POCD_MT000040.HealthCareFacility' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.healthCareFacility = healthCareFacility
        self.healthCareFacility_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Location)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Location.subclass:
            return POCD_MT000040_Location.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Location(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_healthCareFacility(self):
        return self.healthCareFacility
    def set_healthCareFacility(self, healthCareFacility):
        self.healthCareFacility = healthCareFacility
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ParticipationTargetLocation(self, value):
        # Validate type ParticipationTargetLocation, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['LOC', 'DST', 'ELOC', 'ORG', 'RML', 'VIA']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ParticipationTargetLocation' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipationTargetLocation_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ParticipationTargetLocation_patterns_, ))
    validate_ParticipationTargetLocation_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.healthCareFacility is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Location', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Location')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Location':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Location')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Location', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Location'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Location', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.healthCareFacility is not None:
            namespaceprefix_ = self.healthCareFacility_nsprefix_ + ':' if (UseCapturedNS_ and self.healthCareFacility_nsprefix_) else ''
            self.healthCareFacility.export(outfile, level, namespaceprefix_, namespacedef_='', name_='healthCareFacility', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationTargetLocation(self.typeCode)    # validate type ParticipationTargetLocation
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'healthCareFacility':
            obj_ = POCD_MT000040_HealthCareFacility.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.healthCareFacility = obj_
            obj_.original_tagname_ = 'healthCareFacility'
# end class POCD_MT000040_Location


class POCD_MT000040_MaintainedEntity(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClass' = 'MNT', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, effectiveTime: 'IVL_TS' = None, maintainingPerson: 'POCD_MT000040.Person' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.effectiveTime = effectiveTime
        self.effectiveTime_nsprefix_ = None
        self.maintainingPerson = maintainingPerson
        self.maintainingPerson_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_MaintainedEntity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_MaintainedEntity.subclass:
            return POCD_MT000040_MaintainedEntity.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_MaintainedEntity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_effectiveTime(self):
        return self.effectiveTime
    def set_effectiveTime(self, effectiveTime):
        self.effectiveTime = effectiveTime
    def get_maintainingPerson(self):
        return self.maintainingPerson
    def set_maintainingPerson(self, maintainingPerson):
        self.maintainingPerson = maintainingPerson
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_RoleClass(self, value):
        # Validate type RoleClass, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.effectiveTime is not None or
            self.maintainingPerson is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.MaintainedEntity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.MaintainedEntity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.MaintainedEntity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.MaintainedEntity')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.MaintainedEntity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.MaintainedEntity'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.MaintainedEntity', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            namespaceprefix_ = self.effectiveTime_nsprefix_ + ':' if (UseCapturedNS_ and self.effectiveTime_nsprefix_) else ''
            self.effectiveTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='effectiveTime', pretty_print=pretty_print)
        if self.maintainingPerson is not None:
            namespaceprefix_ = self.maintainingPerson_nsprefix_ + ':' if (UseCapturedNS_ and self.maintainingPerson_nsprefix_) else ''
            self.maintainingPerson.export(outfile, level, namespaceprefix_, namespacedef_='', name_='maintainingPerson', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_RoleClass(self.classCode)    # validate type RoleClass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'maintainingPerson':
            obj_ = POCD_MT000040_Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.maintainingPerson = obj_
            obj_.original_tagname_ = 'maintainingPerson'
# end class POCD_MT000040_MaintainedEntity


class POCD_MT000040_ManufacturedProduct(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClassManufacturedProduct' = 'MANU', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, manufacturedLabeledDrug: 'POCD_MT000040.LabeledDrug' = None, manufacturedMaterial: 'POCD_MT000040.Material' = None, manufacturerOrganization: 'POCD_MT000040.Organization' = None, subjectOf1: List_['COCT_MT230100UV.Subject2'] = None, subjectOf2: List_['COCT_MT230100UV.Subject1'] = None, subjectOf3: List_['COCT_MT230100UV.Subject22'] = None, subjectOf4: List_['COCT_MT230100UV.Subject3'] = None, subjectOf5: 'COCT_MT230100UV.Subject7' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.manufacturedLabeledDrug = manufacturedLabeledDrug
        self.manufacturedLabeledDrug_nsprefix_ = None
        self.manufacturedMaterial = manufacturedMaterial
        self.manufacturedMaterial_nsprefix_ = None
        self.manufacturerOrganization = manufacturerOrganization
        self.manufacturerOrganization_nsprefix_ = None
        if subjectOf1 is None:
            self.subjectOf1 = []
        else:
            self.subjectOf1 = subjectOf1
        self.subjectOf1_nsprefix_ = "pharm"
        if subjectOf2 is None:
            self.subjectOf2 = []
        else:
            self.subjectOf2 = subjectOf2
        self.subjectOf2_nsprefix_ = "pharm"
        if subjectOf3 is None:
            self.subjectOf3 = []
        else:
            self.subjectOf3 = subjectOf3
        self.subjectOf3_nsprefix_ = "pharm"
        if subjectOf4 is None:
            self.subjectOf4 = []
        else:
            self.subjectOf4 = subjectOf4
        self.subjectOf4_nsprefix_ = "pharm"
        self.subjectOf5 = subjectOf5
        self.subjectOf5_nsprefix_ = "pharm"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_ManufacturedProduct)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_ManufacturedProduct.subclass:
            return POCD_MT000040_ManufacturedProduct.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_ManufacturedProduct(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_manufacturedLabeledDrug(self):
        return self.manufacturedLabeledDrug
    def set_manufacturedLabeledDrug(self, manufacturedLabeledDrug):
        self.manufacturedLabeledDrug = manufacturedLabeledDrug
    def get_manufacturedMaterial(self):
        return self.manufacturedMaterial
    def set_manufacturedMaterial(self, manufacturedMaterial):
        self.manufacturedMaterial = manufacturedMaterial
    def get_manufacturerOrganization(self):
        return self.manufacturerOrganization
    def set_manufacturerOrganization(self, manufacturerOrganization):
        self.manufacturerOrganization = manufacturerOrganization
    def get_subjectOf1(self):
        return self.subjectOf1
    def set_subjectOf1(self, subjectOf1):
        self.subjectOf1 = subjectOf1
    def add_subjectOf1(self, value):
        self.subjectOf1.append(value)
    def insert_subjectOf1_at(self, index, value):
        self.subjectOf1.insert(index, value)
    def replace_subjectOf1_at(self, index, value):
        self.subjectOf1[index] = value
    def get_subjectOf2(self):
        return self.subjectOf2
    def set_subjectOf2(self, subjectOf2):
        self.subjectOf2 = subjectOf2
    def add_subjectOf2(self, value):
        self.subjectOf2.append(value)
    def insert_subjectOf2_at(self, index, value):
        self.subjectOf2.insert(index, value)
    def replace_subjectOf2_at(self, index, value):
        self.subjectOf2[index] = value
    def get_subjectOf3(self):
        return self.subjectOf3
    def set_subjectOf3(self, subjectOf3):
        self.subjectOf3 = subjectOf3
    def add_subjectOf3(self, value):
        self.subjectOf3.append(value)
    def insert_subjectOf3_at(self, index, value):
        self.subjectOf3.insert(index, value)
    def replace_subjectOf3_at(self, index, value):
        self.subjectOf3[index] = value
    def get_subjectOf4(self):
        return self.subjectOf4
    def set_subjectOf4(self, subjectOf4):
        self.subjectOf4 = subjectOf4
    def add_subjectOf4(self, value):
        self.subjectOf4.append(value)
    def insert_subjectOf4_at(self, index, value):
        self.subjectOf4.insert(index, value)
    def replace_subjectOf4_at(self, index, value):
        self.subjectOf4[index] = value
    def get_subjectOf5(self):
        return self.subjectOf5
    def set_subjectOf5(self, subjectOf5):
        self.subjectOf5 = subjectOf5
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_RoleClassManufacturedProduct(self, value):
        # Validate type RoleClassManufacturedProduct, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['MANU', 'THER']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on RoleClassManufacturedProduct' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RoleClassManufacturedProduct_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RoleClassManufacturedProduct_patterns_, ))
    validate_RoleClassManufacturedProduct_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.manufacturedLabeledDrug is not None or
            self.manufacturedMaterial is not None or
            self.manufacturerOrganization is not None or
            self.subjectOf1 or
            self.subjectOf2 or
            self.subjectOf3 or
            self.subjectOf4 or
            self.subjectOf5 is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:pharm="urn:ihe:pharm:medication" ', name_='POCD_MT000040.ManufacturedProduct', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.ManufacturedProduct')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.ManufacturedProduct':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.ManufacturedProduct')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.ManufacturedProduct', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.ManufacturedProduct'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:pharm="urn:ihe:pharm:medication" ', name_='POCD_MT000040.ManufacturedProduct', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.manufacturedLabeledDrug is not None:
            namespaceprefix_ = self.manufacturedLabeledDrug_nsprefix_ + ':' if (UseCapturedNS_ and self.manufacturedLabeledDrug_nsprefix_) else ''
            self.manufacturedLabeledDrug.export(outfile, level, namespaceprefix_, namespacedef_='', name_='manufacturedLabeledDrug', pretty_print=pretty_print)
        if self.manufacturedMaterial is not None:
            namespaceprefix_ = self.manufacturedMaterial_nsprefix_ + ':' if (UseCapturedNS_ and self.manufacturedMaterial_nsprefix_) else ''
            self.manufacturedMaterial.export(outfile, level, namespaceprefix_, namespacedef_='', name_='manufacturedMaterial', pretty_print=pretty_print)
        if self.manufacturerOrganization is not None:
            namespaceprefix_ = self.manufacturerOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.manufacturerOrganization_nsprefix_) else ''
            self.manufacturerOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='manufacturerOrganization', pretty_print=pretty_print)
        for subjectOf1_ in self.subjectOf1:
            namespaceprefix_ = self.subjectOf1_nsprefix_ + ':' if (UseCapturedNS_ and self.subjectOf1_nsprefix_) else ''
            subjectOf1_.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='subjectOf1', pretty_print=pretty_print)
        for subjectOf2_ in self.subjectOf2:
            namespaceprefix_ = self.subjectOf2_nsprefix_ + ':' if (UseCapturedNS_ and self.subjectOf2_nsprefix_) else ''
            subjectOf2_.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='subjectOf2', pretty_print=pretty_print)
        for subjectOf3_ in self.subjectOf3:
            namespaceprefix_ = self.subjectOf3_nsprefix_ + ':' if (UseCapturedNS_ and self.subjectOf3_nsprefix_) else ''
            subjectOf3_.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='subjectOf3', pretty_print=pretty_print)
        for subjectOf4_ in self.subjectOf4:
            namespaceprefix_ = self.subjectOf4_nsprefix_ + ':' if (UseCapturedNS_ and self.subjectOf4_nsprefix_) else ''
            subjectOf4_.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='subjectOf4', pretty_print=pretty_print)
        if self.subjectOf5 is not None:
            namespaceprefix_ = self.subjectOf5_nsprefix_ + ':' if (UseCapturedNS_ and self.subjectOf5_nsprefix_) else ''
            self.subjectOf5.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='subjectOf5', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClassManufacturedProduct(self.classCode)    # validate type RoleClassManufacturedProduct
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'manufacturedLabeledDrug':
            obj_ = POCD_MT000040_LabeledDrug.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.manufacturedLabeledDrug = obj_
            obj_.original_tagname_ = 'manufacturedLabeledDrug'
        elif nodeName_ == 'manufacturedMaterial':
            obj_ = POCD_MT000040_Material.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.manufacturedMaterial = obj_
            obj_.original_tagname_ = 'manufacturedMaterial'
        elif nodeName_ == 'manufacturerOrganization':
            obj_ = POCD_MT000040_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.manufacturerOrganization = obj_
            obj_.original_tagname_ = 'manufacturerOrganization'
        elif nodeName_ == 'subjectOf1':
            obj_ = COCT_MT230100UV_Subject2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subjectOf1.append(obj_)
            obj_.original_tagname_ = 'subjectOf1'
        elif nodeName_ == 'subjectOf2':
            obj_ = COCT_MT230100UV_Subject1.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subjectOf2.append(obj_)
            obj_.original_tagname_ = 'subjectOf2'
        elif nodeName_ == 'subjectOf3':
            obj_ = COCT_MT230100UV_Subject22.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subjectOf3.append(obj_)
            obj_.original_tagname_ = 'subjectOf3'
        elif nodeName_ == 'subjectOf4':
            obj_ = COCT_MT230100UV_Subject3.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subjectOf4.append(obj_)
            obj_.original_tagname_ = 'subjectOf4'
        elif nodeName_ == 'subjectOf5':
            obj_ = COCT_MT230100UV_Subject7.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subjectOf5 = obj_
            obj_.original_tagname_ = 'subjectOf5'
# end class POCD_MT000040_ManufacturedProduct


class POCD_MT000040_Material(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'EntityClassManufacturedMaterial' = 'MMAT', determinerCode: 'EntityDeterminerDetermined' = 'KIND', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, code: 'CE' = None, name: 'EN' = None, desc: 'ED' = None, riskCode: 'CE' = None, handlingCode: 'CE' = None, formCode: 'CE' = None, lotNumberText: 'ST' = None, expirationTime: 'IVL_TS' = None, stabilityTime: 'IVL_TS' = None, asDistributedProduct: List_['COCT_MT230100UV.DistributedProduct'] = None, asMedicineManufacturer: List_['COCT_MT230100UV.MedicineManufacturer'] = None, asContent: 'COCT_MT230100UV.Content' = None, asSpecializedKind: List_['COCT_MT230100UV.SpecializedKind'] = None, part: List_['COCT_MT230100UV.Part'] = None, ingredient: List_['COCT_MT230100UV.Ingredient'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.determinerCode = _cast(None, determinerCode)
        self.determinerCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.desc = desc
        self.desc_nsprefix_ = "pharm"
        self.riskCode = riskCode
        self.riskCode_nsprefix_ = "pharm"
        self.handlingCode = handlingCode
        self.handlingCode_nsprefix_ = "pharm"
        self.formCode = formCode
        self.formCode_nsprefix_ = "pharm"
        self.lotNumberText = lotNumberText
        self.lotNumberText_nsprefix_ = None
        self.expirationTime = expirationTime
        self.expirationTime_nsprefix_ = "pharm"
        self.stabilityTime = stabilityTime
        self.stabilityTime_nsprefix_ = "pharm"
        if asDistributedProduct is None:
            self.asDistributedProduct = []
        else:
            self.asDistributedProduct = asDistributedProduct
        self.asDistributedProduct_nsprefix_ = "pharm"
        if asMedicineManufacturer is None:
            self.asMedicineManufacturer = []
        else:
            self.asMedicineManufacturer = asMedicineManufacturer
        self.asMedicineManufacturer_nsprefix_ = "pharm"
        self.asContent = asContent
        self.asContent_nsprefix_ = "pharm"
        if asSpecializedKind is None:
            self.asSpecializedKind = []
        else:
            self.asSpecializedKind = asSpecializedKind
        self.asSpecializedKind_nsprefix_ = "pharm"
        if part is None:
            self.part = []
        else:
            self.part = part
        self.part_nsprefix_ = "pharm"
        if ingredient is None:
            self.ingredient = []
        else:
            self.ingredient = ingredient
        self.ingredient_nsprefix_ = "pharm"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Material)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Material.subclass:
            return POCD_MT000040_Material.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Material(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_desc(self):
        return self.desc
    def set_desc(self, desc):
        self.desc = desc
    def get_riskCode(self):
        return self.riskCode
    def set_riskCode(self, riskCode):
        self.riskCode = riskCode
    def get_handlingCode(self):
        return self.handlingCode
    def set_handlingCode(self, handlingCode):
        self.handlingCode = handlingCode
    def get_formCode(self):
        return self.formCode
    def set_formCode(self, formCode):
        self.formCode = formCode
    def get_lotNumberText(self):
        return self.lotNumberText
    def set_lotNumberText(self, lotNumberText):
        self.lotNumberText = lotNumberText
    def get_expirationTime(self):
        return self.expirationTime
    def set_expirationTime(self, expirationTime):
        self.expirationTime = expirationTime
    def get_stabilityTime(self):
        return self.stabilityTime
    def set_stabilityTime(self, stabilityTime):
        self.stabilityTime = stabilityTime
    def get_asDistributedProduct(self):
        return self.asDistributedProduct
    def set_asDistributedProduct(self, asDistributedProduct):
        self.asDistributedProduct = asDistributedProduct
    def add_asDistributedProduct(self, value):
        self.asDistributedProduct.append(value)
    def insert_asDistributedProduct_at(self, index, value):
        self.asDistributedProduct.insert(index, value)
    def replace_asDistributedProduct_at(self, index, value):
        self.asDistributedProduct[index] = value
    def get_asMedicineManufacturer(self):
        return self.asMedicineManufacturer
    def set_asMedicineManufacturer(self, asMedicineManufacturer):
        self.asMedicineManufacturer = asMedicineManufacturer
    def add_asMedicineManufacturer(self, value):
        self.asMedicineManufacturer.append(value)
    def insert_asMedicineManufacturer_at(self, index, value):
        self.asMedicineManufacturer.insert(index, value)
    def replace_asMedicineManufacturer_at(self, index, value):
        self.asMedicineManufacturer[index] = value
    def get_asContent(self):
        return self.asContent
    def set_asContent(self, asContent):
        self.asContent = asContent
    def get_asSpecializedKind(self):
        return self.asSpecializedKind
    def set_asSpecializedKind(self, asSpecializedKind):
        self.asSpecializedKind = asSpecializedKind
    def add_asSpecializedKind(self, value):
        self.asSpecializedKind.append(value)
    def insert_asSpecializedKind_at(self, index, value):
        self.asSpecializedKind.insert(index, value)
    def replace_asSpecializedKind_at(self, index, value):
        self.asSpecializedKind[index] = value
    def get_part(self):
        return self.part
    def set_part(self, part):
        self.part = part
    def add_part(self, value):
        self.part.append(value)
    def insert_part_at(self, index, value):
        self.part.insert(index, value)
    def replace_part_at(self, index, value):
        self.part[index] = value
    def get_ingredient(self):
        return self.ingredient
    def set_ingredient(self, ingredient):
        self.ingredient = ingredient
    def add_ingredient(self, value):
        self.ingredient.append(value)
    def insert_ingredient_at(self, index, value):
        self.ingredient.insert(index, value)
    def replace_ingredient_at(self, index, value):
        self.ingredient[index] = value
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def get_determinerCode(self):
        return self.determinerCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_EntityClassManufacturedMaterial(self, value):
        # Validate type EntityClassManufacturedMaterial, a restriction on cs.
        pass
    def validate_EntityDeterminerDetermined(self, value):
        # Validate type EntityDeterminerDetermined, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['KIND', 'QUANTIFIED_KIND']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EntityDeterminerDetermined' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EntityDeterminerDetermined_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EntityDeterminerDetermined_patterns_, ))
    validate_EntityDeterminerDetermined_patterns_ = [['^([^\\s]+)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.code is not None or
            self.name is not None or
            self.desc is not None or
            self.riskCode is not None or
            self.handlingCode is not None or
            self.formCode is not None or
            self.lotNumberText is not None or
            self.expirationTime is not None or
            self.stabilityTime is not None or
            self.asDistributedProduct or
            self.asMedicineManufacturer or
            self.asContent is not None or
            self.asSpecializedKind or
            self.part or
            self.ingredient
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:pharm="urn:ihe:pharm:medication" ', name_='POCD_MT000040.Material', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Material')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Material':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Material')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Material', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Material'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.determinerCode is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            outfile.write(' determinerCode=%s' % (quote_attrib(self.determinerCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:pharm="urn:ihe:pharm:medication" ', name_='POCD_MT000040.Material', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        if self.desc is not None:
            namespaceprefix_ = self.desc_nsprefix_ + ':' if (UseCapturedNS_ and self.desc_nsprefix_) else ''
            self.desc.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='desc', pretty_print=pretty_print)
        if self.riskCode is not None:
            namespaceprefix_ = self.riskCode_nsprefix_ + ':' if (UseCapturedNS_ and self.riskCode_nsprefix_) else ''
            self.riskCode.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='riskCode', pretty_print=pretty_print)
        if self.handlingCode is not None:
            namespaceprefix_ = self.handlingCode_nsprefix_ + ':' if (UseCapturedNS_ and self.handlingCode_nsprefix_) else ''
            self.handlingCode.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='handlingCode', pretty_print=pretty_print)
        if self.formCode is not None:
            namespaceprefix_ = self.formCode_nsprefix_ + ':' if (UseCapturedNS_ and self.formCode_nsprefix_) else ''
            self.formCode.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='formCode', pretty_print=pretty_print)
        if self.lotNumberText is not None:
            namespaceprefix_ = self.lotNumberText_nsprefix_ + ':' if (UseCapturedNS_ and self.lotNumberText_nsprefix_) else ''
            self.lotNumberText.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lotNumberText', pretty_print=pretty_print)
        if self.expirationTime is not None:
            namespaceprefix_ = self.expirationTime_nsprefix_ + ':' if (UseCapturedNS_ and self.expirationTime_nsprefix_) else ''
            self.expirationTime.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='expirationTime', pretty_print=pretty_print)
        if self.stabilityTime is not None:
            namespaceprefix_ = self.stabilityTime_nsprefix_ + ':' if (UseCapturedNS_ and self.stabilityTime_nsprefix_) else ''
            self.stabilityTime.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='stabilityTime', pretty_print=pretty_print)
        for asDistributedProduct_ in self.asDistributedProduct:
            namespaceprefix_ = self.asDistributedProduct_nsprefix_ + ':' if (UseCapturedNS_ and self.asDistributedProduct_nsprefix_) else ''
            asDistributedProduct_.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='asDistributedProduct', pretty_print=pretty_print)
        for asMedicineManufacturer_ in self.asMedicineManufacturer:
            namespaceprefix_ = self.asMedicineManufacturer_nsprefix_ + ':' if (UseCapturedNS_ and self.asMedicineManufacturer_nsprefix_) else ''
            asMedicineManufacturer_.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='asMedicineManufacturer', pretty_print=pretty_print)
        if self.asContent is not None:
            namespaceprefix_ = self.asContent_nsprefix_ + ':' if (UseCapturedNS_ and self.asContent_nsprefix_) else ''
            self.asContent.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='asContent', pretty_print=pretty_print)
        for asSpecializedKind_ in self.asSpecializedKind:
            namespaceprefix_ = self.asSpecializedKind_nsprefix_ + ':' if (UseCapturedNS_ and self.asSpecializedKind_nsprefix_) else ''
            asSpecializedKind_.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='asSpecializedKind', pretty_print=pretty_print)
        for part_ in self.part:
            namespaceprefix_ = self.part_nsprefix_ + ':' if (UseCapturedNS_ and self.part_nsprefix_) else ''
            part_.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='part', pretty_print=pretty_print)
        for ingredient_ in self.ingredient:
            namespaceprefix_ = self.ingredient_nsprefix_ + ':' if (UseCapturedNS_ and self.ingredient_nsprefix_) else ''
            ingredient_.export(outfile, level, namespaceprefix_='pharm:', namespacedef_='', name_='ingredient', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_EntityClassManufacturedMaterial(self.classCode)    # validate type EntityClassManufacturedMaterial
        value = find_attr_value_('determinerCode', node)
        if value is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            self.determinerCode = value
            self.determinerCode = ' '.join(self.determinerCode.split())
            self.validate_EntityDeterminerDetermined(self.determinerCode)    # validate type EntityDeterminerDetermined
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'name':
            class_obj_ = self.get_class_obj_(child_, EN)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'desc':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.desc = obj_
            obj_.original_tagname_ = 'desc'
        elif nodeName_ == 'riskCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.riskCode = obj_
            obj_.original_tagname_ = 'riskCode'
        elif nodeName_ == 'handlingCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.handlingCode = obj_
            obj_.original_tagname_ = 'handlingCode'
        elif nodeName_ == 'formCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.formCode = obj_
            obj_.original_tagname_ = 'formCode'
        elif nodeName_ == 'lotNumberText':
            class_obj_ = self.get_class_obj_(child_, ST)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.lotNumberText = obj_
            obj_.original_tagname_ = 'lotNumberText'
        elif nodeName_ == 'expirationTime':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.expirationTime = obj_
            obj_.original_tagname_ = 'expirationTime'
        elif nodeName_ == 'stabilityTime':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.stabilityTime = obj_
            obj_.original_tagname_ = 'stabilityTime'
        elif nodeName_ == 'asDistributedProduct':
            obj_ = COCT_MT230100UV_DistributedProduct.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.asDistributedProduct.append(obj_)
            obj_.original_tagname_ = 'asDistributedProduct'
        elif nodeName_ == 'asMedicineManufacturer':
            obj_ = COCT_MT230100UV_MedicineManufacturer.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.asMedicineManufacturer.append(obj_)
            obj_.original_tagname_ = 'asMedicineManufacturer'
        elif nodeName_ == 'asContent':
            obj_ = COCT_MT230100UV_Content.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.asContent = obj_
            obj_.original_tagname_ = 'asContent'
        elif nodeName_ == 'asSpecializedKind':
            obj_ = COCT_MT230100UV_SpecializedKind.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.asSpecializedKind.append(obj_)
            obj_.original_tagname_ = 'asSpecializedKind'
        elif nodeName_ == 'part':
            obj_ = COCT_MT230100UV_Part.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.part.append(obj_)
            obj_.original_tagname_ = 'part'
        elif nodeName_ == 'ingredient':
            obj_ = COCT_MT230100UV_Ingredient.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ingredient.append(obj_)
            obj_.original_tagname_ = 'ingredient'
# end class POCD_MT000040_Material


class POCD_MT000040_NonXMLBody(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClass' = 'DOCBODY', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, text: 'ED' = None, confidentialityCode: 'CE' = None, languageCode: 'CS' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.confidentialityCode = confidentialityCode
        self.confidentialityCode_nsprefix_ = None
        self.languageCode = languageCode
        self.languageCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_NonXMLBody)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_NonXMLBody.subclass:
            return POCD_MT000040_NonXMLBody.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_NonXMLBody(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_confidentialityCode(self):
        return self.confidentialityCode
    def set_confidentialityCode(self, confidentialityCode):
        self.confidentialityCode = confidentialityCode
    def get_languageCode(self):
        return self.languageCode
    def set_languageCode(self, languageCode):
        self.languageCode = languageCode
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def get_moodCode(self):
        return self.moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClass(self, value):
        # Validate type ActClass, a restriction on None.
        pass
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.text is not None or
            self.confidentialityCode is not None or
            self.languageCode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.NonXMLBody', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.NonXMLBody')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.NonXMLBody':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.NonXMLBody')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.NonXMLBody', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.NonXMLBody'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.NonXMLBody', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.confidentialityCode is not None:
            namespaceprefix_ = self.confidentialityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.confidentialityCode_nsprefix_) else ''
            self.confidentialityCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='confidentialityCode', pretty_print=pretty_print)
        if self.languageCode is not None:
            namespaceprefix_ = self.languageCode_nsprefix_ + ':' if (UseCapturedNS_ and self.languageCode_nsprefix_) else ''
            self.languageCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='languageCode', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_ActClass(self.classCode)    # validate type ActClass
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'confidentialityCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.confidentialityCode = obj_
            obj_.original_tagname_ = 'confidentialityCode'
        elif nodeName_ == 'languageCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.languageCode = obj_
            obj_.original_tagname_ = 'languageCode'
# end class POCD_MT000040_NonXMLBody


class POCD_MT000040_Observation(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClassObservation' = None, moodCode: 'x_ActMoodDocumentObservation' = None, negationInd: 'bl' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, derivationExpr: 'ST' = None, text: 'ED' = None, statusCode: 'CS' = None, effectiveTime: 'IVL_TS' = None, priorityCode: 'CE' = None, repeatNumber: 'IVL_INT' = None, languageCode: 'CS' = None, value: List_['ANY'] = None, interpretationCode: List_['CE'] = None, methodCode: List_['CE'] = None, targetSiteCode: List_['CD'] = None, subject: 'POCD_MT000040.Subject' = None, specimen: List_['POCD_MT000040.Specimen'] = None, performer: List_['POCD_MT000040.Performer2'] = None, author: List_['POCD_MT000040.Author'] = None, informant: List_['POCD_MT000040.Informant12'] = None, participant: List_['POCD_MT000040.Participant2'] = None, entryRelationship: List_['POCD_MT000040.EntryRelationship'] = None, reference: List_['POCD_MT000040.Reference'] = None, precondition: List_['POCD_MT000040.Precondition'] = None, referenceRange: List_['POCD_MT000040.ReferenceRange'] = None, inFulfillmentOf1: List_['InFulfillmentOf1'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        self.negationInd = _cast(bool, negationInd)
        self.negationInd_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.derivationExpr = derivationExpr
        self.derivationExpr_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.statusCode = statusCode
        self.statusCode_nsprefix_ = None
        self.effectiveTime = effectiveTime
        self.effectiveTime_nsprefix_ = None
        self.priorityCode = priorityCode
        self.priorityCode_nsprefix_ = None
        self.repeatNumber = repeatNumber
        self.repeatNumber_nsprefix_ = None
        self.languageCode = languageCode
        self.languageCode_nsprefix_ = None
        if value is None:
            self.value = []
        else:
            self.value = value
        self.value_nsprefix_ = None
        if interpretationCode is None:
            self.interpretationCode = []
        else:
            self.interpretationCode = interpretationCode
        self.interpretationCode_nsprefix_ = None
        if methodCode is None:
            self.methodCode = []
        else:
            self.methodCode = methodCode
        self.methodCode_nsprefix_ = None
        if targetSiteCode is None:
            self.targetSiteCode = []
        else:
            self.targetSiteCode = targetSiteCode
        self.targetSiteCode_nsprefix_ = None
        self.subject = subject
        self.subject_nsprefix_ = None
        if specimen is None:
            self.specimen = []
        else:
            self.specimen = specimen
        self.specimen_nsprefix_ = None
        if performer is None:
            self.performer = []
        else:
            self.performer = performer
        self.performer_nsprefix_ = None
        if author is None:
            self.author = []
        else:
            self.author = author
        self.author_nsprefix_ = None
        if informant is None:
            self.informant = []
        else:
            self.informant = informant
        self.informant_nsprefix_ = None
        if participant is None:
            self.participant = []
        else:
            self.participant = participant
        self.participant_nsprefix_ = None
        if entryRelationship is None:
            self.entryRelationship = []
        else:
            self.entryRelationship = entryRelationship
        self.entryRelationship_nsprefix_ = None
        if reference is None:
            self.reference = []
        else:
            self.reference = reference
        self.reference_nsprefix_ = None
        if precondition is None:
            self.precondition = []
        else:
            self.precondition = precondition
        self.precondition_nsprefix_ = None
        if referenceRange is None:
            self.referenceRange = []
        else:
            self.referenceRange = referenceRange
        self.referenceRange_nsprefix_ = None
        if inFulfillmentOf1 is None:
            self.inFulfillmentOf1 = []
        else:
            self.inFulfillmentOf1 = inFulfillmentOf1
        self.inFulfillmentOf1_nsprefix_ = "sdtc"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Observation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Observation.subclass:
            return POCD_MT000040_Observation.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Observation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_derivationExpr(self):
        return self.derivationExpr
    def set_derivationExpr(self, derivationExpr):
        self.derivationExpr = derivationExpr
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_statusCode(self):
        return self.statusCode
    def set_statusCode(self, statusCode):
        self.statusCode = statusCode
    def get_effectiveTime(self):
        return self.effectiveTime
    def set_effectiveTime(self, effectiveTime):
        self.effectiveTime = effectiveTime
    def get_priorityCode(self):
        return self.priorityCode
    def set_priorityCode(self, priorityCode):
        self.priorityCode = priorityCode
    def get_repeatNumber(self):
        return self.repeatNumber
    def set_repeatNumber(self, repeatNumber):
        self.repeatNumber = repeatNumber
    def get_languageCode(self):
        return self.languageCode
    def set_languageCode(self, languageCode):
        self.languageCode = languageCode
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def set_value_with_type(self, value):
        self.value = value
        value.original_tagname_ = 'value'
        value.extensiontype_ = value.__class__.__name__
    def add_value(self, value):
        self.value.append(value)
    def add_value_with_type(self, value):
        self.value.append(value)
        value.original_tagname_ = 'value'
        value.extensiontype_ = value.__class__.__name__
    def insert_value_at(self, index, value):
        self.value.insert(index, value)
    def replace_value_at(self, index, value):
        self.value[index] = value
    def get_interpretationCode(self):
        return self.interpretationCode
    def set_interpretationCode(self, interpretationCode):
        self.interpretationCode = interpretationCode
    def add_interpretationCode(self, value):
        self.interpretationCode.append(value)
    def insert_interpretationCode_at(self, index, value):
        self.interpretationCode.insert(index, value)
    def replace_interpretationCode_at(self, index, value):
        self.interpretationCode[index] = value
    def get_methodCode(self):
        return self.methodCode
    def set_methodCode(self, methodCode):
        self.methodCode = methodCode
    def add_methodCode(self, value):
        self.methodCode.append(value)
    def insert_methodCode_at(self, index, value):
        self.methodCode.insert(index, value)
    def replace_methodCode_at(self, index, value):
        self.methodCode[index] = value
    def get_targetSiteCode(self):
        return self.targetSiteCode
    def set_targetSiteCode(self, targetSiteCode):
        self.targetSiteCode = targetSiteCode
    def add_targetSiteCode(self, value):
        self.targetSiteCode.append(value)
    def insert_targetSiteCode_at(self, index, value):
        self.targetSiteCode.insert(index, value)
    def replace_targetSiteCode_at(self, index, value):
        self.targetSiteCode[index] = value
    def get_subject(self):
        return self.subject
    def set_subject(self, subject):
        self.subject = subject
    def get_specimen(self):
        return self.specimen
    def set_specimen(self, specimen):
        self.specimen = specimen
    def add_specimen(self, value):
        self.specimen.append(value)
    def insert_specimen_at(self, index, value):
        self.specimen.insert(index, value)
    def replace_specimen_at(self, index, value):
        self.specimen[index] = value
    def get_performer(self):
        return self.performer
    def set_performer(self, performer):
        self.performer = performer
    def add_performer(self, value):
        self.performer.append(value)
    def insert_performer_at(self, index, value):
        self.performer.insert(index, value)
    def replace_performer_at(self, index, value):
        self.performer[index] = value
    def get_author(self):
        return self.author
    def set_author(self, author):
        self.author = author
    def add_author(self, value):
        self.author.append(value)
    def insert_author_at(self, index, value):
        self.author.insert(index, value)
    def replace_author_at(self, index, value):
        self.author[index] = value
    def get_informant(self):
        return self.informant
    def set_informant(self, informant):
        self.informant = informant
    def add_informant(self, value):
        self.informant.append(value)
    def insert_informant_at(self, index, value):
        self.informant.insert(index, value)
    def replace_informant_at(self, index, value):
        self.informant[index] = value
    def get_participant(self):
        return self.participant
    def set_participant(self, participant):
        self.participant = participant
    def add_participant(self, value):
        self.participant.append(value)
    def insert_participant_at(self, index, value):
        self.participant.insert(index, value)
    def replace_participant_at(self, index, value):
        self.participant[index] = value
    def get_entryRelationship(self):
        return self.entryRelationship
    def set_entryRelationship(self, entryRelationship):
        self.entryRelationship = entryRelationship
    def add_entryRelationship(self, value):
        self.entryRelationship.append(value)
    def insert_entryRelationship_at(self, index, value):
        self.entryRelationship.insert(index, value)
    def replace_entryRelationship_at(self, index, value):
        self.entryRelationship[index] = value
    def get_reference(self):
        return self.reference
    def set_reference(self, reference):
        self.reference = reference
    def add_reference(self, value):
        self.reference.append(value)
    def insert_reference_at(self, index, value):
        self.reference.insert(index, value)
    def replace_reference_at(self, index, value):
        self.reference[index] = value
    def get_precondition(self):
        return self.precondition
    def set_precondition(self, precondition):
        self.precondition = precondition
    def add_precondition(self, value):
        self.precondition.append(value)
    def insert_precondition_at(self, index, value):
        self.precondition.insert(index, value)
    def replace_precondition_at(self, index, value):
        self.precondition[index] = value
    def get_referenceRange(self):
        return self.referenceRange
    def set_referenceRange(self, referenceRange):
        self.referenceRange = referenceRange
    def add_referenceRange(self, value):
        self.referenceRange.append(value)
    def insert_referenceRange_at(self, index, value):
        self.referenceRange.insert(index, value)
    def replace_referenceRange_at(self, index, value):
        self.referenceRange[index] = value
    def get_inFulfillmentOf1(self):
        return self.inFulfillmentOf1
    def set_inFulfillmentOf1(self, inFulfillmentOf1):
        self.inFulfillmentOf1 = inFulfillmentOf1
    def add_inFulfillmentOf1(self, value):
        self.inFulfillmentOf1.append(value)
    def insert_inFulfillmentOf1_at(self, index, value):
        self.inFulfillmentOf1.insert(index, value)
    def replace_inFulfillmentOf1_at(self, index, value):
        self.inFulfillmentOf1[index] = value
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def get_negationInd(self):
        return self.negationInd
    def set_negationInd(self, negationInd):
        self.negationInd = negationInd
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClassObservation(self, value):
        # Validate type ActClassObservation, a restriction on cs.
        pass
    def validate_x_ActMoodDocumentObservation(self, value):
        # Validate type x_ActMoodDocumentObservation, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['INT', 'DEF', 'EVN', 'GOL', 'PRMS', 'PRP', 'RQO']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_ActMoodDocumentObservation' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_ActMoodDocumentObservation_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_ActMoodDocumentObservation_patterns_, ))
    validate_x_ActMoodDocumentObservation_patterns_ = [['^([^\\s]+)$']]
    def validate_bl(self, value):
        # Validate type bl, a restriction on xs:boolean.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not self.gds_validate_simple_patterns(
                    self.validate_bl_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_bl_patterns_, ))
    validate_bl_patterns_ = [['^(true|false)$']]
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.derivationExpr is not None or
            self.text is not None or
            self.statusCode is not None or
            self.effectiveTime is not None or
            self.priorityCode is not None or
            self.repeatNumber is not None or
            self.languageCode is not None or
            self.value or
            self.interpretationCode or
            self.methodCode or
            self.targetSiteCode or
            self.subject is not None or
            self.specimen or
            self.performer or
            self.author or
            self.informant or
            self.participant or
            self.entryRelationship or
            self.reference or
            self.precondition or
            self.referenceRange or
            self.inFulfillmentOf1
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.Observation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Observation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Observation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Observation')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Observation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Observation'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
        if self.negationInd is not None and 'negationInd' not in already_processed:
            already_processed.add('negationInd')
            outfile.write(' negationInd="%s"' % self.gds_format_boolean(self.negationInd, input_name='negationInd'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.Observation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.derivationExpr is not None:
            namespaceprefix_ = self.derivationExpr_nsprefix_ + ':' if (UseCapturedNS_ and self.derivationExpr_nsprefix_) else ''
            self.derivationExpr.export(outfile, level, namespaceprefix_, namespacedef_='', name_='derivationExpr', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.statusCode is not None:
            namespaceprefix_ = self.statusCode_nsprefix_ + ':' if (UseCapturedNS_ and self.statusCode_nsprefix_) else ''
            self.statusCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='statusCode', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            namespaceprefix_ = self.effectiveTime_nsprefix_ + ':' if (UseCapturedNS_ and self.effectiveTime_nsprefix_) else ''
            self.effectiveTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='effectiveTime', pretty_print=pretty_print)
        if self.priorityCode is not None:
            namespaceprefix_ = self.priorityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.priorityCode_nsprefix_) else ''
            self.priorityCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='priorityCode', pretty_print=pretty_print)
        if self.repeatNumber is not None:
            namespaceprefix_ = self.repeatNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.repeatNumber_nsprefix_) else ''
            self.repeatNumber.export(outfile, level, namespaceprefix_, namespacedef_='', name_='repeatNumber', pretty_print=pretty_print)
        if self.languageCode is not None:
            namespaceprefix_ = self.languageCode_nsprefix_ + ':' if (UseCapturedNS_ and self.languageCode_nsprefix_) else ''
            self.languageCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='languageCode', pretty_print=pretty_print)
        for value_ in self.value:
            value_.export(outfile, level, namespaceprefix_, name_='value', namespacedef_='', pretty_print=pretty_print)
        for interpretationCode_ in self.interpretationCode:
            namespaceprefix_ = self.interpretationCode_nsprefix_ + ':' if (UseCapturedNS_ and self.interpretationCode_nsprefix_) else ''
            interpretationCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='interpretationCode', pretty_print=pretty_print)
        for methodCode_ in self.methodCode:
            namespaceprefix_ = self.methodCode_nsprefix_ + ':' if (UseCapturedNS_ and self.methodCode_nsprefix_) else ''
            methodCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='methodCode', pretty_print=pretty_print)
        for targetSiteCode_ in self.targetSiteCode:
            namespaceprefix_ = self.targetSiteCode_nsprefix_ + ':' if (UseCapturedNS_ and self.targetSiteCode_nsprefix_) else ''
            targetSiteCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='targetSiteCode', pretty_print=pretty_print)
        if self.subject is not None:
            namespaceprefix_ = self.subject_nsprefix_ + ':' if (UseCapturedNS_ and self.subject_nsprefix_) else ''
            self.subject.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subject', pretty_print=pretty_print)
        for specimen_ in self.specimen:
            namespaceprefix_ = self.specimen_nsprefix_ + ':' if (UseCapturedNS_ and self.specimen_nsprefix_) else ''
            specimen_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specimen', pretty_print=pretty_print)
        for performer_ in self.performer:
            namespaceprefix_ = self.performer_nsprefix_ + ':' if (UseCapturedNS_ and self.performer_nsprefix_) else ''
            performer_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='performer', pretty_print=pretty_print)
        for author_ in self.author:
            namespaceprefix_ = self.author_nsprefix_ + ':' if (UseCapturedNS_ and self.author_nsprefix_) else ''
            author_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='author', pretty_print=pretty_print)
        for informant_ in self.informant:
            namespaceprefix_ = self.informant_nsprefix_ + ':' if (UseCapturedNS_ and self.informant_nsprefix_) else ''
            informant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='informant', pretty_print=pretty_print)
        for participant_ in self.participant:
            namespaceprefix_ = self.participant_nsprefix_ + ':' if (UseCapturedNS_ and self.participant_nsprefix_) else ''
            participant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='participant', pretty_print=pretty_print)
        for entryRelationship_ in self.entryRelationship:
            namespaceprefix_ = self.entryRelationship_nsprefix_ + ':' if (UseCapturedNS_ and self.entryRelationship_nsprefix_) else ''
            entryRelationship_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='entryRelationship', pretty_print=pretty_print)
        for reference_ in self.reference:
            namespaceprefix_ = self.reference_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_nsprefix_) else ''
            reference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reference', pretty_print=pretty_print)
        for precondition_ in self.precondition:
            namespaceprefix_ = self.precondition_nsprefix_ + ':' if (UseCapturedNS_ and self.precondition_nsprefix_) else ''
            precondition_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='precondition', pretty_print=pretty_print)
        for referenceRange_ in self.referenceRange:
            namespaceprefix_ = self.referenceRange_nsprefix_ + ':' if (UseCapturedNS_ and self.referenceRange_nsprefix_) else ''
            referenceRange_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='referenceRange', pretty_print=pretty_print)
        for inFulfillmentOf1_ in self.inFulfillmentOf1:
            namespaceprefix_ = self.inFulfillmentOf1_nsprefix_ + ':' if (UseCapturedNS_ and self.inFulfillmentOf1_nsprefix_) else ''
            inFulfillmentOf1_.export(outfile, level, namespaceprefix_='sdtc:', namespacedef_='', name_='inFulfillmentOf1', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClassObservation(self.classCode)    # validate type ActClassObservation
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.moodCode = ' '.join(self.moodCode.split())
            self.validate_x_ActMoodDocumentObservation(self.moodCode)    # validate type x_ActMoodDocumentObservation
        value = find_attr_value_('negationInd', node)
        if value is not None and 'negationInd' not in already_processed:
            already_processed.add('negationInd')
            if value in ('true', '1'):
                self.negationInd = True
            elif value in ('false', '0'):
                self.negationInd = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_bl(self.negationInd)    # validate type bl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'derivationExpr':
            class_obj_ = self.get_class_obj_(child_, ST)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.derivationExpr = obj_
            obj_.original_tagname_ = 'derivationExpr'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'statusCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.statusCode = obj_
            obj_.original_tagname_ = 'statusCode'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'priorityCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.priorityCode = obj_
            obj_.original_tagname_ = 'priorityCode'
        elif nodeName_ == 'repeatNumber':
            obj_ = IVL_INT.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.repeatNumber = obj_
            obj_.original_tagname_ = 'repeatNumber'
        elif nodeName_ == 'languageCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.languageCode = obj_
            obj_.original_tagname_ = 'languageCode'
        elif nodeName_ == 'value':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()["" + type_name_]
                obj_ = class_.factory()
                obj_.build(child_, gds_collector_=gds_collector_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <value> element')
            self.value.append(obj_)
            obj_.original_tagname_ = 'value'
        elif nodeName_ == 'interpretationCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.interpretationCode.append(obj_)
            obj_.original_tagname_ = 'interpretationCode'
        elif nodeName_ == 'methodCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.methodCode.append(obj_)
            obj_.original_tagname_ = 'methodCode'
        elif nodeName_ == 'targetSiteCode':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.targetSiteCode.append(obj_)
            obj_.original_tagname_ = 'targetSiteCode'
        elif nodeName_ == 'subject':
            obj_ = POCD_MT000040_Subject.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subject = obj_
            obj_.original_tagname_ = 'subject'
        elif nodeName_ == 'specimen':
            obj_ = POCD_MT000040_Specimen.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specimen.append(obj_)
            obj_.original_tagname_ = 'specimen'
        elif nodeName_ == 'performer':
            obj_ = POCD_MT000040_Performer2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.performer.append(obj_)
            obj_.original_tagname_ = 'performer'
        elif nodeName_ == 'author':
            obj_ = POCD_MT000040_Author.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'informant':
            obj_ = POCD_MT000040_Informant12.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.informant.append(obj_)
            obj_.original_tagname_ = 'informant'
        elif nodeName_ == 'participant':
            obj_ = POCD_MT000040_Participant2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.participant.append(obj_)
            obj_.original_tagname_ = 'participant'
        elif nodeName_ == 'entryRelationship':
            obj_ = POCD_MT000040_EntryRelationship.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.entryRelationship.append(obj_)
            obj_.original_tagname_ = 'entryRelationship'
        elif nodeName_ == 'reference':
            obj_ = POCD_MT000040_Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reference.append(obj_)
            obj_.original_tagname_ = 'reference'
        elif nodeName_ == 'precondition':
            obj_ = POCD_MT000040_Precondition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.precondition.append(obj_)
            obj_.original_tagname_ = 'precondition'
        elif nodeName_ == 'referenceRange':
            obj_ = POCD_MT000040_ReferenceRange.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.referenceRange.append(obj_)
            obj_.original_tagname_ = 'referenceRange'
        elif nodeName_ == 'inFulfillmentOf1':
            obj_ = InFulfillmentOf1.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.inFulfillmentOf1.append(obj_)
            obj_.original_tagname_ = 'inFulfillmentOf1'
# end class POCD_MT000040_Observation


class POCD_MT000040_ObservationMedia(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ID: 'xs_string' = None, nullFlavor: 'NullFlavor' = None, classCode: 'ActClassObservation' = None, moodCode: 'ActMood' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, languageCode: 'CS' = None, value: 'ED' = None, subject: 'POCD_MT000040.Subject' = None, specimen: List_['POCD_MT000040.Specimen'] = None, performer: List_['POCD_MT000040.Performer2'] = None, author: List_['POCD_MT000040.Author'] = None, informant: List_['POCD_MT000040.Informant12'] = None, participant: List_['POCD_MT000040.Participant2'] = None, entryRelationship: List_['POCD_MT000040.EntryRelationship'] = None, reference: List_['POCD_MT000040.Reference'] = None, precondition: List_['POCD_MT000040.Precondition'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ID = _cast(None, ID)
        self.ID_nsprefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.languageCode = languageCode
        self.languageCode_nsprefix_ = None
        self.value = value
        self.value_nsprefix_ = None
        self.subject = subject
        self.subject_nsprefix_ = None
        if specimen is None:
            self.specimen = []
        else:
            self.specimen = specimen
        self.specimen_nsprefix_ = None
        if performer is None:
            self.performer = []
        else:
            self.performer = performer
        self.performer_nsprefix_ = None
        if author is None:
            self.author = []
        else:
            self.author = author
        self.author_nsprefix_ = None
        if informant is None:
            self.informant = []
        else:
            self.informant = informant
        self.informant_nsprefix_ = None
        if participant is None:
            self.participant = []
        else:
            self.participant = participant
        self.participant_nsprefix_ = None
        if entryRelationship is None:
            self.entryRelationship = []
        else:
            self.entryRelationship = entryRelationship
        self.entryRelationship_nsprefix_ = None
        if reference is None:
            self.reference = []
        else:
            self.reference = reference
        self.reference_nsprefix_ = None
        if precondition is None:
            self.precondition = []
        else:
            self.precondition = precondition
        self.precondition_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_ObservationMedia)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_ObservationMedia.subclass:
            return POCD_MT000040_ObservationMedia.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_ObservationMedia(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_languageCode(self):
        return self.languageCode
    def set_languageCode(self, languageCode):
        self.languageCode = languageCode
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def get_subject(self):
        return self.subject
    def set_subject(self, subject):
        self.subject = subject
    def get_specimen(self):
        return self.specimen
    def set_specimen(self, specimen):
        self.specimen = specimen
    def add_specimen(self, value):
        self.specimen.append(value)
    def insert_specimen_at(self, index, value):
        self.specimen.insert(index, value)
    def replace_specimen_at(self, index, value):
        self.specimen[index] = value
    def get_performer(self):
        return self.performer
    def set_performer(self, performer):
        self.performer = performer
    def add_performer(self, value):
        self.performer.append(value)
    def insert_performer_at(self, index, value):
        self.performer.insert(index, value)
    def replace_performer_at(self, index, value):
        self.performer[index] = value
    def get_author(self):
        return self.author
    def set_author(self, author):
        self.author = author
    def add_author(self, value):
        self.author.append(value)
    def insert_author_at(self, index, value):
        self.author.insert(index, value)
    def replace_author_at(self, index, value):
        self.author[index] = value
    def get_informant(self):
        return self.informant
    def set_informant(self, informant):
        self.informant = informant
    def add_informant(self, value):
        self.informant.append(value)
    def insert_informant_at(self, index, value):
        self.informant.insert(index, value)
    def replace_informant_at(self, index, value):
        self.informant[index] = value
    def get_participant(self):
        return self.participant
    def set_participant(self, participant):
        self.participant = participant
    def add_participant(self, value):
        self.participant.append(value)
    def insert_participant_at(self, index, value):
        self.participant.insert(index, value)
    def replace_participant_at(self, index, value):
        self.participant[index] = value
    def get_entryRelationship(self):
        return self.entryRelationship
    def set_entryRelationship(self, entryRelationship):
        self.entryRelationship = entryRelationship
    def add_entryRelationship(self, value):
        self.entryRelationship.append(value)
    def insert_entryRelationship_at(self, index, value):
        self.entryRelationship.insert(index, value)
    def replace_entryRelationship_at(self, index, value):
        self.entryRelationship[index] = value
    def get_reference(self):
        return self.reference
    def set_reference(self, reference):
        self.reference = reference
    def add_reference(self, value):
        self.reference.append(value)
    def insert_reference_at(self, index, value):
        self.reference.insert(index, value)
    def replace_reference_at(self, index, value):
        self.reference[index] = value
    def get_precondition(self):
        return self.precondition
    def set_precondition(self, precondition):
        self.precondition = precondition
    def add_precondition(self, value):
        self.precondition.append(value)
    def insert_precondition_at(self, index, value):
        self.precondition.insert(index, value)
    def replace_precondition_at(self, index, value):
        self.precondition[index] = value
    def get_ID(self):
        return self.ID
    def set_ID(self, ID):
        self.ID = ID
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClassObservation(self, value):
        # Validate type ActClassObservation, a restriction on cs.
        pass
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.languageCode is not None or
            self.value is not None or
            self.subject is not None or
            self.specimen or
            self.performer or
            self.author or
            self.informant or
            self.participant or
            self.entryRelationship or
            self.reference or
            self.precondition
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.ObservationMedia', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.ObservationMedia')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.ObservationMedia':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.ObservationMedia')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.ObservationMedia', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.ObservationMedia'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            outfile.write(' ID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ID), input_name='ID')), ))
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.ObservationMedia', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.languageCode is not None:
            namespaceprefix_ = self.languageCode_nsprefix_ + ':' if (UseCapturedNS_ and self.languageCode_nsprefix_) else ''
            self.languageCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='languageCode', pretty_print=pretty_print)
        if self.value is not None:
            namespaceprefix_ = self.value_nsprefix_ + ':' if (UseCapturedNS_ and self.value_nsprefix_) else ''
            self.value.export(outfile, level, namespaceprefix_, namespacedef_='', name_='value', pretty_print=pretty_print)
        if self.subject is not None:
            namespaceprefix_ = self.subject_nsprefix_ + ':' if (UseCapturedNS_ and self.subject_nsprefix_) else ''
            self.subject.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subject', pretty_print=pretty_print)
        for specimen_ in self.specimen:
            namespaceprefix_ = self.specimen_nsprefix_ + ':' if (UseCapturedNS_ and self.specimen_nsprefix_) else ''
            specimen_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specimen', pretty_print=pretty_print)
        for performer_ in self.performer:
            namespaceprefix_ = self.performer_nsprefix_ + ':' if (UseCapturedNS_ and self.performer_nsprefix_) else ''
            performer_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='performer', pretty_print=pretty_print)
        for author_ in self.author:
            namespaceprefix_ = self.author_nsprefix_ + ':' if (UseCapturedNS_ and self.author_nsprefix_) else ''
            author_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='author', pretty_print=pretty_print)
        for informant_ in self.informant:
            namespaceprefix_ = self.informant_nsprefix_ + ':' if (UseCapturedNS_ and self.informant_nsprefix_) else ''
            informant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='informant', pretty_print=pretty_print)
        for participant_ in self.participant:
            namespaceprefix_ = self.participant_nsprefix_ + ':' if (UseCapturedNS_ and self.participant_nsprefix_) else ''
            participant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='participant', pretty_print=pretty_print)
        for entryRelationship_ in self.entryRelationship:
            namespaceprefix_ = self.entryRelationship_nsprefix_ + ':' if (UseCapturedNS_ and self.entryRelationship_nsprefix_) else ''
            entryRelationship_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='entryRelationship', pretty_print=pretty_print)
        for reference_ in self.reference:
            namespaceprefix_ = self.reference_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_nsprefix_) else ''
            reference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reference', pretty_print=pretty_print)
        for precondition_ in self.precondition:
            namespaceprefix_ = self.precondition_nsprefix_ + ':' if (UseCapturedNS_ and self.precondition_nsprefix_) else ''
            precondition_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='precondition', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.add('ID')
            self.ID = value
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClassObservation(self.classCode)    # validate type ActClassObservation
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'languageCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.languageCode = obj_
            obj_.original_tagname_ = 'languageCode'
        elif nodeName_ == 'value':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.value = obj_
            obj_.original_tagname_ = 'value'
        elif nodeName_ == 'subject':
            obj_ = POCD_MT000040_Subject.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subject = obj_
            obj_.original_tagname_ = 'subject'
        elif nodeName_ == 'specimen':
            obj_ = POCD_MT000040_Specimen.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specimen.append(obj_)
            obj_.original_tagname_ = 'specimen'
        elif nodeName_ == 'performer':
            obj_ = POCD_MT000040_Performer2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.performer.append(obj_)
            obj_.original_tagname_ = 'performer'
        elif nodeName_ == 'author':
            obj_ = POCD_MT000040_Author.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'informant':
            obj_ = POCD_MT000040_Informant12.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.informant.append(obj_)
            obj_.original_tagname_ = 'informant'
        elif nodeName_ == 'participant':
            obj_ = POCD_MT000040_Participant2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.participant.append(obj_)
            obj_.original_tagname_ = 'participant'
        elif nodeName_ == 'entryRelationship':
            obj_ = POCD_MT000040_EntryRelationship.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.entryRelationship.append(obj_)
            obj_.original_tagname_ = 'entryRelationship'
        elif nodeName_ == 'reference':
            obj_ = POCD_MT000040_Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reference.append(obj_)
            obj_.original_tagname_ = 'reference'
        elif nodeName_ == 'precondition':
            obj_ = POCD_MT000040_Precondition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.precondition.append(obj_)
            obj_.original_tagname_ = 'precondition'
# end class POCD_MT000040_ObservationMedia


class POCD_MT000040_ObservationRange(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClassObservation' = 'OBS', moodCode: 'ActMood' = 'EVN.CRT', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, value: 'ANY' = None, interpretationCode: 'CE' = None, precondition1: List_['Precondition1'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.value = value
        self.value_nsprefix_ = None
        self.interpretationCode = interpretationCode
        self.interpretationCode_nsprefix_ = None
        if precondition1 is None:
            self.precondition1 = []
        else:
            self.precondition1 = precondition1
        self.precondition1_nsprefix_ = "sdtc"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_ObservationRange)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_ObservationRange.subclass:
            return POCD_MT000040_ObservationRange.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_ObservationRange(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def set_value_with_type(self, value):
        self.value = value
        value.original_tagname_ = 'value'
        value.extensiontype_ = value.__class__.__name__
    def get_interpretationCode(self):
        return self.interpretationCode
    def set_interpretationCode(self, interpretationCode):
        self.interpretationCode = interpretationCode
    def get_precondition1(self):
        return self.precondition1
    def set_precondition1(self, precondition1):
        self.precondition1 = precondition1
    def add_precondition1(self, value):
        self.precondition1.append(value)
    def insert_precondition1_at(self, index, value):
        self.precondition1.insert(index, value)
    def replace_precondition1_at(self, index, value):
        self.precondition1[index] = value
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClassObservation(self, value):
        # Validate type ActClassObservation, a restriction on cs.
        pass
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.code is not None or
            self.text is not None or
            self.value is not None or
            self.interpretationCode is not None or
            self.precondition1
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.ObservationRange', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.ObservationRange')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.ObservationRange':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.ObservationRange')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.ObservationRange', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.ObservationRange'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "OBS" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.ObservationRange', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.value is not None:
            self.value.export(outfile, level, namespaceprefix_, name_='value', namespacedef_='', pretty_print=pretty_print)
        if self.interpretationCode is not None:
            namespaceprefix_ = self.interpretationCode_nsprefix_ + ':' if (UseCapturedNS_ and self.interpretationCode_nsprefix_) else ''
            self.interpretationCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='interpretationCode', pretty_print=pretty_print)
        for precondition1_ in self.precondition1:
            namespaceprefix_ = self.precondition1_nsprefix_ + ':' if (UseCapturedNS_ and self.precondition1_nsprefix_) else ''
            precondition1_.export(outfile, level, namespaceprefix_='sdtc:', namespacedef_='', name_='precondition1', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClassObservation(self.classCode)    # validate type ActClassObservation
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'value':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()["" + type_name_]
                obj_ = class_.factory()
                obj_.build(child_, gds_collector_=gds_collector_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <value> element')
            self.value = obj_
            obj_.original_tagname_ = 'value'
        elif nodeName_ == 'interpretationCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.interpretationCode = obj_
            obj_.original_tagname_ = 'interpretationCode'
        elif nodeName_ == 'precondition1':
            obj_ = Precondition1.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.precondition1.append(obj_)
            obj_.original_tagname_ = 'precondition1'
# end class POCD_MT000040_ObservationRange


class POCD_MT000040_Order(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClassRoot' = 'ACT', moodCode: 'ActMood' = 'RQO', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, priorityCode: 'CE' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.priorityCode = priorityCode
        self.priorityCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Order)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Order.subclass:
            return POCD_MT000040_Order.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Order(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_priorityCode(self):
        return self.priorityCode
    def set_priorityCode(self, priorityCode):
        self.priorityCode = priorityCode
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClassRoot(self, value):
        # Validate type ActClassRoot, a restriction on cs.
        pass
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.priorityCode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Order', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Order')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Order':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Order')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Order', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Order'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ACT" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Order', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.priorityCode is not None:
            namespaceprefix_ = self.priorityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.priorityCode_nsprefix_) else ''
            self.priorityCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='priorityCode', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClassRoot(self.classCode)    # validate type ActClassRoot
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'priorityCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.priorityCode = obj_
            obj_.original_tagname_ = 'priorityCode'
# end class POCD_MT000040_Order


class POCD_MT000040_Organization(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'EntityClassOrganization' = 'ORG', determinerCode: 'EntityDeterminer' = 'INSTANCE', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, name: List_['ON'] = None, telecom: List_['TEL'] = None, addr: List_['AD'] = None, standardIndustryClassCode: 'CE' = None, asOrganizationPartOf: 'POCD_MT000040.OrganizationPartOf' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.determinerCode = _cast(None, determinerCode)
        self.determinerCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        if name is None:
            self.name = []
        else:
            self.name = name
        self.name_nsprefix_ = None
        if telecom is None:
            self.telecom = []
        else:
            self.telecom = telecom
        self.telecom_nsprefix_ = None
        if addr is None:
            self.addr = []
        else:
            self.addr = addr
        self.addr_nsprefix_ = None
        self.standardIndustryClassCode = standardIndustryClassCode
        self.standardIndustryClassCode_nsprefix_ = None
        self.asOrganizationPartOf = asOrganizationPartOf
        self.asOrganizationPartOf_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Organization)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Organization.subclass:
            return POCD_MT000040_Organization.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Organization(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def add_name(self, value):
        self.name.append(value)
    def insert_name_at(self, index, value):
        self.name.insert(index, value)
    def replace_name_at(self, index, value):
        self.name[index] = value
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def add_telecom(self, value):
        self.telecom.append(value)
    def insert_telecom_at(self, index, value):
        self.telecom.insert(index, value)
    def replace_telecom_at(self, index, value):
        self.telecom[index] = value
    def get_addr(self):
        return self.addr
    def set_addr(self, addr):
        self.addr = addr
    def add_addr(self, value):
        self.addr.append(value)
    def insert_addr_at(self, index, value):
        self.addr.insert(index, value)
    def replace_addr_at(self, index, value):
        self.addr[index] = value
    def get_standardIndustryClassCode(self):
        return self.standardIndustryClassCode
    def set_standardIndustryClassCode(self, standardIndustryClassCode):
        self.standardIndustryClassCode = standardIndustryClassCode
    def get_asOrganizationPartOf(self):
        return self.asOrganizationPartOf
    def set_asOrganizationPartOf(self, asOrganizationPartOf):
        self.asOrganizationPartOf = asOrganizationPartOf
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def get_determinerCode(self):
        return self.determinerCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_EntityClassOrganization(self, value):
        # Validate type EntityClassOrganization, a restriction on cs.
        pass
    def validate_EntityDeterminer(self, value):
        # Validate type EntityDeterminer, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.name or
            self.telecom or
            self.addr or
            self.standardIndustryClassCode is not None or
            self.asOrganizationPartOf is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Organization', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Organization')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Organization':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Organization')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Organization', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Organization'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.determinerCode is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            outfile.write(' determinerCode=%s' % (quote_attrib(self.determinerCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Organization', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        for name_ in self.name:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            name_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        for telecom_ in self.telecom:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            telecom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
        for addr_ in self.addr:
            namespaceprefix_ = self.addr_nsprefix_ + ':' if (UseCapturedNS_ and self.addr_nsprefix_) else ''
            addr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addr', pretty_print=pretty_print)
        if self.standardIndustryClassCode is not None:
            namespaceprefix_ = self.standardIndustryClassCode_nsprefix_ + ':' if (UseCapturedNS_ and self.standardIndustryClassCode_nsprefix_) else ''
            self.standardIndustryClassCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='standardIndustryClassCode', pretty_print=pretty_print)
        if self.asOrganizationPartOf is not None:
            namespaceprefix_ = self.asOrganizationPartOf_nsprefix_ + ':' if (UseCapturedNS_ and self.asOrganizationPartOf_nsprefix_) else ''
            self.asOrganizationPartOf.export(outfile, level, namespaceprefix_, namespacedef_='', name_='asOrganizationPartOf', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_EntityClassOrganization(self.classCode)    # validate type EntityClassOrganization
        value = find_attr_value_('determinerCode', node)
        if value is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            self.determinerCode = value
            self.determinerCode = ' '.join(self.determinerCode.split())
            self.validate_EntityDeterminer(self.determinerCode)    # validate type EntityDeterminer
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'name':
            obj_ = ON.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name.append(obj_)
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'telecom':
            obj_ = TEL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom.append(obj_)
            obj_.original_tagname_ = 'telecom'
        elif nodeName_ == 'addr':
            obj_ = AD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addr.append(obj_)
            obj_.original_tagname_ = 'addr'
        elif nodeName_ == 'standardIndustryClassCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.standardIndustryClassCode = obj_
            obj_.original_tagname_ = 'standardIndustryClassCode'
        elif nodeName_ == 'asOrganizationPartOf':
            obj_ = POCD_MT000040_OrganizationPartOf.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.asOrganizationPartOf = obj_
            obj_.original_tagname_ = 'asOrganizationPartOf'
# end class POCD_MT000040_Organization


class POCD_MT000040_OrganizationPartOf(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClass' = 'PART', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, statusCode: 'CS' = None, effectiveTime: 'IVL_TS' = None, wholeOrganization: 'POCD_MT000040.Organization' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.statusCode = statusCode
        self.statusCode_nsprefix_ = None
        self.effectiveTime = effectiveTime
        self.effectiveTime_nsprefix_ = None
        self.wholeOrganization = wholeOrganization
        self.wholeOrganization_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_OrganizationPartOf)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_OrganizationPartOf.subclass:
            return POCD_MT000040_OrganizationPartOf.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_OrganizationPartOf(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_statusCode(self):
        return self.statusCode
    def set_statusCode(self, statusCode):
        self.statusCode = statusCode
    def get_effectiveTime(self):
        return self.effectiveTime
    def set_effectiveTime(self, effectiveTime):
        self.effectiveTime = effectiveTime
    def get_wholeOrganization(self):
        return self.wholeOrganization
    def set_wholeOrganization(self, wholeOrganization):
        self.wholeOrganization = wholeOrganization
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_RoleClass(self, value):
        # Validate type RoleClass, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.statusCode is not None or
            self.effectiveTime is not None or
            self.wholeOrganization is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.OrganizationPartOf', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.OrganizationPartOf')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.OrganizationPartOf':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.OrganizationPartOf')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.OrganizationPartOf', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.OrganizationPartOf'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.OrganizationPartOf', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.statusCode is not None:
            namespaceprefix_ = self.statusCode_nsprefix_ + ':' if (UseCapturedNS_ and self.statusCode_nsprefix_) else ''
            self.statusCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='statusCode', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            namespaceprefix_ = self.effectiveTime_nsprefix_ + ':' if (UseCapturedNS_ and self.effectiveTime_nsprefix_) else ''
            self.effectiveTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='effectiveTime', pretty_print=pretty_print)
        if self.wholeOrganization is not None:
            namespaceprefix_ = self.wholeOrganization_nsprefix_ + ':' if (UseCapturedNS_ and self.wholeOrganization_nsprefix_) else ''
            self.wholeOrganization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='wholeOrganization', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.validate_RoleClass(self.classCode)    # validate type RoleClass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'statusCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.statusCode = obj_
            obj_.original_tagname_ = 'statusCode'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'wholeOrganization':
            obj_ = POCD_MT000040_Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.wholeOrganization = obj_
            obj_.original_tagname_ = 'wholeOrganization'
# end class POCD_MT000040_OrganizationPartOf


class POCD_MT000040_Organizer(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'x_ActClassDocumentEntryOrganizer' = None, moodCode: 'ActMood' = None, realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, statusCode: 'CS' = None, effectiveTime: 'IVL_TS' = None, subject: 'POCD_MT000040.Subject' = None, specimen: List_['POCD_MT000040.Specimen'] = None, performer: List_['POCD_MT000040.Performer2'] = None, author: List_['POCD_MT000040.Author'] = None, informant: List_['POCD_MT000040.Informant12'] = None, participant: List_['POCD_MT000040.Participant2'] = None, reference: List_['POCD_MT000040.Reference'] = None, precondition: List_['POCD_MT000040.Precondition'] = None, component: List_['POCD_MT000040.Component4'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = "sdtc"
        self.statusCode = statusCode
        self.statusCode_nsprefix_ = None
        self.effectiveTime = effectiveTime
        self.effectiveTime_nsprefix_ = None
        self.subject = subject
        self.subject_nsprefix_ = None
        if specimen is None:
            self.specimen = []
        else:
            self.specimen = specimen
        self.specimen_nsprefix_ = None
        if performer is None:
            self.performer = []
        else:
            self.performer = performer
        self.performer_nsprefix_ = None
        if author is None:
            self.author = []
        else:
            self.author = author
        self.author_nsprefix_ = None
        if informant is None:
            self.informant = []
        else:
            self.informant = informant
        self.informant_nsprefix_ = None
        if participant is None:
            self.participant = []
        else:
            self.participant = participant
        self.participant_nsprefix_ = None
        if reference is None:
            self.reference = []
        else:
            self.reference = reference
        self.reference_nsprefix_ = None
        if precondition is None:
            self.precondition = []
        else:
            self.precondition = precondition
        self.precondition_nsprefix_ = None
        if component is None:
            self.component = []
        else:
            self.component = component
        self.component_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Organizer)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Organizer.subclass:
            return POCD_MT000040_Organizer.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Organizer(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_statusCode(self):
        return self.statusCode
    def set_statusCode(self, statusCode):
        self.statusCode = statusCode
    def get_effectiveTime(self):
        return self.effectiveTime
    def set_effectiveTime(self, effectiveTime):
        self.effectiveTime = effectiveTime
    def get_subject(self):
        return self.subject
    def set_subject(self, subject):
        self.subject = subject
    def get_specimen(self):
        return self.specimen
    def set_specimen(self, specimen):
        self.specimen = specimen
    def add_specimen(self, value):
        self.specimen.append(value)
    def insert_specimen_at(self, index, value):
        self.specimen.insert(index, value)
    def replace_specimen_at(self, index, value):
        self.specimen[index] = value
    def get_performer(self):
        return self.performer
    def set_performer(self, performer):
        self.performer = performer
    def add_performer(self, value):
        self.performer.append(value)
    def insert_performer_at(self, index, value):
        self.performer.insert(index, value)
    def replace_performer_at(self, index, value):
        self.performer[index] = value
    def get_author(self):
        return self.author
    def set_author(self, author):
        self.author = author
    def add_author(self, value):
        self.author.append(value)
    def insert_author_at(self, index, value):
        self.author.insert(index, value)
    def replace_author_at(self, index, value):
        self.author[index] = value
    def get_informant(self):
        return self.informant
    def set_informant(self, informant):
        self.informant = informant
    def add_informant(self, value):
        self.informant.append(value)
    def insert_informant_at(self, index, value):
        self.informant.insert(index, value)
    def replace_informant_at(self, index, value):
        self.informant[index] = value
    def get_participant(self):
        return self.participant
    def set_participant(self, participant):
        self.participant = participant
    def add_participant(self, value):
        self.participant.append(value)
    def insert_participant_at(self, index, value):
        self.participant.insert(index, value)
    def replace_participant_at(self, index, value):
        self.participant[index] = value
    def get_reference(self):
        return self.reference
    def set_reference(self, reference):
        self.reference = reference
    def add_reference(self, value):
        self.reference.append(value)
    def insert_reference_at(self, index, value):
        self.reference.insert(index, value)
    def replace_reference_at(self, index, value):
        self.reference[index] = value
    def get_precondition(self):
        return self.precondition
    def set_precondition(self, precondition):
        self.precondition = precondition
    def add_precondition(self, value):
        self.precondition.append(value)
    def insert_precondition_at(self, index, value):
        self.precondition.insert(index, value)
    def replace_precondition_at(self, index, value):
        self.precondition[index] = value
    def get_component(self):
        return self.component
    def set_component(self, component):
        self.component = component
    def add_component(self, value):
        self.component.append(value)
    def insert_component_at(self, index, value):
        self.component.insert(index, value)
    def replace_component_at(self, index, value):
        self.component[index] = value
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def get_moodCode(self):
        return self.moodCode
    def set_moodCode(self, moodCode):
        self.moodCode = moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_x_ActClassDocumentEntryOrganizer(self, value):
        # Validate type x_ActClassDocumentEntryOrganizer, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['BATTERY', 'CLUSTER']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on x_ActClassDocumentEntryOrganizer' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_x_ActClassDocumentEntryOrganizer_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_x_ActClassDocumentEntryOrganizer_patterns_, ))
    validate_x_ActClassDocumentEntryOrganizer_patterns_ = [['^([^\\s]+)$']]
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.text is not None or
            self.statusCode is not None or
            self.effectiveTime is not None or
            self.subject is not None or
            self.specimen or
            self.performer or
            self.author or
            self.informant or
            self.participant or
            self.reference or
            self.precondition or
            self.component
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.Organizer', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Organizer')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Organizer':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Organizer')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Organizer', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Organizer'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.Organizer', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_='sdtc:', namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.statusCode is not None:
            namespaceprefix_ = self.statusCode_nsprefix_ + ':' if (UseCapturedNS_ and self.statusCode_nsprefix_) else ''
            self.statusCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='statusCode', pretty_print=pretty_print)
        if self.effectiveTime is not None:
            namespaceprefix_ = self.effectiveTime_nsprefix_ + ':' if (UseCapturedNS_ and self.effectiveTime_nsprefix_) else ''
            self.effectiveTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='effectiveTime', pretty_print=pretty_print)
        if self.subject is not None:
            namespaceprefix_ = self.subject_nsprefix_ + ':' if (UseCapturedNS_ and self.subject_nsprefix_) else ''
            self.subject.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subject', pretty_print=pretty_print)
        for specimen_ in self.specimen:
            namespaceprefix_ = self.specimen_nsprefix_ + ':' if (UseCapturedNS_ and self.specimen_nsprefix_) else ''
            specimen_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specimen', pretty_print=pretty_print)
        for performer_ in self.performer:
            namespaceprefix_ = self.performer_nsprefix_ + ':' if (UseCapturedNS_ and self.performer_nsprefix_) else ''
            performer_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='performer', pretty_print=pretty_print)
        for author_ in self.author:
            namespaceprefix_ = self.author_nsprefix_ + ':' if (UseCapturedNS_ and self.author_nsprefix_) else ''
            author_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='author', pretty_print=pretty_print)
        for informant_ in self.informant:
            namespaceprefix_ = self.informant_nsprefix_ + ':' if (UseCapturedNS_ and self.informant_nsprefix_) else ''
            informant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='informant', pretty_print=pretty_print)
        for participant_ in self.participant:
            namespaceprefix_ = self.participant_nsprefix_ + ':' if (UseCapturedNS_ and self.participant_nsprefix_) else ''
            participant_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='participant', pretty_print=pretty_print)
        for reference_ in self.reference:
            namespaceprefix_ = self.reference_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_nsprefix_) else ''
            reference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reference', pretty_print=pretty_print)
        for precondition_ in self.precondition:
            namespaceprefix_ = self.precondition_nsprefix_ + ':' if (UseCapturedNS_ and self.precondition_nsprefix_) else ''
            precondition_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='precondition', pretty_print=pretty_print)
        for component_ in self.component:
            namespaceprefix_ = self.component_nsprefix_ + ':' if (UseCapturedNS_ and self.component_nsprefix_) else ''
            component_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='component', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_x_ActClassDocumentEntryOrganizer(self.classCode)    # validate type x_ActClassDocumentEntryOrganizer
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'statusCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.statusCode = obj_
            obj_.original_tagname_ = 'statusCode'
        elif nodeName_ == 'effectiveTime':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.effectiveTime = obj_
            obj_.original_tagname_ = 'effectiveTime'
        elif nodeName_ == 'subject':
            obj_ = POCD_MT000040_Subject.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subject = obj_
            obj_.original_tagname_ = 'subject'
        elif nodeName_ == 'specimen':
            obj_ = POCD_MT000040_Specimen.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specimen.append(obj_)
            obj_.original_tagname_ = 'specimen'
        elif nodeName_ == 'performer':
            obj_ = POCD_MT000040_Performer2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.performer.append(obj_)
            obj_.original_tagname_ = 'performer'
        elif nodeName_ == 'author':
            obj_ = POCD_MT000040_Author.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'informant':
            obj_ = POCD_MT000040_Informant12.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.informant.append(obj_)
            obj_.original_tagname_ = 'informant'
        elif nodeName_ == 'participant':
            obj_ = POCD_MT000040_Participant2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.participant.append(obj_)
            obj_.original_tagname_ = 'participant'
        elif nodeName_ == 'reference':
            obj_ = POCD_MT000040_Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reference.append(obj_)
            obj_.original_tagname_ = 'reference'
        elif nodeName_ == 'precondition':
            obj_ = POCD_MT000040_Precondition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.precondition.append(obj_)
            obj_.original_tagname_ = 'precondition'
        elif nodeName_ == 'component':
            obj_ = POCD_MT000040_Component4.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.component.append(obj_)
            obj_.original_tagname_ = 'component'
# end class POCD_MT000040_Organizer


class POCD_MT000040_ParentDocument(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'ActClinicalDocument' = 'DOCCLIN', moodCode: 'ActMood' = 'EVN', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CD' = None, text: 'ED' = None, setId: 'II' = None, versionNumber: 'INT' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.moodCode = _cast(None, moodCode)
        self.moodCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.setId = setId
        self.setId_nsprefix_ = None
        self.versionNumber = versionNumber
        self.versionNumber_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_ParentDocument)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_ParentDocument.subclass:
            return POCD_MT000040_ParentDocument.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_ParentDocument(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_setId(self):
        return self.setId
    def set_setId(self, setId):
        self.setId = setId
    def get_versionNumber(self):
        return self.versionNumber
    def set_versionNumber(self, versionNumber):
        self.versionNumber = versionNumber
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def get_moodCode(self):
        return self.moodCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ActClinicalDocument(self, value):
        # Validate type ActClinicalDocument, a restriction on cs.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['DOCCLIN', 'CDALVLONE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActClinicalDocument' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActClinicalDocument_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActClinicalDocument_patterns_, ))
    validate_ActClinicalDocument_patterns_ = [['^([^\\s]+)$']]
    def validate_ActMood(self, value):
        # Validate type ActMood, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.text is not None or
            self.setId is not None or
            self.versionNumber is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.ParentDocument', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.ParentDocument')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.ParentDocument':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.ParentDocument')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.ParentDocument', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.ParentDocument'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.moodCode is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            outfile.write(' moodCode=%s' % (quote_attrib(self.moodCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.ParentDocument', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.setId is not None:
            namespaceprefix_ = self.setId_nsprefix_ + ':' if (UseCapturedNS_ and self.setId_nsprefix_) else ''
            self.setId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='setId', pretty_print=pretty_print)
        if self.versionNumber is not None:
            namespaceprefix_ = self.versionNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.versionNumber_nsprefix_) else ''
            self.versionNumber.export(outfile, level, namespaceprefix_, namespacedef_='', name_='versionNumber', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_ActClinicalDocument(self.classCode)    # validate type ActClinicalDocument
        value = find_attr_value_('moodCode', node)
        if value is not None and 'moodCode' not in already_processed:
            already_processed.add('moodCode')
            self.moodCode = value
            self.validate_ActMood(self.moodCode)    # validate type ActMood
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CD)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'text':
            obj_ = ED.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'setId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.setId = obj_
            obj_.original_tagname_ = 'setId'
        elif nodeName_ == 'versionNumber':
            class_obj_ = self.get_class_obj_(child_, INT)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.versionNumber = obj_
            obj_.original_tagname_ = 'versionNumber'
# end class POCD_MT000040_ParentDocument


class POCD_MT000040_Participant1(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = None, contextControlCode: 'ContextControl' = 'OP', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, functionCode: 'CE' = None, time: 'IVL_TS' = None, associatedEntity: 'POCD_MT000040.AssociatedEntity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextControlCode = _cast(None, contextControlCode)
        self.contextControlCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.functionCode = functionCode
        self.functionCode_nsprefix_ = None
        self.time = time
        self.time_nsprefix_ = None
        self.associatedEntity = associatedEntity
        self.associatedEntity_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Participant1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Participant1.subclass:
            return POCD_MT000040_Participant1.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Participant1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_functionCode(self):
        return self.functionCode
    def set_functionCode(self, functionCode):
        self.functionCode = functionCode
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_associatedEntity(self):
        return self.associatedEntity
    def set_associatedEntity(self, associatedEntity):
        self.associatedEntity = associatedEntity
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_contextControlCode(self):
        return self.contextControlCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        pass
    def validate_ContextControl(self, value):
        # Validate type ContextControl, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.functionCode is not None or
            self.time is not None or
            self.associatedEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Participant1', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Participant1')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Participant1':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Participant1')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Participant1', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Participant1'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextControlCode is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            outfile.write(' contextControlCode=%s' % (quote_attrib(self.contextControlCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Participant1', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.functionCode is not None:
            namespaceprefix_ = self.functionCode_nsprefix_ + ':' if (UseCapturedNS_ and self.functionCode_nsprefix_) else ''
            self.functionCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='functionCode', pretty_print=pretty_print)
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            self.time.export(outfile, level, namespaceprefix_, namespacedef_='', name_='time', pretty_print=pretty_print)
        if self.associatedEntity is not None:
            namespaceprefix_ = self.associatedEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.associatedEntity_nsprefix_) else ''
            self.associatedEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='associatedEntity', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
        value = find_attr_value_('contextControlCode', node)
        if value is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            self.contextControlCode = value
            self.validate_ContextControl(self.contextControlCode)    # validate type ContextControl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'functionCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.functionCode = obj_
            obj_.original_tagname_ = 'functionCode'
        elif nodeName_ == 'time':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'associatedEntity':
            obj_ = POCD_MT000040_AssociatedEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.associatedEntity = obj_
            obj_.original_tagname_ = 'associatedEntity'
# end class POCD_MT000040_Participant1


class POCD_MT000040_Participant2(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, typeCode: 'ParticipationType' = None, contextControlCode: 'ContextControl' = 'OP', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, functionCode: 'CE' = None, time: 'IVL_TS' = None, awarenessCode: 'CE' = None, participantRole: 'POCD_MT000040.ParticipantRole' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.typeCode = _cast(None, typeCode)
        self.typeCode_nsprefix_ = None
        self.contextControlCode = _cast(None, contextControlCode)
        self.contextControlCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.functionCode = functionCode
        self.functionCode_nsprefix_ = None
        self.time = time
        self.time_nsprefix_ = None
        self.awarenessCode = awarenessCode
        self.awarenessCode_nsprefix_ = None
        self.participantRole = participantRole
        self.participantRole_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Participant2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Participant2.subclass:
            return POCD_MT000040_Participant2.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Participant2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_functionCode(self):
        return self.functionCode
    def set_functionCode(self, functionCode):
        self.functionCode = functionCode
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_awarenessCode(self):
        return self.awarenessCode
    def set_awarenessCode(self, awarenessCode):
        self.awarenessCode = awarenessCode
    def get_participantRole(self):
        return self.participantRole
    def set_participantRole(self, participantRole):
        self.participantRole = participantRole
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_typeCode(self):
        return self.typeCode
    def set_typeCode(self, typeCode):
        self.typeCode = typeCode
    def get_contextControlCode(self):
        return self.contextControlCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_ParticipationType(self, value):
        # Validate type ParticipationType, a restriction on cs.
        pass
    def validate_ContextControl(self, value):
        # Validate type ContextControl, a restriction on None.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.functionCode is not None or
            self.time is not None or
            self.awarenessCode is not None or
            self.participantRole is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Participant2', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Participant2')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Participant2':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Participant2')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Participant2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Participant2'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.typeCode is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            outfile.write(' typeCode=%s' % (quote_attrib(self.typeCode), ))
        if self.contextControlCode is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            outfile.write(' contextControlCode=%s' % (quote_attrib(self.contextControlCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.Participant2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        if self.functionCode is not None:
            namespaceprefix_ = self.functionCode_nsprefix_ + ':' if (UseCapturedNS_ and self.functionCode_nsprefix_) else ''
            self.functionCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='functionCode', pretty_print=pretty_print)
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            self.time.export(outfile, level, namespaceprefix_, namespacedef_='', name_='time', pretty_print=pretty_print)
        if self.awarenessCode is not None:
            namespaceprefix_ = self.awarenessCode_nsprefix_ + ':' if (UseCapturedNS_ and self.awarenessCode_nsprefix_) else ''
            self.awarenessCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='awarenessCode', pretty_print=pretty_print)
        if self.participantRole is not None:
            namespaceprefix_ = self.participantRole_nsprefix_ + ':' if (UseCapturedNS_ and self.participantRole_nsprefix_) else ''
            self.participantRole.export(outfile, level, namespaceprefix_, namespacedef_='', name_='participantRole', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('typeCode', node)
        if value is not None and 'typeCode' not in already_processed:
            already_processed.add('typeCode')
            self.typeCode = value
            self.typeCode = ' '.join(self.typeCode.split())
            self.validate_ParticipationType(self.typeCode)    # validate type ParticipationType
        value = find_attr_value_('contextControlCode', node)
        if value is not None and 'contextControlCode' not in already_processed:
            already_processed.add('contextControlCode')
            self.contextControlCode = value
            self.validate_ContextControl(self.contextControlCode)    # validate type ContextControl
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'functionCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.functionCode = obj_
            obj_.original_tagname_ = 'functionCode'
        elif nodeName_ == 'time':
            obj_ = IVL_TS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'awarenessCode':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.awarenessCode = obj_
            obj_.original_tagname_ = 'awarenessCode'
        elif nodeName_ == 'participantRole':
            obj_ = POCD_MT000040_ParticipantRole.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.participantRole = obj_
            obj_.original_tagname_ = 'participantRole'
# end class POCD_MT000040_Participant2


class functionCode(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, functionCode)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if functionCode.subclass:
            return functionCode.subclass(*args_, **kwargs_)
        else:
            return functionCode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def has__content(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='functionCode', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('functionCode')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'functionCode':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='functionCode')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='functionCode', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='functionCode'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='functionCode', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class functionCode


class POCD_MT000040_ParticipantRole(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'RoleClassRoot' = 'ROL', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: List_['II'] = None, code: 'CE' = None, addr: List_['AD'] = None, telecom: List_['TEL'] = None, playingDevice: 'POCD_MT000040.Device' = None, playingEntity: 'POCD_MT000040.PlayingEntity' = None, scopingEntity: 'POCD_MT000040.Entity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
        self.id_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        if addr is None:
            self.addr = []
        else:
            self.addr = addr
        self.addr_nsprefix_ = None
        if telecom is None:
            self.telecom = []
        else:
            self.telecom = telecom
        self.telecom_nsprefix_ = None
        self.playingDevice = playingDevice
        self.playingDevice_nsprefix_ = None
        self.playingEntity = playingEntity
        self.playingEntity_nsprefix_ = None
        self.scopingEntity = scopingEntity
        self.scopingEntity_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_ParticipantRole)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_ParticipantRole.subclass:
            return POCD_MT000040_ParticipantRole.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_ParticipantRole(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def add_id(self, value):
        self.id.append(value)
    def insert_id_at(self, index, value):
        self.id.insert(index, value)
    def replace_id_at(self, index, value):
        self.id[index] = value
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_addr(self):
        return self.addr
    def set_addr(self, addr):
        self.addr = addr
    def add_addr(self, value):
        self.addr.append(value)
    def insert_addr_at(self, index, value):
        self.addr.insert(index, value)
    def replace_addr_at(self, index, value):
        self.addr[index] = value
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def add_telecom(self, value):
        self.telecom.append(value)
    def insert_telecom_at(self, index, value):
        self.telecom.insert(index, value)
    def replace_telecom_at(self, index, value):
        self.telecom[index] = value
    def get_playingDevice(self):
        return self.playingDevice
    def set_playingDevice(self, playingDevice):
        self.playingDevice = playingDevice
    def get_playingEntity(self):
        return self.playingEntity
    def set_playingEntity(self, playingEntity):
        self.playingEntity = playingEntity
    def get_scopingEntity(self):
        return self.scopingEntity
    def set_scopingEntity(self, scopingEntity):
        self.scopingEntity = scopingEntity
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def set_classCode(self, classCode):
        self.classCode = classCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_RoleClassRoot(self, value):
        # Validate type RoleClassRoot, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id or
            self.code is not None or
            self.addr or
            self.telecom or
            self.playingDevice is not None or
            self.playingEntity is not None or
            self.scopingEntity is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.ParticipantRole', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.ParticipantRole')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.ParticipantRole':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.ParticipantRole')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.ParticipantRole', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.ParticipantRole'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode != "ROL" and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3" ', name_='POCD_MT000040.ParticipantRole', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for realmCode_ in self.realmCode:
            namespaceprefix_ = self.realmCode_nsprefix_ + ':' if (UseCapturedNS_ and self.realmCode_nsprefix_) else ''
            realmCode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='realmCode', pretty_print=pretty_print)
        if self.typeId is not None:
            namespaceprefix_ = self.typeId_nsprefix_ + ':' if (UseCapturedNS_ and self.typeId_nsprefix_) else ''
            self.typeId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='typeId', pretty_print=pretty_print)
        for templateId_ in self.templateId:
            namespaceprefix_ = self.templateId_nsprefix_ + ':' if (UseCapturedNS_ and self.templateId_nsprefix_) else ''
            templateId_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateId', pretty_print=pretty_print)
        for id_ in self.id:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            id_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        for addr_ in self.addr:
            namespaceprefix_ = self.addr_nsprefix_ + ':' if (UseCapturedNS_ and self.addr_nsprefix_) else ''
            addr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='addr', pretty_print=pretty_print)
        for telecom_ in self.telecom:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            telecom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
        if self.playingDevice is not None:
            namespaceprefix_ = self.playingDevice_nsprefix_ + ':' if (UseCapturedNS_ and self.playingDevice_nsprefix_) else ''
            self.playingDevice.export(outfile, level, namespaceprefix_, namespacedef_='', name_='playingDevice', pretty_print=pretty_print)
        if self.playingEntity is not None:
            namespaceprefix_ = self.playingEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.playingEntity_nsprefix_) else ''
            self.playingEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='playingEntity', pretty_print=pretty_print)
        if self.scopingEntity is not None:
            namespaceprefix_ = self.scopingEntity_nsprefix_ + ':' if (UseCapturedNS_ and self.scopingEntity_nsprefix_) else ''
            self.scopingEntity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='scopingEntity', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('nullFlavor', node)
        if value is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            self.nullFlavor = value
            self.nullFlavor = ' '.join(self.nullFlavor.split())
            self.validate_NullFlavor(self.nullFlavor)    # validate type NullFlavor
        value = find_attr_value_('classCode', node)
        if value is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            self.classCode = value
            self.classCode = ' '.join(self.classCode.split())
            self.validate_RoleClassRoot(self.classCode)    # validate type RoleClassRoot
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'realmCode':
            obj_ = CS.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.realmCode.append(obj_)
            obj_.original_tagname_ = 'realmCode'
        elif nodeName_ == 'typeId':
            obj_ = POCD_MT000040_InfrastructureRoot_typeId.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.typeId = obj_
            obj_.original_tagname_ = 'typeId'
        elif nodeName_ == 'templateId':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateId.append(obj_)
            obj_.original_tagname_ = 'templateId'
        elif nodeName_ == 'id':
            class_obj_ = self.get_class_obj_(child_, II)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id.append(obj_)
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'code':
            class_obj_ = self.get_class_obj_(child_, CE)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'addr':
            obj_ = AD.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.addr.append(obj_)
            obj_.original_tagname_ = 'addr'
        elif nodeName_ == 'telecom':
            obj_ = TEL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom.append(obj_)
            obj_.original_tagname_ = 'telecom'
        elif nodeName_ == 'playingDevice':
            obj_ = POCD_MT000040_Device.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.playingDevice = obj_
            obj_.original_tagname_ = 'playingDevice'
        elif nodeName_ == 'playingEntity':
            obj_ = POCD_MT000040_PlayingEntity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.playingEntity = obj_
            obj_.original_tagname_ = 'playingEntity'
        elif nodeName_ == 'scopingEntity':
            obj_ = POCD_MT000040_Entity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.scopingEntity = obj_
            obj_.original_tagname_ = 'scopingEntity'
# end class POCD_MT000040_ParticipantRole


class POCD_MT000040_Patient(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, nullFlavor: 'NullFlavor' = None, classCode: 'EntityClass' = 'PSN', determinerCode: 'EntityDeterminer' = 'INSTANCE', realmCode: List_['CS'] = None, typeId: 'POCD_MT000040.InfrastructureRoot.typeId' = None, templateId: List_['II'] = None, id: 'II' = None, name: List_['PN'] = None, desc: 'ED' = None, administrativeGenderCode: 'CE' = None, birthTime: 'TS' = None, deceasedInd: 'BL' = None, deceasedTime: 'TS' = None, multipleBirthInd: 'BL' = None, multipleBirthOrderNumber: 'INT_POS' = None, maritalStatusCode: 'CE' = None, religiousAffiliationCode: 'CE' = None, raceCode: List_['CE'] = None, ethnicGroupCode: List_['CE'] = None, guardian: List_['POCD_MT000040.Guardian'] = None, birthplace: 'POCD_MT000040.Birthplace' = None, languageCommunication: List_['POCD_MT000040.LanguageCommunication'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.nullFlavor = _cast(None, nullFlavor)
        self.nullFlavor_nsprefix_ = None
        self.classCode = _cast(None, classCode)
        self.classCode_nsprefix_ = None
        self.determinerCode = _cast(None, determinerCode)
        self.determinerCode_nsprefix_ = None
        if realmCode is None:
            self.realmCode = []
        else:
            self.realmCode = realmCode
        self.realmCode_nsprefix_ = None
        self.typeId = typeId
        self.typeId_nsprefix_ = None
        if templateId is None:
            self.templateId = []
        else:
            self.templateId = templateId
        self.templateId_nsprefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        if name is None:
            self.name = []
        else:
            self.name = name
        self.name_nsprefix_ = None
        self.desc = desc
        self.desc_nsprefix_ = "sdtc"
        self.administrativeGenderCode = administrativeGenderCode
        self.administrativeGenderCode_nsprefix_ = None
        self.birthTime = birthTime
        self.birthTime_nsprefix_ = None
        self.deceasedInd = deceasedInd
        self.deceasedInd_nsprefix_ = "sdtc"
        self.deceasedTime = deceasedTime
        self.deceasedTime_nsprefix_ = "sdtc"
        self.multipleBirthInd = multipleBirthInd
        self.multipleBirthInd_nsprefix_ = "sdtc"
        self.multipleBirthOrderNumber = multipleBirthOrderNumber
        self.multipleBirthOrderNumber_nsprefix_ = "sdtc"
        self.maritalStatusCode = maritalStatusCode
        self.maritalStatusCode_nsprefix_ = None
        self.religiousAffiliationCode = religiousAffiliationCode
        self.religiousAffiliationCode_nsprefix_ = None
        if raceCode is None:
            self.raceCode = []
        else:
            self.raceCode = raceCode
        self.raceCode_nsprefix_ = "sdtc"
        if ethnicGroupCode is None:
            self.ethnicGroupCode = []
        else:
            self.ethnicGroupCode = ethnicGroupCode
        self.ethnicGroupCode_nsprefix_ = "sdtc"
        if guardian is None:
            self.guardian = []
        else:
            self.guardian = guardian
        self.guardian_nsprefix_ = None
        self.birthplace = birthplace
        self.birthplace_nsprefix_ = None
        if languageCommunication is None:
            self.languageCommunication = []
        else:
            self.languageCommunication = languageCommunication
        self.languageCommunication_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POCD_MT000040_Patient)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POCD_MT000040_Patient.subclass:
            return POCD_MT000040_Patient.subclass(*args_, **kwargs_)
        else:
            return POCD_MT000040_Patient(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_realmCode(self):
        return self.realmCode
    def set_realmCode(self, realmCode):
        self.realmCode = realmCode
    def add_realmCode(self, value):
        self.realmCode.append(value)
    def insert_realmCode_at(self, index, value):
        self.realmCode.insert(index, value)
    def replace_realmCode_at(self, index, value):
        self.realmCode[index] = value
    def get_typeId(self):
        return self.typeId
    def set_typeId(self, typeId):
        self.typeId = typeId
    def get_templateId(self):
        return self.templateId
    def set_templateId(self, templateId):
        self.templateId = templateId
    def add_templateId(self, value):
        self.templateId.append(value)
    def insert_templateId_at(self, index, value):
        self.templateId.insert(index, value)
    def replace_templateId_at(self, index, value):
        self.templateId[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def add_name(self, value):
        self.name.append(value)
    def insert_name_at(self, index, value):
        self.name.insert(index, value)
    def replace_name_at(self, index, value):
        self.name[index] = value
    def get_desc(self):
        return self.desc
    def set_desc(self, desc):
        self.desc = desc
    def get_administrativeGenderCode(self):
        return self.administrativeGenderCode
    def set_administrativeGenderCode(self, administrativeGenderCode):
        self.administrativeGenderCode = administrativeGenderCode
    def get_birthTime(self):
        return self.birthTime
    def set_birthTime(self, birthTime):
        self.birthTime = birthTime
    def get_deceasedInd(self):
        return self.deceasedInd
    def set_deceasedInd(self, deceasedInd):
        self.deceasedInd = deceasedInd
    def get_deceasedTime(self):
        return self.deceasedTime
    def set_deceasedTime(self, deceasedTime):
        self.deceasedTime = deceasedTime
    def get_multipleBirthInd(self):
        return self.multipleBirthInd
    def set_multipleBirthInd(self, multipleBirthInd):
        self.multipleBirthInd = multipleBirthInd
    def get_multipleBirthOrderNumber(self):
        return self.multipleBirthOrderNumber
    def set_multipleBirthOrderNumber(self, multipleBirthOrderNumber):
        self.multipleBirthOrderNumber = multipleBirthOrderNumber
    def get_maritalStatusCode(self):
        return self.maritalStatusCode
    def set_maritalStatusCode(self, maritalStatusCode):
        self.maritalStatusCode = maritalStatusCode
    def get_religiousAffiliationCode(self):
        return self.religiousAffiliationCode
    def set_religiousAffiliationCode(self, religiousAffiliationCode):
        self.religiousAffiliationCode = religiousAffiliationCode
    def get_raceCode(self):
        return self.raceCode
    def set_raceCode(self, raceCode):
        self.raceCode = raceCode
    def add_raceCode(self, value):
        self.raceCode.append(value)
    def insert_raceCode_at(self, index, value):
        self.raceCode.insert(index, value)
    def replace_raceCode_at(self, index, value):
        self.raceCode[index] = value
    def get_ethnicGroupCode(self):
        return self.ethnicGroupCode
    def set_ethnicGroupCode(self, ethnicGroupCode):
        self.ethnicGroupCode = ethnicGroupCode
    def add_ethnicGroupCode(self, value):
        self.ethnicGroupCode.append(value)
    def insert_ethnicGroupCode_at(self, index, value):
        self.ethnicGroupCode.insert(index, value)
    def replace_ethnicGroupCode_at(self, index, value):
        self.ethnicGroupCode[index] = value
    def get_guardian(self):
        return self.guardian
    def set_guardian(self, guardian):
        self.guardian = guardian
    def add_guardian(self, value):
        self.guardian.append(value)
    def insert_guardian_at(self, index, value):
        self.guardian.insert(index, value)
    def replace_guardian_at(self, index, value):
        self.guardian[index] = value
    def get_birthplace(self):
        return self.birthplace
    def set_birthplace(self, birthplace):
        self.birthplace = birthplace
    def get_languageCommunication(self):
        return self.languageCommunication
    def set_languageCommunication(self, languageCommunication):
        self.languageCommunication = languageCommunication
    def add_languageCommunication(self, value):
        self.languageCommunication.append(value)
    def insert_languageCommunication_at(self, index, value):
        self.languageCommunication.insert(index, value)
    def replace_languageCommunication_at(self, index, value):
        self.languageCommunication[index] = value
    def get_nullFlavor(self):
        return self.nullFlavor
    def set_nullFlavor(self, nullFlavor):
        self.nullFlavor = nullFlavor
    def get_classCode(self):
        return self.classCode
    def get_determinerCode(self):
        return self.determinerCode
    def validate_NullFlavor(self, value):
        # Validate type NullFlavor, a restriction on cs.
        pass
    def validate_EntityClass(self, value):
        # Validate type EntityClass, a restriction on None.
        pass
    def validate_EntityDeterminer(self, value):
        # Validate type EntityDeterminer, a restriction on cs.
        pass
    def has__content(self):
        if (
            self.realmCode or
            self.typeId is not None or
            self.templateId or
            self.id is not None or
            self.name or
            self.desc is not None or
            self.administrativeGenderCode is not None or
            self.birthTime is not None or
            self.deceasedInd is not None or
            self.deceasedTime is not None or
            self.multipleBirthInd is not None or
            self.multipleBirthOrderNumber is not None or
            self.maritalStatusCode is not None or
            self.religiousAffiliationCode is not None or
            self.raceCode or
            self.ethnicGroupCode or
            self.guardian or
            self.birthplace is not None or
            self.languageCommunication
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.Patient', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POCD_MT000040.Patient')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POCD_MT000040.Patient':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POCD_MT000040.Patient')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POCD_MT000040.Patient', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POCD_MT000040.Patient'):
        if self.nullFlavor is not None and 'nullFlavor' not in already_processed:
            already_processed.add('nullFlavor')
            outfile.write(' nullFlavor=%s' % (quote_attrib(self.nullFlavor), ))
        if self.classCode is not None and 'classCode' not in already_processed:
            already_processed.add('classCode')
            outfile.write(' classCode=%s' % (quote_attrib(self.classCode), ))
        if self.determinerCode is not None and 'determinerCode' not in already_processed:
            already_processed.add('determinerCode')
            outfile.write(' determinerCode=%s' % (quote_attrib(self.determinerCode), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="urn:hl7-org:v3"  xmlns:sdtc="urn:hl7-org:sdtc" ', name_='POCD_MT000040.Patient', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = '